/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.accountstate.callback;

import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.accountstate.AccountStateCallBackUtils;
import org.tron.core.db.accountstate.storetrie.AccountStateStoreTrie;
import org.tron.core.exception.BadBlockException;
import org.tron.core.trie.TrieImpl;

@Component
public class AccountStateCallBack
extends AccountStateCallBackUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"AccountState");
    private BlockCapsule blockCapsule;
    private TrieImpl trie;
    private ChainBaseManager chainBaseManager;
    @Autowired
    private AccountStateStoreTrie db;

    public void preExeTrans() {
        this.trieEntryList.clear();
    }

    public void exeTransFinish() {
        for (AccountStateCallBackUtils.TrieEntry trieEntry : this.trieEntryList) {
            this.trie.put(Hash.encodeElement((byte[])trieEntry.getKey()), trieEntry.getData());
        }
        this.trieEntryList.clear();
    }

    public void deleteAccount(byte[] key) {
        if (!this.exe()) {
            return;
        }
        this.trie.delete(Hash.encodeElement((byte[])key));
    }

    public void preExecute(BlockCapsule blockCapsule) {
        this.blockCapsule = blockCapsule;
        this.execute = true;
        this.allowGenerateRoot = this.chainBaseManager.getDynamicPropertiesStore().allowAccountStateRoot();
        if (!this.exe()) {
            return;
        }
        byte[] rootHash = null;
        try {
            BlockCapsule parentBlockCapsule = this.chainBaseManager.getBlockById((Sha256Hash)blockCapsule.getParentBlockId());
            rootHash = parentBlockCapsule.getInstance().getBlockHeader().getRawData().getAccountStateRoot().toByteArray();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (Arrays.equals(Internal.EMPTY_BYTE_ARRAY, rootHash)) {
            rootHash = Hash.EMPTY_TRIE_HASH;
        }
        this.trie = new TrieImpl(this.db, rootHash);
    }

    public void executePushFinish() throws BadBlockException {
        if (!this.exe()) {
            return;
        }
        ByteString oldRoot = this.blockCapsule.getInstance().getBlockHeader().getRawData().getAccountStateRoot();
        this.execute = false;
        byte[] newRoot = this.trie.getRootHash();
        if (ArrayUtils.isEmpty((byte[])newRoot)) {
            newRoot = Hash.EMPTY_TRIE_HASH;
        }
        if (!oldRoot.isEmpty() && !Arrays.equals(oldRoot.toByteArray(), newRoot)) {
            throw new BadBlockException(String.format("accountStateRoot hash is error, %s, oldRoot: %s, newRoot: %s.", this.blockCapsule, ByteArray.toHexString((byte[])oldRoot.toByteArray()), ByteArray.toHexString((byte[])newRoot)));
        }
    }

    public void executeGenerateFinish() {
        if (!this.exe()) {
            return;
        }
        byte[] newRoot = this.trie.getRootHash();
        if (ArrayUtils.isEmpty((byte[])newRoot)) {
            newRoot = Hash.EMPTY_TRIE_HASH;
        }
        this.blockCapsule.setAccountStateRoot(newRoot);
        this.execute = false;
    }

    public void exceptionFinish() {
        this.execute = false;
    }

    public void setChainBaseManager(ChainBaseManager chainBaseManager) {
        this.chainBaseManager = chainBaseManager;
    }
}

