/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.accountstate;

import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.accountstate.storetrie.AccountStateStoreTrie;

@Component
public class TrieService {
    private static final Logger logger = LoggerFactory.getLogger((String)"AccountState");
    private ChainBaseManager chainBaseManager;
    private AccountStateStoreTrie accountStateStoreTrie;

    public byte[] getFullAccountStateRootHash() {
        long latestNumber = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        return this.getAccountStateRootHash(latestNumber);
    }

    public byte[] getSolidityAccountStateRootHash() {
        long latestSolidityNumber = this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
        return this.getAccountStateRootHash(latestSolidityNumber);
    }

    private byte[] getAccountStateRootHash(long blockNumber) {
        long latestNumber = blockNumber;
        byte[] rootHash = null;
        try {
            BlockCapsule blockCapsule = this.chainBaseManager.getBlockByNum(latestNumber);
            ByteString value = blockCapsule.getInstance().getBlockHeader().getRawData().getAccountStateRoot();
            byte[] byArray = rootHash = value == null ? null : value.toByteArray();
            if (Arrays.equals(rootHash, Internal.EMPTY_BYTE_ARRAY)) {
                rootHash = Hash.EMPTY_TRIE_HASH;
            }
        }
        catch (Exception e) {
            logger.error("Get the {} block error.", (Object)latestNumber, (Object)e);
        }
        return rootHash;
    }

    public void setChainBaseManager(ChainBaseManager chainBaseManager) {
        this.chainBaseManager = chainBaseManager;
    }

    public void setAccountStateStoreTrie(AccountStateStoreTrie accountStateStoreTrie) {
        this.accountStateStoreTrie = accountStateStoreTrie;
    }
}

