/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;

public class PendingManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private Manager dbManager;
    private long timeout = Args.getInstance().getPendingTransactionTimeout();

    public PendingManager(Manager db) {
        this.dbManager = db;
        db.getSession().reset();
        db.getShieldedTransInPendingCounts().set(0);
    }

    @Override
    public void close() {
        long now = System.currentTimeMillis();
        Iterator iterator = this.dbManager.getRePushTransactions().iterator();
        while (iterator.hasNext()) {
            TransactionCapsule tx = (TransactionCapsule)iterator.next();
            if (now - tx.getTime() <= this.timeout) continue;
            iterator.remove();
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
            Metrics.counterInc((String)"tron:txs", (double)1.0, (String[])new String[]{"fail", "timeout"});
            if (!Args.getInstance().isOpenPrintLog()) continue;
            logger.warn("Timeout remove tx from repush, txId: {}.", (Object)tx.getTransactionId());
        }
        for (TransactionCapsule tx : this.dbManager.getPendingTransactions()) {
            this.txIteration(tx);
        }
        this.dbManager.getPendingTransactions().clear();
        Metrics.gaugeSet((String)"tron:manager_queue_size", (double)0.0, (String[])new String[]{"pending"});
        for (TransactionCapsule tx : this.dbManager.getPoppedTransactions()) {
            tx.setTime(System.currentTimeMillis());
            this.txIteration(tx);
        }
        this.dbManager.getPoppedTransactions().clear();
        Metrics.gaugeSet((String)"tron:manager_queue_size", (double)0.0, (String[])new String[]{"popped"});
        if (Args.getInstance().isOpenPrintLog()) {
            logger.info("Pending tx size: {}.", (Object)this.dbManager.getRePushTransactions().size());
        }
    }

    private void txIteration(TransactionCapsule tx) {
        try {
            if (System.currentTimeMillis() - tx.getTime() < this.timeout) {
                this.dbManager.getRePushTransactions().put(tx);
                Metrics.gaugeInc((String)"tron:manager_queue_size", (double)1.0, (String[])new String[]{"repush"});
            } else {
                Metrics.counterInc((String)"tron:txs", (double)1.0, (String[])new String[]{"fail", "timeout"});
                if (Args.getInstance().isOpenPrintLog()) {
                    logger.warn("Timeout remove tx from pending, txId: {}.", (Object)tx.getTransactionId());
                }
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }
}

