/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import io.prometheus.client.Histogram;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.bouncycastle.util.encoders.Hex;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.args.GenesisBlock;
import org.tron.common.bloom.Bloom;
import org.tron.common.logsfilter.EventPluginLoader;
import org.tron.common.logsfilter.FilterQuery;
import org.tron.common.logsfilter.capsule.BlockFilterCapsule;
import org.tron.common.logsfilter.capsule.BlockLogTriggerCapsule;
import org.tron.common.logsfilter.capsule.ContractTriggerCapsule;
import org.tron.common.logsfilter.capsule.FilterTriggerCapsule;
import org.tron.common.logsfilter.capsule.LogsFilterCapsule;
import org.tron.common.logsfilter.capsule.SolidityTriggerCapsule;
import org.tron.common.logsfilter.capsule.TransactionLogTriggerCapsule;
import org.tron.common.logsfilter.capsule.TriggerCapsule;
import org.tron.common.logsfilter.trigger.ContractEventTrigger;
import org.tron.common.logsfilter.trigger.ContractLogTrigger;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.overlay.message.Message;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;
import org.tron.common.runtime.Runtime;
import org.tron.common.runtime.RuntimeImpl;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.JsonUtil;
import org.tron.common.utils.Pair;
import org.tron.common.utils.SessionOptional;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.common.zksnark.MerkleContainer;
import org.tron.consensus.Consensus;
import org.tron.consensus.base.Param;
import org.tron.core.ChainBaseManager;
import org.tron.core.Wallet;
import org.tron.core.actuator.ActuatorCreator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockBalanceTraceCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.config.args.Args;
import org.tron.core.consensus.ProposalController;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.BlockIndexStore;
import org.tron.core.db.BlockStore;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.KhaosDatabase;
import org.tron.core.db.PendingManager;
import org.tron.core.db.RecentTransactionItem;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.TransactionCache;
import org.tron.core.db.TransactionStore;
import org.tron.core.db.TransactionTrace;
import org.tron.core.db.accountstate.TrieService;
import org.tron.core.db.accountstate.callback.AccountStateCallBack;
import org.tron.core.db.api.AssetUpdateHelper;
import org.tron.core.db.api.BandwidthPriceHistoryLoader;
import org.tron.core.db.api.EnergyPriceHistoryLoader;
import org.tron.core.db.api.MoveAbiHelper;
import org.tron.core.db2.ISession;
import org.tron.core.db2.core.Chainbase;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BadBlockException;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.BadNumberBlockException;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractSizeNotEqualToOneException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.EventBloomException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateScheduleException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AccountAssetStore;
import org.tron.core.store.AccountIdIndexStore;
import org.tron.core.store.AccountIndexStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.CodeStore;
import org.tron.core.store.ContractStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.core.store.IncrementalMerkleTreeStore;
import org.tron.core.store.NullifierStore;
import org.tron.core.store.ProposalStore;
import org.tron.core.store.StorageRowStore;
import org.tron.core.store.StoreFactory;
import org.tron.core.store.TransactionHistoryStore;
import org.tron.core.store.TransactionRetStore;
import org.tron.core.store.TreeBlockIndexStore;
import org.tron.core.store.VotesStore;
import org.tron.core.store.WitnessScheduleStore;
import org.tron.core.store.WitnessStore;
import org.tron.core.utils.TransactionRegister;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

@Component
public class Manager {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final int SHIELDED_TRANS_IN_BLOCK_COUNTS = 1;
    private static final String SAVE_BLOCK = "Save block: {}";
    private static final int SLEEP_TIME_OUT = 50;
    private static final int TX_ID_CACHE_SIZE = 100000;
    private static final int SLEEP_FOR_WAIT_LOCK = 10;
    private static final int NO_BLOCK_WAITING_LOCK = 0;
    private final int shieldedTransInPendingMaxCounts = Args.getInstance().getShieldedTransInPendingMaxCounts();
    public boolean eventPluginLoaded = false;
    private int maxTransactionPendingSize = Args.getInstance().getMaxTransactionPendingSize();
    @Autowired(required=false)
    private TransactionCache transactionCache;
    @Autowired
    private KhaosDatabase khaosDb;
    @Autowired
    private RevokingDatabase revokingStore;
    private SessionOptional session = SessionOptional.instance();
    private boolean isSyncMode;
    private Object forkLock = new Object();
    private String netType;
    private ProposalController proposalController;
    private MerkleContainer merkleContainer;
    private ExecutorService validateSignService;
    private boolean isRunRePushThread = true;
    private boolean isRunTriggerCapsuleProcessThread = true;
    private BlockingQueue<TransactionCapsule> pushTransactionQueue = new LinkedBlockingQueue<TransactionCapsule>();
    private Cache<Sha256Hash, Boolean> transactionIdCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();
    @Autowired
    private AccountStateCallBack accountStateCallBack;
    @Autowired
    private TrieService trieService;
    private Set<String> ownerAddressSet = new HashSet<String>();
    @Autowired
    private MortgageService mortgageService;
    @Autowired
    private Consensus consensus;
    @Autowired
    private ChainBaseManager chainBaseManager;
    private BlockingQueue<TransactionCapsule> pendingTransactions;
    private AtomicInteger shieldedTransInPendingCounts = new AtomicInteger(0);
    private List<TransactionCapsule> poppedTransactions = Collections.synchronizedList(Lists.newArrayList());
    private BlockingQueue<TransactionCapsule> rePushTransactions;
    private BlockingQueue<TriggerCapsule> triggerCapsuleQueue;
    private boolean isRunFilterProcessThread = true;
    private BlockingQueue<FilterTriggerCapsule> filterCapsuleQueue;
    private volatile long latestSolidityNumShutDown;
    private long lastUsedSolidityNum = -1L;
    private int maxFlushCount;
    private final ThreadLocal<Histogram.Timer> blockedTimer = new ThreadLocal();
    private AtomicInteger blockWaitLock = new AtomicInteger(0);
    private Object transactionLock = new Object();
    private Runnable rePushLoop = () -> {
        while (this.isRunRePushThread) {
            TransactionCapsule tx = null;
            try {
                tx = (TransactionCapsule)this.getRePushTransactions().peek();
                if (tx != null) {
                    this.rePush(tx);
                } else {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                if (tx == null || !this.getRePushTransactions().remove(tx)) continue;
            }
            catch (Throwable ex) {
                try {
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    logger.error("Unknown exception happened in rePush loop.", ex);
                    if (tx != null) {
                        Metrics.counterInc((String)"tron:txs", (double)1.0, (String[])new String[]{"fail", "error"});
                    }
                    if (tx == null || !this.getRePushTransactions().remove(tx)) continue;
                }
                catch (Throwable throwable) {
                    if (tx != null && this.getRePushTransactions().remove(tx)) {
                        Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
                    }
                    throw throwable;
                }
                Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
                continue;
            }
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
        }
    };
    private Runnable triggerCapsuleProcessLoop = () -> {
        while (this.isRunTriggerCapsuleProcessThread) {
            try {
                TriggerCapsule triggerCapsule = this.triggerCapsuleQueue.poll(1L, TimeUnit.SECONDS);
                if (triggerCapsule == null) continue;
                triggerCapsule.processTrigger();
            }
            catch (InterruptedException ex) {
                logger.info(ex.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                logger.error("Unknown throwable happened in process capsule loop.", throwable);
            }
        }
    };
    private Runnable filterProcessLoop = () -> {
        while (this.isRunFilterProcessThread) {
            try {
                FilterTriggerCapsule filterCapsule = this.filterCapsuleQueue.poll(1L, TimeUnit.SECONDS);
                if (filterCapsule == null) continue;
                filterCapsule.processFilterTrigger();
            }
            catch (InterruptedException e) {
                logger.error("FilterProcessLoop get InterruptedException, error is {}.", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                logger.error("Unknown throwable happened in filterProcessLoop. ", throwable);
            }
        }
    };
    private Comparator downComparator = (o1, o2) -> Long.compare(o2.getOrder(), o1.getOrder());

    public WitnessStore getWitnessStore() {
        return this.chainBaseManager.getWitnessStore();
    }

    public boolean needToUpdateAsset() {
        return this.getDynamicPropertiesStore().getTokenUpdateDone() == 0L;
    }

    public boolean needToMoveAbi() {
        return this.getDynamicPropertiesStore().getAbiMoveDone() == 0L;
    }

    private boolean needToLoadEnergyPriceHistory() {
        return this.getDynamicPropertiesStore().getEnergyPriceHistoryDone() == 0L;
    }

    private boolean needToLoadBandwidthPriceHistory() {
        return this.getDynamicPropertiesStore().getBandwidthPriceHistoryDone() == 0L;
    }

    public boolean needToSetBlackholePermission() {
        return this.getDynamicPropertiesStore().getSetBlackholeAccountPermission() == 0L;
    }

    private void resetBlackholeAccountPermission() {
        AccountCapsule blackholeAccount = this.getAccountStore().getBlackhole();
        byte[] zeroAddress = new byte[21];
        zeroAddress[0] = Wallet.getAddressPreFixByte();
        Protocol.Permission owner = AccountCapsule.createDefaultOwnerPermission((ByteString)ByteString.copyFrom((byte[])zeroAddress));
        blackholeAccount.updatePermissions(owner, null, null);
        this.getAccountStore().put(blackholeAccount.getAddress().toByteArray(), blackholeAccount);
        this.getDynamicPropertiesStore().saveSetBlackholePermission(1L);
    }

    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.chainBaseManager.getDynamicPropertiesStore();
    }

    public DelegationStore getDelegationStore() {
        return this.chainBaseManager.getDelegationStore();
    }

    public IncrementalMerkleTreeStore getMerkleTreeStore() {
        return this.chainBaseManager.getMerkleTreeStore();
    }

    public WitnessScheduleStore getWitnessScheduleStore() {
        return this.chainBaseManager.getWitnessScheduleStore();
    }

    public DelegatedResourceStore getDelegatedResourceStore() {
        return this.chainBaseManager.getDelegatedResourceStore();
    }

    public DelegatedResourceAccountIndexStore getDelegatedResourceAccountIndexStore() {
        return this.chainBaseManager.getDelegatedResourceAccountIndexStore();
    }

    public CodeStore getCodeStore() {
        return this.chainBaseManager.getCodeStore();
    }

    public ContractStore getContractStore() {
        return this.chainBaseManager.getContractStore();
    }

    public VotesStore getVotesStore() {
        return this.chainBaseManager.getVotesStore();
    }

    public ProposalStore getProposalStore() {
        return this.chainBaseManager.getProposalStore();
    }

    public ExchangeStore getExchangeStore() {
        return this.chainBaseManager.getExchangeStore();
    }

    public ExchangeV2Store getExchangeV2Store() {
        return this.chainBaseManager.getExchangeV2Store();
    }

    public StorageRowStore getStorageRowStore() {
        return this.chainBaseManager.getStorageRowStore();
    }

    public BlockIndexStore getBlockIndexStore() {
        return this.chainBaseManager.getBlockIndexStore();
    }

    public BlockingQueue<TransactionCapsule> getPendingTransactions() {
        return this.pendingTransactions;
    }

    public List<TransactionCapsule> getPoppedTransactions() {
        return this.poppedTransactions;
    }

    public BlockingQueue<TransactionCapsule> getRePushTransactions() {
        return this.rePushTransactions;
    }

    public void stopRePushThread() {
        this.isRunRePushThread = false;
    }

    public void stopRePushTriggerThread() {
        this.isRunTriggerCapsuleProcessThread = false;
    }

    public void stopFilterProcessThread() {
        this.isRunFilterProcessThread = false;
    }

    @PostConstruct
    public void init() {
        ChainBaseManager.init((ChainBaseManager)this.chainBaseManager);
        Message.setDynamicPropertiesStore((DynamicPropertiesStore)this.getDynamicPropertiesStore());
        this.mortgageService.initStore(this.chainBaseManager.getWitnessStore(), this.chainBaseManager.getDelegationStore(), this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAccountStore());
        this.accountStateCallBack.setChainBaseManager(this.chainBaseManager);
        this.trieService.setChainBaseManager(this.chainBaseManager);
        this.revokingStore.disable();
        this.revokingStore.check();
        this.transactionCache.initCache();
        this.setProposalController(ProposalController.createInstance(this));
        this.setMerkleContainer(MerkleContainer.createInstance((IncrementalMerkleTreeStore)this.chainBaseManager.getMerkleTreeStore(), (TreeBlockIndexStore)this.chainBaseManager.getMerkleTreeIndexStore()));
        if (Args.getInstance().isOpenTransactionSort()) {
            this.pendingTransactions = new PriorityBlockingQueue<TransactionCapsule>(2000, this.downComparator);
            this.rePushTransactions = new PriorityBlockingQueue<TransactionCapsule>(2000, this.downComparator);
        } else {
            this.pendingTransactions = new LinkedBlockingQueue<TransactionCapsule>();
            this.rePushTransactions = new LinkedBlockingQueue<TransactionCapsule>();
        }
        this.triggerCapsuleQueue = new LinkedBlockingQueue<TriggerCapsule>();
        this.filterCapsuleQueue = new LinkedBlockingQueue<FilterTriggerCapsule>();
        this.chainBaseManager.setMerkleContainer(this.getMerkleContainer());
        this.chainBaseManager.setMortgageService(this.mortgageService);
        this.initGenesis();
        try {
            this.khaosDb.start(this.chainBaseManager.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash()));
        }
        catch (ItemNotFoundException e) {
            logger.error("Can not find Dynamic highest block from DB! \nnumber={} \nhash={}", (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            logger.error("Please delete database directory({}) and restart", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        }
        catch (BadItemException e) {
            logger.error("DB data broken {}.", (Object)e.getMessage());
            logger.error("Please delete database directory({}) and restart.", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        }
        this.getChainBaseManager().getForkController().init(this.chainBaseManager);
        if (Args.getInstance().isNeedToUpdateAsset() && this.needToUpdateAsset()) {
            new AssetUpdateHelper(this.chainBaseManager).doWork();
        }
        if (this.needToMoveAbi()) {
            new MoveAbiHelper(this.chainBaseManager).doWork();
        }
        if (this.needToLoadEnergyPriceHistory()) {
            new EnergyPriceHistoryLoader(this.chainBaseManager).doWork();
        }
        if (this.needToLoadBandwidthPriceHistory()) {
            new BandwidthPriceHistoryLoader(this.chainBaseManager).doWork();
        }
        if (this.needToSetBlackholePermission()) {
            this.resetBlackholeAccountPermission();
        }
        this.chainBaseManager.getDynamicPropertiesStore().updateDynamicStoreByConfig();
        this.initLiteNode();
        long headNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        logger.info("Current headNum is: {}.", (Object)headNum);
        boolean isLite = this.chainBaseManager.isLiteNode();
        logger.info("Node type is: {}.", (Object)(isLite ? "lite" : "full"));
        if (isLite) {
            logger.info("Lite node lowestNum: {}", (Object)this.chainBaseManager.getLowestBlockNum());
        }
        this.revokingStore.enable();
        this.validateSignService = Executors.newFixedThreadPool(Args.getInstance().getValidateSignThreadNum());
        Thread rePushThread = new Thread(this.rePushLoop);
        rePushThread.setDaemon(true);
        rePushThread.start();
        if (Args.getInstance().isEventSubscribe()) {
            this.startEventSubscribing();
            Thread triggerCapsuleProcessThread = new Thread(this.triggerCapsuleProcessLoop);
            triggerCapsuleProcessThread.setDaemon(true);
            triggerCapsuleProcessThread.start();
        }
        if (CommonParameter.getInstance().isJsonRpcFilterEnabled()) {
            Thread filterProcessThread = new Thread(this.filterProcessLoop);
            filterProcessThread.start();
        }
        this.prepareStoreFactory();
        ActuatorCreator.init();
        TransactionRegister.registerActuator();
        try {
            this.initAutoStop();
        }
        catch (IllegalArgumentException e) {
            logger.error("Auto-stop params error: {}", (Object)e.getMessage());
            System.exit(1);
        }
        this.maxFlushCount = CommonParameter.getInstance().getStorage().getMaxFlushCount();
    }

    public void initGenesis() {
        this.chainBaseManager.initGenesis();
        BlockCapsule genesisBlock = this.chainBaseManager.getGenesisBlock();
        if (this.chainBaseManager.containBlock((Sha256Hash)genesisBlock.getBlockId())) {
            Args.getInstance().setChainId(genesisBlock.getBlockId().toString());
        } else if (this.chainBaseManager.hasBlocks()) {
            logger.error("Genesis block modify, please delete database directory({}) and restart.", (Object)Args.getInstance().getOutputDirectory());
            System.exit(1);
        } else {
            logger.info("Create genesis block.");
            Args.getInstance().setChainId(genesisBlock.getBlockId().toString());
            this.chainBaseManager.getBlockStore().put(genesisBlock.getBlockId().getBytes(), (ProtoCapsule)genesisBlock);
            this.chainBaseManager.getBlockIndexStore().put(genesisBlock.getBlockId());
            logger.info(SAVE_BLOCK, (Object)genesisBlock);
            this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderNumber(0L);
            this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderHash(genesisBlock.getBlockId().getByteString());
            this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderTimestamp(genesisBlock.getTimeStamp());
            this.initAccount();
            this.initWitness();
            this.khaosDb.start(genesisBlock);
            this.updateRecentBlock(genesisBlock);
            this.initAccountHistoryBalance();
        }
    }

    public void initAccount() {
        CommonParameter parameter = CommonParameter.getInstance();
        GenesisBlock genesisBlockArg = parameter.getGenesisBlock();
        genesisBlockArg.getAssets().forEach(account -> {
            account.setAccountType("Normal");
            AccountCapsule accountCapsule = new AccountCapsule(account.getAccountName(), ByteString.copyFrom((byte[])account.getAddress()), account.getAccountType(), account.getBalance());
            this.chainBaseManager.getAccountStore().put(account.getAddress(), accountCapsule);
            this.chainBaseManager.getAccountIdIndexStore().put(accountCapsule);
            this.chainBaseManager.getAccountIndexStore().put(accountCapsule);
        });
    }

    public void initAccountHistoryBalance() {
        BlockCapsule genesis = this.chainBaseManager.getGenesisBlock();
        BlockBalanceTraceCapsule genesisBlockBalanceTraceCapsule = new BlockBalanceTraceCapsule(genesis);
        List transactionCapsules = genesis.getTransactions();
        for (TransactionCapsule transactionCapsule : transactionCapsules) {
            BalanceContract.TransferContract transferContract = transactionCapsule.getTransferContract();
            BalanceContract.TransactionBalanceTrace.Operation operation = BalanceContract.TransactionBalanceTrace.Operation.newBuilder().setOperationIdentifier(0L).setAddress(transferContract.getToAddress()).setAmount(transferContract.getAmount()).build();
            BalanceContract.TransactionBalanceTrace transactionBalanceTrace = BalanceContract.TransactionBalanceTrace.newBuilder().setTransactionIdentifier(transactionCapsule.getTransactionId().getByteString()).setType(Protocol.Transaction.Contract.ContractType.TransferContract.name()).setStatus(Protocol.Transaction.Result.contractResult.SUCCESS.name()).addOperation(operation).build();
            genesisBlockBalanceTraceCapsule.addTransactionBalanceTrace(transactionBalanceTrace);
            this.chainBaseManager.getAccountTraceStore().recordBalanceWithBlock(transferContract.getToAddress().toByteArray(), 0L, transferContract.getAmount());
        }
        this.chainBaseManager.getBalanceTraceStore().put(Longs.toByteArray((long)0L), (ProtoCapsule)genesisBlockBalanceTraceCapsule);
    }

    private void initWitness() {
        CommonParameter commonParameter = Args.getInstance();
        GenesisBlock genesisBlockArg = commonParameter.getGenesisBlock();
        genesisBlockArg.getWitnesses().forEach(key -> {
            byte[] keyAddress = key.getAddress();
            ByteString address = ByteString.copyFrom((byte[])keyAddress);
            AccountCapsule accountCapsule = !this.chainBaseManager.getAccountStore().has(keyAddress) ? new AccountCapsule(ByteString.EMPTY, address, Protocol.AccountType.AssetIssue, 0L) : (AccountCapsule)this.chainBaseManager.getAccountStore().getUnchecked(keyAddress);
            accountCapsule.setIsWitness(true);
            this.chainBaseManager.getAccountStore().put(keyAddress, accountCapsule);
            WitnessCapsule witnessCapsule = new WitnessCapsule(address, key.getVoteCount(), key.getUrl());
            witnessCapsule.setIsJobs(true);
            this.chainBaseManager.getWitnessStore().put(keyAddress, (ProtoCapsule)witnessCapsule);
        });
    }

    private void initAutoStop() {
        long headNum = this.chainBaseManager.getHeadBlockNum();
        long headTime = this.chainBaseManager.getHeadBlockTimeStamp();
        long exitHeight = CommonParameter.getInstance().getShutdownBlockHeight();
        long exitCount = CommonParameter.getInstance().getShutdownBlockCount();
        CronExpression blockTime = Args.getInstance().getShutdownBlockTime();
        if (exitHeight > 0L && exitHeight < headNum) {
            throw new IllegalArgumentException(String.format("shutDownBlockHeight %d is less than headNum %d", exitHeight, headNum));
        }
        if (exitCount == 0L) {
            throw new IllegalArgumentException(String.format("shutDownBlockCount %d is less than 1", exitCount));
        }
        if (blockTime != null && blockTime.getNextValidTimeAfter(new Date(headTime)) == null) {
            throw new IllegalArgumentException(String.format("shutDownBlockTime %s is illegal", blockTime));
        }
        if (exitHeight > 0L && exitCount > 0L) {
            throw new IllegalArgumentException(String.format("shutDownBlockHeight %d and shutDownBlockCount %d set both", exitHeight, exitCount));
        }
        if (exitHeight > 0L && blockTime != null) {
            throw new IllegalArgumentException(String.format("shutDownBlockHeight %d and shutDownBlockTime %s set both", exitHeight, blockTime));
        }
        if (exitCount > 0L && blockTime != null) {
            throw new IllegalArgumentException(String.format("shutDownBlockCount %d and shutDownBlockTime %s set both", exitCount, blockTime));
        }
        if (exitHeight == headNum && !Args.getInstance().isP2pDisable()) {
            logger.info("Auto-stop hit: shutDownBlockHeight: {}, currentHeaderNum: {}, exit now", (Object)exitHeight, (Object)headNum);
            System.exit(0);
        }
        if (exitCount > 0L) {
            CommonParameter.getInstance().setShutdownBlockHeight(headNum + exitCount);
        }
        this.latestSolidityNumShutDown = CommonParameter.getInstance().getShutdownBlockHeight();
    }

    public AccountStore getAccountStore() {
        return this.chainBaseManager.getAccountStore();
    }

    public AccountAssetStore getAccountAssetStore() {
        return this.chainBaseManager.getAccountAssetStore();
    }

    public AccountIndexStore getAccountIndexStore() {
        return this.chainBaseManager.getAccountIndexStore();
    }

    void validateTapos(TransactionCapsule transactionCapsule) throws TaposException {
        byte[] refBlockHash = transactionCapsule.getInstance().getRawData().getRefBlockHash().toByteArray();
        byte[] refBlockNumBytes = transactionCapsule.getInstance().getRawData().getRefBlockBytes().toByteArray();
        try {
            byte[] blockHash = this.chainBaseManager.getRecentBlockStore().get(refBlockNumBytes).getData();
            if (!Arrays.equals(blockHash, refBlockHash)) {
                String str = String.format("Tapos failed, different block hash, %s, %s , recent block %s, solid block %s head block %s", ByteArray.toLong((byte[])refBlockNumBytes), Hex.toHexString((byte[])refBlockHash), Hex.toHexString((byte[])blockHash), this.chainBaseManager.getSolidBlockId().getString(), this.chainBaseManager.getHeadBlockId().getString());
                throw new TaposException(str);
            }
        }
        catch (ItemNotFoundException e) {
            String str = String.format("Tapos failed, block not found, ref block %s, %s , solid block %s head block %s", ByteArray.toLong((byte[])refBlockNumBytes), Hex.toHexString((byte[])refBlockHash), this.chainBaseManager.getSolidBlockId().getString(), this.chainBaseManager.getHeadBlockId().getString());
            throw new TaposException(str);
        }
    }

    void validateCommon(TransactionCapsule transactionCapsule) throws TransactionExpirationException, TooBigTransactionException {
        long headBlockTime;
        if ((long)transactionCapsule.getData().length > 512000L) {
            throw new TooBigTransactionException(String.format("Too big transaction, the size is %d bytes", transactionCapsule.getData().length));
        }
        long transactionExpiration = transactionCapsule.getExpiration();
        if (transactionExpiration <= (headBlockTime = this.chainBaseManager.getHeadBlockTimeStamp()) || transactionExpiration > headBlockTime + 86400000L) {
            throw new TransactionExpirationException(String.format("Transaction expiration, transaction expiration time is %d, but headBlockTime is %d", transactionExpiration, headBlockTime));
        }
    }

    void validateDup(TransactionCapsule transactionCapsule) throws DupTransactionException {
        if (this.containsTransaction(transactionCapsule)) {
            throw new DupTransactionException(String.format("dup trans : %s ", transactionCapsule.getTransactionId()));
        }
    }

    private boolean containsTransaction(TransactionCapsule transactionCapsule) {
        return this.containsTransaction(transactionCapsule.getTransactionId().getBytes());
    }

    private boolean containsTransaction(byte[] transactionId) {
        if (this.transactionCache != null && !this.transactionCache.has(transactionId)) {
            return false;
        }
        return this.chainBaseManager.getTransactionStore().has(transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean pushTransaction(TransactionCapsule trx) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, DupTransactionException, TaposException, TooBigTransactionException, TransactionExpirationException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException {
        block29: {
            boolean bl;
            if (this.isShieldedTransaction(trx.getInstance()) && !Args.getInstance().isFullNodeAllowShieldedTransactionArgs()) {
                return true;
            }
            this.pushTransactionQueue.add(trx);
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)1.0, (String[])new String[]{"queued"});
            try {
                if (!trx.validateSignature(this.chainBaseManager.getAccountStore(), this.chainBaseManager.getDynamicPropertiesStore())) {
                    throw new ValidateSignatureException(String.format("trans sig validate failed, id: %s", trx.getTransactionId()));
                }
                Object object = this.transactionLock;
                // MONITORENTER : object
                while (true) {
                    try {
                        while (this.isBlockWaitingLock()) {
                            TimeUnit.MILLISECONDS.sleep(10L);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.debug("The wait has been interrupted.");
                        continue;
                    }
                    break;
                }
                Manager manager = this;
                // MONITORENTER : manager
                if (!this.isShieldedTransaction(trx.getInstance()) || this.shieldedTransInPendingCounts.get() < this.shieldedTransInPendingMaxCounts) break block29;
                bl = false;
                // MONITOREXIT : manager
                // MONITOREXIT : object
                if (!this.pushTransactionQueue.remove(trx)) return bl;
            }
            catch (Throwable throwable) {
                if (!this.pushTransactionQueue.remove(trx)) throw throwable;
                Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"queued"});
                throw throwable;
            }
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"queued"});
            return bl;
        }
        if (!this.session.valid()) {
            this.session.setValue(this.revokingStore.buildSession());
        }
        try (ISession tmpSession = this.revokingStore.buildSession();){
            this.processTransaction(trx, null);
            trx.setTrxTrace(null);
            this.pendingTransactions.add(trx);
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)1.0, (String[])new String[]{"pending"});
            tmpSession.merge();
        }
        if (this.isShieldedTransaction(trx.getInstance())) {
            this.shieldedTransInPendingCounts.incrementAndGet();
        }
        // MONITOREXIT : manager
        // MONITOREXIT : object
        if (!this.pushTransactionQueue.remove(trx)) return true;
        Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"queued"});
        return true;
    }

    public void consumeMultiSignFee(TransactionCapsule trx, TransactionTrace trace) throws AccountResourceInsufficientException {
        if (trx.getInstance().getSignatureCount() > 1) {
            long fee = this.getDynamicPropertiesStore().getMultiSignFee();
            List contracts = trx.getInstance().getRawData().getContractList();
            for (Protocol.Transaction.Contract contract : contracts) {
                byte[] address = TransactionCapsule.getOwner((Protocol.Transaction.Contract)contract);
                AccountCapsule accountCapsule = this.getAccountStore().get(address);
                try {
                    if (accountCapsule == null) continue;
                    Commons.adjustBalance((AccountStore)this.getAccountStore(), (AccountCapsule)accountCapsule, (long)(-fee));
                    if (this.getDynamicPropertiesStore().supportBlackHoleOptimization()) {
                        this.getDynamicPropertiesStore().burnTrx(fee);
                        continue;
                    }
                    Commons.adjustBalance((AccountStore)this.getAccountStore(), (AccountCapsule)this.getAccountStore().getBlackhole(), (long)fee);
                }
                catch (BalanceInsufficientException e) {
                    throw new AccountResourceInsufficientException(String.format("account %s insufficient balance[%d] to multiSign", StringUtil.encode58Check((byte[])address), fee));
                }
            }
            trace.getReceipt().setMultiSignFee(fee);
        }
    }

    public void consumeMemoFee(TransactionCapsule trx, TransactionTrace trace) throws AccountResourceInsufficientException {
        if (trx.getInstance().getRawData().getData().isEmpty()) {
            return;
        }
        long fee = this.getDynamicPropertiesStore().getMemoFee();
        if (fee == 0L) {
            return;
        }
        List contracts = trx.getInstance().getRawData().getContractList();
        for (Protocol.Transaction.Contract contract : contracts) {
            byte[] address = TransactionCapsule.getOwner((Protocol.Transaction.Contract)contract);
            AccountCapsule accountCapsule = this.getAccountStore().get(address);
            try {
                if (accountCapsule == null) continue;
                Commons.adjustBalance((AccountStore)this.getAccountStore(), (AccountCapsule)accountCapsule, (long)(-fee));
                if (this.getDynamicPropertiesStore().supportBlackHoleOptimization()) {
                    this.getDynamicPropertiesStore().burnTrx(fee);
                    continue;
                }
                Commons.adjustBalance((AccountStore)this.getAccountStore(), (AccountCapsule)this.getAccountStore().getBlackhole(), (long)fee);
            }
            catch (BalanceInsufficientException e) {
                throw new AccountResourceInsufficientException(String.format("account %s insufficient balance[%d] to memo fee", StringUtil.encode58Check((byte[])address), fee));
            }
        }
        trace.getReceipt().setMemoFee(fee);
    }

    public void consumeBandwidth(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException {
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.consume(trx, trace);
    }

    public void eraseBlock() {
        this.session.reset();
        try {
            BlockCapsule oldHeadBlock = this.chainBaseManager.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            logger.info("Start to erase block: {}.", (Object)oldHeadBlock);
            this.khaosDb.pop();
            this.revokingStore.fastPop();
            logger.info("End to erase block: {}.", (Object)oldHeadBlock);
            oldHeadBlock.getTransactions().forEach(tc -> this.poppedTransactions.add(new TransactionCapsule(tc.getInstance())));
            Metrics.gaugeInc((String)"tron:manager_queue_size", (double)oldHeadBlock.getTransactions().size(), (String[])new String[]{"popped"});
        }
        catch (BadItemException | ItemNotFoundException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void pushVerifiedBlock(BlockCapsule block) throws ContractValidateException, ContractExeException, ValidateSignatureException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, DupTransactionException, TaposException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException, UnLinkedBlockException, NonCommonBlockException, BadNumberBlockException, BadBlockException, ZksnarkException, EventBloomException {
        block.generatedByMyself = true;
        long start = System.currentTimeMillis();
        this.pushBlock(block);
        logger.info("Push block cost: {} ms, blockNum: {}, blockHash: {}, trx count: {}.", new Object[]{System.currentTimeMillis() - start, block.getNum(), block.getBlockId(), block.getTransactions().size()});
    }

    private void applyBlock(BlockCapsule block) throws ContractValidateException, ContractExeException, ValidateSignatureException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, DupTransactionException, TaposException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException, ZksnarkException, BadBlockException, EventBloomException {
        this.applyBlock(block, block.getTransactions());
    }

    private void applyBlock(BlockCapsule block, List<TransactionCapsule> txs) throws ContractValidateException, ContractExeException, ValidateSignatureException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, DupTransactionException, TaposException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException, ZksnarkException, BadBlockException, EventBloomException {
        this.processBlock(block, txs);
        this.chainBaseManager.getBlockStore().put(block.getBlockId().getBytes(), (ProtoCapsule)block);
        this.chainBaseManager.getBlockIndexStore().put(block.getBlockId());
        if (block.getTransactions().size() != 0) {
            this.chainBaseManager.getTransactionRetStore().put(ByteArray.fromLong((long)block.getNum()), block.getResult());
        }
        this.updateFork(block);
        if (System.currentTimeMillis() - block.getTimeStamp() >= 60000L) {
            this.revokingStore.setMaxFlushCount(this.maxFlushCount);
            if (Args.getInstance().getShutdownBlockTime() != null && Args.getInstance().getShutdownBlockTime().getNextValidTimeAfter(new Date(block.getTimeStamp() - (long)(this.maxFlushCount * 1000) * 3L)).compareTo(new Date(block.getTimeStamp())) <= 0) {
                this.revokingStore.setMaxFlushCount(1);
            }
            if (this.latestSolidityNumShutDown > 0L && this.latestSolidityNumShutDown - block.getNum() <= (long)this.maxFlushCount) {
                this.revokingStore.setMaxFlushCount(1);
            }
        } else {
            this.revokingStore.setMaxFlushCount(1);
        }
    }

    private void switchFork(BlockCapsule newHead) throws ValidateSignatureException, ContractValidateException, ContractExeException, ValidateScheduleException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TransactionExpirationException, NonCommonBlockException, ReceiptCheckErrException, VMIllegalException, ZksnarkException, BadBlockException, EventBloomException {
        Pair binaryTree;
        MetricsUtil.meterMark("blockchain.forkCount");
        Metrics.counterInc((String)"tron:block_fork", (double)1.0, (String[])new String[]{"all"});
        try {
            binaryTree = this.khaosDb.getBranch((Sha256Hash)newHead.getBlockId(), this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
        }
        catch (NonCommonBlockException e) {
            Metrics.counterInc((String)"tron:block_fork", (double)1.0, (String[])new String[]{"fail"});
            MetricsUtil.meterMark("blockchain.failForkCount");
            logger.info("This is not the most recent common ancestor, need to remove all blocks in the fork chain.");
            BlockCapsule tmp = newHead;
            while (tmp != null) {
                this.khaosDb.removeBlk((Sha256Hash)tmp.getBlockId());
                tmp = this.khaosDb.getBlock(tmp.getParentHash());
            }
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)binaryTree.getValue()))) {
            while (!this.getDynamicPropertiesStore().getLatestBlockHeaderHash().equals((Object)((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekLast()).getParentHash())) {
                this.reOrgContractTrigger();
                this.reOrgLogsFilter();
                this.eraseBlock();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)binaryTree.getKey()))) {
            ArrayList first = new ArrayList((Collection)binaryTree.getKey());
            Collections.reverse(first);
            for (KhaosDatabase.KhaosBlock item : first) {
                Throwable exception = null;
                try {
                    ISession tmpSession = this.revokingStore.buildSession();
                    Object object = null;
                    try {
                        this.applyBlock(item.getBlk().setSwitch(true));
                        tmpSession.commit();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (tmpSession != null) {
                            if (object != null) {
                                try {
                                    tmpSession.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                tmpSession.close();
                            }
                        }
                    }
                    if (exception == null) continue;
                }
                catch (AccountResourceInsufficientException | BadBlockException | ContractExeException | ContractValidateException | DupTransactionException | ReceiptCheckErrException | TaposException | TooBigTransactionException | TooBigTransactionResultException | TransactionExpirationException | VMIllegalException | ValidateScheduleException | ValidateSignatureException | ZksnarkException e) {
                    try {
                        logger.warn(e.getMessage(), e);
                        exception = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (exception != null) {
                            Metrics.counterInc((String)"tron:block_fork", (double)1.0, (String[])new String[]{"fail"});
                            MetricsUtil.meterMark("blockchain.failForkCount");
                            logger.warn("Switch back because exception thrown while switching forks.", exception);
                            first.forEach(khaosBlock -> this.khaosDb.removeBlk((Sha256Hash)khaosBlock.getBlk().getBlockId()));
                            this.khaosDb.setHead((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekFirst());
                            while (!this.getDynamicPropertiesStore().getLatestBlockHeaderHash().equals((Object)((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekLast()).getParentHash())) {
                                this.eraseBlock();
                            }
                            ArrayList second = new ArrayList((Collection)binaryTree.getValue());
                            Collections.reverse(second);
                            for (KhaosDatabase.KhaosBlock khaosBlock2 : second) {
                                try {
                                    ISession tmpSession = this.revokingStore.buildSession();
                                    Throwable throwable2 = null;
                                    try {
                                        this.applyBlock(khaosBlock2.getBlk().setSwitch(true));
                                        tmpSession.commit();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (tmpSession == null) continue;
                                        if (throwable2 != null) {
                                            try {
                                                tmpSession.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue;
                                        }
                                        tmpSession.close();
                                    }
                                }
                                catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | TaposException | TooBigTransactionException | TransactionExpirationException | ValidateScheduleException | ValidateSignatureException | ZksnarkException e2) {
                                    logger.warn(e2.getMessage(), e2);
                                }
                            }
                        }
                        throw throwable;
                    }
                }
                Metrics.counterInc((String)"tron:block_fork", (double)1.0, (String[])new String[]{"fail"});
                MetricsUtil.meterMark("blockchain.failForkCount");
                logger.warn("Switch back because exception thrown while switching forks.", exception);
                first.forEach(khaosBlock -> this.khaosDb.removeBlk((Sha256Hash)khaosBlock.getBlk().getBlockId()));
                this.khaosDb.setHead((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekFirst());
                while (!this.getDynamicPropertiesStore().getLatestBlockHeaderHash().equals((Object)((KhaosDatabase.KhaosBlock)((LinkedList)binaryTree.getValue()).peekLast()).getParentHash())) {
                    this.eraseBlock();
                }
                ArrayList second = new ArrayList((Collection)binaryTree.getValue());
                Collections.reverse(second);
                for (KhaosDatabase.KhaosBlock khaosBlock3 : second) {
                    try {
                        ISession tmpSession = this.revokingStore.buildSession();
                        Throwable throwable = null;
                        try {
                            this.applyBlock(khaosBlock3.getBlk().setSwitch(true));
                            tmpSession.commit();
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (tmpSession == null) continue;
                            if (throwable != null) {
                                try {
                                    tmpSession.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            tmpSession.close();
                        }
                    }
                    catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | TaposException | TooBigTransactionException | TransactionExpirationException | ValidateScheduleException | ValidateSignatureException | ZksnarkException e) {
                        logger.warn(e.getMessage(), e);
                    }
                }
            }
        }
    }

    public List<TransactionCapsule> getVerifyTxs(BlockCapsule block) {
        if (this.pendingTransactions.size() == 0) {
            return block.getTransactions();
        }
        ArrayList<TransactionCapsule> txs = new ArrayList<TransactionCapsule>();
        HashSet txIds = new HashSet();
        HashSet multiAddresses = new HashSet();
        this.pendingTransactions.forEach(capsule -> {
            String txId = Hex.toHexString((byte[])capsule.getTransactionId().getBytes());
            if (this.isMultiSignTransaction(capsule.getInstance())) {
                String address = Hex.toHexString((byte[])capsule.getOwnerAddress());
                multiAddresses.add(address);
            } else {
                txIds.add(txId);
            }
        });
        block.getTransactions().forEach(capsule -> {
            String address = Hex.toHexString((byte[])capsule.getOwnerAddress());
            String txId = Hex.toHexString((byte[])capsule.getTransactionId().getBytes());
            if (multiAddresses.contains(address) || !txIds.contains(txId)) {
                txs.add((TransactionCapsule)capsule);
            } else {
                capsule.setVerified(true);
            }
        });
        return txs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pushBlock(BlockCapsule block) throws ValidateSignatureException, ContractValidateException, ContractExeException, UnLinkedBlockException, ValidateScheduleException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TransactionExpirationException, BadNumberBlockException, BadBlockException, NonCommonBlockException, ReceiptCheckErrException, VMIllegalException, ZksnarkException, EventBloomException {
        block64: {
            block61: {
                block58: {
                    this.setBlockWaitLock(true);
                    var2_2 = this;
                    synchronized (var2_2) {
                        Metrics.histogramObserve((Histogram.Timer)this.blockedTimer.get());
                        this.blockedTimer.remove();
                        headerNumber = this.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
                        if (block.getNum() > headerNumber || !this.khaosDb.containBlockInMiniStore((Sha256Hash)block.getBlockId()).booleanValue()) ** break block56
                        Manager.logger.info("Block {} is already exist.", (Object)block.getBlockId().getString());
                    }
                    this.setBlockWaitLock(false);
                    return;
                    {
                        block59: {
                            timer = Metrics.histogramStartTimer((String)"tron:block_push_latency_seconds", (String[])new String[0]);
                            start = System.currentTimeMillis();
                            txs = this.getVerifyTxs(block);
                            Manager.logger.info("Block num: {}, re-push-size: {}, pending-size: {}, block-tx-size: {}, verify-tx-size: {}", new Object[]{block.getNum(), this.rePushTransactions.size(), this.pendingTransactions.size(), block.getTransactions().size(), txs.size()});
                            if (CommonParameter.getInstance().getShutdownBlockTime() != null && CommonParameter.getInstance().getShutdownBlockTime().isSatisfiedBy(new Date(block.getTimeStamp()))) {
                                this.latestSolidityNumShutDown = block.getNum();
                            }
                            pm = new PendingManager(this);
                            var10_9 = null;
                            if (!block.generatedByMyself) {
                                if (!block.calcMerkleRoot().equals((Object)block.getMerkleRoot())) {
                                    Manager.logger.warn("Num: {}, the merkle root doesn't match, expect is {} , actual is {}.", new Object[]{block.getNum(), block.getMerkleRoot(), block.calcMerkleRoot()});
                                    throw new BadBlockException(BadBlockException.TypeEnum.CALC_MERKLE_ROOT_FAILED, String.format("The merkle hash is not validated for %d", new Object[]{block.getNum()}));
                                }
                                this.consensus.receiveBlock(block);
                            }
                            if (block.getTransactions().stream().filter((Predicate<TransactionCapsule>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$pushBlock$10(org.tron.core.capsule.TransactionCapsule ), (Lorg/tron/core/capsule/TransactionCapsule;)Z)((Manager)this)).count() > 1L) {
                                throw new BadBlockException(String.format("num: %d, shielded transaction count > %d", new Object[]{block.getNum(), 1}));
                            }
                            try {
                                newBlock = this.khaosDb.push(block);
                            }
                            catch (UnLinkedBlockException e) {
                                Manager.logger.error("LatestBlockHeaderHash: {}, latestBlockHeaderNumber: {}, latestSolidifiedBlockNum: {}.", new Object[]{this.getDynamicPropertiesStore().getLatestBlockHeaderHash(), this.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum()});
                                throw e;
                            }
                            if (this.getDynamicPropertiesStore().getLatestBlockHeaderHash() != null) ** break block57
                            if (newBlock.getNum() == 0L) ** GOTO lbl120
                            if (pm == null) break block58;
                            if (var10_9 == null) break block59;
                            try {
                                pm.close();
                            }
                            catch (Throwable e) {
                                var10_9.addSuppressed(e);
                            }
                            break block58;
                        }
                        pm.close();
                    }
                }
                this.setBlockWaitLock(false);
                return;
                {
                    block62: {
                        if (newBlock.getNum() > headerNumber) ** break block60
                        if (pm == null) break block61;
                        if (var10_9 == null) break block62;
                        try {
                            pm.close();
                        }
                        catch (Throwable e) {
                            var10_9.addSuppressed(e);
                        }
                        break block61;
                    }
                    pm.close();
                }
            }
            this.setBlockWaitLock(false);
            return;
            {
                block65: {
                    if (newBlock.getParentHash().equals((Object)this.getDynamicPropertiesStore().getLatestBlockHeaderHash())) ** break block63
                    Manager.logger.warn("Switch fork! new head num = {}, block id = {}.", (Object)newBlock.getNum(), (Object)newBlock.getBlockId());
                    Manager.logger.warn("******** Before switchFork ******* push block: {}, new block: {}, dynamic head num: {}, dynamic head hash: {}, dynamic head timestamp: {}, khaosDb head: {}, khaosDb miniStore size: {}, khaosDb unlinkMiniStore size: {}.", new Object[]{block, newBlock, this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderHash(), this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp(), this.khaosDb.getHead(), this.khaosDb.getMiniStore().size(), this.khaosDb.getMiniUnlinkedStore().size()});
                    e = this.forkLock;
                    synchronized (e) {
                        this.switchFork(newBlock);
                    }
                    Manager.logger.info("Save block: {}", (Object)newBlock);
                    Manager.logger.warn("******** After switchFork ******* push block: {}, new block: {}, dynamic head num: {}, dynamic head hash: {}, dynamic head timestamp: {}, khaosDb head: {}, khaosDb miniStore size: {}, khaosDb unlinkMiniStore size: {}.", new Object[]{block, newBlock, this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderHash(), this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp(), this.khaosDb.getHead(), this.khaosDb.getMiniStore().size(), this.khaosDb.getMiniUnlinkedStore().size()});
                    if (pm == null) break block64;
                    if (var10_9 == null) break block65;
                    try {
                        pm.close();
                    }
                    catch (Throwable e) {
                        var10_9.addSuppressed(e);
                    }
                    break block64;
                }
                pm.close();
            }
        }
        this.setBlockWaitLock(false);
        return;
        {
            try {
                try {
                    tmpSession = this.revokingStore.buildSession();
                    var13_20 = null;
                    try {
                        oldSolidNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
                        this.applyBlock(newBlock, txs);
                        tmpSession.commit();
                        this.postBlockTrigger(newBlock);
                        this.postSolidityTrigger(oldSolidNum, this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
                    }
                    catch (Throwable var14_23) {
                        var13_20 = var14_23;
                        throw var14_23;
                    }
                    finally {
                        if (tmpSession != null) {
                            if (var13_20 != null) {
                                try {
                                    tmpSession.close();
                                }
                                catch (Throwable var14_22) {
                                    var13_20.addSuppressed(var14_22);
                                }
                            } else {
                                tmpSession.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Manager.logger.error(throwable.getMessage(), throwable);
                    this.khaosDb.removeBlk((Sha256Hash)block.getBlockId());
                    throw throwable;
                }
                Manager.logger.info("Save block: {}", (Object)newBlock);
            }
            catch (Throwable newBlock) {
                var10_9 = newBlock;
                throw newBlock;
            }
            catch (Throwable var18_26) {
                throw var18_26;
            }
            finally {
                if (pm != null) {
                    if (var10_9 != null) {
                        try {
                            pm.close();
                        }
                        catch (Throwable newBlock) {
                            var10_9.addSuppressed(newBlock);
                        }
                    } else {
                        pm.close();
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(this.ownerAddressSet)) {
                result = new HashSet<String>();
                for (TransactionCapsule transactionCapsule : this.rePushTransactions) {
                    this.filterOwnerAddress(transactionCapsule, result);
                }
                for (TransactionCapsule transactionCapsule : this.pushTransactionQueue) {
                    this.filterOwnerAddress(transactionCapsule, result);
                }
                this.ownerAddressSet.clear();
                this.ownerAddressSet.addAll(result);
            }
            cost = System.currentTimeMillis() - start;
            MetricsUtil.meterMark("blockchain.blockProcessTime", cost);
            Manager.logger.info("PushBlock block number: {}, cost/txs: {}/{} {}.", new Object[]{block.getNum(), cost, block.getTransactions().size(), cost > 1000L});
            Metrics.histogramObserve((Histogram.Timer)timer);
            return;
        }
        {
            finally {
                this.setBlockWaitLock(false);
            }
        }
    }

    public void updateDynamicProperties(BlockCapsule block) {
        this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderHash(block.getBlockId().getByteString());
        this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderNumber(block.getNum());
        this.chainBaseManager.getDynamicPropertiesStore().saveLatestBlockHeaderTimestamp(block.getTimeStamp());
        this.revokingStore.setMaxSize((int)(this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() - this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum() + 1L));
        this.khaosDb.setMaxSize((int)(this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() - this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum() + 1L));
        Metrics.gaugeSet((String)"tron:header_height", (double)block.getNum(), (String[])new String[0]);
        Metrics.gaugeSet((String)"tron:header_time", (double)block.getTimeStamp(), (String[])new String[0]);
    }

    public LinkedList<BlockCapsule.BlockId> getBlockChainHashesOnFork(BlockCapsule.BlockId forkBlockHash) throws NonCommonBlockException {
        Pair branch = this.khaosDb.getBranch(this.getDynamicPropertiesStore().getLatestBlockHeaderHash(), (Sha256Hash)forkBlockHash);
        LinkedList blockCapsules = (LinkedList)branch.getValue();
        if (blockCapsules.isEmpty()) {
            logger.info("Empty branch {}.", (Object)forkBlockHash);
            return Lists.newLinkedList();
        }
        LinkedList result = blockCapsules.stream().map(KhaosDatabase.KhaosBlock::getBlk).map(BlockCapsule::getBlockId).collect(Collectors.toCollection(LinkedList::new));
        result.add(((KhaosDatabase.KhaosBlock)blockCapsules.peekLast()).getBlk().getParentBlockId());
        return result;
    }

    public Protocol.TransactionInfo processTransaction(TransactionCapsule trxCap, BlockCapsule blockCap) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, TransactionExpirationException, TooBigTransactionException, TooBigTransactionResultException, DupTransactionException, TaposException, ReceiptCheckErrException, VMIllegalException {
        long cost;
        if (trxCap == null) {
            return null;
        }
        Protocol.Transaction.Contract contract = trxCap.getInstance().getRawData().getContract(0);
        Sha256Hash txId = trxCap.getTransactionId();
        Histogram.Timer requestTimer = Metrics.histogramStartTimer((String)"tron:process_transaction_latency_seconds", (String[])new String[]{Objects.nonNull(blockCap) ? "block" : "trx", contract.getType().name()});
        long start = System.currentTimeMillis();
        if (Objects.nonNull(blockCap)) {
            this.chainBaseManager.getBalanceTraceStore().initCurrentTransactionBalanceTrace(trxCap);
        }
        this.validateTapos(trxCap);
        this.validateCommon(trxCap);
        if (trxCap.getInstance().getRawData().getContractList().size() != 1) {
            throw new ContractSizeNotEqualToOneException(String.format("tx %s contract size should be exactly 1, this is extend feature ,actual :%d", txId, trxCap.getInstance().getRawData().getContractList().size()));
        }
        this.validateDup(trxCap);
        if (!trxCap.validateSignature(this.chainBaseManager.getAccountStore(), this.chainBaseManager.getDynamicPropertiesStore())) {
            throw new ValidateSignatureException(String.format(" %s transaction signature validate failed", txId));
        }
        TransactionTrace trace = new TransactionTrace(trxCap, StoreFactory.getInstance(), (Runtime)new RuntimeImpl());
        trxCap.setTrxTrace(trace);
        this.consumeBandwidth(trxCap, trace);
        this.consumeMultiSignFee(trxCap, trace);
        this.consumeMemoFee(trxCap, trace);
        trace.init(blockCap, this.eventPluginLoaded);
        trace.checkIsConstant();
        trace.exec();
        if (Objects.nonNull(blockCap)) {
            trace.setResult();
            if (trace.checkNeedRetry()) {
                trace.init(blockCap, this.eventPluginLoaded);
                trace.checkIsConstant();
                trace.exec();
                trace.setResult();
                logger.info("Retry result when push: {}, for tx id: {}, tx resultCode in receipt: {}.", new Object[]{blockCap.hasWitnessSignature(), txId, trace.getReceipt().getResult()});
            }
            if (blockCap.hasWitnessSignature()) {
                trace.check();
            }
        }
        trace.finalization();
        if (this.getDynamicPropertiesStore().supportVM()) {
            trxCap.setResult(trace.getTransactionContext());
        }
        this.chainBaseManager.getTransactionStore().put(trxCap.getTransactionId().getBytes(), trxCap);
        Optional.ofNullable(this.transactionCache).ifPresent(t -> t.put(trxCap.getTransactionId().getBytes(), (ProtoCapsule)new BytesCapsule(ByteArray.fromLong((long)trxCap.getBlockNum()))));
        TransactionInfoCapsule transactionInfo = TransactionUtil.buildTransactionInfoInstance((TransactionCapsule)trxCap, (BlockCapsule)blockCap, (TransactionTrace)trace);
        if (Objects.nonNull(blockCap) && !blockCap.isMerkleRootEmpty()) {
            String blockHash = blockCap.getBlockId().toString();
            this.postContractTrigger(trace, false, blockHash);
        }
        if (this.isMultiSignTransaction(trxCap.getInstance())) {
            this.ownerAddressSet.add(ByteArray.toHexString((byte[])trxCap.getOwnerAddress()));
        }
        if (Objects.nonNull(blockCap)) {
            this.chainBaseManager.getBalanceTraceStore().updateCurrentTransactionStatus(trace.getRuntimeResult().getResultCode().name());
            this.chainBaseManager.getBalanceTraceStore().resetCurrentTransactionTrace();
        }
        trxCap.setOrder(transactionInfo.getFee());
        if (!this.eventPluginLoaded) {
            trxCap.setTrxTrace(null);
        }
        if ((cost = System.currentTimeMillis() - start) > 100L) {
            String type = "broadcast";
            if (Objects.nonNull(blockCap)) {
                type = blockCap.hasWitnessSignature() ? "apply" : "pack";
            }
            logger.info("Process transaction {} cost {} ms during {}, {}", new Object[]{Hex.toHexString((byte[])transactionInfo.getId()), cost, type, contract.getType().name()});
        }
        Metrics.histogramObserve((Histogram.Timer)requestTimer);
        return transactionInfo.getInstance();
    }

    public BlockCapsule generateBlock(Param.Miner miner, long blockTime, long timeout) {
        AccountCapsule witnessAccount;
        byte[] privateKeyAddress;
        String address = StringUtil.encode58Check((byte[])miner.getWitnessAddress().toByteArray());
        Histogram.Timer timer = Metrics.histogramStartTimer((String)"tron:block_generate_latency_seconds", (String[])new String[]{address});
        Metrics.histogramObserve((String)"tron:miner_delay_seconds", (double)((double)(System.currentTimeMillis() - blockTime) / 1000.0), (String[])new String[]{address});
        long postponedTrxCount = 0L;
        logger.info("Generate block {} begin.", (Object)(this.chainBaseManager.getHeadBlockNum() + 1L));
        BlockCapsule blockCapsule = new BlockCapsule(this.chainBaseManager.getHeadBlockNum() + 1L, (Sha256Hash)this.chainBaseManager.getHeadBlockId(), blockTime, miner.getWitnessAddress());
        blockCapsule.generatedByMyself = true;
        this.session.reset();
        this.session.setValue(this.revokingStore.buildSession());
        this.accountStateCallBack.preExecute(blockCapsule);
        if (this.getDynamicPropertiesStore().getAllowMultiSign() == 1L && !Arrays.equals(privateKeyAddress = miner.getPrivateKeyAddress().toByteArray(), (witnessAccount = this.getAccountStore().get(miner.getWitnessAddress().toByteArray())).getWitnessPermissionAddress())) {
            logger.warn("Witness permission is wrong.");
            return null;
        }
        HashSet<String> accountSet = new HashSet<String>();
        AtomicInteger shieldedTransCounts = new AtomicInteger(0);
        ArrayList<TransactionCapsule> toBePacked = new ArrayList<TransactionCapsule>();
        long currentSize = blockCapsule.getInstance().getSerializedSize();
        boolean isSort = Args.getInstance().isOpenTransactionSort();
        while (this.pendingTransactions.size() > 0 || this.rePushTransactions.size() > 0) {
            byte[] owner;
            String ownerAddress;
            TransactionCapsule trx;
            boolean fromPending = false;
            if (this.pendingTransactions.size() > 0) {
                trx = (TransactionCapsule)this.pendingTransactions.peek();
                if (isSort) {
                    TransactionCapsule trxRepush = (TransactionCapsule)this.rePushTransactions.peek();
                    if (trxRepush == null || trx.getOrder() >= trxRepush.getOrder()) {
                        fromPending = true;
                    } else {
                        trx = (TransactionCapsule)this.rePushTransactions.poll();
                        Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
                    }
                } else {
                    fromPending = true;
                }
            } else {
                trx = (TransactionCapsule)this.rePushTransactions.poll();
                Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"repush"});
            }
            if (fromPending) {
                this.pendingTransactions.poll();
                Metrics.gaugeInc((String)"tron:manager_queue_size", (double)-1.0, (String[])new String[]{"pending"});
            }
            if (trx == null) {
                logger.warn("Trx is null, fromPending: {}, pending: {}, repush: {}.", new Object[]{fromPending, this.pendingTransactions.size(), this.rePushTransactions.size()});
                continue;
            }
            if (System.currentTimeMillis() > timeout) {
                logger.warn("Processing transaction time exceeds the producing time {}.", (Object)System.currentTimeMillis());
                break;
            }
            long trxPackSize = trx.computeTrxSizeForBlockMessage();
            if (currentSize + trxPackSize > 2000000L) {
                ++postponedTrxCount;
                continue;
            }
            Protocol.Transaction transaction = trx.getInstance();
            if (this.isShieldedTransaction(transaction) && shieldedTransCounts.incrementAndGet() > 1 || accountSet.contains(ownerAddress = ByteArray.toHexString((byte[])(owner = trx.getOwnerAddress())))) continue;
            if (this.isMultiSignTransaction(transaction)) {
                accountSet.add(ownerAddress);
            }
            if (this.ownerAddressSet.contains(ownerAddress)) {
                trx.setVerified(false);
            }
            try {
                ISession tmpSession = this.revokingStore.buildSession();
                Throwable throwable = null;
                try {
                    this.accountStateCallBack.preExeTrans();
                    this.processTransaction(trx, blockCapsule);
                    this.accountStateCallBack.exeTransFinish();
                    tmpSession.merge();
                    toBePacked.add(trx);
                    currentSize += trxPackSize;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tmpSession == null) continue;
                    if (throwable != null) {
                        try {
                            tmpSession.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tmpSession.close();
                }
            }
            catch (Exception e) {
                logger.warn("Process trx {} failed when generating block {}, {}.", new Object[]{trx.getTransactionId(), blockCapsule.getNum(), e.getMessage()});
            }
        }
        blockCapsule.addAllTransactions(toBePacked);
        this.accountStateCallBack.executeGenerateFinish();
        this.session.reset();
        blockCapsule.setMerkleRoot();
        blockCapsule.sign(miner.getPrivateKey());
        BlockCapsule capsule = new BlockCapsule(blockCapsule.getInstance());
        capsule.generatedByMyself = true;
        Metrics.histogramObserve((Histogram.Timer)timer);
        logger.info("Generate block {} success, trxs:{}, pendingCount: {}, rePushCount: {}, postponedCount: {}, blockSize: {} B", new Object[]{capsule.getNum(), capsule.getTransactions().size(), this.pendingTransactions.size(), this.rePushTransactions.size(), postponedTrxCount, capsule.getSerializedSize()});
        return capsule;
    }

    private void filterOwnerAddress(TransactionCapsule transactionCapsule, Set<String> result) {
        byte[] owner = transactionCapsule.getOwnerAddress();
        String ownerAddress = ByteArray.toHexString((byte[])owner);
        if (this.ownerAddressSet.contains(ownerAddress)) {
            result.add(ownerAddress);
        }
    }

    private boolean isMultiSignTransaction(Protocol.Transaction transaction) {
        Protocol.Transaction.Contract contract = transaction.getRawData().getContract(0);
        switch (contract.getType()) {
            case AccountPermissionUpdateContract: {
                return true;
            }
        }
        return false;
    }

    private boolean isShieldedTransaction(Protocol.Transaction transaction) {
        Protocol.Transaction.Contract contract = transaction.getRawData().getContract(0);
        switch (contract.getType()) {
            case ShieldedTransferContract: {
                return true;
            }
        }
        return false;
    }

    public TransactionStore getTransactionStore() {
        return this.chainBaseManager.getTransactionStore();
    }

    public TransactionHistoryStore getTransactionHistoryStore() {
        return this.chainBaseManager.getTransactionHistoryStore();
    }

    public TransactionRetStore getTransactionRetStore() {
        return this.chainBaseManager.getTransactionRetStore();
    }

    public BlockStore getBlockStore() {
        return this.chainBaseManager.getBlockStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlock(BlockCapsule block, List<TransactionCapsule> txs) throws ValidateSignatureException, ContractValidateException, ContractExeException, AccountResourceInsufficientException, TaposException, TooBigTransactionException, DupTransactionException, TransactionExpirationException, ValidateScheduleException, ReceiptCheckErrException, VMIllegalException, TooBigTransactionResultException, ZksnarkException, BadBlockException, EventBloomException {
        boolean flag;
        if (!this.consensus.validBlock(block)) {
            throw new ValidateScheduleException("validateWitnessSchedule error");
        }
        this.chainBaseManager.getBalanceTraceStore().initCurrentBlockBalanceTrace(block);
        this.chainBaseManager.getDynamicPropertiesStore().saveBlockEnergyUsage(0L);
        if (!block.generatedByMyself) {
            try {
                this.preValidateTransactionSign(txs);
            }
            catch (InterruptedException e) {
                logger.error("Parallel check sign interrupted exception! block info: {}.", (Object)block, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        TransactionRetCapsule transactionRetCapsule = new TransactionRetCapsule(block);
        try {
            this.merkleContainer.resetCurrentMerkleTree();
            this.accountStateCallBack.preExecute(block);
            ArrayList<Protocol.TransactionInfo> results = new ArrayList<Protocol.TransactionInfo>();
            long num = block.getNum();
            for (TransactionCapsule transactionCapsule : block.getTransactions()) {
                transactionCapsule.setBlockNum(num);
                if (block.generatedByMyself) {
                    transactionCapsule.setVerified(true);
                }
                this.accountStateCallBack.preExeTrans();
                Protocol.TransactionInfo result = this.processTransaction(transactionCapsule, block);
                this.accountStateCallBack.exeTransFinish();
                if (!Objects.nonNull(result)) continue;
                results.add(result);
            }
            transactionRetCapsule.addAllTransactionInfos(results);
            this.accountStateCallBack.executePushFinish();
        }
        finally {
            this.accountStateCallBack.exceptionFinish();
        }
        this.merkleContainer.saveCurrentMerkleTreeAsBestMerkleTree(block.getNum());
        block.setResult(transactionRetCapsule);
        if (this.getDynamicPropertiesStore().getAllowAdaptiveEnergy() == 1L) {
            EnergyProcessor energyProcessor = new EnergyProcessor(this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAccountStore());
            energyProcessor.updateTotalEnergyAverageUsage();
            energyProcessor.updateAdaptiveTotalEnergyLimit();
        }
        this.payReward(block);
        boolean bl = flag = this.chainBaseManager.getDynamicPropertiesStore().getNextMaintenanceTime() <= block.getTimeStamp();
        if (flag) {
            this.proposalController.processProposals();
        }
        if (!this.consensus.applyBlock(block)) {
            throw new BadBlockException("consensus apply block failed");
        }
        if (flag) {
            this.chainBaseManager.getForkController().reset();
        }
        this.updateTransHashCache(block);
        this.updateRecentBlock(block);
        this.updateRecentTransaction(block);
        this.updateDynamicProperties(block);
        this.chainBaseManager.getBalanceTraceStore().resetCurrentBlockTrace();
        if (CommonParameter.getInstance().isJsonRpcFilterEnabled()) {
            Bloom blockBloom = this.chainBaseManager.getSectionBloomStore().initBlockSection(transactionRetCapsule);
            this.chainBaseManager.getSectionBloomStore().write(block.getNum());
            block.setBloom(blockBloom);
        }
    }

    private void payReward(BlockCapsule block) {
        WitnessCapsule witnessCapsule = (WitnessCapsule)this.chainBaseManager.getWitnessStore().getUnchecked(block.getInstance().getBlockHeader().getRawData().getWitnessAddress().toByteArray());
        if (this.getDynamicPropertiesStore().allowChangeDelegation()) {
            this.mortgageService.payBlockReward(witnessCapsule.getAddress().toByteArray(), this.getDynamicPropertiesStore().getWitnessPayPerBlock());
            this.mortgageService.payStandbyWitness();
            if (this.chainBaseManager.getDynamicPropertiesStore().supportTransactionFeePool()) {
                long transactionFeeReward = Math.floorDiv(this.chainBaseManager.getDynamicPropertiesStore().getTransactionFeePool(), 1L);
                this.mortgageService.payTransactionFeeReward(witnessCapsule.getAddress().toByteArray(), transactionFeeReward);
                this.chainBaseManager.getDynamicPropertiesStore().saveTransactionFeePool(this.chainBaseManager.getDynamicPropertiesStore().getTransactionFeePool() - transactionFeeReward);
            }
        } else {
            byte[] witness = block.getWitnessAddress().toByteArray();
            AccountCapsule account = this.getAccountStore().get(witness);
            account.setAllowance(account.getAllowance() + this.chainBaseManager.getDynamicPropertiesStore().getWitnessPayPerBlock());
            if (this.chainBaseManager.getDynamicPropertiesStore().supportTransactionFeePool()) {
                long transactionFeeReward = Math.floorDiv(this.chainBaseManager.getDynamicPropertiesStore().getTransactionFeePool(), 1L);
                account.setAllowance(account.getAllowance() + transactionFeeReward);
                this.chainBaseManager.getDynamicPropertiesStore().saveTransactionFeePool(this.chainBaseManager.getDynamicPropertiesStore().getTransactionFeePool() - transactionFeeReward);
            }
            this.getAccountStore().put(account.createDbKey(), account);
        }
    }

    private void postSolidityLogContractTrigger(Long blockNum, Long lastSolidityNum) {
        ContractLogTrigger triggerCapsule;
        if (blockNum > lastSolidityNum) {
            return;
        }
        BlockingQueue<ContractLogTrigger> contractLogTriggersQueue = Args.getSolidityContractLogTriggerMap().get(blockNum);
        while (!contractLogTriggersQueue.isEmpty() && (triggerCapsule = (ContractLogTrigger)contractLogTriggersQueue.poll()) != null) {
            if (this.containsTransaction(ByteArray.fromHexString((String)triggerCapsule.getTransactionId()))) {
                triggerCapsule.setTriggerName("solidityLogTrigger");
                EventPluginLoader.getInstance().postSolidityLogTrigger(triggerCapsule);
                continue;
            }
            logger.error("PostSolidityLogContractTrigger txId = {} not contains transaction.", (Object)triggerCapsule.getTransactionId());
        }
        Args.getSolidityContractLogTriggerMap().remove(blockNum);
    }

    private void postSolidityEventContractTrigger(Long blockNum, Long lastSolidityNum) {
        ContractEventTrigger triggerCapsule;
        if (blockNum > lastSolidityNum) {
            return;
        }
        BlockingQueue<ContractEventTrigger> contractEventTriggersQueue = Args.getSolidityContractEventTriggerMap().get(blockNum);
        while (!contractEventTriggersQueue.isEmpty() && (triggerCapsule = (ContractEventTrigger)contractEventTriggersQueue.poll()) != null) {
            if (!this.containsTransaction(ByteArray.fromHexString((String)triggerCapsule.getTransactionId()))) continue;
            triggerCapsule.setTriggerName("solidityEventTrigger");
            EventPluginLoader.getInstance().postSolidityEventTrigger(triggerCapsule);
        }
        Args.getSolidityContractEventTriggerMap().remove(blockNum);
    }

    private void updateTransHashCache(BlockCapsule block) {
        for (TransactionCapsule transactionCapsule : block.getTransactions()) {
            this.transactionIdCache.put((Object)transactionCapsule.getTransactionId(), (Object)true);
        }
    }

    public void updateRecentBlock(BlockCapsule block) {
        this.chainBaseManager.getRecentBlockStore().put(ByteArray.subArray((byte[])ByteArray.fromLong((long)block.getNum()), (int)6, (int)8), (ProtoCapsule)new BytesCapsule(ByteArray.subArray((byte[])block.getBlockId().getBytes(), (int)8, (int)16)));
    }

    public void updateRecentTransaction(BlockCapsule block) {
        ArrayList list = new ArrayList();
        block.getTransactions().forEach(capsule -> list.add(capsule.getTransactionId().toString()));
        RecentTransactionItem item = new RecentTransactionItem(block.getNum(), list);
        this.chainBaseManager.getRecentTransactionStore().put(ByteArray.subArray((byte[])ByteArray.fromLong((long)block.getNum()), (int)6, (int)8), (ProtoCapsule)new BytesCapsule(JsonUtil.obj2Json((Object)item).getBytes()));
    }

    public void updateFork(BlockCapsule block) {
        int blockVersion = block.getInstance().getBlockHeader().getRawData().getVersion();
        if (blockVersion > 28) {
            logger.warn("Newer block version found: {}, YOU MUST UPGRADE java-tron!", (Object)blockVersion);
        }
        this.chainBaseManager.getForkController().update(block);
    }

    public long getSyncBeginNumber() {
        logger.info("HeadNumber: {}, syncBeginNumber: {}, solidBlockNumber: {}.", new Object[]{this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() - (long)this.revokingStore.size(), this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum()});
        return this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber() - (long)this.revokingStore.size();
    }

    public AssetIssueStore getAssetIssueStore() {
        return this.chainBaseManager.getAssetIssueStore();
    }

    public AssetIssueV2Store getAssetIssueV2Store() {
        return this.chainBaseManager.getAssetIssueV2Store();
    }

    public AccountIdIndexStore getAccountIdIndexStore() {
        return this.chainBaseManager.getAccountIdIndexStore();
    }

    public NullifierStore getNullifierStore() {
        return this.chainBaseManager.getNullifierStore();
    }

    public void closeAllStore() {
        logger.info("******** Begin to close db. ********");
        this.chainBaseManager.closeAllStore();
        this.validateSignService.shutdown();
        logger.info("******** End to close db. ********");
    }

    public void closeOneStore(ITronChainBase database) {
        logger.info("******** Begin to close {}. ********", (Object)database.getName());
        try {
            database.close();
        }
        catch (Exception e) {
            logger.info("Failed to close {}.", (Object)database.getName(), (Object)e);
        }
        finally {
            logger.info("******** End to close {}. ********", (Object)database.getName());
        }
    }

    public boolean isTooManyPending() {
        return this.getPendingTransactions().size() + this.getRePushTransactions().size() > this.maxTransactionPendingSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void preValidateTransactionSign(List<TransactionCapsule> txs) throws InterruptedException, ValidateSignatureException {
        int transSize = txs.size();
        if (transSize <= 0) {
            return;
        }
        Histogram.Timer requestTimer = Metrics.histogramStartTimer((String)"tron:verify_sign_latency_seconds", (String[])new String[]{"trx"});
        try {
            CountDownLatch countDownLatch = new CountDownLatch(transSize);
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(transSize);
            for (TransactionCapsule transactionCapsule : txs) {
                Future<Boolean> future = this.validateSignService.submit(new ValidateSignTask(transactionCapsule, countDownLatch, this.chainBaseManager));
                futures.add(future);
            }
            countDownLatch.await();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new ValidateSignatureException(e.getCause().getMessage());
                    return;
                }
            }
        }
        finally {
            Metrics.histogramObserve((Histogram.Timer)requestTimer);
        }
    }

    public void rePush(TransactionCapsule tx) {
        if (this.containsTransaction(tx)) {
            return;
        }
        try {
            this.pushTransaction(tx);
        }
        catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | VMIllegalException | ValidateSignatureException e) {
            logger.debug(e.getMessage(), e);
        }
        catch (DupTransactionException e) {
            logger.debug("Pending manager: dup trans", (Throwable)e);
        }
        catch (TaposException e) {
            logger.debug("Pending manager: tapos exception", (Throwable)e);
        }
        catch (TooBigTransactionException e) {
            logger.debug("Pending manager: too big transaction", (Throwable)e);
        }
        catch (TransactionExpirationException e) {
            logger.debug("Pending manager: expiration transaction", (Throwable)e);
        }
        catch (ReceiptCheckErrException e) {
            logger.debug("Pending manager: outOfSlotTime transaction", (Throwable)e);
        }
        catch (TooBigTransactionResultException e) {
            logger.debug("Pending manager: too big transaction result", (Throwable)e);
        }
    }

    public long getHeadBlockNum() {
        return this.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
    }

    public void setCursor(Chainbase.Cursor cursor) {
        if (cursor == Chainbase.Cursor.PBFT) {
            long headNum = this.getHeadBlockNum();
            long pbftNum = this.chainBaseManager.getCommonDataBase().getLatestPbftBlockNum();
            this.revokingStore.setCursor(cursor, headNum - pbftNum);
        } else {
            this.revokingStore.setCursor(cursor);
        }
    }

    public void resetCursor() {
        this.revokingStore.setCursor(Chainbase.Cursor.HEAD, 0L);
    }

    private void startEventSubscribing() {
        try {
            FilterQuery eventFilter;
            this.eventPluginLoaded = EventPluginLoader.getInstance().start(Args.getInstance().getEventPluginConfig());
            if (!this.eventPluginLoaded) {
                logger.error("Failed to load eventPlugin.");
            }
            if (!Objects.isNull(eventFilter = Args.getInstance().getEventFilter())) {
                EventPluginLoader.getInstance().setFilterQuery(eventFilter);
            }
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
        }
    }

    private void postSolidityFilter(long oldSolidNum, long latestSolidifiedBlockNumber) {
        if (oldSolidNum >= latestSolidifiedBlockNumber) {
            logger.warn("Post solidity filter failed, oldSolidity: {} >= latestSolidity: {}.", (Object)oldSolidNum, (Object)latestSolidifiedBlockNumber);
            return;
        }
        List<BlockCapsule> capsuleList = this.getContinuousBlockCapsule(latestSolidifiedBlockNumber);
        for (BlockCapsule blockCapsule : capsuleList) {
            this.postBlockFilter(blockCapsule, true);
            this.postLogsFilter(blockCapsule, true, false);
        }
    }

    private void postSolidityTrigger(long oldSolidNum, long latestSolidifiedBlockNumber) {
        if (this.eventPluginLoaded && EventPluginLoader.getInstance().isSolidityLogTriggerEnable()) {
            for (Long i : Args.getSolidityContractLogTriggerMap().keySet()) {
                this.postSolidityLogContractTrigger(i, latestSolidifiedBlockNumber);
            }
        }
        if (this.eventPluginLoaded && EventPluginLoader.getInstance().isSolidityEventTriggerEnable()) {
            for (Long i : Args.getSolidityContractEventTriggerMap().keySet()) {
                this.postSolidityEventContractTrigger(i, latestSolidifiedBlockNumber);
            }
        }
        if (this.eventPluginLoaded && EventPluginLoader.getInstance().isSolidityTriggerEnable()) {
            List<BlockCapsule> capsuleList = this.getContinuousBlockCapsule(latestSolidifiedBlockNumber);
            for (BlockCapsule blockCapsule : capsuleList) {
                SolidityTriggerCapsule solidityTriggerCapsule = new SolidityTriggerCapsule(blockCapsule.getNum());
                solidityTriggerCapsule.setTimeStamp(blockCapsule.getTimeStamp());
                boolean result = this.triggerCapsuleQueue.offer(solidityTriggerCapsule);
                if (result) continue;
                logger.info("Too many trigger, lost solidified trigger, block number: {}.", (Object)blockCapsule.getNum());
            }
        }
        if (CommonParameter.getInstance().isJsonRpcHttpSolidityNodeEnable()) {
            this.postSolidityFilter(oldSolidNum, latestSolidifiedBlockNumber);
        }
        this.lastUsedSolidityNum = latestSolidifiedBlockNumber;
    }

    private void processTransactionTrigger(BlockCapsule newBlock) {
        List transactionCapsuleList = newBlock.getTransactions();
        if (EventPluginLoader.getInstance().isTransactionLogTriggerEthCompatible() && newBlock.getNum() != 0L) {
            GrpcAPI.TransactionInfoList transactionInfoList = GrpcAPI.TransactionInfoList.newBuilder().build();
            GrpcAPI.TransactionInfoList.Builder transactionInfoListBuilder = GrpcAPI.TransactionInfoList.newBuilder();
            try {
                TransactionRetCapsule result = this.chainBaseManager.getTransactionRetStore().getTransactionInfoByBlockNum(ByteArray.fromLong((long)newBlock.getNum()));
                if (!Objects.isNull(result) && !Objects.isNull(result.getInstance())) {
                    result.getInstance().getTransactioninfoList().forEach(arg_0 -> ((GrpcAPI.TransactionInfoList.Builder)transactionInfoListBuilder).addTransactionInfo(arg_0));
                    transactionInfoList = transactionInfoListBuilder.build();
                }
            }
            catch (BadItemException e) {
                logger.error("PostBlockTrigger getTransactionInfoList blockNum = {}, error is {}.", (Object)newBlock.getNum(), (Object)e.getMessage());
            }
            if (transactionCapsuleList.size() == transactionInfoList.getTransactionInfoCount()) {
                long cumulativeEnergyUsed = 0L;
                long cumulativeLogCount = 0L;
                long energyUnitPrice = this.chainBaseManager.getDynamicPropertiesStore().getEnergyFee();
                for (int i = 0; i < transactionCapsuleList.size(); ++i) {
                    Protocol.TransactionInfo transactionInfo = transactionInfoList.getTransactionInfo(i);
                    TransactionCapsule transactionCapsule = (TransactionCapsule)transactionCapsuleList.get(i);
                    transactionCapsule.setBlockNum(newBlock.getNum());
                    cumulativeEnergyUsed += this.postTransactionTrigger(transactionCapsule, newBlock, i, cumulativeEnergyUsed, cumulativeLogCount, transactionInfo, energyUnitPrice);
                    cumulativeLogCount += (long)transactionInfo.getLogCount();
                }
            } else {
                logger.error("PostBlockTrigger blockNum = {} has no transactions or {}.", (Object)newBlock.getNum(), (Object)"the sizes of transactionInfoList and transactionCapsuleList are not equal");
                for (TransactionCapsule e : newBlock.getTransactions()) {
                    this.postTransactionTrigger(e, newBlock);
                }
            }
        } else {
            for (TransactionCapsule e : newBlock.getTransactions()) {
                this.postTransactionTrigger(e, newBlock);
            }
        }
    }

    private void reOrgLogsFilter() {
        if (CommonParameter.getInstance().isJsonRpcHttpFullNodeEnable()) {
            logger.info("Switch fork occurred, post reOrgLogsFilter.");
            try {
                BlockCapsule oldHeadBlock = this.chainBaseManager.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
                this.postLogsFilter(oldHeadBlock, false, true);
            }
            catch (BadItemException | ItemNotFoundException e) {
                logger.error("Block header hash does not exist or is bad: {}.", (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            }
        }
    }

    private void postBlockFilter(BlockCapsule blockCapsule, boolean solidified) {
        BlockFilterCapsule blockFilterCapsule = new BlockFilterCapsule(blockCapsule, solidified);
        if (!this.filterCapsuleQueue.offer(blockFilterCapsule)) {
            logger.info("Too many filters, block filter lost: {}.", (Object)blockCapsule.getBlockId());
        }
    }

    private void postLogsFilter(BlockCapsule blockCapsule, boolean solidified, boolean removed) {
        if (!blockCapsule.getTransactions().isEmpty()) {
            long blockNumber = blockCapsule.getNum();
            ArrayList<Protocol.TransactionInfo> transactionInfoList = new ArrayList<Protocol.TransactionInfo>();
            try {
                TransactionRetCapsule result = this.chainBaseManager.getTransactionRetStore().getTransactionInfoByBlockNum(ByteArray.fromLong((long)blockNumber));
                if (!Objects.isNull(result) && !Objects.isNull(result.getInstance())) {
                    transactionInfoList.addAll(result.getInstance().getTransactioninfoList());
                }
            }
            catch (BadItemException e) {
                logger.error("ProcessLogsFilter getTransactionInfoList blockNum = {}, error is {}.", (Object)blockNumber, (Object)e.getMessage());
                return;
            }
            LogsFilterCapsule logsFilterCapsule = new LogsFilterCapsule(blockNumber, blockCapsule.getBlockId().toString(), blockCapsule.getBloom(), transactionInfoList, solidified, removed);
            if (!this.filterCapsuleQueue.offer(logsFilterCapsule)) {
                logger.info("Too many filters, logs filter lost: {}.", (Object)blockNumber);
            }
        }
    }

    private void postBlockTrigger(BlockCapsule blockCapsule) {
        List<Object> capsuleList;
        if (CommonParameter.getInstance().isJsonRpcHttpFullNodeEnable()) {
            this.postBlockFilter(blockCapsule, false);
            this.postLogsFilter(blockCapsule, false, false);
        }
        long solidityBlkNum = this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
        if (this.eventPluginLoaded && EventPluginLoader.getInstance().isBlockLogTriggerEnable()) {
            capsuleList = new ArrayList<BlockCapsule>();
            if (EventPluginLoader.getInstance().isBlockLogTriggerSolidified()) {
                capsuleList = this.getContinuousBlockCapsule(solidityBlkNum);
            } else {
                capsuleList.add(blockCapsule);
            }
            for (BlockCapsule blockCapsule2 : capsuleList) {
                BlockLogTriggerCapsule blockLogTriggerCapsule = new BlockLogTriggerCapsule(blockCapsule2);
                blockLogTriggerCapsule.setLatestSolidifiedBlockNumber(solidityBlkNum);
                if (this.triggerCapsuleQueue.offer(blockLogTriggerCapsule)) continue;
                logger.info("Too many triggers, block trigger lost: {}.", (Object)blockCapsule2.getBlockId());
            }
        }
        if (this.eventPluginLoaded && EventPluginLoader.getInstance().isTransactionLogTriggerEnable()) {
            capsuleList = new ArrayList();
            if (EventPluginLoader.getInstance().isTransactionLogTriggerSolidified()) {
                capsuleList = this.getContinuousBlockCapsule(solidityBlkNum);
            } else {
                capsuleList.add(blockCapsule);
            }
            for (BlockCapsule blockCapsule3 : capsuleList) {
                this.processTransactionTrigger(blockCapsule3);
            }
        }
    }

    private List<BlockCapsule> getContinuousBlockCapsule(long solidityBlkNum) {
        long start;
        ArrayList<BlockCapsule> capsuleList = new ArrayList<BlockCapsule>();
        long l = start = this.lastUsedSolidityNum < 0L ? solidityBlkNum : this.lastUsedSolidityNum + 1L;
        if (solidityBlkNum > start) {
            logger.info("Continuous block start:{}, end:{}", (Object)start, (Object)solidityBlkNum);
        }
        for (long blockNum = start; blockNum <= solidityBlkNum; ++blockNum) {
            try {
                BlockCapsule capsule = this.chainBaseManager.getBlockByNum(blockNum);
                capsuleList.add(capsule);
                continue;
            }
            catch (Exception e) {
                logger.error("GetContinuousBlockCapsule getBlockByNum blkNum = {} except, error is {}.", (Object)solidityBlkNum, (Object)e.getMessage());
            }
        }
        return capsuleList;
    }

    private long postTransactionTrigger(TransactionCapsule trxCap, BlockCapsule blockCap, int index, long preCumulativeEnergyUsed, long cumulativeLogCount, Protocol.TransactionInfo transactionInfo, long energyUnitPrice) {
        TransactionLogTriggerCapsule trx = new TransactionLogTriggerCapsule(trxCap, blockCap, index, preCumulativeEnergyUsed, cumulativeLogCount, transactionInfo, energyUnitPrice);
        trx.setLatestSolidifiedBlockNumber(this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
        if (!this.triggerCapsuleQueue.offer(trx)) {
            logger.info("Too many triggers, transaction trigger lost: {}.", (Object)trxCap.getTransactionId());
        }
        return trx.getTransactionLogTrigger().getEnergyUsageTotal();
    }

    private void postTransactionTrigger(TransactionCapsule trxCap, BlockCapsule blockCap) {
        TransactionLogTriggerCapsule trx = new TransactionLogTriggerCapsule(trxCap, blockCap);
        trx.setLatestSolidifiedBlockNumber(this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
        if (!this.triggerCapsuleQueue.offer(trx)) {
            logger.info("Too many triggers, transaction trigger lost: {}.", (Object)trxCap.getTransactionId());
        }
    }

    private void reOrgContractTrigger() {
        if (this.eventPluginLoaded && (EventPluginLoader.getInstance().isContractEventTriggerEnable() || EventPluginLoader.getInstance().isContractLogTriggerEnable())) {
            logger.info("Switch fork occurred, post reOrgContractTrigger.");
            try {
                BlockCapsule oldHeadBlock = this.chainBaseManager.getBlockById(this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
                for (TransactionCapsule trx : oldHeadBlock.getTransactions()) {
                    this.postContractTrigger(trx.getTrxTrace(), true, oldHeadBlock.getBlockId().toString());
                }
            }
            catch (BadItemException | ItemNotFoundException e) {
                logger.error("Block header hash does not exist or is bad: {}.", (Object)this.getDynamicPropertiesStore().getLatestBlockHeaderHash());
            }
        }
    }

    private void postContractTrigger(TransactionTrace trace, boolean remove, String blockHash) {
        boolean isSolidityContractTriggerEnable;
        boolean isContractTriggerEnable = EventPluginLoader.getInstance().isContractEventTriggerEnable() || EventPluginLoader.getInstance().isContractLogTriggerEnable();
        boolean bl = isSolidityContractTriggerEnable = EventPluginLoader.getInstance().isSolidityEventTriggerEnable() || EventPluginLoader.getInstance().isSolidityLogTriggerEnable();
        if (this.eventPluginLoaded && (isContractTriggerEnable || isSolidityContractTriggerEnable)) {
            for (ContractTrigger trigger : trace.getRuntimeResult().getTriggerList()) {
                ContractTriggerCapsule contractTriggerCapsule = new ContractTriggerCapsule(trigger);
                contractTriggerCapsule.getContractTrigger().setRemoved(remove);
                contractTriggerCapsule.setLatestSolidifiedBlockNumber(this.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
                contractTriggerCapsule.setBlockHash(blockHash);
                if (this.triggerCapsuleQueue.offer(contractTriggerCapsule)) continue;
                logger.info("Too many triggers, contract log trigger lost: {}.", (Object)trigger.getTransactionId());
            }
        }
    }

    private void prepareStoreFactory() {
        StoreFactory.init();
        StoreFactory.getInstance().setChainBaseManager(this.chainBaseManager);
    }

    public TransactionCapsule getTxFromPending(String txId) {
        AtomicReference transactionCapsule = new AtomicReference();
        Sha256Hash txHash = Sha256Hash.wrap((byte[])ByteArray.fromHexString((String)txId));
        this.pendingTransactions.forEach(tx -> {
            if (tx.getTransactionId().equals((Object)txHash)) {
                transactionCapsule.set(tx);
                return;
            }
        });
        if (transactionCapsule.get() != null) {
            return (TransactionCapsule)transactionCapsule.get();
        }
        this.rePushTransactions.forEach(tx -> {
            if (tx.getTransactionId().equals((Object)txHash)) {
                transactionCapsule.set(tx);
                return;
            }
        });
        return (TransactionCapsule)transactionCapsule.get();
    }

    public Collection<String> getTxListFromPending() {
        HashSet<String> result = new HashSet<String>();
        this.pendingTransactions.forEach(tx -> result.add(tx.getTransactionId().toString()));
        this.rePushTransactions.forEach(tx -> result.add(tx.getTransactionId().toString()));
        return result;
    }

    public long getPendingSize() {
        long value = this.getPendingTransactions().size() + this.getRePushTransactions().size() + this.getPoppedTransactions().size();
        return value;
    }

    private void initLiteNode() {
        long headNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        long recentBlockCount = this.chainBaseManager.getRecentBlockStore().size();
        long recentBlockStart = headNum - recentBlockCount + 1L;
        boolean needInit = false;
        if (recentBlockStart == 0L) {
            needInit = true;
        } else {
            try {
                this.chainBaseManager.getBlockByNum(recentBlockStart);
            }
            catch (BadItemException | ItemNotFoundException e) {
                needInit = true;
            }
        }
        if (needInit) {
            logger.info("Load trans for lite node.");
            TransactionCapsule item = new TransactionCapsule(Protocol.Transaction.newBuilder().build());
            long transactionCount = 0L;
            long minBlock = Long.MAX_VALUE;
            long maxBlock = Long.MIN_VALUE;
            for (Map.Entry entry : this.chainBaseManager.getRecentTransactionStore()) {
                byte[] data = ((BytesCapsule)entry.getValue()).getData();
                RecentTransactionItem trx = (RecentTransactionItem)JsonUtil.json2Obj((String)new String(data), RecentTransactionItem.class);
                if (trx == null) continue;
                transactionCount += (long)trx.getTransactionIds().size();
                long blockNum = trx.getNum();
                maxBlock = Math.max(maxBlock, blockNum);
                minBlock = Math.min(minBlock, blockNum);
                item.setBlockNum(blockNum);
                trx.getTransactionIds().forEach(tid -> this.chainBaseManager.getTransactionStore().put(Hex.decode((String)tid), item));
            }
            logger.info("Load trans complete, trans: {}, from = {}, to = {}.", new Object[]{transactionCount, minBlock, maxBlock});
        }
    }

    public void setBlockWaitLock(boolean waitFlag) {
        if (waitFlag) {
            this.blockWaitLock.incrementAndGet();
        } else {
            this.blockWaitLock.decrementAndGet();
        }
    }

    private boolean isBlockWaitingLock() {
        return this.blockWaitLock.get() > 0;
    }

    public boolean isEventPluginLoaded() {
        return this.eventPluginLoaded;
    }

    public void setEventPluginLoaded(boolean eventPluginLoaded) {
        this.eventPluginLoaded = eventPluginLoaded;
    }

    public TransactionCache getTransactionCache() {
        return this.transactionCache;
    }

    public RevokingDatabase getRevokingStore() {
        return this.revokingStore;
    }

    public SessionOptional getSession() {
        return this.session;
    }

    public boolean isSyncMode() {
        return this.isSyncMode;
    }

    public void setSyncMode(boolean isSyncMode) {
        this.isSyncMode = isSyncMode;
    }

    public Object getForkLock() {
        return this.forkLock;
    }

    public String getNetType() {
        return this.netType;
    }

    public void setNetType(String netType) {
        this.netType = netType;
    }

    public ProposalController getProposalController() {
        return this.proposalController;
    }

    public void setProposalController(ProposalController proposalController) {
        this.proposalController = proposalController;
    }

    public MerkleContainer getMerkleContainer() {
        return this.merkleContainer;
    }

    public void setMerkleContainer(MerkleContainer merkleContainer) {
        this.merkleContainer = merkleContainer;
    }

    public Cache<Sha256Hash, Boolean> getTransactionIdCache() {
        return this.transactionIdCache;
    }

    public MortgageService getMortgageService() {
        return this.mortgageService;
    }

    public ChainBaseManager getChainBaseManager() {
        return this.chainBaseManager;
    }

    public AtomicInteger getShieldedTransInPendingCounts() {
        return this.shieldedTransInPendingCounts;
    }

    public long getLatestSolidityNumShutDown() {
        return this.latestSolidityNumShutDown;
    }

    public long getLastUsedSolidityNum() {
        return this.lastUsedSolidityNum;
    }

    public int getMaxFlushCount() {
        return this.maxFlushCount;
    }

    public ThreadLocal<Histogram.Timer> getBlockedTimer() {
        return this.blockedTimer;
    }

    private /* synthetic */ boolean lambda$pushBlock$10(TransactionCapsule tran) {
        return this.isShieldedTransaction(tran.getInstance());
    }

    private static class ValidateSignTask
    implements Callable<Boolean> {
        private TransactionCapsule trx;
        private CountDownLatch countDownLatch;
        private ChainBaseManager manager;

        ValidateSignTask(TransactionCapsule trx, CountDownLatch countDownLatch, ChainBaseManager manager) {
            this.trx = trx;
            this.countDownLatch = countDownLatch;
            this.manager = manager;
        }

        @Override
        public Boolean call() throws ValidateSignatureException {
            try {
                this.trx.validateSignature(this.manager.getAccountStore(), this.manager.getDynamicPropertiesStore());
            }
            catch (ValidateSignatureException e) {
                throw e;
            }
            finally {
                this.countDownLatch.countDown();
            }
            return true;
        }
    }
}

