/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.consensus;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.db.Manager;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.utils.ProposalUtil;

public class ProposalService
extends ProposalUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProposalService.class);

    public static boolean process(Manager manager, ProposalCapsule proposalCapsule) {
        Map map = proposalCapsule.getInstance().getParametersMap();
        boolean find = true;
        block66: for (Map.Entry entry : map.entrySet()) {
            ProposalUtil.ProposalType proposalType = ProposalUtil.ProposalType.getEnumOrNull((long)((Long)entry.getKey()));
            if (proposalType == null) {
                find = false;
                continue;
            }
            switch (proposalType) {
                case MAINTENANCE_TIME_INTERVAL: {
                    manager.getDynamicPropertiesStore().saveMaintenanceTimeInterval(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ACCOUNT_UPGRADE_COST: {
                    manager.getDynamicPropertiesStore().saveAccountUpgradeCost(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case CREATE_ACCOUNT_FEE: {
                    manager.getDynamicPropertiesStore().saveCreateAccountFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case TRANSACTION_FEE: {
                    manager.getDynamicPropertiesStore().saveTransactionFee(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().saveBandwidthPriceHistory(manager.getDynamicPropertiesStore().getBandwidthPriceHistory() + "," + proposalCapsule.getExpirationTime() + ":" + entry.getValue());
                    continue block66;
                }
                case ASSET_ISSUE_FEE: {
                    manager.getDynamicPropertiesStore().saveAssetIssueFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case WITNESS_PAY_PER_BLOCK: {
                    manager.getDynamicPropertiesStore().saveWitnessPayPerBlock(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case WITNESS_STANDBY_ALLOWANCE: {
                    manager.getDynamicPropertiesStore().saveWitnessStandbyAllowance(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT: {
                    manager.getDynamicPropertiesStore().saveCreateNewAccountFeeInSystemContract(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case CREATE_NEW_ACCOUNT_BANDWIDTH_RATE: {
                    manager.getDynamicPropertiesStore().saveCreateNewAccountBandwidthRate(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_CREATION_OF_CONTRACTS: {
                    manager.getDynamicPropertiesStore().saveAllowCreationOfContracts(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case REMOVE_THE_POWER_OF_THE_GR: {
                    if (manager.getDynamicPropertiesStore().getRemoveThePowerOfTheGr() != 0L) continue block66;
                    manager.getDynamicPropertiesStore().saveRemoveThePowerOfTheGr(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ENERGY_FEE: {
                    manager.getDynamicPropertiesStore().saveEnergyFee(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().saveEnergyPriceHistory(manager.getDynamicPropertiesStore().getEnergyPriceHistory() + "," + proposalCapsule.getExpirationTime() + ":" + entry.getValue());
                    continue block66;
                }
                case EXCHANGE_CREATE_FEE: {
                    manager.getDynamicPropertiesStore().saveExchangeCreateFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case MAX_CPU_TIME_OF_ONE_TX: {
                    manager.getDynamicPropertiesStore().saveMaxCpuTimeOfOneTx(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_UPDATE_ACCOUNT_NAME: {
                    manager.getDynamicPropertiesStore().saveAllowUpdateAccountName(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_SAME_TOKEN_NAME: {
                    manager.getDynamicPropertiesStore().saveAllowSameTokenName(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_DELEGATE_RESOURCE: {
                    manager.getDynamicPropertiesStore().saveAllowDelegateResource(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case TOTAL_ENERGY_LIMIT: {
                    manager.getDynamicPropertiesStore().saveTotalEnergyLimit(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_TRANSFER_TRC10: {
                    manager.getDynamicPropertiesStore().saveAllowTvmTransferTrc10(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case TOTAL_CURRENT_ENERGY_LIMIT: {
                    manager.getDynamicPropertiesStore().saveTotalEnergyLimit2(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_MULTI_SIGN: {
                    if (manager.getDynamicPropertiesStore().getAllowMultiSign() != 0L) continue block66;
                    manager.getDynamicPropertiesStore().saveAllowMultiSign(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_ADAPTIVE_ENERGY: {
                    if (manager.getDynamicPropertiesStore().getAllowAdaptiveEnergy() != 0L) continue block66;
                    manager.getDynamicPropertiesStore().saveAllowAdaptiveEnergy(((Long)entry.getValue()).longValue());
                    if (!manager.getChainBaseManager().getForkController().pass(Parameter.ForkBlockVersionEnum.VERSION_3_6_5)) continue block66;
                    manager.getDynamicPropertiesStore().saveAdaptiveResourceLimitTargetRatio(2880L);
                    manager.getDynamicPropertiesStore().saveTotalEnergyTargetLimit(manager.getDynamicPropertiesStore().getTotalEnergyLimit() / 2880L);
                    manager.getDynamicPropertiesStore().saveAdaptiveResourceLimitMultiplier(50L);
                    continue block66;
                }
                case UPDATE_ACCOUNT_PERMISSION_FEE: {
                    manager.getDynamicPropertiesStore().saveUpdateAccountPermissionFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case MULTI_SIGN_FEE: {
                    manager.getDynamicPropertiesStore().saveMultiSignFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_PROTO_FILTER_NUM: {
                    manager.getDynamicPropertiesStore().saveAllowProtoFilterNum(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_ACCOUNT_STATE_ROOT: {
                    manager.getDynamicPropertiesStore().saveAllowAccountStateRoot(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_CONSTANTINOPLE: {
                    manager.getDynamicPropertiesStore().saveAllowTvmConstantinople(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().addSystemContractAndSetPermission(48);
                    continue block66;
                }
                case ALLOW_TVM_SOLIDITY_059: {
                    manager.getDynamicPropertiesStore().saveAllowTvmSolidity059(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO: {
                    long ratio = 1440L * (Long)entry.getValue();
                    manager.getDynamicPropertiesStore().saveAdaptiveResourceLimitTargetRatio(ratio);
                    manager.getDynamicPropertiesStore().saveTotalEnergyTargetLimit(manager.getDynamicPropertiesStore().getTotalEnergyLimit() / ratio);
                    continue block66;
                }
                case ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER: {
                    manager.getDynamicPropertiesStore().saveAdaptiveResourceLimitMultiplier(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_CHANGE_DELEGATION: {
                    manager.getDynamicPropertiesStore().saveChangeDelegation(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().addSystemContractAndSetPermission(49);
                    continue block66;
                }
                case WITNESS_127_PAY_PER_BLOCK: {
                    manager.getDynamicPropertiesStore().saveWitness127PayPerBlock(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case FORBID_TRANSFER_TO_CONTRACT: {
                    manager.getDynamicPropertiesStore().saveForbidTransferToContract(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_PBFT: {
                    manager.getDynamicPropertiesStore().saveAllowPBFT(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_ISTANBUL: {
                    manager.getDynamicPropertiesStore().saveAllowTvmIstanbul(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_SHIELDED_TRC20_TRANSACTION: {
                    manager.getDynamicPropertiesStore().saveAllowShieldedTRC20Transaction(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_MARKET_TRANSACTION: {
                    if (manager.getDynamicPropertiesStore().getAllowMarketTransaction() != 0L) continue block66;
                    manager.getDynamicPropertiesStore().saveAllowMarketTransaction(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().addSystemContractAndSetPermission(52);
                    manager.getDynamicPropertiesStore().addSystemContractAndSetPermission(53);
                    continue block66;
                }
                case MARKET_SELL_FEE: {
                    manager.getDynamicPropertiesStore().saveMarketSellFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case MARKET_CANCEL_FEE: {
                    manager.getDynamicPropertiesStore().saveMarketCancelFee(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case MAX_FEE_LIMIT: {
                    manager.getDynamicPropertiesStore().saveMaxFeeLimit(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TRANSACTION_FEE_POOL: {
                    manager.getDynamicPropertiesStore().saveAllowTransactionFeePool(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_BLACKHOLE_OPTIMIZATION: {
                    manager.getDynamicPropertiesStore().saveAllowBlackHoleOptimization(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_NEW_RESOURCE_MODEL: {
                    manager.getDynamicPropertiesStore().saveAllowNewResourceModel(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_FREEZE: {
                    manager.getDynamicPropertiesStore().saveAllowTvmFreeze(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_VOTE: {
                    manager.getDynamicPropertiesStore().saveNewRewardAlgorithmEffectiveCycle();
                    manager.getDynamicPropertiesStore().saveAllowTvmVote(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_LONDON: {
                    manager.getDynamicPropertiesStore().saveAllowTvmLondon(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_COMPATIBLE_EVM: {
                    manager.getDynamicPropertiesStore().saveAllowTvmCompatibleEvm(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case FREE_NET_LIMIT: {
                    manager.getDynamicPropertiesStore().saveFreeNetLimit(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case TOTAL_NET_LIMIT: {
                    manager.getDynamicPropertiesStore().saveTotalNetLimit(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_ACCOUNT_ASSET_OPTIMIZATION: {
                    manager.getDynamicPropertiesStore().setAllowAccountAssetOptimization(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX: {
                    manager.getDynamicPropertiesStore().saveAllowHigherLimitForMaxCpuTimeOfOneTx(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_ASSET_OPTIMIZATION: {
                    manager.getDynamicPropertiesStore().setAllowAssetOptimization(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_NEW_REWARD: {
                    manager.getDynamicPropertiesStore().saveNewRewardAlgorithmEffectiveCycle();
                    manager.getDynamicPropertiesStore().saveAllowNewReward(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case MEMO_FEE: {
                    manager.getDynamicPropertiesStore().saveMemoFee(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().saveMemoFeeHistory(manager.getDynamicPropertiesStore().getMemoFeeHistory() + "," + proposalCapsule.getExpirationTime() + ":" + entry.getValue());
                    continue block66;
                }
                case UNFREEZE_DELAY_DAYS: {
                    DynamicPropertiesStore dynamicStore = manager.getDynamicPropertiesStore();
                    dynamicStore.saveUnfreezeDelayDays(((Long)entry.getValue()).longValue());
                    dynamicStore.addSystemContractAndSetPermission(54);
                    dynamicStore.addSystemContractAndSetPermission(55);
                    dynamicStore.addSystemContractAndSetPermission(56);
                    dynamicStore.addSystemContractAndSetPermission(57);
                    dynamicStore.addSystemContractAndSetPermission(58);
                    continue block66;
                }
                case ALLOW_DELEGATE_OPTIMIZATION: {
                    manager.getDynamicPropertiesStore().saveAllowDelegateOptimization(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID: {
                    manager.getDynamicPropertiesStore().saveAllowOptimizedReturnValueOfChainId(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_DYNAMIC_ENERGY: {
                    manager.getDynamicPropertiesStore().saveAllowDynamicEnergy(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case DYNAMIC_ENERGY_THRESHOLD: {
                    manager.getDynamicPropertiesStore().saveDynamicEnergyThreshold(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case DYNAMIC_ENERGY_INCREASE_FACTOR: {
                    manager.getDynamicPropertiesStore().saveDynamicEnergyIncreaseFactor(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case DYNAMIC_ENERGY_MAX_FACTOR: {
                    manager.getDynamicPropertiesStore().saveDynamicEnergyMaxFactor(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_TVM_SHANGHAI: {
                    manager.getDynamicPropertiesStore().saveAllowTvmShangHai(((Long)entry.getValue()).longValue());
                    continue block66;
                }
                case ALLOW_CANCEL_ALL_UNFREEZE_V2: {
                    if (manager.getDynamicPropertiesStore().getAllowCancelAllUnfreezeV2() != 0L) continue block66;
                    manager.getDynamicPropertiesStore().saveAllowCancelAllUnfreezeV2(((Long)entry.getValue()).longValue());
                    manager.getDynamicPropertiesStore().addSystemContractAndSetPermission(59);
                    continue block66;
                }
                case MAX_DELEGATE_LOCK_PERIOD: {
                    manager.getDynamicPropertiesStore().saveMaxDelegateLockPeriod(((Long)entry.getValue()).longValue());
                    continue block66;
                }
            }
            find = false;
        }
        return find;
    }
}

