/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.consensus;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.backup.BackupManager;
import org.tron.consensus.Consensus;
import org.tron.consensus.base.BlockHandle;
import org.tron.consensus.base.Param;
import org.tron.consensus.base.State;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.Manager;
import org.tron.core.net.TronNetService;
import org.tron.core.net.message.adv.BlockMessage;

@Component
public class BlockHandleImpl
implements BlockHandle {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private Manager manager;
    @Autowired
    private BackupManager backupManager;
    @Autowired
    private TronNetService tronNetService;
    @Autowired
    private Consensus consensus;

    public State getState() {
        if (!this.backupManager.getStatus().equals((Object)BackupManager.BackupStatusEnum.MASTER)) {
            return State.BACKUP_IS_NOT_MASTER;
        }
        return State.OK;
    }

    public Object getLock() {
        return this.manager;
    }

    public BlockCapsule produce(Param.Miner miner, long blockTime, long timeout) {
        BlockCapsule blockCapsule = this.manager.generateBlock(miner, blockTime, timeout);
        if (blockCapsule == null) {
            return null;
        }
        try {
            this.consensus.receiveBlock(blockCapsule);
            BlockMessage blockMessage = new BlockMessage(blockCapsule);
            this.tronNetService.broadcast(blockMessage);
            this.manager.pushBlock(blockCapsule);
        }
        catch (Exception e) {
            logger.error("Handle block {} failed.", (Object)blockCapsule.getBlockId().getString(), (Object)e);
            return null;
        }
        return blockCapsule;
    }

    public void setBlockWaitLock(boolean flag) {
        this.manager.setBlockWaitLock(flag);
    }
}

