/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.args.Account;
import org.tron.common.args.GenesisBlock;
import org.tron.common.args.Witness;
import org.tron.common.config.DbBackupConfig;
import org.tron.common.crypto.SignInterface;
import org.tron.common.logsfilter.EventPluginConfig;
import org.tron.common.logsfilter.FilterQuery;
import org.tron.common.logsfilter.TriggerConfig;
import org.tron.common.logsfilter.trigger.ContractEventTrigger;
import org.tron.common.logsfilter.trigger.ContractLogTrigger;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.parameter.RateLimiterInitialization;
import org.tron.common.setting.RocksDbSettings;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.LocalWitnesses;
import org.tron.core.Wallet;
import org.tron.core.config.Configuration;
import org.tron.core.config.args.SeedNode;
import org.tron.core.config.args.Storage;
import org.tron.core.exception.CipherException;
import org.tron.core.store.AccountStore;
import org.tron.keystore.Credentials;
import org.tron.keystore.WalletUtils;
import org.tron.p2p.dns.update.DnsType;
import org.tron.p2p.dns.update.PublishConfig;
import org.tron.p2p.utils.NetUtil;
import org.tron.program.Version;

@Component
public class Args
extends CommonParameter {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private static LocalWitnesses localWitnesses = new LocalWitnesses();
    @Autowired(required=false)
    private static final ConcurrentHashMap<Long, BlockingQueue<ContractLogTrigger>> solidityContractLogTriggerMap = new ConcurrentHashMap();
    @Autowired(required=false)
    private static final ConcurrentHashMap<Long, BlockingQueue<ContractEventTrigger>> solidityContractEventTriggerMap = new ConcurrentHashMap();

    public static void clearParam() {
        Args.PARAMETER.outputDirectory = "output-directory";
        Args.PARAMETER.help = false;
        Args.PARAMETER.witness = false;
        Args.PARAMETER.seedNodes = new ArrayList();
        Args.PARAMETER.privateKey = "";
        Args.PARAMETER.witnessAddress = "";
        Args.PARAMETER.storageDbDirectory = "";
        Args.PARAMETER.storageIndexDirectory = "";
        Args.PARAMETER.storageIndexSwitch = "";
        if (Args.PARAMETER.storage != null) {
            Args.PARAMETER.storage.deleteAllStoragePaths();
            Args.PARAMETER.storage = null;
        }
        Args.PARAMETER.overlay = null;
        Args.PARAMETER.seedNode = null;
        Args.PARAMETER.genesisBlock = null;
        Args.PARAMETER.chainId = null;
        localWitnesses = null;
        Args.PARAMETER.needSyncCheck = false;
        Args.PARAMETER.nodeDiscoveryEnable = false;
        Args.PARAMETER.nodeDiscoveryPersist = false;
        Args.PARAMETER.nodeEffectiveCheckEnable = false;
        Args.PARAMETER.nodeConnectionTimeout = 2000;
        Args.PARAMETER.activeNodes = new ArrayList();
        Args.PARAMETER.passiveNodes = new ArrayList();
        Args.PARAMETER.fastForwardNodes = new ArrayList();
        Args.PARAMETER.maxFastForwardNum = 3;
        Args.PARAMETER.nodeChannelReadTimeout = 0;
        Args.PARAMETER.maxConnections = 30;
        Args.PARAMETER.minConnections = 8;
        Args.PARAMETER.minActiveConnections = 3;
        Args.PARAMETER.maxConnectionsWithSameIp = 2;
        Args.PARAMETER.maxTps = 1000;
        Args.PARAMETER.minParticipationRate = 0;
        Args.PARAMETER.nodeListenPort = 0;
        Args.PARAMETER.nodeDiscoveryBindIp = "";
        Args.PARAMETER.nodeExternalIp = "";
        Args.PARAMETER.nodeDiscoveryPublicHomeNode = false;
        Args.PARAMETER.nodeDiscoveryPingTimeout = 15000L;
        Args.PARAMETER.nodeP2pPingInterval = 0L;
        Args.PARAMETER.nodeP2pVersion = 0;
        Args.PARAMETER.nodeEnableIpv6 = false;
        Args.PARAMETER.dnsTreeUrls = new ArrayList();
        Args.PARAMETER.dnsPublishConfig = null;
        Args.PARAMETER.syncFetchBatchNum = 2000L;
        Args.PARAMETER.rpcPort = 0;
        Args.PARAMETER.rpcOnSolidityPort = 0;
        Args.PARAMETER.rpcOnPBFTPort = 0;
        Args.PARAMETER.fullNodeHttpPort = 0;
        Args.PARAMETER.solidityHttpPort = 0;
        Args.PARAMETER.pBFTHttpPort = 0;
        Args.PARAMETER.jsonRpcHttpFullNodePort = 0;
        Args.PARAMETER.jsonRpcHttpSolidityPort = 0;
        Args.PARAMETER.jsonRpcHttpPBFTPort = 0;
        Args.PARAMETER.maintenanceTimeInterval = 0L;
        Args.PARAMETER.proposalExpireTime = 0L;
        Args.PARAMETER.checkFrozenTime = 1;
        Args.PARAMETER.allowCreationOfContracts = 0L;
        Args.PARAMETER.allowAdaptiveEnergy = 0L;
        Args.PARAMETER.allowTvmTransferTrc10 = 0L;
        Args.PARAMETER.allowTvmConstantinople = 0L;
        Args.PARAMETER.allowDelegateResource = 0L;
        Args.PARAMETER.allowSameTokenName = 0L;
        Args.PARAMETER.allowTvmSolidity059 = 0L;
        Args.PARAMETER.forbidTransferToContract = 0L;
        Args.PARAMETER.tcpNettyWorkThreadNum = 0;
        Args.PARAMETER.udpNettyWorkThreadNum = 0;
        Args.PARAMETER.p2pNodeId = "";
        Args.PARAMETER.solidityNode = false;
        Args.PARAMETER.trustNodeAddr = "";
        Args.PARAMETER.walletExtensionApi = false;
        Args.PARAMETER.estimateEnergy = false;
        Args.PARAMETER.estimateEnergyMaxRetry = 3;
        Args.PARAMETER.receiveTcpMinDataLength = 2048L;
        Args.PARAMETER.isOpenFullTcpDisconnect = false;
        Args.PARAMETER.nodeDetectEnable = false;
        Args.PARAMETER.supportConstant = false;
        Args.PARAMETER.debug = false;
        Args.PARAMETER.minTimeRatio = 0.0;
        Args.PARAMETER.maxTimeRatio = 5.0;
        Args.PARAMETER.longRunningTime = 10;
        Args.PARAMETER.maxHttpConnectNumber = 50;
        Args.PARAMETER.allowMultiSign = 0;
        Args.PARAMETER.trxExpirationTimeInMilliseconds = 0L;
        Args.PARAMETER.fullNodeAllowShieldedTransactionArgs = true;
        Args.PARAMETER.zenTokenId = "000000";
        Args.PARAMETER.allowProtoFilterNum = 0L;
        Args.PARAMETER.allowAccountStateRoot = 0L;
        Args.PARAMETER.validContractProtoThreadNum = 1;
        Args.PARAMETER.shieldedTransInPendingMaxCounts = 10;
        Args.PARAMETER.changedDelegation = 0L;
        Args.PARAMETER.fullNodeHttpEnable = true;
        Args.PARAMETER.solidityNodeHttpEnable = true;
        Args.PARAMETER.jsonRpcHttpFullNodeEnable = false;
        Args.PARAMETER.jsonRpcHttpSolidityNodeEnable = false;
        Args.PARAMETER.jsonRpcHttpPBFTNodeEnable = false;
        Args.PARAMETER.nodeMetricsEnable = false;
        Args.PARAMETER.metricsStorageEnable = false;
        Args.PARAMETER.metricsPrometheusEnable = false;
        Args.PARAMETER.agreeNodeCount = 19;
        Args.PARAMETER.allowPBFT = 0L;
        Args.PARAMETER.allowShieldedTRC20Transaction = 0L;
        Args.PARAMETER.allowMarketTransaction = 0L;
        Args.PARAMETER.allowTransactionFeePool = 0L;
        Args.PARAMETER.allowBlackHoleOptimization = 0L;
        Args.PARAMETER.allowNewResourceModel = 0L;
        Args.PARAMETER.allowTvmIstanbul = 0L;
        Args.PARAMETER.allowTvmFreeze = 0L;
        Args.PARAMETER.allowTvmVote = 0L;
        Args.PARAMETER.allowTvmLondon = 0L;
        Args.PARAMETER.allowTvmCompatibleEvm = 0L;
        Args.PARAMETER.historyBalanceLookup = false;
        Args.PARAMETER.openPrintLog = true;
        Args.PARAMETER.openTransactionSort = false;
        Args.PARAMETER.allowAccountAssetOptimization = 0L;
        Args.PARAMETER.allowAssetOptimization = 0L;
        Args.PARAMETER.disabledApiList = Collections.emptyList();
        Args.PARAMETER.shutdownBlockTime = null;
        Args.PARAMETER.shutdownBlockHeight = -1L;
        Args.PARAMETER.shutdownBlockCount = -1L;
        Args.PARAMETER.blockCacheTimeout = 60L;
        Args.PARAMETER.allowNewRewardAlgorithm = 0L;
        Args.PARAMETER.allowNewReward = 0L;
        Args.PARAMETER.memoFee = 0L;
        Args.PARAMETER.rateLimiterGlobalQps = 50000;
        Args.PARAMETER.rateLimiterGlobalIpQps = 10000;
        Args.PARAMETER.p2pDisable = false;
        Args.PARAMETER.dynamicConfigEnable = false;
        Args.PARAMETER.dynamicConfigCheckInterval = 600L;
        Args.PARAMETER.allowTvmShangHai = 0L;
    }

    private static void printVersion() {
        Properties properties = new Properties();
        boolean noGitProperties = true;
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("git.properties");
            if (in != null) {
                noGitProperties = false;
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        JCommander.getConsole().println("OS : " + System.getProperty("os.name"));
        JCommander.getConsole().println("JVM : " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.arch"));
        if (!noGitProperties) {
            JCommander.getConsole().println("Git : " + properties.getProperty("git.commit.id"));
        }
        JCommander.getConsole().println("Version : " + Version.getVersion());
        JCommander.getConsole().println("Code : 18031");
    }

    public static void printHelp(JCommander jCommander) {
        List parameterDescriptionList = jCommander.getParameters();
        HashMap<String, ParameterDescription> stringParameterDescriptionMap = new HashMap<String, ParameterDescription>();
        for (ParameterDescription parameterDescription : parameterDescriptionList) {
            String parameterName = parameterDescription.getParameterized().getName();
            stringParameterDescriptionMap.put(parameterName, parameterDescription);
        }
        StringBuilder helpStr = new StringBuilder();
        helpStr.append("Name:\n\tFullNode - the java-tron command line interface\n");
        String programName = Strings.isNullOrEmpty((String)jCommander.getProgramName()) ? "FullNode.jar" : jCommander.getProgramName();
        helpStr.append(String.format("%nUsage: java -jar %s [options] [seedNode <seedNode> ...]%n", programName));
        helpStr.append(String.format("%nVERSION: %n%s-%s%n", Version.getVersion(), Args.getCommitIdAbbrev()));
        Map<String, String[]> groupOptionListMap = Args.getOptionGroup();
        for (Map.Entry<String, String[]> entry : groupOptionListMap.entrySet()) {
            String group = entry.getKey();
            helpStr.append(String.format("%n%s OPTIONS:%n", group.toUpperCase()));
            int optionMaxLength = Arrays.stream((Object[])entry.getValue()).mapToInt(p -> {
                ParameterDescription tmpParameterDescription = (ParameterDescription)stringParameterDescriptionMap.get(p);
                if (tmpParameterDescription == null) {
                    return 1;
                }
                return tmpParameterDescription.getNames().length();
            }).max().orElse(1);
            for (String option : groupOptionListMap.get(group)) {
                ParameterDescription parameterDescription = (ParameterDescription)stringParameterDescriptionMap.get(option);
                if (parameterDescription == null) {
                    logger.warn("Miss option:{}", (Object)option);
                    continue;
                }
                String tmpOptionDesc = String.format("%s\t\t\t%s%n", Strings.padEnd((String)parameterDescription.getNames(), (int)optionMaxLength, (char)' '), Args.upperFirst(parameterDescription.getDescription()));
                helpStr.append(tmpOptionDesc);
            }
        }
        JCommander.getConsole().println(helpStr.toString());
    }

    public static String upperFirst(String name) {
        if (name.length() <= 1) {
            return name;
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    private static String getCommitIdAbbrev() {
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("git.properties");
            properties.load(in);
        }
        catch (IOException e) {
            logger.warn("Load resource failed,git.properties {}", (Object)e.getMessage());
        }
        return properties.getProperty("git.commit.id.abbrev");
    }

    private static Map<String, String[]> getOptionGroup() {
        String[] tronOption = new String[]{"version", "help", "shellConfFileName", "logbackPath", "eventSubscribe"};
        String[] dbOption = new String[]{"outputDirectory"};
        String[] witnessOption = new String[]{"witness", "privateKey"};
        String[] vmOption = new String[]{"debug"};
        LinkedHashMap<String, String[]> optionGroupMap = new LinkedHashMap<String, String[]>();
        optionGroupMap.put("tron", tronOption);
        optionGroupMap.put("db", dbOption);
        optionGroupMap.put("witness", witnessOption);
        optionGroupMap.put("virtual machine", vmOption);
        Iterator iterator = optionGroupMap.values().iterator();
        while (iterator.hasNext()) {
            String[] optionList;
            for (String option : optionList = (String[])iterator.next()) {
                try {
                    CommonParameter.class.getField(option);
                }
                catch (NoSuchFieldException e) {
                    logger.warn("NoSuchFieldException:{},{}", (Object)option, (Object)e.getMessage());
                }
            }
        }
        return optionGroupMap;
    }

    public static void setParam(String[] args, String confFileName) {
        Config config;
        JCommander.newBuilder().addObject((Object)PARAMETER).build().parse(args);
        if (Args.PARAMETER.version) {
            Args.printVersion();
            System.exit(0);
        }
        if ((config = Configuration.getByFileName((String)Args.PARAMETER.shellConfFileName, (String)confFileName)).hasPath("net.type") && "testnet".equalsIgnoreCase(config.getString("net.type"))) {
            Wallet.setAddressPreFixByte((byte)-96);
            Wallet.setAddressPreFixString("a0");
        } else {
            Wallet.setAddressPreFixByte((byte)65);
            Wallet.setAddressPreFixString("41");
        }
        String string = Args.PARAMETER.cryptoEngine = config.hasPath("crypto.engine") ? config.getString("crypto.engine") : "ECKey";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Args.PARAMETER.privateKey})) {
            localWitnesses = new LocalWitnesses(Args.PARAMETER.privateKey);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Args.PARAMETER.witnessAddress})) {
                byte[] bytes = Commons.decodeFromBase58Check((String)Args.PARAMETER.witnessAddress);
                if (bytes != null) {
                    localWitnesses.setWitnessAccountAddress(bytes);
                    logger.debug("Got localWitnessAccountAddress from cmd");
                } else {
                    Args.PARAMETER.witnessAddress = "";
                    logger.warn("The localWitnessAccountAddress format is incorrect, ignored");
                }
            }
            localWitnesses.initWitnessAccountAddress(PARAMETER.isECKeyCryptoEngine());
            logger.debug("Got privateKey from cmd");
        } else if (config.hasPath("localwitness")) {
            localWitnesses = new LocalWitnesses();
            List localwitness = config.getStringList("localwitness");
            localWitnesses.setPrivateKeys(localwitness);
            Args.witnessAddressCheck(config);
            localWitnesses.initWitnessAccountAddress(PARAMETER.isECKeyCryptoEngine());
            logger.debug("Got privateKey from config.conf");
        } else if (config.hasPath("localwitnesskeystore")) {
            List localwitness;
            localWitnesses = new LocalWitnesses();
            ArrayList<String> privateKeys = new ArrayList<String>();
            if (PARAMETER.isWitness() && (localwitness = config.getStringList("localwitnesskeystore")).size() > 0) {
                String password;
                String fileName = System.getProperty("user.dir") + "/" + (String)localwitness.get(0);
                if (StringUtils.isEmpty((CharSequence)Args.PARAMETER.password)) {
                    System.out.println("Please input your password.");
                    password = WalletUtils.inputPassword();
                } else {
                    password = Args.PARAMETER.password;
                    Args.PARAMETER.password = null;
                }
                try {
                    Credentials credentials = WalletUtils.loadCredentials(password, new File(fileName));
                    SignInterface sign = credentials.getSignInterface();
                    String prikey = ByteArray.toHexString((byte[])sign.getPrivateKey());
                    privateKeys.add(prikey);
                }
                catch (IOException | CipherException e) {
                    logger.error(e.getMessage());
                    logger.error("Witness node start failed!");
                    System.exit(-1);
                }
            }
            localWitnesses.setPrivateKeys(privateKeys);
            Args.witnessAddressCheck(config);
            localWitnesses.initWitnessAccountAddress(PARAMETER.isECKeyCryptoEngine());
            logger.debug("Got privateKey from keystore");
        }
        if (PARAMETER.isWitness() && CollectionUtils.isEmpty((Collection)localWitnesses.getPrivateKeys())) {
            logger.warn("This is a witness node, but localWitnesses is null");
        }
        if (config.hasPath("vm.supportConstant")) {
            Args.PARAMETER.supportConstant = config.getBoolean("vm.supportConstant");
        }
        if (config.hasPath("vm.maxEnergyLimitForConstant")) {
            long configLimit = config.getLong("vm.maxEnergyLimitForConstant");
            Args.PARAMETER.maxEnergyLimitForConstant = Math.max(3000000L, configLimit);
        }
        if (config.hasPath("vm.lruCacheSize")) {
            Args.PARAMETER.lruCacheSize = config.getInt("vm.lruCacheSize");
        }
        if (config.hasPath("node.http.fullNodeEnable")) {
            Args.PARAMETER.fullNodeHttpEnable = config.getBoolean("node.http.fullNodeEnable");
        }
        if (config.hasPath("node.http.solidityEnable")) {
            Args.PARAMETER.solidityNodeHttpEnable = config.getBoolean("node.http.solidityEnable");
        }
        if (config.hasPath("node.jsonrpc.httpFullNodeEnable")) {
            Args.PARAMETER.jsonRpcHttpFullNodeEnable = config.getBoolean("node.jsonrpc.httpFullNodeEnable");
        }
        if (config.hasPath("node.jsonrpc.httpSolidityEnable")) {
            Args.PARAMETER.jsonRpcHttpSolidityNodeEnable = config.getBoolean("node.jsonrpc.httpSolidityEnable");
        }
        if (config.hasPath("node.jsonrpc.httpPBFTEnable")) {
            Args.PARAMETER.jsonRpcHttpPBFTNodeEnable = config.getBoolean("node.jsonrpc.httpPBFTEnable");
        }
        if (config.hasPath("vm.minTimeRatio")) {
            Args.PARAMETER.minTimeRatio = config.getDouble("vm.minTimeRatio");
        }
        if (config.hasPath("vm.maxTimeRatio")) {
            Args.PARAMETER.maxTimeRatio = config.getDouble("vm.maxTimeRatio");
        }
        if (config.hasPath("vm.longRunningTime")) {
            Args.PARAMETER.longRunningTime = config.getInt("vm.longRunningTime");
        }
        Args.PARAMETER.storage = new Storage();
        Args.PARAMETER.storage.setDbEngine(Optional.ofNullable(Args.PARAMETER.storageDbEngine).filter(StringUtils::isNotEmpty).orElse(Storage.getDbEngineFromConfig((Config)config)));
        Args.PARAMETER.storage.setDbSync(Optional.ofNullable(Args.PARAMETER.storageDbSynchronous).filter(StringUtils::isNotEmpty).map(Boolean::valueOf).orElse(Storage.getDbVersionSyncFromConfig((Config)config)).booleanValue());
        Args.PARAMETER.storage.setContractParseSwitch(Optional.ofNullable(Args.PARAMETER.contractParseEnable).filter(StringUtils::isNotEmpty).map(Boolean::valueOf).orElse(Storage.getContractParseSwitchFromConfig((Config)config)).booleanValue());
        Args.PARAMETER.storage.setDbDirectory(Optional.ofNullable(Args.PARAMETER.storageDbDirectory).filter(StringUtils::isNotEmpty).orElse(Storage.getDbDirectoryFromConfig((Config)config)));
        Args.PARAMETER.storage.setIndexDirectory(Optional.ofNullable(Args.PARAMETER.storageIndexDirectory).filter(StringUtils::isNotEmpty).orElse(Storage.getIndexDirectoryFromConfig((Config)config)));
        Args.PARAMETER.storage.setIndexSwitch(Optional.ofNullable(Args.PARAMETER.storageIndexSwitch).filter(StringUtils::isNotEmpty).orElse(Storage.getIndexSwitchFromConfig((Config)config)));
        Args.PARAMETER.storage.setTransactionHistorySwitch(Optional.ofNullable(Args.PARAMETER.storageTransactionHistorySwitch).filter(StringUtils::isNotEmpty).orElse(Storage.getTransactionHistorySwitchFromConfig((Config)config)));
        Args.PARAMETER.storage.setCheckpointVersion(Storage.getCheckpointVersionFromConfig((Config)config));
        Args.PARAMETER.storage.setCheckpointSync(Storage.getCheckpointSyncFromConfig((Config)config));
        Args.PARAMETER.storage.setEstimatedBlockTransactions(Storage.getEstimatedTransactionsFromConfig((Config)config));
        Args.PARAMETER.storage.setMaxFlushCount(Storage.getSnapshotMaxFlushCountFromConfig((Config)config));
        Args.PARAMETER.storage.setDefaultDbOptions(config);
        Args.PARAMETER.storage.setPropertyMapFromConfig(config);
        Args.PARAMETER.storage.setCacheStrategies(config);
        Args.PARAMETER.seedNode = new SeedNode();
        Args.PARAMETER.seedNode.setAddressList(Args.loadSeeds(config));
        if (config.hasPath("genesis.block")) {
            Args.PARAMETER.genesisBlock = new GenesisBlock();
            Args.PARAMETER.genesisBlock.setTimestamp(config.getString("genesis.block.timestamp"));
            Args.PARAMETER.genesisBlock.setParentHash(config.getString("genesis.block.parentHash"));
            if (config.hasPath("genesis.block.assets")) {
                Args.PARAMETER.genesisBlock.setAssets(Args.getAccountsFromConfig(config));
                AccountStore.setAccount((Config)config);
            }
            if (config.hasPath("genesis.block.witnesses")) {
                Args.PARAMETER.genesisBlock.setWitnesses(Args.getWitnessesFromConfig(config));
            }
        } else {
            Args.PARAMETER.genesisBlock = GenesisBlock.getDefault();
        }
        Args.PARAMETER.needSyncCheck = config.hasPath("block.needSyncCheck") && config.getBoolean("block.needSyncCheck");
        Args.PARAMETER.nodeDiscoveryEnable = config.hasPath("node.discovery.enable") && config.getBoolean("node.discovery.enable");
        Args.PARAMETER.nodeDiscoveryPersist = config.hasPath("node.discovery.persist") && config.getBoolean("node.discovery.persist");
        Args.PARAMETER.nodeEffectiveCheckEnable = config.hasPath("node.effectiveCheckEnable") && config.getBoolean("node.effectiveCheckEnable");
        int n = Args.PARAMETER.nodeConnectionTimeout = config.hasPath("node.connection.timeout") ? config.getInt("node.connection.timeout") * 1000 : 2000;
        Args.PARAMETER.fetchBlockTimeout = !config.hasPath("node.fetchBlock.timeout") ? 500 : (config.getInt("node.fetchBlock.timeout") > 1000 ? 1000 : (config.getInt("node.fetchBlock.timeout") < 100 ? 100 : config.getInt("node.fetchBlock.timeout")));
        int n2 = Args.PARAMETER.nodeChannelReadTimeout = config.hasPath("node.channel.read.timeout") ? config.getInt("node.channel.read.timeout") : 0;
        if (config.hasPath("node.maxActiveNodes")) {
            Args.PARAMETER.maxConnections = config.getInt("node.maxActiveNodes");
        } else {
            int n3 = Args.PARAMETER.maxConnections = config.hasPath("node.maxConnections") ? config.getInt("node.maxConnections") : 30;
        }
        if (config.hasPath("node.maxActiveNodes") && config.hasPath("node.connectFactor")) {
            Args.PARAMETER.minConnections = (int)((double)Args.PARAMETER.maxConnections * config.getDouble("node.connectFactor"));
        } else {
            int n4 = Args.PARAMETER.minConnections = config.hasPath("node.minConnections") ? config.getInt("node.minConnections") : 8;
        }
        if (config.hasPath("node.maxActiveNodes") && config.hasPath("node.activeConnectFactor")) {
            Args.PARAMETER.minActiveConnections = (int)((double)Args.PARAMETER.maxConnections * config.getDouble("node.activeConnectFactor"));
        } else {
            int n5 = Args.PARAMETER.minActiveConnections = config.hasPath("node.minActiveConnections") ? config.getInt("node.minActiveConnections") : 3;
        }
        Args.PARAMETER.maxConnectionsWithSameIp = config.hasPath("node.maxActiveNodesWithSameIp") ? config.getInt("node.maxActiveNodesWithSameIp") : (config.hasPath("node.maxConnectionsWithSameIp") ? config.getInt("node.maxConnectionsWithSameIp") : 2);
        Args.PARAMETER.maxTps = config.hasPath("node.maxTps") ? config.getInt("node.maxTps") : 1000;
        Args.PARAMETER.minParticipationRate = config.hasPath("node.minParticipationRate") ? config.getInt("node.minParticipationRate") : 0;
        Args.PARAMETER.nodeListenPort = config.hasPath("node.listen.port") ? config.getInt("node.listen.port") : 0;
        Args.bindIp(config);
        Args.externalIp(config);
        Args.PARAMETER.nodeDiscoveryPublicHomeNode = config.hasPath("node.discovery.public.home.node") && config.getBoolean("node.discovery.public.home.node");
        Args.PARAMETER.nodeDiscoveryPingTimeout = config.hasPath("node.discovery.ping.timeout") ? config.getLong("node.discovery.ping.timeout") : 15000L;
        Args.PARAMETER.nodeP2pPingInterval = config.hasPath("node.p2p.pingInterval") ? config.getLong("node.p2p.pingInterval") : 0L;
        Args.PARAMETER.nodeP2pVersion = config.hasPath("node.p2p.version") ? config.getInt("node.p2p.version") : 0;
        Args.PARAMETER.nodeEnableIpv6 = config.hasPath("node.enableIpv6") && config.getBoolean("node.enableIpv6");
        Args.PARAMETER.dnsTreeUrls = config.hasPath("node.dns.treeUrls") ? config.getStringList("node.dns.treeUrls") : new ArrayList();
        Args.PARAMETER.dnsPublishConfig = Args.loadDnsPublishConfig(config);
        long l = Args.PARAMETER.syncFetchBatchNum = config.hasPath("node.syncFetchBatchNum") ? (long)config.getInt("node.syncFetchBatchNum") : 2000L;
        if (Args.PARAMETER.syncFetchBatchNum > 2000L) {
            Args.PARAMETER.syncFetchBatchNum = 2000L;
        }
        if (Args.PARAMETER.syncFetchBatchNum < 100L) {
            Args.PARAMETER.syncFetchBatchNum = 100L;
        }
        Args.PARAMETER.rpcPort = config.hasPath("node.rpc.port") ? config.getInt("node.rpc.port") : 50051;
        Args.PARAMETER.rpcOnSolidityPort = config.hasPath("node.rpc.solidityPort") ? config.getInt("node.rpc.solidityPort") : 50061;
        Args.PARAMETER.rpcOnPBFTPort = config.hasPath("node.rpc.PBFTPort") ? config.getInt("node.rpc.PBFTPort") : 50071;
        Args.PARAMETER.fullNodeHttpPort = config.hasPath("node.http.fullNodePort") ? config.getInt("node.http.fullNodePort") : 8090;
        Args.PARAMETER.solidityHttpPort = config.hasPath("node.http.solidityPort") ? config.getInt("node.http.solidityPort") : 8091;
        Args.PARAMETER.pBFTHttpPort = config.hasPath("node.http.PBFTPort") ? config.getInt("node.http.PBFTPort") : 8092;
        Args.PARAMETER.jsonRpcHttpFullNodePort = config.hasPath("node.jsonrpc.httpFullNodePort") ? config.getInt("node.jsonrpc.httpFullNodePort") : 8545;
        Args.PARAMETER.jsonRpcHttpSolidityPort = config.hasPath("node.jsonrpc.httpSolidityPort") ? config.getInt("node.jsonrpc.httpSolidityPort") : 8555;
        Args.PARAMETER.jsonRpcHttpPBFTPort = config.hasPath("node.jsonrpc.httpPBFTPort") ? config.getInt("node.jsonrpc.httpPBFTPort") : 8565;
        Args.PARAMETER.rpcThreadNum = config.hasPath("node.rpc.thread") ? config.getInt("node.rpc.thread") : (Runtime.getRuntime().availableProcessors() + 1) / 2;
        Args.PARAMETER.solidityThreads = config.hasPath("node.solidity.threads") ? config.getInt("node.solidity.threads") : Runtime.getRuntime().availableProcessors();
        Args.PARAMETER.maxConcurrentCallsPerConnection = config.hasPath("node.rpc.maxConcurrentCallsPerConnection") ? config.getInt("node.rpc.maxConcurrentCallsPerConnection") : Integer.MAX_VALUE;
        Args.PARAMETER.flowControlWindow = config.hasPath("node.rpc.flowControlWindow") ? config.getInt("node.rpc.flowControlWindow") : 0x100000;
        Args.PARAMETER.maxConnectionIdleInMillis = config.hasPath("node.rpc.maxConnectionIdleInMillis") ? config.getLong("node.rpc.maxConnectionIdleInMillis") : Long.MAX_VALUE;
        Args.PARAMETER.blockProducedTimeOut = config.hasPath("node.blockProducedTimeOut") ? config.getInt("node.blockProducedTimeOut") : 50;
        int n6 = Args.PARAMETER.maxHttpConnectNumber = config.hasPath("node.maxHttpConnectNumber") ? config.getInt("node.maxHttpConnectNumber") : 50;
        if (Args.PARAMETER.blockProducedTimeOut < 30) {
            Args.PARAMETER.blockProducedTimeOut = 30;
        }
        if (Args.PARAMETER.blockProducedTimeOut > 100) {
            Args.PARAMETER.blockProducedTimeOut = 100;
        }
        Args.PARAMETER.netMaxTrxPerSecond = config.hasPath("node.netMaxTrxPerSecond") ? (long)config.getInt("node.netMaxTrxPerSecond") : 700L;
        Args.PARAMETER.maxConnectionAgeInMillis = config.hasPath("node.rpc.maxConnectionAgeInMillis") ? config.getLong("node.rpc.maxConnectionAgeInMillis") : Long.MAX_VALUE;
        Args.PARAMETER.maxMessageSize = config.hasPath("node.rpc.maxMessageSize") ? config.getInt("node.rpc.maxMessageSize") : 0x400000;
        Args.PARAMETER.maxHeaderListSize = config.hasPath("node.rpc.maxHeaderListSize") ? config.getInt("node.rpc.maxHeaderListSize") : 8192;
        Args.PARAMETER.maintenanceTimeInterval = config.hasPath("block.maintenanceTimeInterval") ? (long)config.getInt("block.maintenanceTimeInterval") : 21600000L;
        Args.PARAMETER.proposalExpireTime = config.hasPath("block.proposalExpireTime") ? (long)config.getInt("block.proposalExpireTime") : 259200000L;
        Args.PARAMETER.checkFrozenTime = config.hasPath("block.checkFrozenTime") ? config.getInt("block.checkFrozenTime") : 1;
        Args.PARAMETER.allowCreationOfContracts = config.hasPath("committee.allowCreationOfContracts") ? (long)config.getInt("committee.allowCreationOfContracts") : 0L;
        Args.PARAMETER.allowMultiSign = config.hasPath("committee.allowMultiSign") ? config.getInt("committee.allowMultiSign") : 0;
        Args.PARAMETER.allowAdaptiveEnergy = config.hasPath("committee.allowAdaptiveEnergy") ? (long)config.getInt("committee.allowAdaptiveEnergy") : 0L;
        Args.PARAMETER.allowDelegateResource = config.hasPath("committee.allowDelegateResource") ? (long)config.getInt("committee.allowDelegateResource") : 0L;
        Args.PARAMETER.allowSameTokenName = config.hasPath("committee.allowSameTokenName") ? (long)config.getInt("committee.allowSameTokenName") : 0L;
        Args.PARAMETER.allowTvmTransferTrc10 = config.hasPath("committee.allowTvmTransferTrc10") ? (long)config.getInt("committee.allowTvmTransferTrc10") : 0L;
        Args.PARAMETER.allowTvmConstantinople = config.hasPath("committee.allowTvmConstantinople") ? (long)config.getInt("committee.allowTvmConstantinople") : 0L;
        Args.PARAMETER.allowTvmSolidity059 = config.hasPath("committee.allowTvmSolidity059") ? (long)config.getInt("committee.allowTvmSolidity059") : 0L;
        Args.PARAMETER.forbidTransferToContract = config.hasPath("committee.forbidTransferToContract") ? (long)config.getInt("committee.forbidTransferToContract") : 0L;
        Args.PARAMETER.tcpNettyWorkThreadNum = config.hasPath("node.tcpNettyWorkThreadNum") ? config.getInt("node.tcpNettyWorkThreadNum") : 0;
        int n7 = Args.PARAMETER.udpNettyWorkThreadNum = config.hasPath("node.udpNettyWorkThreadNum") ? config.getInt("node.udpNettyWorkThreadNum") : 1;
        if (StringUtils.isEmpty((CharSequence)Args.PARAMETER.trustNodeAddr)) {
            Args.PARAMETER.trustNodeAddr = config.hasPath("node.trustNode") ? config.getString("node.trustNode") : null;
        }
        Args.PARAMETER.validateSignThreadNum = config.hasPath("node.validateSignThreadNum") ? config.getInt("node.validateSignThreadNum") : (Runtime.getRuntime().availableProcessors() + 1) / 2;
        Args.PARAMETER.walletExtensionApi = config.hasPath("node.walletExtensionApi") && config.getBoolean("node.walletExtensionApi");
        Args.PARAMETER.estimateEnergy = config.hasPath("vm.estimateEnergy") && config.getBoolean("vm.estimateEnergy");
        int n8 = Args.PARAMETER.estimateEnergyMaxRetry = config.hasPath("vm.estimateEnergyMaxRetry") ? config.getInt("vm.estimateEnergyMaxRetry") : 3;
        if (Args.PARAMETER.estimateEnergyMaxRetry < 0) {
            Args.PARAMETER.estimateEnergyMaxRetry = 0;
        }
        if (Args.PARAMETER.estimateEnergyMaxRetry > 10) {
            Args.PARAMETER.estimateEnergyMaxRetry = 10;
        }
        Args.PARAMETER.receiveTcpMinDataLength = config.hasPath("node.receiveTcpMinDataLength") ? config.getLong("node.receiveTcpMinDataLength") : 2048L;
        Args.PARAMETER.isOpenFullTcpDisconnect = config.hasPath("node.isOpenFullTcpDisconnect") && config.getBoolean("node.isOpenFullTcpDisconnect");
        Args.PARAMETER.nodeDetectEnable = config.hasPath("node.nodeDetectEnable") && config.getBoolean("node.nodeDetectEnable");
        Args.PARAMETER.maxTransactionPendingSize = config.hasPath("node.maxTransactionPendingSize") ? config.getInt("node.maxTransactionPendingSize") : 2000;
        Args.PARAMETER.pendingTransactionTimeout = config.hasPath("node.pendingTransactionTimeout") ? config.getLong("node.pendingTransactionTimeout") : 60000L;
        Args.PARAMETER.needToUpdateAsset = !config.hasPath("storage.needToUpdateAsset") || config.getBoolean("storage.needToUpdateAsset");
        Args.PARAMETER.trxReferenceBlock = config.hasPath("trx.reference.block") ? config.getString("trx.reference.block") : "solid";
        Args.PARAMETER.trxExpirationTimeInMilliseconds = config.hasPath("trx.expiration.timeInMilliseconds") && config.getLong("trx.expiration.timeInMilliseconds") > 0L ? config.getLong("trx.expiration.timeInMilliseconds") : 60000L;
        Args.PARAMETER.minEffectiveConnection = config.hasPath("node.rpc.minEffectiveConnection") ? config.getInt("node.rpc.minEffectiveConnection") : 1;
        Args.PARAMETER.trxCacheEnable = config.hasPath("node.rpc.trxCacheEnable") && config.getBoolean("node.rpc.trxCacheEnable");
        Args.PARAMETER.blockNumForEnergyLimit = config.hasPath("enery.limit.block.num") ? (long)config.getInt("enery.limit.block.num") : 4727890L;
        Args.PARAMETER.vmTrace = config.hasPath("vm.vmTrace") && config.getBoolean("vm.vmTrace");
        Args.PARAMETER.saveInternalTx = config.hasPath("vm.saveInternalTx") && config.getBoolean("vm.saveInternalTx");
        Args.PARAMETER.saveFeaturedInternalTx = config.hasPath("vm.saveFeaturedInternalTx") && config.getBoolean("vm.saveFeaturedInternalTx");
        Args.PARAMETER.allowShieldedTRC20Transaction = config.hasPath("committee.allowShieldedTRC20Transaction") ? (long)config.getInt("committee.allowShieldedTRC20Transaction") : 0L;
        Args.PARAMETER.allowMarketTransaction = config.hasPath("committee.allowMarketTransaction") ? (long)config.getInt("committee.allowMarketTransaction") : 0L;
        Args.PARAMETER.allowTransactionFeePool = config.hasPath("committee.allowTransactionFeePool") ? (long)config.getInt("committee.allowTransactionFeePool") : 0L;
        Args.PARAMETER.allowBlackHoleOptimization = config.hasPath("committee.allowBlackHoleOptimization") ? (long)config.getInt("committee.allowBlackHoleOptimization") : 0L;
        Args.PARAMETER.allowNewResourceModel = config.hasPath("committee.allowNewResourceModel") ? (long)config.getInt("committee.allowNewResourceModel") : 0L;
        Args.PARAMETER.allowTvmIstanbul = config.hasPath("committee.allowTvmIstanbul") ? (long)config.getInt("committee.allowTvmIstanbul") : 0L;
        Args.PARAMETER.eventPluginConfig = config.hasPath("event.subscribe") ? Args.getEventPluginConfig(config) : null;
        Args.PARAMETER.eventFilter = config.hasPath("event.subscribe.filter") ? Args.getEventFilter(config) : null;
        Args.PARAMETER.fullNodeAllowShieldedTransactionArgs = !config.hasPath("node.fullNodeAllowShieldedTransaction") || config.getBoolean("node.fullNodeAllowShieldedTransaction");
        Args.PARAMETER.zenTokenId = config.hasPath("node.zenTokenId") ? config.getString("node.zenTokenId") : "000000";
        Args.PARAMETER.allowProtoFilterNum = config.hasPath("committee.allowProtoFilterNum") ? (long)config.getInt("committee.allowProtoFilterNum") : 0L;
        Args.PARAMETER.allowAccountStateRoot = config.hasPath("committee.allowAccountStateRoot") ? (long)config.getInt("committee.allowAccountStateRoot") : 0L;
        Args.PARAMETER.validContractProtoThreadNum = config.hasPath("node.validContractProto.threads") ? config.getInt("node.validContractProto.threads") : Runtime.getRuntime().availableProcessors();
        Args.PARAMETER.activeNodes = Args.getInetSocketAddress(config, "node.active", true);
        Args.PARAMETER.passiveNodes = Args.getInetAddress(config, "node.passive");
        Args.PARAMETER.fastForwardNodes = Args.getInetSocketAddress(config, "node.fastForward", true);
        int n9 = Args.PARAMETER.maxFastForwardNum = config.hasPath("node.maxFastForwardNum") ? config.getInt("node.maxFastForwardNum") : 3;
        if (Args.PARAMETER.maxFastForwardNum > 27) {
            Args.PARAMETER.maxFastForwardNum = 27;
        }
        if (Args.PARAMETER.maxFastForwardNum < 1) {
            Args.PARAMETER.maxFastForwardNum = 1;
        }
        int n10 = Args.PARAMETER.shieldedTransInPendingMaxCounts = config.hasPath("node.shieldedTransInPendingMaxCounts") ? config.getInt("node.shieldedTransInPendingMaxCounts") : 10;
        if (PARAMETER.isWitness()) {
            Args.PARAMETER.fullNodeAllowShieldedTransactionArgs = true;
        }
        Args.PARAMETER.rateLimiterGlobalQps = config.hasPath("rate.limiter.global.qps") ? config.getInt("rate.limiter.global.qps") : 50000;
        Args.PARAMETER.rateLimiterGlobalIpQps = config.hasPath("rate.limiter.global.ip.qps") ? config.getInt("rate.limiter.global.ip.qps") : 10000;
        Args.PARAMETER.rateLimiterInitialization = Args.getRateLimiterFromConfig(config);
        Args.PARAMETER.changedDelegation = config.hasPath("committee.changedDelegation") ? (long)config.getInt("committee.changedDelegation") : 0L;
        Args.PARAMETER.allowPBFT = config.hasPath("committee.allowPBFT") ? config.getLong("committee.allowPBFT") : 0L;
        Args.PARAMETER.agreeNodeCount = config.hasPath("node.agreeNodeCount") ? config.getInt("node.agreeNodeCount") : 19;
        int n11 = Args.PARAMETER.agreeNodeCount = Args.PARAMETER.agreeNodeCount > 27 ? 27 : Args.PARAMETER.agreeNodeCount;
        if (PARAMETER.isWitness()) {
            // empty if block
        }
        Args.PARAMETER.allowTvmFreeze = config.hasPath("committee.allowTvmFreeze") ? (long)config.getInt("committee.allowTvmFreeze") : 0L;
        Args.PARAMETER.allowTvmVote = config.hasPath("committee.allowTvmVote") ? (long)config.getInt("committee.allowTvmVote") : 0L;
        Args.PARAMETER.allowTvmLondon = config.hasPath("committee.allowTvmLondon") ? (long)config.getInt("committee.allowTvmLondon") : 0L;
        Args.PARAMETER.allowTvmCompatibleEvm = config.hasPath("committee.allowTvmCompatibleEvm") ? (long)config.getInt("committee.allowTvmCompatibleEvm") : 0L;
        Args.PARAMETER.allowHigherLimitForMaxCpuTimeOfOneTx = config.hasPath("committee.allowHigherLimitForMaxCpuTimeOfOneTx") ? (long)config.getInt("committee.allowHigherLimitForMaxCpuTimeOfOneTx") : 0L;
        Args.PARAMETER.allowNewRewardAlgorithm = config.hasPath("committee.allowNewRewardAlgorithm") ? (long)config.getInt("committee.allowNewRewardAlgorithm") : 0L;
        Args.PARAMETER.allowOptimizedReturnValueOfChainId = config.hasPath("committee.allowOptimizedReturnValueOfChainId") ? (long)config.getInt("committee.allowOptimizedReturnValueOfChainId") : 0L;
        Args.initBackupProperty(config);
        if ("ROCKSDB".equalsIgnoreCase(CommonParameter.getInstance().getStorage().getDbEngine())) {
            Args.initRocksDbBackupProperty(config);
            Args.initRocksDbSettings(config);
        }
        Set set = Args.PARAMETER.actuatorSet = config.hasPath("actuator.whitelist") ? new HashSet(config.getStringList("actuator.whitelist")) : Collections.emptySet();
        if (config.hasPath("node.metricsEnable")) {
            Args.PARAMETER.nodeMetricsEnable = config.getBoolean("node.metricsEnable");
        }
        Args.PARAMETER.metricsStorageEnable = config.hasPath("node.metrics.storageEnable") && config.getBoolean("node.metrics.storageEnable");
        Args.PARAMETER.influxDbIp = config.hasPath("node.metrics.influxdb.ip") ? config.getString("node.metrics.influxdb.ip") : "127.0.0.1";
        Args.PARAMETER.influxDbPort = config.hasPath("node.metrics.influxdb.port") ? config.getInt("node.metrics.influxdb.port") : 8086;
        Args.PARAMETER.influxDbDatabase = config.hasPath("node.metrics.influxdb.database") ? config.getString("node.metrics.influxdb.database") : "metrics";
        Args.PARAMETER.metricsReportInterval = config.hasPath("node.metrics.influxdb.metricsReportInterval") ? config.getInt("node.metrics.influxdb.metricsReportInterval") : 10;
        Args.PARAMETER.metricsPrometheusEnable = config.hasPath("node.metrics.prometheus.enable") && config.getBoolean("node.metrics.prometheus.enable");
        Args.PARAMETER.metricsPrometheusPort = config.hasPath("node.metrics.prometheus.port") ? config.getInt("node.metrics.prometheus.port") : 9527;
        PARAMETER.setOpenHistoryQueryWhenLiteFN(config.hasPath("node.openHistoryQueryWhenLiteFN") && config.getBoolean("node.openHistoryQueryWhenLiteFN"));
        boolean bl = Args.PARAMETER.historyBalanceLookup = config.hasPath("storage.balance.history.lookup") && config.getBoolean("storage.balance.history.lookup");
        if (config.hasPath("node.openPrintLog")) {
            Args.PARAMETER.openPrintLog = config.getBoolean("node.openPrintLog");
        }
        Args.PARAMETER.openTransactionSort = config.hasPath("node.openTransactionSort") && config.getBoolean("node.openTransactionSort");
        Args.PARAMETER.allowAccountAssetOptimization = config.hasPath("committee.allowAccountAssetOptimization") ? (long)config.getInt("committee.allowAccountAssetOptimization") : 0L;
        Args.PARAMETER.allowAssetOptimization = config.hasPath("committee.allowAssetOptimization") ? (long)config.getInt("committee.allowAssetOptimization") : 0L;
        List list = Args.PARAMETER.disabledApiList = config.hasPath("node.disabledApi") ? config.getStringList("node.disabledApi").stream().map(String::toLowerCase).collect(Collectors.toList()) : Collections.emptyList();
        if (config.hasPath("node.shutdown.BlockTime")) {
            try {
                Args.PARAMETER.shutdownBlockTime = new CronExpression(config.getString("node.shutdown.BlockTime"));
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (config.hasPath("node.shutdown.BlockHeight")) {
            Args.PARAMETER.shutdownBlockHeight = config.getLong("node.shutdown.BlockHeight");
        }
        if (config.hasPath("node.shutdown.BlockCount")) {
            Args.PARAMETER.shutdownBlockCount = config.getLong("node.shutdown.BlockCount");
        }
        if (config.hasPath("node.blockCacheTimeout")) {
            Args.PARAMETER.blockCacheTimeout = config.getLong("node.blockCacheTimeout");
        }
        if (config.hasPath("committee.allowNewReward")) {
            Args.PARAMETER.allowNewReward = config.getLong("committee.allowNewReward");
            if (Args.PARAMETER.allowNewReward > 1L) {
                Args.PARAMETER.allowNewReward = 1L;
            }
            if (Args.PARAMETER.allowNewReward < 0L) {
                Args.PARAMETER.allowNewReward = 0L;
            }
        }
        if (config.hasPath("committee.memoFee")) {
            Args.PARAMETER.memoFee = config.getLong("committee.memoFee");
            if (Args.PARAMETER.memoFee > 1000000000L) {
                Args.PARAMETER.memoFee = 1000000000L;
            }
            if (Args.PARAMETER.memoFee < 0L) {
                Args.PARAMETER.memoFee = 0L;
            }
        }
        if (config.hasPath("committee.allowDelegateOptimization")) {
            Args.PARAMETER.allowDelegateOptimization = config.getLong("committee.allowDelegateOptimization");
            Args.PARAMETER.allowDelegateOptimization = Math.min(Args.PARAMETER.allowDelegateOptimization, 1L);
            Args.PARAMETER.allowDelegateOptimization = Math.max(Args.PARAMETER.allowDelegateOptimization, 0L);
        }
        if (config.hasPath("committee.unfreezeDelayDays")) {
            Args.PARAMETER.unfreezeDelayDays = config.getLong("committee.unfreezeDelayDays");
            if (Args.PARAMETER.unfreezeDelayDays > 365L) {
                Args.PARAMETER.unfreezeDelayDays = 365L;
            }
            if (Args.PARAMETER.unfreezeDelayDays < 0L) {
                Args.PARAMETER.unfreezeDelayDays = 0L;
            }
        }
        if (config.hasPath("committee.allowDynamicEnergy")) {
            Args.PARAMETER.allowDynamicEnergy = config.getLong("committee.allowDynamicEnergy");
            Args.PARAMETER.allowDynamicEnergy = Math.min(Args.PARAMETER.allowDynamicEnergy, 1L);
            Args.PARAMETER.allowDynamicEnergy = Math.max(Args.PARAMETER.allowDynamicEnergy, 0L);
        }
        if (config.hasPath("committee.dynamicEnergyThreshold")) {
            Args.PARAMETER.dynamicEnergyThreshold = config.getLong("committee.dynamicEnergyThreshold");
            Args.PARAMETER.dynamicEnergyThreshold = Math.min(Args.PARAMETER.dynamicEnergyThreshold, 100000000000000000L);
            Args.PARAMETER.dynamicEnergyThreshold = Math.max(Args.PARAMETER.dynamicEnergyThreshold, 0L);
        }
        if (config.hasPath("committee.dynamicEnergyIncreaseFactor")) {
            Args.PARAMETER.dynamicEnergyIncreaseFactor = config.getLong("committee.dynamicEnergyIncreaseFactor");
            Args.PARAMETER.dynamicEnergyIncreaseFactor = Math.min(Args.PARAMETER.dynamicEnergyIncreaseFactor, 10000L);
            Args.PARAMETER.dynamicEnergyIncreaseFactor = Math.max(Args.PARAMETER.dynamicEnergyIncreaseFactor, 0L);
        }
        if (config.hasPath("committee.dynamicEnergyMaxFactor")) {
            Args.PARAMETER.dynamicEnergyMaxFactor = config.getLong("committee.dynamicEnergyMaxFactor");
            Args.PARAMETER.dynamicEnergyMaxFactor = Math.min(Args.PARAMETER.dynamicEnergyMaxFactor, 100000L);
            Args.PARAMETER.dynamicEnergyMaxFactor = Math.max(Args.PARAMETER.dynamicEnergyMaxFactor, 0L);
        }
        boolean bl2 = Args.PARAMETER.dynamicConfigEnable = config.hasPath("node.dynamicConfig.enable") && config.getBoolean("node.dynamicConfig.enable");
        if (config.hasPath("node.dynamicConfig.checkInterval")) {
            Args.PARAMETER.dynamicConfigCheckInterval = config.getLong("node.dynamicConfig.checkInterval");
            if (Args.PARAMETER.dynamicConfigCheckInterval <= 0L) {
                Args.PARAMETER.dynamicConfigCheckInterval = 600L;
            }
        } else {
            Args.PARAMETER.dynamicConfigCheckInterval = 600L;
        }
        Args.PARAMETER.allowTvmShangHai = config.hasPath("committee.allowTvmShangHai") ? (long)config.getInt("committee.allowTvmShangHai") : 0L;
        Args.logConfig();
    }

    private static List<Witness> getWitnessesFromConfig(Config config) {
        return config.getObjectList("genesis.block.witnesses").stream().map(Args::createWitness).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Witness createWitness(ConfigObject witnessAccount) {
        Witness witness = new Witness();
        witness.setAddress(Commons.decodeFromBase58Check((String)witnessAccount.get((Object)"address").unwrapped().toString()));
        witness.setUrl(witnessAccount.get((Object)"url").unwrapped().toString());
        witness.setVoteCount(witnessAccount.toConfig().getLong("voteCount"));
        return witness;
    }

    private static List<Account> getAccountsFromConfig(Config config) {
        return config.getObjectList("genesis.block.assets").stream().map(Args::createAccount).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Account createAccount(ConfigObject asset) {
        Account account = new Account();
        account.setAccountName(asset.get((Object)"accountName").unwrapped().toString());
        account.setAccountType(asset.get((Object)"accountType").unwrapped().toString());
        account.setAddress(Commons.decodeFromBase58Check((String)asset.get((Object)"address").unwrapped().toString()));
        account.setBalance(asset.get((Object)"balance").unwrapped().toString());
        return account;
    }

    private static RateLimiterInitialization getRateLimiterFromConfig(Config config) {
        RateLimiterInitialization initialization = new RateLimiterInitialization();
        if (config.hasPath("rate.limiter.http")) {
            ArrayList list1 = config.getObjectList("rate.limiter.http").stream().map(RateLimiterInitialization::createHttpItem).collect(Collectors.toCollection(ArrayList::new));
            initialization.setHttpMap((List)list1);
        }
        if (config.hasPath("rate.limiter.rpc")) {
            ArrayList list2 = config.getObjectList("rate.limiter.rpc").stream().map(RateLimiterInitialization::createRpcItem).collect(Collectors.toCollection(ArrayList::new));
            initialization.setRpcMap((List)list2);
        }
        return initialization;
    }

    public static List<InetSocketAddress> getInetSocketAddress(Config config, String path, boolean filter) {
        ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
        if (!config.hasPath(path)) {
            return ret;
        }
        List list = config.getStringList(path);
        for (String configString : list) {
            InetSocketAddress inetSocketAddress = NetUtil.parseInetSocketAddress((String)configString);
            if (filter) {
                String ip = inetSocketAddress.getAddress().getHostAddress();
                int port = inetSocketAddress.getPort();
                if ((Args.PARAMETER.nodeDiscoveryBindIp.equals(ip) || Args.PARAMETER.nodeExternalIp.equals(ip) || "127.0.0.1".equals(ip)) && Args.PARAMETER.nodeListenPort == port) continue;
                ret.add(inetSocketAddress);
                continue;
            }
            ret.add(inetSocketAddress);
        }
        return ret;
    }

    public static List<InetAddress> getInetAddress(Config config, String path) {
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>();
        if (!config.hasPath(path)) {
            return ret;
        }
        List list = config.getStringList(path);
        for (String configString : list) {
            InetSocketAddress inetSocketAddress = NetUtil.parseInetSocketAddress((String)configString);
            ret.add(inetSocketAddress.getAddress());
        }
        return ret;
    }

    private static EventPluginConfig getEventPluginConfig(Config config) {
        EventPluginConfig eventPluginConfig = new EventPluginConfig();
        boolean useNativeQueue = false;
        int bindPort = 0;
        int sendQueueLength = 0;
        if (config.hasPath("event.subscribe.native.useNativeQueue")) {
            useNativeQueue = config.getBoolean("event.subscribe.native.useNativeQueue");
            if (config.hasPath("event.subscribe.native.bindport")) {
                bindPort = config.getInt("event.subscribe.native.bindport");
            }
            if (config.hasPath("event.subscribe.native.sendqueuelength")) {
                sendQueueLength = config.getInt("event.subscribe.native.sendqueuelength");
            }
            eventPluginConfig.setUseNativeQueue(useNativeQueue);
            eventPluginConfig.setBindPort(bindPort);
            eventPluginConfig.setSendQueueLength(sendQueueLength);
        }
        if (!useNativeQueue) {
            String dbConfig;
            String serverAddress;
            String pluginPath;
            if (config.hasPath("event.subscribe.path") && StringUtils.isNotEmpty((CharSequence)(pluginPath = config.getString("event.subscribe.path")))) {
                eventPluginConfig.setPluginPath(pluginPath.trim());
            }
            if (config.hasPath("event.subscribe.server") && StringUtils.isNotEmpty((CharSequence)(serverAddress = config.getString("event.subscribe.server")))) {
                eventPluginConfig.setServerAddress(serverAddress.trim());
            }
            if (config.hasPath("event.subscribe.dbconfig") && StringUtils.isNotEmpty((CharSequence)(dbConfig = config.getString("event.subscribe.dbconfig")))) {
                eventPluginConfig.setDbConfig(dbConfig.trim());
            }
        }
        if (config.hasPath("event.subscribe.topics")) {
            List triggerConfigList = config.getObjectList("event.subscribe.topics").stream().map(Args::createTriggerConfig).collect(Collectors.toCollection(ArrayList::new));
            eventPluginConfig.setTriggerConfigList(triggerConfigList);
        }
        return eventPluginConfig;
    }

    private static List<InetSocketAddress> loadSeeds(Config config) {
        ArrayList<InetSocketAddress> inetSocketAddressList = new ArrayList();
        if (Args.PARAMETER.seedNodes != null && !Args.PARAMETER.seedNodes.isEmpty()) {
            for (String s : Args.PARAMETER.seedNodes) {
                InetSocketAddress inetSocketAddress = NetUtil.parseInetSocketAddress((String)s);
                inetSocketAddressList.add(inetSocketAddress);
            }
        } else {
            inetSocketAddressList = Args.getInetSocketAddress(config, "seed.node.ip.list", false);
        }
        return inetSocketAddressList;
    }

    public static PublishConfig loadDnsPublishConfig(Config config) {
        PublishConfig publishConfig = new PublishConfig();
        if (config.hasPath("node.dns.publish")) {
            publishConfig.setDnsPublishEnable(config.getBoolean("node.dns.publish"));
        }
        Args.loadDnsPublishParameters(config, publishConfig);
        return publishConfig;
    }

    public static void loadDnsPublishParameters(Config config, PublishConfig publishConfig) {
        if (publishConfig.isDnsPublishEnable()) {
            if (config.hasPath("node.dns.dnsDomain") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.dnsDomain"))) {
                publishConfig.setDnsDomain(config.getString("node.dns.dnsDomain"));
            } else {
                Args.logEmptyError("node.dns.dnsDomain");
            }
            if (config.hasPath("node.dns.changeThreshold")) {
                double changeThreshold = config.getDouble("node.dns.changeThreshold");
                if (changeThreshold > 0.0) {
                    publishConfig.setChangeThreshold(changeThreshold);
                } else {
                    logger.error("Check {}, should be bigger than 0, default 0.1", (Object)"node.dns.changeThreshold");
                }
            }
            if (config.hasPath("node.dns.maxMergeSize")) {
                int maxMergeSize = config.getInt("node.dns.maxMergeSize");
                if (maxMergeSize >= 1 && maxMergeSize <= 5) {
                    publishConfig.setMaxMergeSize(maxMergeSize);
                } else {
                    logger.error("Check {}, should be [1~5], default 5", (Object)"node.dns.maxMergeSize");
                }
            }
            if (config.hasPath("node.dns.dnsPrivate") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.dnsPrivate"))) {
                publishConfig.setDnsPrivate(config.getString("node.dns.dnsPrivate"));
            } else {
                Args.logEmptyError("node.dns.dnsPrivate");
            }
            if (config.hasPath("node.dns.knownUrls")) {
                publishConfig.setKnownTreeUrls(config.getStringList("node.dns.knownUrls"));
            }
            if (config.hasPath("node.dns.staticNodes")) {
                publishConfig.setStaticNodes(Args.getInetSocketAddress(config, "node.dns.staticNodes", false));
            }
            if (config.hasPath("node.dns.serverType") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.serverType"))) {
                String serverType = config.getString("node.dns.serverType");
                if (!"aws".equalsIgnoreCase(serverType) && !"aliyun".equalsIgnoreCase(serverType)) {
                    throw new IllegalArgumentException(String.format("Check %s, must be aws or aliyun", "node.dns.serverType"));
                }
                if ("aws".equalsIgnoreCase(serverType)) {
                    publishConfig.setDnsType(DnsType.AwsRoute53);
                } else {
                    publishConfig.setDnsType(DnsType.AliYun);
                }
            } else {
                Args.logEmptyError("node.dns.serverType");
            }
            if (config.hasPath("node.dns.accessKeyId") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.accessKeyId"))) {
                publishConfig.setAccessKeyId(config.getString("node.dns.accessKeyId"));
            } else {
                Args.logEmptyError("node.dns.accessKeyId");
            }
            if (config.hasPath("node.dns.accessKeySecret") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.accessKeySecret"))) {
                publishConfig.setAccessKeySecret(config.getString("node.dns.accessKeySecret"));
            } else {
                Args.logEmptyError("node.dns.accessKeySecret");
            }
            if (publishConfig.getDnsType() == DnsType.AwsRoute53) {
                if (config.hasPath("node.dns.awsRegion") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.awsRegion"))) {
                    publishConfig.setAwsRegion(config.getString("node.dns.awsRegion"));
                } else {
                    Args.logEmptyError("node.dns.awsRegion");
                }
                if (config.hasPath("node.dns.awsHostZoneId")) {
                    publishConfig.setAwsHostZoneId(config.getString("node.dns.awsHostZoneId"));
                }
            } else if (config.hasPath("node.dns.aliyunDnsEndpoint") && StringUtils.isNotEmpty((CharSequence)config.getString("node.dns.aliyunDnsEndpoint"))) {
                publishConfig.setAliDnsEndpoint(config.getString("node.dns.aliyunDnsEndpoint"));
            } else {
                Args.logEmptyError("node.dns.aliyunDnsEndpoint");
            }
        }
    }

    private static void logEmptyError(String arg) {
        throw new IllegalArgumentException(String.format("Check %s, must not be null or empty", arg));
    }

    private static TriggerConfig createTriggerConfig(ConfigObject triggerObject) {
        if (Objects.isNull(triggerObject)) {
            return null;
        }
        TriggerConfig triggerConfig = new TriggerConfig();
        String triggerName = triggerObject.get((Object)"triggerName").unwrapped().toString();
        triggerConfig.setTriggerName(triggerName);
        String enabled = triggerObject.get((Object)"enable").unwrapped().toString();
        triggerConfig.setEnabled("true".equalsIgnoreCase(enabled));
        String topic = triggerObject.get((Object)"topic").unwrapped().toString();
        triggerConfig.setTopic(topic);
        if (triggerObject.containsKey((Object)"redundancy")) {
            String redundancy = triggerObject.get((Object)"redundancy").unwrapped().toString();
            triggerConfig.setRedundancy("true".equalsIgnoreCase(redundancy));
        }
        if (triggerObject.containsKey((Object)"ethCompatible")) {
            String ethCompatible = triggerObject.get((Object)"ethCompatible").unwrapped().toString();
            triggerConfig.setEthCompatible("true".equalsIgnoreCase(ethCompatible));
        }
        if (triggerObject.containsKey((Object)"solidified")) {
            String solidified = triggerObject.get((Object)"solidified").unwrapped().toString();
            triggerConfig.setSolidified("true".equalsIgnoreCase(solidified));
        }
        return triggerConfig;
    }

    private static FilterQuery getEventFilter(Config config) {
        FilterQuery filter = new FilterQuery();
        long fromBlockLong = 0L;
        long toBlockLong = 0L;
        String fromBlock = config.getString("event.subscribe.filter.fromblock").trim();
        try {
            fromBlockLong = FilterQuery.parseFromBlockNumber((String)fromBlock);
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
            return null;
        }
        filter.setFromBlock(fromBlockLong);
        String toBlock = config.getString("event.subscribe.filter.toblock").trim();
        try {
            toBlockLong = FilterQuery.parseToBlockNumber((String)toBlock);
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
            return null;
        }
        filter.setToBlock(toBlockLong);
        List addressList = config.getStringList("event.subscribe.filter.contractAddress");
        addressList = addressList.stream().filter(address -> StringUtils.isNotEmpty((CharSequence)address)).collect(Collectors.toList());
        filter.setContractAddressList(addressList);
        List topicList = config.getStringList("event.subscribe.filter.contractTopic");
        topicList = topicList.stream().filter(top -> StringUtils.isNotEmpty((CharSequence)top)).collect(Collectors.toList());
        filter.setContractTopicList(topicList);
        return filter;
    }

    private static void bindIp(Config config) {
        if (!config.hasPath("node.discovery.bind.ip") || config.getString("node.discovery.bind.ip").trim().isEmpty()) {
            if (Args.PARAMETER.nodeDiscoveryBindIp == null) {
                logger.info("Bind address wasn't set, Punching to identify it...");
                try (Socket s = new Socket("www.baidu.com", 80);){
                    Args.PARAMETER.nodeDiscoveryBindIp = s.getLocalAddress().getHostAddress();
                    logger.info("UDP local bound to: {}", (Object)Args.PARAMETER.nodeDiscoveryBindIp);
                }
                catch (IOException e) {
                    logger.warn("Can't get bind IP. Fall back to 127.0.0.1: " + e);
                    Args.PARAMETER.nodeDiscoveryBindIp = "127.0.0.1";
                }
            }
        } else {
            Args.PARAMETER.nodeDiscoveryBindIp = config.getString("node.discovery.bind.ip").trim();
        }
    }

    private static void externalIp(Config config) {
        if (!config.hasPath("node.discovery.external.ip") || config.getString("node.discovery.external.ip").trim().isEmpty()) {
            if (Args.PARAMETER.nodeExternalIp == null) {
                logger.info("External IP wasn't set, using checkip.amazonaws.com to identify it...");
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(new URL("http://checkip.amazonaws.com").openStream()));
                    Args.PARAMETER.nodeExternalIp = in.readLine();
                    if (Args.PARAMETER.nodeExternalIp == null || Args.PARAMETER.nodeExternalIp.trim().isEmpty()) {
                        throw new IOException("Invalid address: '" + Args.PARAMETER.nodeExternalIp + "'");
                    }
                    try {
                        InetAddress.getByName(Args.PARAMETER.nodeExternalIp);
                    }
                    catch (Exception e) {
                        throw new IOException("Invalid address: '" + Args.PARAMETER.nodeExternalIp + "'");
                    }
                    logger.info("External address identified: {}", (Object)Args.PARAMETER.nodeExternalIp);
                }
                catch (IOException e) {
                    Args.PARAMETER.nodeExternalIp = Args.PARAMETER.nodeDiscoveryBindIp;
                    logger.warn("Can't get external IP. Fall back to peer.bind.ip: " + Args.PARAMETER.nodeExternalIp + " :" + e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            Args.PARAMETER.nodeExternalIp = config.getString("node.discovery.external.ip").trim();
        }
    }

    private static void initRocksDbSettings(Config config) {
        String prefix = "storage.dbSettings.";
        int levelNumber = config.hasPath(prefix + "levelNumber") ? config.getInt(prefix + "levelNumber") : 7;
        int compactThreads = config.hasPath(prefix + "compactThreads") ? config.getInt(prefix + "compactThreads") : Math.max(Runtime.getRuntime().availableProcessors(), 1);
        int blocksize = config.hasPath(prefix + "blocksize") ? config.getInt(prefix + "blocksize") : 16;
        long maxBytesForLevelBase = config.hasPath(prefix + "maxBytesForLevelBase") ? (long)config.getInt(prefix + "maxBytesForLevelBase") : 256L;
        double maxBytesForLevelMultiplier = config.hasPath(prefix + "maxBytesForLevelMultiplier") ? config.getDouble(prefix + "maxBytesForLevelMultiplier") : 10.0;
        int level0FileNumCompactionTrigger = config.hasPath(prefix + "level0FileNumCompactionTrigger") ? config.getInt(prefix + "level0FileNumCompactionTrigger") : 2;
        long targetFileSizeBase = config.hasPath(prefix + "targetFileSizeBase") ? config.getLong(prefix + "targetFileSizeBase") : 64L;
        int targetFileSizeMultiplier = config.hasPath(prefix + "targetFileSizeMultiplier") ? config.getInt(prefix + "targetFileSizeMultiplier") : 1;
        Args.PARAMETER.rocksDBCustomSettings = RocksDbSettings.initCustomSettings((int)levelNumber, (int)compactThreads, (int)blocksize, (long)maxBytesForLevelBase, (double)maxBytesForLevelMultiplier, (int)level0FileNumCompactionTrigger, (long)targetFileSizeBase, (int)targetFileSizeMultiplier);
        RocksDbSettings.loggingSettings();
    }

    private static void initRocksDbBackupProperty(Config config) {
        boolean enable = config.hasPath("storage.backup.enable") && config.getBoolean("storage.backup.enable");
        String propPath = config.hasPath("storage.backup.propPath") ? config.getString("storage.backup.propPath") : "prop.properties";
        String bak1path = config.hasPath("storage.backup.bak1path") ? config.getString("storage.backup.bak1path") : "bak1/database/";
        String bak2path = config.hasPath("storage.backup.bak2path") ? config.getString("storage.backup.bak2path") : "bak2/database/";
        int frequency = config.hasPath("storage.backup.frequency") ? config.getInt("storage.backup.frequency") : 10000;
        Args.PARAMETER.dbBackupConfig = DbBackupConfig.getInstance().initArgs(enable, propPath, bak1path, bak2path, frequency);
    }

    private static void initBackupProperty(Config config) {
        Args.PARAMETER.backupPriority = config.hasPath("node.backup.priority") ? config.getInt("node.backup.priority") : 0;
        Args.PARAMETER.backupPort = config.hasPath("node.backup.port") ? config.getInt("node.backup.port") : 10001;
        Args.PARAMETER.keepAliveInterval = config.hasPath("node.backup.keepAliveInterval") ? config.getInt("node.backup.keepAliveInterval") : 3000;
        Args.PARAMETER.backupMembers = config.hasPath("node.backup.members") ? config.getStringList("node.backup.members") : new ArrayList();
    }

    public static void logConfig() {
        CommonParameter parameter = CommonParameter.getInstance();
        logger.info("\n");
        logger.info("************************ Net config ************************");
        logger.info("P2P version: {}", (Object)parameter.getNodeP2pVersion());
        logger.info("Bind IP: {}", (Object)parameter.getNodeDiscoveryBindIp());
        logger.info("External IP: {}", (Object)parameter.getNodeExternalIp());
        logger.info("Listen port: {}", (Object)parameter.getNodeListenPort());
        logger.info("Node ipv6 enable: {}", (Object)parameter.isNodeEnableIpv6());
        logger.info("Discover enable: {}", (Object)parameter.isNodeDiscoveryEnable());
        logger.info("Active node size: {}", (Object)parameter.getActiveNodes().size());
        logger.info("Passive node size: {}", (Object)parameter.getPassiveNodes().size());
        logger.info("FastForward node size: {}", (Object)parameter.getFastForwardNodes().size());
        logger.info("FastForward node number: {}", (Object)parameter.getMaxFastForwardNum());
        logger.info("Seed node size: {}", (Object)parameter.getSeedNode().getAddressList().size());
        logger.info("Max connection: {}", (Object)parameter.getMaxConnections());
        logger.info("Min connection: {}", (Object)parameter.getMinConnections());
        logger.info("Min active connection: {}", (Object)parameter.getMinActiveConnections());
        logger.info("Max connection with same IP: {}", (Object)parameter.getMaxConnectionsWithSameIp());
        logger.info("Solidity threads: {}", (Object)parameter.getSolidityThreads());
        logger.info("Trx reference block: {}", (Object)parameter.getTrxReferenceBlock());
        logger.info("Open full tcp disconnect: {}", (Object)parameter.isOpenFullTcpDisconnect());
        logger.info("Node detect enable: {}", (Object)parameter.isNodeDetectEnable());
        logger.info("Node effective check enable: {}", (Object)parameter.isNodeEffectiveCheckEnable());
        logger.info("Rate limiter global qps: {}", (Object)parameter.getRateLimiterGlobalQps());
        logger.info("Rate limiter global ip qps: {}", (Object)parameter.getRateLimiterGlobalIpQps());
        logger.info("************************ Backup config ************************");
        logger.info("Backup priority: {}", (Object)parameter.getBackupPriority());
        logger.info("Backup listen port: {}", (Object)parameter.getBackupPort());
        logger.info("Backup listen keepAliveInterval: {}", (Object)parameter.getKeepAliveInterval());
        logger.info("Backup member size: {}", (Object)parameter.getBackupMembers().size());
        logger.info("************************ Code version *************************");
        logger.info("Code version : {}", (Object)Version.getVersion());
        logger.info("Version code: {}", (Object)"18031");
        logger.info("************************ DB config *************************");
        logger.info("DB engine : {}", (Object)parameter.getStorage().getDbEngine());
        logger.info("Snapshot max flush count: {}", (Object)parameter.getStorage().getMaxFlushCount());
        logger.info("***************************************************************");
        logger.info("************************ shutDown config *************************");
        logger.info("ShutDown blockTime  : {}", (Object)parameter.getShutdownBlockTime());
        logger.info("ShutDown blockHeight : {}", (Object)parameter.getShutdownBlockHeight());
        logger.info("ShutDown blockCount : {}", (Object)parameter.getShutdownBlockCount());
        logger.info("***************************************************************");
        logger.info("\n");
    }

    public static void setFullNodeAllowShieldedTransaction(boolean fullNodeAllowShieldedTransaction) {
        Args.PARAMETER.fullNodeAllowShieldedTransactionArgs = fullNodeAllowShieldedTransaction;
    }

    private static void witnessAddressCheck(Config config) {
        if (config.hasPath("localWitnessAccountAddress")) {
            byte[] bytes = Commons.decodeFromBase58Check((String)config.getString("localWitnessAccountAddress"));
            if (bytes != null) {
                localWitnesses.setWitnessAccountAddress(bytes);
                logger.debug("Got localWitnessAccountAddress from config.conf");
            } else {
                logger.warn("The localWitnessAccountAddress format is incorrect, ignored");
            }
        }
    }

    public String getOutputDirectory() {
        if (!this.outputDirectory.equals("") && !this.outputDirectory.endsWith(File.separator)) {
            return this.outputDirectory + File.separator;
        }
        return this.outputDirectory;
    }

    public static LocalWitnesses getLocalWitnesses() {
        return localWitnesses;
    }

    public static void setLocalWitnesses(LocalWitnesses localWitnesses) {
        Args.localWitnesses = localWitnesses;
    }

    public static ConcurrentHashMap<Long, BlockingQueue<ContractLogTrigger>> getSolidityContractLogTriggerMap() {
        return solidityContractLogTriggerMap;
    }

    public static ConcurrentHashMap<Long, BlockingQueue<ContractEventTrigger>> getSolidityContractEventTriggerMap() {
        return solidityContractEventTriggerMap;
    }
}

