/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config;

import com.alibaba.fastjson.parser.ParserConfig;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.tron.common.utils.StorageUtils;
import org.tron.core.config.CommonConfig;
import org.tron.core.config.args.Args;
import org.tron.core.db.RecentTransactionStore;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db.TransactionCache;
import org.tron.core.db.backup.BackupRocksDBAspect;
import org.tron.core.db.backup.NeedBeanCondition;
import org.tron.core.db2.core.SnapshotManager;
import org.tron.core.services.interfaceOnPBFT.RpcApiServiceOnPBFT;
import org.tron.core.services.interfaceOnPBFT.http.PBFT.HttpApiOnPBFTService;
import org.tron.core.services.interfaceOnSolidity.RpcApiServiceOnSolidity;
import org.tron.core.services.interfaceOnSolidity.http.solidity.HttpApiOnSolidityService;

@Configuration
@Import(value={CommonConfig.class})
public class DefaultConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    @Autowired
    public ApplicationContext appCtx;
    @Autowired
    public CommonConfig commonConfig;

    public DefaultConfig() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("Uncaught exception", e));
    }

    @Bean
    public RevokingDatabase revokingDatabase() {
        try {
            SnapshotManager snapshotManager = new SnapshotManager(StorageUtils.getOutputDirectoryByDbName((String)"block"));
            return snapshotManager;
        }
        finally {
            logger.info("key-value data source created.");
        }
    }

    @Bean
    public RpcApiServiceOnSolidity getRpcApiServiceOnSolidity() {
        boolean isSolidityNode = Args.getInstance().isSolidityNode();
        if (!isSolidityNode) {
            return new RpcApiServiceOnSolidity();
        }
        return null;
    }

    @Bean
    public HttpApiOnSolidityService getHttpApiOnSolidityService() {
        boolean isSolidityNode = Args.getInstance().isSolidityNode();
        if (!isSolidityNode) {
            return new HttpApiOnSolidityService();
        }
        return null;
    }

    @Bean
    public RpcApiServiceOnPBFT getRpcApiServiceOnPBFT() {
        boolean isSolidityNode = Args.getInstance().isSolidityNode();
        if (!isSolidityNode) {
            return new RpcApiServiceOnPBFT();
        }
        return null;
    }

    @Bean
    public HttpApiOnPBFTService getHttpApiOnPBFTService() {
        boolean isSolidityNode = Args.getInstance().isSolidityNode();
        if (!isSolidityNode) {
            return new HttpApiOnPBFTService();
        }
        return null;
    }

    @Bean
    public TransactionCache transactionCache() {
        return new TransactionCache("trans-cache", (RecentTransactionStore)this.appCtx.getBean(RecentTransactionStore.class));
    }

    @Bean
    @Conditional(value={NeedBeanCondition.class})
    public BackupRocksDBAspect backupRocksDBAspect() {
        return new BackupRocksDBAspect();
    }

    static {
        RocksDB.loadLibrary();
        ParserConfig.getGlobalInstance().setSafeMode(true);
    }
}

