/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.contract.ShieldContract;

public class ReceiveDescriptionCapsule
implements ProtoCapsule<ShieldContract.ReceiveDescription> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private ShieldContract.ReceiveDescription receiveDescription;

    public ReceiveDescriptionCapsule() {
        this.receiveDescription = ShieldContract.ReceiveDescription.newBuilder().build();
    }

    public ReceiveDescriptionCapsule(ShieldContract.ReceiveDescription outputDescription) {
        this.receiveDescription = this.receiveDescription;
    }

    public ReceiveDescriptionCapsule(byte[] data) {
        try {
            this.receiveDescription = ShieldContract.ReceiveDescription.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public ReceiveDescriptionCapsule(ByteString cv, ByteString cm, ByteString ephemeralKey, ByteString encCiphertext, ByteString outCiphertext, ByteString zkproof) {
        this.receiveDescription = ShieldContract.ReceiveDescription.newBuilder().setValueCommitment(cv).setNoteCommitment(cm).setEpk(ephemeralKey).setCEnc(encCiphertext).setCOut(outCiphertext).setZkproof(zkproof).build();
    }

    public ByteString getValueCommitment() {
        return this.receiveDescription.getValueCommitment();
    }

    public void setValueCommitment(byte[] bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setValueCommitment(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setValueCommitment(ByteString bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setValueCommitment(bytes).build();
    }

    public ByteString getEphemeralKey() {
        return this.receiveDescription.getEpk();
    }

    public void setEpk(byte[] bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setEpk(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setEpk(ByteString bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setEpk(bytes).build();
    }

    public ByteString getEncCiphertext() {
        return this.receiveDescription.getCEnc();
    }

    public void setCEnc(byte[] bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setCEnc(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setCEnc(ByteString bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setCEnc(bytes).build();
    }

    public ByteString getOutCiphertext() {
        return this.receiveDescription.getCOut();
    }

    public void setCOut(byte[] bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setCOut(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setCOut(ByteString bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setCOut(bytes).build();
    }

    public ByteString getCm() {
        return this.receiveDescription.getNoteCommitment();
    }

    public void setNoteCommitment(byte[] bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setNoteCommitment(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setNoteCommitment(ByteString bytes) {
        this.receiveDescription = this.receiveDescription.toBuilder().setNoteCommitment(bytes).build();
    }

    public ByteString getZkproof() {
        return this.receiveDescription.getZkproof();
    }

    public void setZkproof(byte[] proof) {
        ByteString proof1 = ByteString.copyFrom((byte[])proof);
        this.receiveDescription = this.receiveDescription.toBuilder().setZkproof(proof1).build();
    }

    public void setZkproof(ByteString proof) {
        this.receiveDescription = this.receiveDescription.toBuilder().setZkproof(proof).build();
    }

    public byte[] getData() {
        return this.receiveDescription.toByteArray();
    }

    public ShieldContract.ReceiveDescription getInstance() {
        return this.receiveDescription;
    }
}

