/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.Utils;
import org.tron.common.utils.WalletUtil;
import org.tron.common.zksnark.IncrementalMerkleTreeContainer;
import org.tron.common.zksnark.IncrementalMerkleVoucherContainer;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.consensus.ConsensusDelegate;
import org.tron.core.ChainBaseManager;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.ActuatorFactory;
import org.tron.core.actuator.UnfreezeBalanceV2Actuator;
import org.tron.core.actuator.VMActuator;
import org.tron.core.capsule.AbiCapsule;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockBalanceTraceCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.CodeCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.capsule.IncrementalMerkleVoucherCapsule;
import org.tron.core.capsule.MarketAccountOrderCapsule;
import org.tron.core.capsule.MarketOrderCapsule;
import org.tron.core.capsule.MarketOrderIdListCapsule;
import org.tron.core.capsule.PedersenHashCapsule;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.config.args.Args;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.BlockIndexStore;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.Manager;
import org.tron.core.db.TransactionContext;
import org.tron.core.db2.core.Chainbase;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.exception.NonUniqueObjectException;
import org.tron.core.exception.PermissionException;
import org.tron.core.exception.SignatureFormatException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.TronNetService;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.store.AccountIdIndexStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AccountTraceStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.BalanceTraceStore;
import org.tron.core.store.ContractStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.core.store.MarketOrderStore;
import org.tron.core.store.MarketPairPriceToOrderStore;
import org.tron.core.store.MarketPairToPriceStore;
import org.tron.core.store.StoreFactory;
import org.tron.core.vm.program.Program;
import org.tron.core.zen.ShieldedTRC20ParametersBuilder;
import org.tron.core.zen.ZenTransactionBuilder;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.ExpandedSpendingKey;
import org.tron.core.zen.address.IncomingViewingKey;
import org.tron.core.zen.address.KeyIo;
import org.tron.core.zen.address.PaymentAddress;
import org.tron.core.zen.address.SpendingKey;
import org.tron.core.zen.note.Note;
import org.tron.core.zen.note.NoteEncryption;
import org.tron.core.zen.note.OutgoingPlaintext;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;

@Component
public class Wallet {
    private static final Logger logger = LoggerFactory.getLogger(Wallet.class);
    private static final String SHIELDED_ID_NOT_ALLOWED = "ShieldedTransactionApi is not allowed";
    private static final String PAYMENT_ADDRESS_FORMAT_WRONG = "paymentAddress format is wrong";
    private static final String SHIELDED_TRANSACTION_SCAN_RANGE = "request requires start_block_index >= 0 && end_block_index > start_block_index && end_block_index - start_block_index <= 1000";
    private static String addressPreFixString = "41";
    private static final byte[] SHIELDED_TRC20_LOG_TOPICS_MINT = Hash.sha3((byte[])ByteArray.fromString((String)"MintNewLeaf(uint256,bytes32,bytes32,bytes32,bytes32[21])"));
    private static final byte[] SHIELDED_TRC20_LOG_TOPICS_TRANSFER = Hash.sha3((byte[])ByteArray.fromString((String)"TransferNewLeaf(uint256,bytes32,bytes32,bytes32,bytes32[21])"));
    private static final byte[] SHIELDED_TRC20_LOG_TOPICS_BURN_LEAF = Hash.sha3((byte[])ByteArray.fromString((String)"BurnNewLeaf(uint256,bytes32,bytes32,bytes32,bytes32[21])"));
    private static final byte[] SHIELDED_TRC20_LOG_TOPICS_BURN_TOKEN = Hash.sha3((byte[])ByteArray.fromString((String)"TokenBurn(address,uint256,bytes32[3])"));
    private static final String BROADCAST_TRANS_FAILED = "Broadcast transaction {} failed, {}.";
    private final SignInterface cryptoEngine;
    @Autowired
    private TronNetService tronNetService;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private Manager dbManager;
    @Autowired
    private ConsensusDelegate consensusDelegate;
    @Autowired
    private ChainBaseManager chainBaseManager;
    private int minEffectiveConnection = CommonParameter.getInstance().getMinEffectiveConnection();
    private boolean trxCacheEnable = CommonParameter.getInstance().isTrxCacheEnable();
    public static final String CONTRACT_VALIDATE_EXCEPTION = "ContractValidateException: {}";
    public static final String CONTRACT_VALIDATE_ERROR = "Contract validate error : ";

    public Wallet() {
        this.cryptoEngine = SignUtils.getGeneratedRandomSign((SecureRandom)Utils.getRandom(), (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
    }

    public Wallet(SignInterface cryptoEngine) {
        this.cryptoEngine = cryptoEngine;
        logger.info("wallet address: {}", (Object)ByteArray.toHexString((byte[])this.cryptoEngine.getAddress()));
    }

    public static String getAddressPreFixString() {
        return DecodeUtil.addressPreFixString;
    }

    public static void setAddressPreFixString(String addressPreFixString) {
        DecodeUtil.addressPreFixString = addressPreFixString;
    }

    public static byte getAddressPreFixByte() {
        return DecodeUtil.addressPreFixByte;
    }

    public static void setAddressPreFixByte(byte addressPreFixByte) {
        DecodeUtil.addressPreFixByte = addressPreFixByte;
    }

    public byte[] getAddress() {
        return this.cryptoEngine.getAddress();
    }

    public Protocol.Account getAccount(Protocol.Account account) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AccountCapsule accountCapsule = accountStore.get(account.getAddress().toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        accountCapsule.importAllAsset();
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAccountStore());
        energyProcessor.updateUsage(accountCapsule);
        long genesisTimeStamp = this.chainBaseManager.getGenesisBlock().getTimeStamp();
        accountCapsule.setLatestConsumeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTime());
        accountCapsule.setLatestConsumeFreeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeFreeTime());
        accountCapsule.setLatestConsumeTimeForEnergy(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTimeForEnergy());
        this.sortFrozenV2List(accountCapsule);
        return accountCapsule.getInstance();
    }

    private void sortFrozenV2List(AccountCapsule accountCapsule) {
        List oldFreezeV2List = accountCapsule.getFrozenV2List();
        accountCapsule.clearFrozenV2();
        for (Common.ResourceCode code2 : Common.ResourceCode.values()) {
            if (Common.ResourceCode.UNRECOGNIZED == code2) continue;
            accountCapsule.addFrozenV2List(Protocol.Account.FreezeV2.newBuilder().setType(code2).setAmount(0L).build());
        }
        List newFreezeV2List = accountCapsule.getFrozenV2List();
        for (int i = 0; i < newFreezeV2List.size(); ++i) {
            Common.ResourceCode code2;
            Protocol.Account.FreezeV2 freezeV2 = (Protocol.Account.FreezeV2)newFreezeV2List.get(i);
            code2 = freezeV2.getType();
            Optional<Protocol.Account.FreezeV2> optional = oldFreezeV2List.stream().filter(o -> o.getType() == code2).findFirst();
            if (!optional.isPresent()) continue;
            accountCapsule.updateFrozenV2List(i, optional.get());
        }
    }

    public Protocol.Account getAccountById(Protocol.Account account) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.chainBaseManager.getAccountIdIndexStore();
        byte[] address = accountIdIndexStore.get(account.getAccountId());
        if (address == null) {
            return null;
        }
        AccountCapsule accountCapsule = accountStore.get(address);
        if (accountCapsule == null) {
            return null;
        }
        accountCapsule.importAllAsset();
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAccountStore());
        energyProcessor.updateUsage(accountCapsule);
        long genesisTimeStamp = this.chainBaseManager.getGenesisBlock().getTimeStamp();
        accountCapsule.setLatestConsumeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTime());
        accountCapsule.setLatestConsumeFreeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeFreeTime());
        accountCapsule.setLatestConsumeTimeForEnergy(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTimeForEnergy());
        return accountCapsule.getInstance();
    }

    @Deprecated
    public Protocol.Transaction createTransaction(BalanceContract.TransferContract contract) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        return new TransactionCapsule(contract, accountStore).getInstance();
    }

    private void setTransaction(TransactionCapsule trx) {
        try {
            BlockCapsule.BlockId blockId = this.chainBaseManager.getHeadBlockId();
            if ("solid".equals(Args.getInstance().getTrxReferenceBlock())) {
                blockId = this.chainBaseManager.getSolidBlockId();
            }
            trx.setReference(blockId.getNum(), blockId.getBytes());
            long expiration = this.chainBaseManager.getHeadBlockTimeStamp() + Args.getInstance().getTrxExpirationTimeInMilliseconds();
            trx.setExpiration(expiration);
            trx.setTimestamp();
        }
        catch (Exception e) {
            logger.error("Create transaction capsule failed.", (Throwable)e);
        }
    }

    private TransactionCapsule createTransactionCapsuleWithoutValidateWithTimeout(Message message, Protocol.Transaction.Contract.ContractType contractType, long timeout) {
        TransactionCapsule trx = new TransactionCapsule(message, contractType);
        try {
            BlockCapsule.BlockId blockId = this.chainBaseManager.getHeadBlockId();
            if ("solid".equals(Args.getInstance().getTrxReferenceBlock())) {
                blockId = this.chainBaseManager.getSolidBlockId();
            }
            trx.setReference(blockId.getNum(), blockId.getBytes());
            long expiration = timeout > 0L ? this.chainBaseManager.getHeadBlockTimeStamp() + timeout * 1000L : this.chainBaseManager.getHeadBlockTimeStamp() + Args.getInstance().getTrxExpirationTimeInMilliseconds();
            trx.setExpiration(expiration);
            trx.setTimestamp();
        }
        catch (Exception e) {
            logger.error("Create transaction capsule failed.", (Throwable)e);
        }
        return trx;
    }

    public TransactionCapsule createTransactionCapsuleWithoutValidate(Message message, Protocol.Transaction.Contract.ContractType contractType, long timeout) {
        return this.createTransactionCapsuleWithoutValidateWithTimeout(message, contractType, timeout);
    }

    public TransactionCapsule createTransactionCapsuleWithoutValidate(Message message, Protocol.Transaction.Contract.ContractType contractType) {
        return this.createTransactionCapsuleWithoutValidateWithTimeout(message, contractType, 0L);
    }

    public TransactionCapsule createTransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) throws ContractValidateException {
        SmartContractOuterClass.CreateSmartContract contract;
        long percent;
        TransactionCapsule trx = new TransactionCapsule(message, contractType);
        trx.setTransactionCreate(true);
        if (contractType != Protocol.Transaction.Contract.ContractType.CreateSmartContract && contractType != Protocol.Transaction.Contract.ContractType.TriggerSmartContract) {
            List actList = ActuatorFactory.createActuator((TransactionCapsule)trx, (ChainBaseManager)this.chainBaseManager);
            for (Actuator act : actList) {
                act.validate();
            }
        }
        trx.setTransactionCreate(false);
        if (contractType == Protocol.Transaction.Contract.ContractType.CreateSmartContract && ((percent = (contract = ContractCapsule.getSmartContractFromTransaction((Protocol.Transaction)trx.getInstance())).getNewContract().getConsumeUserResourcePercent()) < 0L || percent > 100L)) {
            throw new ContractValidateException("percent must be >= 0 and <= 100");
        }
        this.setTransaction(trx);
        return trx;
    }

    public GrpcAPI.Return broadcastTransaction(Protocol.Transaction signedTransaction) {
        GrpcAPI.Return.Builder builder = GrpcAPI.Return.newBuilder();
        TransactionCapsule trx = new TransactionCapsule(signedTransaction);
        trx.setTime(System.currentTimeMillis());
        Sha256Hash txID = trx.getTransactionId();
        try {
            TransactionMessage message = new TransactionMessage(signedTransaction.toByteArray());
            if (this.minEffectiveConnection != 0) {
                if (this.tronNetDelegate.getActivePeer().isEmpty()) {
                    logger.warn("Broadcast transaction {} has failed, no connection.", (Object)txID);
                    return builder.setResult(false).setCode(GrpcAPI.Return.response_code.NO_CONNECTION).setMessage(ByteString.copyFromUtf8((String)"No connection.")).build();
                }
                int count = (int)this.tronNetDelegate.getActivePeer().stream().filter(p -> !p.isNeedSyncFromUs() && !p.isNeedSyncFromPeer()).count();
                if (count < this.minEffectiveConnection) {
                    String info = "Effective connection:" + count + " lt minEffectiveConnection:" + this.minEffectiveConnection;
                    logger.warn("Broadcast transaction {} has failed. {}.", (Object)txID, (Object)info);
                    return builder.setResult(false).setCode(GrpcAPI.Return.response_code.NOT_ENOUGH_EFFECTIVE_CONNECTION).setMessage(ByteString.copyFromUtf8((String)info)).build();
                }
            }
            if (this.dbManager.isTooManyPending()) {
                logger.warn("Broadcast transaction {} has failed, too many pending.", (Object)txID);
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.SERVER_BUSY).setMessage(ByteString.copyFromUtf8((String)"Server busy.")).build();
            }
            if (this.trxCacheEnable) {
                if (this.dbManager.getTransactionIdCache().getIfPresent((Object)txID) != null) {
                    logger.warn("Broadcast transaction {} has failed, it already exists.", (Object)txID);
                    return builder.setResult(false).setCode(GrpcAPI.Return.response_code.DUP_TRANSACTION_ERROR).setMessage(ByteString.copyFromUtf8((String)"Transaction already exists.")).build();
                }
                this.dbManager.getTransactionIdCache().put((Object)txID, (Object)true);
            }
            if (this.chainBaseManager.getDynamicPropertiesStore().supportVM()) {
                trx.resetResult();
            }
            if (trx.getInstance().getRawData().getContractCount() == 0) {
                throw new ContractValidateException("No contract!");
            }
            this.dbManager.pushTransaction(trx);
            int num = this.tronNetService.fastBroadcastTransaction(message);
            if (num == 0 && this.minEffectiveConnection != 0) {
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.NOT_ENOUGH_EFFECTIVE_CONNECTION).setMessage(ByteString.copyFromUtf8((String)"P2P broadcast failed.")).build();
            }
            logger.info("Broadcast transaction {} to {} peers successfully.", (Object)txID, (Object)num);
            return builder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS).build();
        }
        catch (ValidateSignatureException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.SIGERROR).setMessage(ByteString.copyFromUtf8((String)("Validate signature error: " + e.getMessage()))).build();
        }
        catch (ContractValidateException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)(CONTRACT_VALIDATE_ERROR + e.getMessage()))).build();
        }
        catch (ContractExeException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract execute error : " + e.getMessage()))).build();
        }
        catch (AccountResourceInsufficientException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.BANDWITH_ERROR).setMessage(ByteString.copyFromUtf8((String)"Account resource insufficient error.")).build();
        }
        catch (DupTransactionException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.DUP_TRANSACTION_ERROR).setMessage(ByteString.copyFromUtf8((String)"Dup transaction.")).build();
        }
        catch (TaposException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TAPOS_ERROR).setMessage(ByteString.copyFromUtf8((String)"Tapos check error.")).build();
        }
        catch (TooBigTransactionException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TOO_BIG_TRANSACTION_ERROR).setMessage(ByteString.copyFromUtf8((String)"Transaction size is too big.")).build();
        }
        catch (TransactionExpirationException e) {
            logger.warn(BROADCAST_TRANS_FAILED, (Object)txID, (Object)e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TRANSACTION_EXPIRATION_ERROR).setMessage(ByteString.copyFromUtf8((String)"Transaction expired")).build();
        }
        catch (Exception e) {
            logger.warn("Broadcast transaction {} failed", (Object)txID, (Object)e);
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)("Error: " + e.getMessage()))).build();
        }
    }

    public GrpcAPI.TransactionApprovedList getTransactionApprovedList(Protocol.Transaction trx) {
        GrpcAPI.TransactionApprovedList.Builder tswBuilder = GrpcAPI.TransactionApprovedList.newBuilder();
        GrpcAPI.TransactionExtention.Builder trxExBuilder = GrpcAPI.TransactionExtention.newBuilder();
        trxExBuilder.setTransaction(trx);
        trxExBuilder.setTxid(ByteString.copyFrom((byte[])Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])trx.getRawData().toByteArray())));
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExBuilder.setResult(retBuilder);
        tswBuilder.setTransaction(trxExBuilder);
        GrpcAPI.TransactionApprovedList.Result.Builder resultBuilder = GrpcAPI.TransactionApprovedList.Result.newBuilder();
        if (trx.getRawData().getContractCount() == 0) {
            resultBuilder.setCode(GrpcAPI.TransactionApprovedList.Result.response_code.OTHER_ERROR);
            resultBuilder.setMessage("Invalid transaction: no valid contract");
        } else {
            try {
                Protocol.Transaction.Contract contract = trx.getRawData().getContract(0);
                byte[] owner = TransactionCapsule.getOwner((Protocol.Transaction.Contract)contract);
                AccountCapsule account = this.chainBaseManager.getAccountStore().get(owner);
                if (account == null) {
                    throw new PermissionException("Account does not exist!");
                }
                if (trx.getSignatureCount() > 0) {
                    ArrayList<ByteString> approveList = new ArrayList<ByteString>();
                    byte[] hash = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])trx.getRawData().toByteArray());
                    for (ByteString sig : trx.getSignatureList()) {
                        if (sig.size() < 65) {
                            throw new SignatureFormatException("Signature size is " + sig.size());
                        }
                        String base64 = TransactionCapsule.getBase64FromByteString((ByteString)sig);
                        byte[] address = SignUtils.signatureToAddress((byte[])hash, (String)base64, (boolean)Args.getInstance().isECKeyCryptoEngine());
                        approveList.add(ByteString.copyFrom((byte[])address));
                    }
                    tswBuilder.addAllApprovedList(approveList);
                }
                resultBuilder.setCode(GrpcAPI.TransactionApprovedList.Result.response_code.SUCCESS);
            }
            catch (SignatureFormatException signEx) {
                resultBuilder.setCode(GrpcAPI.TransactionApprovedList.Result.response_code.SIGNATURE_FORMAT_ERROR);
                resultBuilder.setMessage(signEx.getMessage());
            }
            catch (SignatureException signEx) {
                resultBuilder.setCode(GrpcAPI.TransactionApprovedList.Result.response_code.COMPUTE_ADDRESS_ERROR);
                resultBuilder.setMessage(signEx.getMessage());
            }
            catch (Exception ex) {
                resultBuilder.setCode(GrpcAPI.TransactionApprovedList.Result.response_code.OTHER_ERROR);
                resultBuilder.setMessage(ex.getClass() + " : " + ex.getMessage());
            }
        }
        tswBuilder.setResult(resultBuilder);
        return tswBuilder.build();
    }

    public Protocol.Block getNowBlock() {
        List blockList = this.chainBaseManager.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isEmpty((Collection)blockList)) {
            return null;
        }
        return ((BlockCapsule)blockList.get(0)).getInstance();
    }

    public Protocol.Block getBlockByNum(long blockNum) {
        try {
            return this.chainBaseManager.getBlockByNum(blockNum).getInstance();
        }
        catch (StoreException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public BlockCapsule getBlockCapsuleByNum(long blockNum) {
        try {
            return this.chainBaseManager.getBlockByNum(blockNum);
        }
        catch (StoreException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public long getTransactionCountByBlockNum(long blockNum) {
        long count = 0L;
        try {
            Protocol.Block block = this.chainBaseManager.getBlockByNum(blockNum).getInstance();
            count = block.getTransactionsCount();
        }
        catch (StoreException e) {
            logger.warn(e.getMessage());
        }
        return count;
    }

    public Protocol.Block getByJsonBlockId(String id) throws JsonRpcInvalidParamsException {
        long blockNumber;
        if ("earliest".equalsIgnoreCase(id)) {
            return this.getBlockByNum(0L);
        }
        if ("latest".equalsIgnoreCase(id)) {
            return this.getNowBlock();
        }
        if ("pending".equalsIgnoreCase(id)) {
            throw new JsonRpcInvalidParamsException("TAG pending not supported");
        }
        try {
            blockNumber = ByteArray.hexToBigInteger((String)id).longValue();
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException("invalid block number");
        }
        return this.getBlockByNum(blockNumber);
    }

    public List<Protocol.Transaction> getTransactionsByJsonBlockId(String id) throws JsonRpcInvalidParamsException {
        if ("pending".equalsIgnoreCase(id)) {
            throw new JsonRpcInvalidParamsException("TAG pending not supported");
        }
        Protocol.Block block = this.getByJsonBlockId(id);
        return block != null ? block.getTransactionsList() : null;
    }

    public GrpcAPI.WitnessList getWitnessList() {
        GrpcAPI.WitnessList.Builder builder = GrpcAPI.WitnessList.newBuilder();
        List witnessCapsuleList = this.chainBaseManager.getWitnessStore().getAllWitnesses();
        witnessCapsuleList.forEach(witnessCapsule -> builder.addWitnesses(witnessCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.ProposalList getProposalList() {
        GrpcAPI.ProposalList.Builder builder = GrpcAPI.ProposalList.newBuilder();
        List proposalCapsuleList = this.chainBaseManager.getProposalStore().getAllProposals();
        proposalCapsuleList.forEach(proposalCapsule -> builder.addProposals(proposalCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.DelegatedResourceList getDelegatedResource(ByteString fromAddress, ByteString toAddress) {
        GrpcAPI.DelegatedResourceList.Builder builder = GrpcAPI.DelegatedResourceList.newBuilder();
        byte[] dbKey = DelegatedResourceCapsule.createDbKey((byte[])fromAddress.toByteArray(), (byte[])toAddress.toByteArray());
        DelegatedResourceCapsule delegatedResourceCapsule = this.chainBaseManager.getDelegatedResourceStore().get(dbKey);
        if (delegatedResourceCapsule != null) {
            builder.addDelegatedResource(delegatedResourceCapsule.getInstance());
        }
        return builder.build();
    }

    public GrpcAPI.DelegatedResourceList getDelegatedResourceV2(ByteString fromAddress, ByteString toAddress) {
        GrpcAPI.DelegatedResourceList.Builder builder = GrpcAPI.DelegatedResourceList.newBuilder();
        byte[] dbKey = DelegatedResourceCapsule.createDbKeyV2((byte[])fromAddress.toByteArray(), (byte[])toAddress.toByteArray(), (boolean)false);
        DelegatedResourceCapsule unlockResource = this.chainBaseManager.getDelegatedResourceStore().get(dbKey);
        if (this.nonEmptyResource(unlockResource)) {
            builder.addDelegatedResource(unlockResource.getInstance());
        }
        dbKey = DelegatedResourceCapsule.createDbKeyV2((byte[])fromAddress.toByteArray(), (byte[])toAddress.toByteArray(), (boolean)true);
        DelegatedResourceCapsule lockResource = this.chainBaseManager.getDelegatedResourceStore().get(dbKey);
        if (this.nonEmptyResource(lockResource)) {
            builder.addDelegatedResource(lockResource.getInstance());
        }
        return builder.build();
    }

    private boolean nonEmptyResource(DelegatedResourceCapsule resource) {
        return Objects.nonNull(resource) && (resource.getExpireTimeForBandwidth() != 0L || resource.getExpireTimeForEnergy() != 0L || resource.getFrozenBalanceForBandwidth() != 0L || resource.getFrozenBalanceForEnergy() != 0L);
    }

    public GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage getCanWithdrawUnfreezeAmount(ByteString ownerAddress, long timestamp) {
        GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage.Builder builder = GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage.newBuilder();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountCapsule accountCapsule = accountStore.get(ownerAddress.toByteArray());
        if (accountCapsule == null) {
            return builder.build();
        }
        if (timestamp == 0L) {
            timestamp = dynamicStore.getLatestBlockHeaderTimestamp();
        }
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        long finalTimestamp = timestamp;
        long canWithdrawUnfreezeAmount = unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeAmount() > 0L && unfrozenV2.getUnfreezeExpireTime() <= finalTimestamp).mapToLong(Protocol.Account.UnFreezeV2::getUnfreezeAmount).sum();
        builder.setAmount(canWithdrawUnfreezeAmount);
        return builder.build();
    }

    public GrpcAPI.CanDelegatedMaxSizeResponseMessage getCanDelegatedMaxSize(ByteString ownerAddress, int resourceType) {
        long canDelegatedMaxSize = 0L;
        GrpcAPI.CanDelegatedMaxSizeResponseMessage.Builder builder = GrpcAPI.CanDelegatedMaxSizeResponseMessage.newBuilder();
        if (Common.ResourceCode.BANDWIDTH.getNumber() == resourceType) {
            canDelegatedMaxSize = this.calcCanDelegatedBandWidthMaxSize(ownerAddress);
        } else if (Common.ResourceCode.ENERGY.getNumber() == resourceType) {
            canDelegatedMaxSize = this.calcCanDelegatedEnergyMaxSize(ownerAddress);
        }
        if (canDelegatedMaxSize < 1000000L) {
            canDelegatedMaxSize = 0L;
        }
        builder.setMaxSize(canDelegatedMaxSize);
        return builder.build();
    }

    public GrpcAPI.GetAvailableUnfreezeCountResponseMessage getAvailableUnfreezeCount(ByteString ownerAddress) {
        GrpcAPI.GetAvailableUnfreezeCountResponseMessage.Builder builder = GrpcAPI.GetAvailableUnfreezeCountResponseMessage.newBuilder();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountCapsule accountCapsule = accountStore.get(ownerAddress.toByteArray());
        if (accountCapsule == null) {
            return builder.build();
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        List unfrozenV2List = accountCapsule.getInstance().getUnfrozenV2List();
        long getUsedUnfreezeCount = unfrozenV2List.stream().filter(unfrozenV2 -> unfrozenV2.getUnfreezeAmount() > 0L && unfrozenV2.getUnfreezeExpireTime() > now).count();
        long getAvailableUnfreezeCount = (long)UnfreezeBalanceV2Actuator.getUNFREEZE_MAX_TIMES() - getUsedUnfreezeCount;
        builder.setCount(getAvailableUnfreezeCount);
        return builder.build();
    }

    public long calcCanDelegatedBandWidthMaxSize(ByteString ownerAddress) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress.toByteArray());
        if (ownerCapsule == null) {
            return 0L;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.updateUsage(ownerCapsule);
        long accountNetUsage = ownerCapsule.getNetUsage();
        long netUsage = (long)((double)((accountNetUsage += org.tron.core.utils.TransactionUtil.estimateConsumeBandWidthSize((AccountCapsule)ownerCapsule, (ChainBaseManager)this.chainBaseManager)) * 1000000L) * ((double)dynamicStore.getTotalNetWeight() / (double)dynamicStore.getTotalNetLimit()));
        long remainNetUsage = netUsage - ownerCapsule.getFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
        remainNetUsage = Math.max(0L, remainNetUsage);
        long maxSize = ownerCapsule.getFrozenV2BalanceForBandwidth() - remainNetUsage;
        return Math.max(0L, maxSize);
    }

    public long calcCanDelegatedEnergyMaxSize(ByteString ownerAddress) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress.toByteArray());
        if (ownerCapsule == null) {
            return 0L;
        }
        EnergyProcessor processor = new EnergyProcessor(dynamicStore, accountStore);
        processor.updateUsage(ownerCapsule);
        long energyUsage = (long)((double)(ownerCapsule.getEnergyUsage() * 1000000L) * ((double)dynamicStore.getTotalEnergyWeight() / (double)dynamicStore.getTotalEnergyCurrentLimit()));
        long remainEnergyUsage = energyUsage - ownerCapsule.getEnergyFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy();
        remainEnergyUsage = Math.max(0L, remainEnergyUsage);
        long maxSize = ownerCapsule.getFrozenV2BalanceForEnergy() - remainEnergyUsage;
        return Math.max(0L, maxSize);
    }

    public Protocol.DelegatedResourceAccountIndex getDelegatedResourceAccountIndex(ByteString address) {
        if (address == null || address.size() != 21) {
            return Protocol.DelegatedResourceAccountIndex.getDefaultInstance();
        }
        DelegatedResourceAccountIndexCapsule accountIndexCapsule = this.chainBaseManager.getDelegatedResourceAccountIndexStore().getIndex(address.toByteArray());
        if (accountIndexCapsule != null) {
            return accountIndexCapsule.getInstance();
        }
        return Protocol.DelegatedResourceAccountIndex.getDefaultInstance();
    }

    public Protocol.DelegatedResourceAccountIndex getDelegatedResourceAccountIndexV2(ByteString address) {
        if (address == null || address.size() != 21) {
            return Protocol.DelegatedResourceAccountIndex.getDefaultInstance();
        }
        DelegatedResourceAccountIndexCapsule accountIndexCapsule = this.chainBaseManager.getDelegatedResourceAccountIndexStore().getV2Index(address.toByteArray());
        if (accountIndexCapsule != null) {
            return accountIndexCapsule.getInstance();
        }
        return Protocol.DelegatedResourceAccountIndex.getDefaultInstance();
    }

    public GrpcAPI.ExchangeList getExchangeList() {
        GrpcAPI.ExchangeList.Builder builder = GrpcAPI.ExchangeList.newBuilder();
        List exchangeCapsuleList = Commons.getExchangeStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (ExchangeStore)this.chainBaseManager.getExchangeStore(), (ExchangeV2Store)this.chainBaseManager.getExchangeV2Store()).getAllExchanges();
        exchangeCapsuleList.forEach(exchangeCapsule -> builder.addExchanges(exchangeCapsule.getInstance()));
        return builder.build();
    }

    public Protocol.ChainParameters getChainParameters() {
        Protocol.ChainParameters.Builder builder = Protocol.ChainParameters.newBuilder();
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMaintenanceTimeInterval").setValue(this.chainBaseManager.getDynamicPropertiesStore().getMaintenanceTimeInterval()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAccountUpgradeCost").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAccountUpgradeCost()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getCreateAccountFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getCreateAccountFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTransactionFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getTransactionFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAssetIssueFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAssetIssueFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getWitnessPayPerBlock").setValue(this.chainBaseManager.getDynamicPropertiesStore().getWitnessPayPerBlock()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getWitnessStandbyAllowance").setValue(this.chainBaseManager.getDynamicPropertiesStore().getWitnessStandbyAllowance()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getCreateNewAccountFeeInSystemContract").setValue(this.chainBaseManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getCreateNewAccountBandwidthRate").setValue(this.chainBaseManager.getDynamicPropertiesStore().getCreateNewAccountBandwidthRate()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowCreationOfContracts").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowCreationOfContracts()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getRemoveThePowerOfTheGr").setValue(this.chainBaseManager.getDynamicPropertiesStore().getRemoveThePowerOfTheGr()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getEnergyFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getEnergyFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getExchangeCreateFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getExchangeCreateFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMaxCpuTimeOfOneTx").setValue(this.chainBaseManager.getDynamicPropertiesStore().getMaxCpuTimeOfOneTx()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowUpdateAccountName").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowUpdateAccountName()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowSameTokenName").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowDelegateResource").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowDelegateResource()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTotalEnergyLimit").setValue(this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmTransferTrc10").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowTvmTransferTrc10()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTotalEnergyCurrentLimit").setValue(this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyCurrentLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowMultiSign").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowMultiSign()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowAdaptiveEnergy").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowAdaptiveEnergy()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTotalEnergyTargetLimit").setValue(this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyTargetLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTotalEnergyAverageUsage").setValue(this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyAverageUsage()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getUpdateAccountPermissionFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getUpdateAccountPermissionFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMultiSignFee").setValue(this.chainBaseManager.getDynamicPropertiesStore().getMultiSignFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowAccountStateRoot").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowAccountStateRoot()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowProtoFilterNum").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowProtoFilterNum()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmConstantinople").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowTvmConstantinople()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmSolidity059").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAllowTvmSolidity059()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmIstanbul").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmIstanbul()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowShieldedTRC20Transaction").setValue(this.dbManager.getDynamicPropertiesStore().getAllowShieldedTRC20Transaction()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getForbidTransferToContract").setValue(this.dbManager.getDynamicPropertiesStore().getForbidTransferToContract()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAdaptiveResourceLimitTargetRatio").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAdaptiveResourceLimitTargetRatio() / 1440L).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAdaptiveResourceLimitMultiplier").setValue(this.chainBaseManager.getDynamicPropertiesStore().getAdaptiveResourceLimitMultiplier()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getChangeDelegation").setValue(this.chainBaseManager.getDynamicPropertiesStore().getChangeDelegation()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getWitness127PayPerBlock").setValue(this.chainBaseManager.getDynamicPropertiesStore().getWitness127PayPerBlock()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowMarketTransaction").setValue(this.dbManager.getDynamicPropertiesStore().getAllowMarketTransaction()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMarketSellFee").setValue(this.dbManager.getDynamicPropertiesStore().getMarketSellFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMarketCancelFee").setValue(this.dbManager.getDynamicPropertiesStore().getMarketCancelFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowPBFT").setValue(this.dbManager.getDynamicPropertiesStore().getAllowPBFT()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTransactionFeePool").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTransactionFeePool()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMaxFeeLimit").setValue(this.dbManager.getDynamicPropertiesStore().getMaxFeeLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowOptimizeBlackHole").setValue(this.dbManager.getDynamicPropertiesStore().getAllowBlackHoleOptimization()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowNewResourceModel").setValue(this.dbManager.getDynamicPropertiesStore().getAllowNewResourceModel()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmFreeze").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmFreeze()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmVote").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmVote()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmLondon").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmLondon()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmCompatibleEvm").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmCompatibleEvm()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowAccountAssetOptimization").setValue(this.dbManager.getDynamicPropertiesStore().getAllowAccountAssetOptimization()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getFreeNetLimit").setValue(this.dbManager.getDynamicPropertiesStore().getFreeNetLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getTotalNetLimit").setValue(this.dbManager.getDynamicPropertiesStore().getTotalNetLimit()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowHigherLimitForMaxCpuTimeOfOneTx").setValue(this.dbManager.getDynamicPropertiesStore().getAllowHigherLimitForMaxCpuTimeOfOneTx()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowAssetOptimization").setValue(this.dbManager.getDynamicPropertiesStore().getAllowAssetOptimization()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowNewReward").setValue(this.dbManager.getDynamicPropertiesStore().getAllowNewReward()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMemoFee").setValue(this.dbManager.getDynamicPropertiesStore().getMemoFee()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowDelegateOptimization").setValue(this.dbManager.getDynamicPropertiesStore().getAllowDelegateOptimization()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getUnfreezeDelayDays").setValue(this.dbManager.getDynamicPropertiesStore().getUnfreezeDelayDays()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowOptimizedReturnValueOfChainId").setValue(this.dbManager.getDynamicPropertiesStore().getAllowOptimizedReturnValueOfChainId()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowDynamicEnergy").setValue(this.dbManager.getDynamicPropertiesStore().getAllowDynamicEnergy()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getDynamicEnergyThreshold").setValue(this.dbManager.getDynamicPropertiesStore().getDynamicEnergyThreshold()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getDynamicEnergyIncreaseFactor").setValue(this.dbManager.getDynamicPropertiesStore().getDynamicEnergyIncreaseFactor()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getDynamicEnergyMaxFactor").setValue(this.dbManager.getDynamicPropertiesStore().getDynamicEnergyMaxFactor()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowTvmShangHai").setValue(this.dbManager.getDynamicPropertiesStore().getAllowTvmShangHai()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getAllowCancelAllUnfreezeV2").setValue(this.dbManager.getDynamicPropertiesStore().getAllowCancelAllUnfreezeV2()).build());
        builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey("getMaxDelegateLockPeriod").setValue(this.dbManager.getDynamicPropertiesStore().getMaxDelegateLockPeriod()).build());
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueList() {
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (AssetIssueStore)this.chainBaseManager.getAssetIssueStore(), (AssetIssueV2Store)this.chainBaseManager.getAssetIssueV2Store()).getAllAssetIssues().forEach(issueCapsule -> {
            processor.updateUsage(issueCapsule);
            builder.addAssetIssue(issueCapsule.getInstance());
        });
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueList(long offset, long limit) {
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        List assetIssueList = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (AssetIssueStore)this.chainBaseManager.getAssetIssueStore(), (AssetIssueV2Store)this.chainBaseManager.getAssetIssueV2Store()).getAssetIssuesPaginated(offset, limit);
        if (CollectionUtils.isEmpty((Collection)assetIssueList)) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        assetIssueList.forEach(issueCapsule -> {
            processor.updateUsage(issueCapsule);
            builder.addAssetIssue(issueCapsule.getInstance());
        });
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueByAccount(ByteString accountAddress) {
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        List assetIssueCapsuleList = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (AssetIssueStore)this.chainBaseManager.getAssetIssueStore(), (AssetIssueV2Store)this.chainBaseManager.getAssetIssueV2Store()).getAllAssetIssues();
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getOwnerAddress().equals((Object)accountAddress)).forEach(issueCapsule -> {
            processor.updateUsage(issueCapsule);
            builder.addAssetIssue(issueCapsule.getInstance());
        });
        return builder.build();
    }

    private Map<String, Long> setAssetNetLimit(Map<String, Long> assetNetLimitMap, AccountCapsule accountCapsule) {
        Map allFreeAssetNetUsage;
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsage();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString((String)asset);
                assetNetLimitMap.put((String)asset, this.chainBaseManager.getAssetIssueStore().get(key).getFreeAssetNetLimit());
            });
        } else {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsageV2();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString((String)asset);
                assetNetLimitMap.put((String)asset, this.chainBaseManager.getAssetIssueV2Store().get(key).getFreeAssetNetLimit());
            });
        }
        return allFreeAssetNetUsage;
    }

    public GrpcAPI.AccountNetMessage getAccountNet(ByteString accountAddress) {
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        GrpcAPI.AccountNetMessage.Builder builder = GrpcAPI.AccountNetMessage.newBuilder();
        AccountCapsule accountCapsule = this.chainBaseManager.getAccountStore().get(accountAddress.toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.updateUsage(accountCapsule);
        long netLimit = processor.calculateGlobalNetLimit(accountCapsule);
        long freeNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getFreeNetLimit();
        long totalNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetWeight();
        HashMap<String, Long> assetNetLimitMap = new HashMap<String, Long>();
        Map<String, Long> allFreeAssetNetUsage = this.setAssetNetLimit(assetNetLimitMap, accountCapsule);
        builder.setFreeNetUsed(accountCapsule.getFreeNetUsage()).setFreeNetLimit(freeNetLimit).setNetUsed(accountCapsule.getNetUsage()).setNetLimit(netLimit).setTotalNetLimit(totalNetLimit).setTotalNetWeight(totalNetWeight).putAllAssetNetUsed(allFreeAssetNetUsage).putAllAssetNetLimit(assetNetLimitMap);
        return builder.build();
    }

    public GrpcAPI.AccountResourceMessage getAccountResource(ByteString accountAddress) {
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        GrpcAPI.AccountResourceMessage.Builder builder = GrpcAPI.AccountResourceMessage.newBuilder();
        AccountCapsule accountCapsule = this.chainBaseManager.getAccountStore().get(accountAddress.toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAccountStore());
        energyProcessor.updateUsage(accountCapsule);
        long netLimit = processor.calculateGlobalNetLimit(accountCapsule);
        long freeNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getFreeNetLimit();
        long totalNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetWeight();
        long totalTronPowerWeight = this.chainBaseManager.getDynamicPropertiesStore().getTotalTronPowerWeight();
        long energyLimit = energyProcessor.calculateGlobalEnergyLimit(accountCapsule);
        long totalEnergyLimit = this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.chainBaseManager.getDynamicPropertiesStore().getTotalEnergyWeight();
        long storageLimit = accountCapsule.getAccountResource().getStorageLimit();
        long storageUsage = accountCapsule.getAccountResource().getStorageUsage();
        long allTronPowerUsage = accountCapsule.getTronPowerUsage();
        long allTronPower = accountCapsule.getAllTronPower() / 1000000L;
        HashMap<String, Long> assetNetLimitMap = new HashMap<String, Long>();
        Map<String, Long> allFreeAssetNetUsage = this.setAssetNetLimit(assetNetLimitMap, accountCapsule);
        builder.setFreeNetUsed(accountCapsule.getFreeNetUsage()).setFreeNetLimit(freeNetLimit).setNetUsed(accountCapsule.getNetUsage()).setNetLimit(netLimit).setTotalNetLimit(totalNetLimit).setTotalNetWeight(totalNetWeight).setTotalTronPowerWeight(totalTronPowerWeight).setEnergyLimit(energyLimit).setEnergyUsed(accountCapsule.getAccountResource().getEnergyUsage()).setTronPowerUsed(allTronPowerUsage).setTronPowerLimit(allTronPower).setTotalEnergyLimit(totalEnergyLimit).setTotalEnergyWeight(totalEnergyWeight).setStorageLimit(storageLimit).setStorageUsed(storageUsage).putAllAssetNetUsed(allFreeAssetNetUsage).putAllAssetNetLimit(assetNetLimitMap);
        return builder.build();
    }

    public AssetIssueContractOuterClass.AssetIssueContract getAssetIssueByName(ByteString assetName) throws NonUniqueObjectException {
        if (assetName == null || assetName.isEmpty()) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            AssetIssueCapsule assetIssueCapsule2 = this.chainBaseManager.getAssetIssueStore().get(assetName.toByteArray());
            if (assetIssueCapsule2 != null) {
                processor.updateUsage(assetIssueCapsule2);
                return assetIssueCapsule2.getInstance();
            }
            return null;
        }
        List assetIssueCapsuleList = this.chainBaseManager.getAssetIssueV2Store().getAllAssetIssues();
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getName().equals((Object)assetName)).forEach(issueCapsule -> {
            processor.updateUsage(issueCapsule);
            builder.addAssetIssue(issueCapsule.getInstance());
        });
        if (builder.getAssetIssueCount() > 1) {
            throw new NonUniqueObjectException("To get more than one asset, please use getAssetIssueById syntax");
        }
        AssetIssueCapsule assetIssueCapsule3 = this.chainBaseManager.getAssetIssueV2Store().get(assetName.toByteArray());
        if (assetIssueCapsule3 != null) {
            processor.updateUsage(assetIssueCapsule3);
            if (builder.getAssetIssueCount() > 0 && builder.getAssetIssue(0).getId().equals(assetIssueCapsule3.getInstance().getId())) {
                return assetIssueCapsule3.getInstance();
            }
            builder.addAssetIssue(assetIssueCapsule3.getInstance());
            if (builder.getAssetIssueCount() > 1) {
                throw new NonUniqueObjectException("To get more than one asset, please use getAssetIssueById syntax");
            }
        }
        if (builder.getAssetIssueCount() > 0) {
            return builder.getAssetIssue(0);
        }
        return null;
    }

    public GrpcAPI.AssetIssueList getAssetIssueListByName(ByteString assetName) {
        if (assetName == null || assetName.isEmpty()) {
            return null;
        }
        List assetIssueCapsuleList = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (AssetIssueStore)this.chainBaseManager.getAssetIssueStore(), (AssetIssueV2Store)this.chainBaseManager.getAssetIssueV2Store()).getAllAssetIssues();
        BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getName().equals((Object)assetName)).forEach(issueCapsule -> {
            processor.updateUsage(issueCapsule);
            builder.addAssetIssue(issueCapsule.getInstance());
        });
        return builder.build();
    }

    public AssetIssueContractOuterClass.AssetIssueContract getAssetIssueById(String assetId) {
        if (assetId == null || assetId.isEmpty()) {
            return null;
        }
        AssetIssueCapsule assetIssueCapsule = this.chainBaseManager.getAssetIssueV2Store().get(ByteArray.fromString((String)assetId));
        if (assetIssueCapsule != null) {
            BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
            processor.updateUsage(assetIssueCapsule);
            return assetIssueCapsule.getInstance();
        }
        return null;
    }

    public GrpcAPI.NumberMessage totalTransaction() {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder().setNum(this.chainBaseManager.getTransactionStore().getTotalTransactions());
        return builder.build();
    }

    public GrpcAPI.NumberMessage getNextMaintenanceTime() {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder().setNum(this.chainBaseManager.getDynamicPropertiesStore().getNextMaintenanceTime());
        return builder.build();
    }

    public Protocol.Block getBlockById(ByteString blockId) {
        if (Objects.isNull(blockId)) {
            return null;
        }
        Protocol.Block block = null;
        try {
            block = ((BlockCapsule)this.chainBaseManager.getBlockStore().get(blockId.toByteArray())).getInstance();
        }
        catch (StoreException e) {
            logger.warn(e.getMessage());
        }
        return block;
    }

    public GrpcAPI.BlockList getBlocksByLimitNext(long number, long limit) {
        if (limit <= 0L) {
            return null;
        }
        GrpcAPI.BlockList.Builder blockListBuilder = GrpcAPI.BlockList.newBuilder();
        this.chainBaseManager.getBlockStore().getLimitNumber(number, limit).forEach(blockCapsule -> blockListBuilder.addBlock(blockCapsule.getInstance()));
        return blockListBuilder.build();
    }

    public GrpcAPI.BlockList getBlockByLatestNum(long getNum) {
        GrpcAPI.BlockList.Builder blockListBuilder = GrpcAPI.BlockList.newBuilder();
        this.chainBaseManager.getBlockStore().getBlockByLatestNum(getNum).forEach(blockCapsule -> blockListBuilder.addBlock(blockCapsule.getInstance()));
        return blockListBuilder.build();
    }

    public Protocol.Transaction getTransactionById(ByteString transactionId) {
        if (Objects.isNull(transactionId)) {
            return null;
        }
        TransactionCapsule transactionCapsule = null;
        try {
            transactionCapsule = this.chainBaseManager.getTransactionStore().get(transactionId.toByteArray());
        }
        catch (StoreException e) {
            return null;
        }
        if (transactionCapsule != null) {
            return transactionCapsule.getInstance();
        }
        return null;
    }

    public TransactionCapsule getTransactionCapsuleById(ByteString transactionId) {
        TransactionCapsule transactionCapsule;
        if (Objects.isNull(transactionId)) {
            return null;
        }
        try {
            transactionCapsule = this.chainBaseManager.getTransactionStore().get(transactionId.toByteArray());
        }
        catch (StoreException e) {
            return null;
        }
        return transactionCapsule;
    }

    public Protocol.TransactionInfo getTransactionInfoById(ByteString transactionId) {
        TransactionInfoCapsule transactionInfoCapsule;
        if (Objects.isNull(transactionId)) {
            return null;
        }
        try {
            transactionInfoCapsule = this.chainBaseManager.getTransactionRetStore().getTransactionInfo(transactionId.toByteArray());
        }
        catch (StoreException e) {
            return null;
        }
        if (transactionInfoCapsule != null) {
            return transactionInfoCapsule.getInstance();
        }
        try {
            transactionInfoCapsule = this.chainBaseManager.getTransactionHistoryStore().get(transactionId.toByteArray());
        }
        catch (BadItemException e) {
            return null;
        }
        return transactionInfoCapsule == null ? null : transactionInfoCapsule.getInstance();
    }

    public Protocol.Proposal getProposalById(ByteString proposalId) {
        if (Objects.isNull(proposalId)) {
            return null;
        }
        ProposalCapsule proposalCapsule = null;
        try {
            proposalCapsule = this.chainBaseManager.getProposalStore().get(proposalId.toByteArray());
        }
        catch (StoreException e) {
            logger.warn(e.getMessage());
        }
        if (proposalCapsule != null) {
            return proposalCapsule.getInstance();
        }
        return null;
    }

    public Protocol.Exchange getExchangeById(ByteString exchangeId) {
        ExchangeCapsule exchangeCapsule;
        if (Objects.isNull(exchangeId)) {
            return null;
        }
        try {
            exchangeCapsule = Commons.getExchangeStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (ExchangeStore)this.chainBaseManager.getExchangeStore(), (ExchangeV2Store)this.chainBaseManager.getExchangeV2Store()).get(exchangeId.toByteArray());
        }
        catch (StoreException e) {
            return null;
        }
        if (exchangeCapsule != null) {
            return exchangeCapsule.getInstance();
        }
        return null;
    }

    private boolean getFullNodeAllowShieldedTransaction() {
        return Args.getInstance().isFullNodeAllowShieldedTransactionArgs();
    }

    private void checkFullNodeAllowShieldedTransaction() throws ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
    }

    public GrpcAPI.BytesMessage getNullifier(ByteString id) {
        if (Objects.isNull(id)) {
            return null;
        }
        BytesCapsule nullifier = null;
        nullifier = this.chainBaseManager.getNullifierStore().get(id.toByteArray());
        if (nullifier != null) {
            return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])nullifier.getData())).build();
        }
        return null;
    }

    private long getBlockNumber(ShieldContract.OutputPoint outPoint) throws BadItemException, ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
        ByteString txId = outPoint.getHash();
        long blockNum = this.chainBaseManager.getTransactionStore().getBlockNumber(txId.toByteArray());
        if (blockNum <= 0L) {
            throw new RuntimeException("tx is not found:" + ByteArray.toHexString((byte[])txId.toByteArray()));
        }
        return blockNum;
    }

    private IncrementalMerkleVoucherContainer createWitness(ShieldContract.OutputPoint outPoint, Long blockNumber) throws ItemNotFoundException, BadItemException, InvalidProtocolBufferException, ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
        ByteString txId = outPoint.getHash();
        byte[] treeRoot = this.chainBaseManager.getMerkleTreeIndexStore().get(Long.valueOf(blockNumber - 1L));
        if (treeRoot == null) {
            throw new RuntimeException("treeRoot is null, blockNumber:" + (blockNumber - 1L));
        }
        IncrementalMerkleTreeCapsule treeCapsule = this.chainBaseManager.getMerkleTreeStore().get(treeRoot);
        if (treeCapsule == null) {
            if ("fbc2f4300c01f0b7820d00e3347c8da4ee614674376cbc45359daa54f9b5493e".equals(ByteArray.toHexString((byte[])treeRoot))) {
                treeCapsule = new IncrementalMerkleTreeCapsule();
            } else {
                throw new RuntimeException("tree is null, treeRoot:" + ByteArray.toHexString((byte[])treeRoot));
            }
        }
        IncrementalMerkleTreeContainer tree = treeCapsule.toMerkleTreeContainer();
        BlockCapsule block = this.chainBaseManager.getBlockByNum(blockNumber.longValue());
        IncrementalMerkleVoucherContainer witness = null;
        boolean found = false;
        for (Protocol.Transaction transaction : block.getInstance().getTransactionsList()) {
            Protocol.Transaction.Contract contract = transaction.getRawData().getContract(0);
            if (contract.getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
            ShieldContract.ShieldedTransferContract zkContract = (ShieldContract.ShieldedTransferContract)contract.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
            if (new TransactionCapsule(transaction).getTransactionId().getByteString().equals((Object)txId)) {
                found = true;
                if (outPoint.getIndex() >= zkContract.getReceiveDescriptionCount()) {
                    throw new RuntimeException("outPoint.getIndex():" + outPoint.getIndex() + " >= zkContract.getReceiveDescriptionCount():" + zkContract.getReceiveDescriptionCount());
                }
                int index = 0;
                for (ShieldContract.ReceiveDescription receiveDescription : zkContract.getReceiveDescriptionList()) {
                    PedersenHashCapsule cmCapsule = new PedersenHashCapsule();
                    cmCapsule.setContent(receiveDescription.getNoteCommitment());
                    ShieldContract.PedersenHash cm = cmCapsule.getInstance();
                    if (index < outPoint.getIndex()) {
                        tree.append(cm);
                    } else if (outPoint.getIndex() == index) {
                        tree.append(cm);
                        witness = tree.getTreeCapsule().deepCopy().toMerkleTreeContainer().toVoucher();
                    } else if (witness != null) {
                        witness.append(cm);
                    } else {
                        throw new ZksnarkException("witness is null!");
                    }
                    ++index;
                }
                continue;
            }
            for (ShieldContract.ReceiveDescription receiveDescription : zkContract.getReceiveDescriptionList()) {
                PedersenHashCapsule cmCapsule = new PedersenHashCapsule();
                cmCapsule.setContent(receiveDescription.getNoteCommitment());
                ShieldContract.PedersenHash cm = cmCapsule.getInstance();
                if (witness != null) {
                    witness.append(cm);
                    continue;
                }
                tree.append(cm);
            }
        }
        if (!found) {
            throw new RuntimeException("cm not found");
        }
        return witness;
    }

    private void updateWitnesses(List<IncrementalMerkleVoucherContainer> witnessList, long large, int synBlockNum) throws ItemNotFoundException, BadItemException, InvalidProtocolBufferException, ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
        long start = large;
        long end = large + (long)synBlockNum - 1L;
        long latestBlockHeaderNumber = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        if (end > latestBlockHeaderNumber) {
            throw new RuntimeException("synBlockNum is too large, cmBlockNum plus synBlockNum must be <= latestBlockNumber");
        }
        for (long n = start; n <= end; ++n) {
            BlockCapsule block = this.chainBaseManager.getBlockByNum(n);
            for (Protocol.Transaction transaction1 : block.getInstance().getTransactionsList()) {
                Protocol.Transaction.Contract contract1 = transaction1.getRawData().getContract(0);
                if (contract1.getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
                ShieldContract.ShieldedTransferContract zkContract = (ShieldContract.ShieldedTransferContract)contract1.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                for (ShieldContract.ReceiveDescription receiveDescription : zkContract.getReceiveDescriptionList()) {
                    PedersenHashCapsule cmCapsule = new PedersenHashCapsule();
                    cmCapsule.setContent(receiveDescription.getNoteCommitment());
                    ShieldContract.PedersenHash cm = cmCapsule.getInstance();
                    for (IncrementalMerkleVoucherContainer wit : witnessList) {
                        wit.append(cm);
                    }
                }
            }
        }
    }

    private void updateLowWitness(IncrementalMerkleVoucherContainer witness, long blockNum1, long blockNum2) throws ItemNotFoundException, BadItemException, InvalidProtocolBufferException, ZksnarkException {
        if (blockNum1 >= blockNum2) {
            return;
        }
        long start = blockNum1 + 1L;
        long end = blockNum2;
        for (long n = start; n <= end; ++n) {
            BlockCapsule block = this.chainBaseManager.getBlockByNum(n);
            for (Protocol.Transaction transaction1 : block.getInstance().getTransactionsList()) {
                Protocol.Transaction.Contract contract1 = transaction1.getRawData().getContract(0);
                if (contract1.getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
                ShieldContract.ShieldedTransferContract zkContract = (ShieldContract.ShieldedTransferContract)contract1.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                for (ShieldContract.ReceiveDescription receiveDescription : zkContract.getReceiveDescriptionList()) {
                    PedersenHashCapsule cmCapsule = new PedersenHashCapsule();
                    cmCapsule.setContent(receiveDescription.getNoteCommitment());
                    ShieldContract.PedersenHash cm = cmCapsule.getInstance();
                    witness.append(cm);
                }
            }
        }
    }

    private void validateInput(ShieldContract.OutputPointInfo request) throws BadItemException, ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
        if (request.getBlockNum() < 0 || request.getBlockNum() > 1000) {
            throw new BadItemException("request.BlockNum must be specified with range in [0, 1000]");
        }
        if (request.getOutPointsCount() < 1 || request.getOutPointsCount() > 10) {
            throw new BadItemException("request.OutPointsCount must be speccified with range in [1, 10]");
        }
        for (ShieldContract.OutputPoint outputPoint : request.getOutPointsList()) {
            if (outputPoint.getHash() == null) {
                throw new BadItemException("outPoint.getHash() == null");
            }
            if (outputPoint.getIndex() < 10 && outputPoint.getIndex() >= 0) continue;
            throw new BadItemException("outPoint.getIndex() > 10 || outPoint.getIndex() < 0");
        }
    }

    public ShieldContract.IncrementalMerkleVoucherInfo getMerkleTreeVoucherInfo(ShieldContract.OutputPointInfo request) throws ItemNotFoundException, BadItemException, InvalidProtocolBufferException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        this.validateInput(request);
        ShieldContract.IncrementalMerkleVoucherInfo.Builder result = ShieldContract.IncrementalMerkleVoucherInfo.newBuilder();
        long largeBlockNum = 0L;
        for (ShieldContract.OutputPoint outputPoint : request.getOutPointsList()) {
            Long blockNum1 = this.getBlockNumber(outputPoint);
            if (blockNum1 <= largeBlockNum) continue;
            largeBlockNum = blockNum1;
        }
        logger.debug("largeBlockNum:" + largeBlockNum);
        int opIndex = 0;
        ArrayList witnessList = Lists.newArrayList();
        for (ShieldContract.OutputPoint outputPoint : request.getOutPointsList()) {
            Long blockNum1 = this.getBlockNumber(outputPoint);
            logger.debug("blockNum:" + blockNum1 + ", opIndex:" + opIndex++);
            if (blockNum1 + 100L < largeBlockNum) {
                throw new RuntimeException("blockNum:" + blockNum1 + " + 100 < largeBlockNum:" + largeBlockNum);
            }
            IncrementalMerkleVoucherContainer witness = this.createWitness(outputPoint, blockNum1);
            this.updateLowWitness(witness, blockNum1, largeBlockNum);
            witnessList.add(witness);
        }
        int synBlockNum = request.getBlockNum();
        if (synBlockNum != 0) {
            this.updateWitnesses(witnessList, largeBlockNum + 1L, synBlockNum);
        }
        for (IncrementalMerkleVoucherContainer w : witnessList) {
            w.getVoucherCapsule().resetRt();
            result.addVouchers(w.getVoucherCapsule().getInstance());
            result.addPaths(ByteString.copyFrom((byte[])w.path().encode()));
        }
        return result.build();
    }

    public ShieldContract.IncrementalMerkleTree getMerkleTreeOfBlock(long blockNum) throws ZksnarkException {
        if (!this.getFullNodeAllowShieldedTransaction()) {
            throw new ZksnarkException(SHIELDED_ID_NOT_ALLOWED);
        }
        if (blockNum < 0L) {
            return null;
        }
        try {
            if (this.chainBaseManager.getMerkleTreeIndexStore().has(ByteArray.fromLong((long)blockNum))) {
                return ShieldContract.IncrementalMerkleTree.parseFrom((byte[])this.chainBaseManager.getMerkleTreeIndexStore().get(Long.valueOf(blockNum)));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }

    public long getShieldedTransactionFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getShieldedTransactionFee();
    }

    private void checkCmValid(List<GrpcAPI.SpendNote> shieldedSpends, List<GrpcAPI.ReceiveNote> shieldedReceives) throws ContractValidateException {
        this.checkCmNumber(shieldedSpends, shieldedReceives);
        this.checkCmValue(shieldedSpends, shieldedReceives);
    }

    private void checkCmNumber(List<GrpcAPI.SpendNote> shieldedSpends, List<GrpcAPI.ReceiveNote> shieldedReceives) throws ContractValidateException {
        if (!shieldedSpends.isEmpty() && shieldedSpends.size() > 1) {
            throw new ContractValidateException("The number of spend note must <= 1");
        }
        if (!shieldedReceives.isEmpty() && shieldedReceives.size() > 2) {
            throw new ContractValidateException("The number of receive note must <= 2");
        }
    }

    private void checkCmValue(List<GrpcAPI.SpendNote> shieldedSpends, List<GrpcAPI.ReceiveNote> shieldedReceives) throws ContractValidateException {
        for (GrpcAPI.SpendNote spendNote : shieldedSpends) {
            if (spendNote.getNote().getValue() >= 0L) continue;
            throw new ContractValidateException("The value in SpendNote must >= 0");
        }
        for (GrpcAPI.ReceiveNote receiveNote : shieldedReceives) {
            if (receiveNote.getNote().getValue() >= 0L) continue;
            throw new ContractValidateException("The value in ReceiveNote must >= 0");
        }
    }

    public GrpcAPI.ReceiveNote createReceiveNoteRandom(long value) throws ZksnarkException, BadItemException {
        SpendingKey spendingKey = SpendingKey.random();
        PaymentAddress paymentAddress = spendingKey.defaultAddress();
        GrpcAPI.Note note = GrpcAPI.Note.newBuilder().setValue(value).setPaymentAddress(KeyIo.encodePaymentAddress(paymentAddress)).setRcm(ByteString.copyFrom((byte[])Note.generateR())).setMemo(ByteString.copyFrom((byte[])new byte[512])).build();
        return GrpcAPI.ReceiveNote.newBuilder().setNote(note).build();
    }

    public TransactionCapsule createShieldedTransaction(GrpcAPI.PrivateParameters request) throws ContractValidateException, RuntimeException, ZksnarkException, BadItemException {
        this.checkFullNodeAllowShieldedTransaction();
        ZenTransactionBuilder builder = new ZenTransactionBuilder(this);
        long timeout = request.getTimeout();
        if (timeout < 0L) {
            throw new ContractValidateException("Timeout must >= 0");
        }
        builder.setTimeout(timeout);
        byte[] transparentFromAddress = request.getTransparentFromAddress().toByteArray();
        byte[] ask = request.getAsk().toByteArray();
        byte[] nsk = request.getNsk().toByteArray();
        byte[] ovk = request.getOvk().toByteArray();
        if (ArrayUtils.isEmpty((byte[])transparentFromAddress) && (ArrayUtils.isEmpty((byte[])ask) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk))) {
            throw new ContractValidateException("No input address");
        }
        long fromAmount = request.getFromAmount();
        if (!ArrayUtils.isEmpty((byte[])transparentFromAddress) && fromAmount <= 0L) {
            throw new ContractValidateException("Input amount must > 0");
        }
        List shieldedSpends = request.getShieldedSpendsList();
        if (!ArrayUtils.isEmpty((byte[])ask) && !ArrayUtils.isEmpty((byte[])nsk) && !ArrayUtils.isEmpty((byte[])ovk) && shieldedSpends.isEmpty()) {
            throw new ContractValidateException("No input note");
        }
        ArrayList<GrpcAPI.ReceiveNote> shieldedReceives = request.getShieldedReceivesList();
        byte[] transparentToAddress = request.getTransparentToAddress().toByteArray();
        if (shieldedReceives.isEmpty() && ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            throw new ContractValidateException("No output address");
        }
        long toAmount = request.getToAmount();
        if (!ArrayUtils.isEmpty((byte[])transparentToAddress) && toAmount <= 0L) {
            throw new ContractValidateException("Output amount must > 0");
        }
        this.checkCmValid(shieldedSpends, (List<GrpcAPI.ReceiveNote>)shieldedReceives);
        if (!ArrayUtils.isEmpty((byte[])transparentFromAddress)) {
            builder.setTransparentInput(transparentFromAddress, fromAmount);
        }
        if (!ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            builder.setTransparentOutput(transparentToAddress, toAmount);
        }
        if (!shieldedSpends.isEmpty() && !ArrayUtils.isEmpty((byte[])transparentToAddress) && shieldedReceives.isEmpty()) {
            shieldedReceives = new ArrayList<GrpcAPI.ReceiveNote>();
            GrpcAPI.ReceiveNote receiveNote = this.createReceiveNoteRandom(0L);
            shieldedReceives.add(receiveNote);
        }
        if (!(ArrayUtils.isEmpty((byte[])ask) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk))) {
            ExpandedSpendingKey expsk = new ExpandedSpendingKey(ask, nsk, ovk);
            for (GrpcAPI.SpendNote spendNote : shieldedSpends) {
                GrpcAPI.Note note = spendNote.getNote();
                PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
                if (paymentAddress == null) {
                    throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
                }
                Note baseNote = new Note(paymentAddress.getD(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray());
                IncrementalMerkleVoucherContainer voucherContainer = new IncrementalMerkleVoucherCapsule(spendNote.getVoucher()).toMerkleVoucherContainer();
                builder.addSpend(expsk, baseNote, spendNote.getAlpha().toByteArray(), spendNote.getVoucher().getRt().toByteArray(), voucherContainer);
            }
        }
        this.shieldedOutput((List<GrpcAPI.ReceiveNote>)shieldedReceives, builder, ovk);
        TransactionCapsule transactionCapsule = null;
        try {
            transactionCapsule = builder.build();
        }
        catch (ZksnarkException e) {
            logger.error("createShieldedTransaction except, error is " + e.toString());
            throw new ZksnarkException(e.toString());
        }
        return transactionCapsule;
    }

    public TransactionCapsule createShieldedTransactionWithoutSpendAuthSig(GrpcAPI.PrivateParametersWithoutAsk request) throws ContractValidateException, ZksnarkException, BadItemException {
        this.checkFullNodeAllowShieldedTransaction();
        ZenTransactionBuilder builder = new ZenTransactionBuilder(this);
        long timeout = request.getTimeout();
        if (timeout < 0L) {
            throw new ContractValidateException("Timeout must >= 0");
        }
        builder.setTimeout(timeout);
        byte[] transparentFromAddress = request.getTransparentFromAddress().toByteArray();
        byte[] ak = request.getAk().toByteArray();
        byte[] nsk = request.getNsk().toByteArray();
        byte[] ovk = request.getOvk().toByteArray();
        if (ArrayUtils.isEmpty((byte[])transparentFromAddress) && (ArrayUtils.isEmpty((byte[])ak) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk))) {
            throw new ContractValidateException("No input address");
        }
        long fromAmount = request.getFromAmount();
        if (!ArrayUtils.isEmpty((byte[])transparentFromAddress) && fromAmount <= 0L) {
            throw new ContractValidateException("Input amount must > 0");
        }
        List shieldedSpends = request.getShieldedSpendsList();
        if (!ArrayUtils.isEmpty((byte[])ak) && !ArrayUtils.isEmpty((byte[])nsk) && !ArrayUtils.isEmpty((byte[])ovk) && shieldedSpends.isEmpty()) {
            throw new ContractValidateException("No input note");
        }
        ArrayList<GrpcAPI.ReceiveNote> shieldedReceives = request.getShieldedReceivesList();
        byte[] transparentToAddress = request.getTransparentToAddress().toByteArray();
        if (shieldedReceives.isEmpty() && ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            throw new ContractValidateException("No output address");
        }
        long toAmount = request.getToAmount();
        if (!ArrayUtils.isEmpty((byte[])transparentToAddress) && toAmount <= 0L) {
            throw new ContractValidateException("Output amount must > 0");
        }
        this.checkCmValid(shieldedSpends, (List<GrpcAPI.ReceiveNote>)shieldedReceives);
        if (!ArrayUtils.isEmpty((byte[])transparentFromAddress)) {
            builder.setTransparentInput(transparentFromAddress, fromAmount);
        }
        if (!ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            builder.setTransparentOutput(transparentToAddress, toAmount);
        }
        if (!shieldedSpends.isEmpty() && !ArrayUtils.isEmpty((byte[])transparentToAddress) && shieldedReceives.isEmpty()) {
            shieldedReceives = new ArrayList<GrpcAPI.ReceiveNote>();
            GrpcAPI.ReceiveNote receiveNote = this.createReceiveNoteRandom(0L);
            shieldedReceives.add(receiveNote);
        }
        if (!(ArrayUtils.isEmpty((byte[])ak) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk))) {
            for (GrpcAPI.SpendNote spendNote : shieldedSpends) {
                GrpcAPI.Note note = spendNote.getNote();
                PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
                if (paymentAddress == null) {
                    throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
                }
                Note baseNote = new Note(paymentAddress.getD(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray());
                IncrementalMerkleVoucherContainer voucherContainer = new IncrementalMerkleVoucherCapsule(spendNote.getVoucher()).toMerkleVoucherContainer();
                builder.addSpend(ak, nsk, ovk, baseNote, spendNote.getAlpha().toByteArray(), spendNote.getVoucher().getRt().toByteArray(), voucherContainer);
            }
        }
        this.shieldedOutput((List<GrpcAPI.ReceiveNote>)shieldedReceives, builder, ovk);
        TransactionCapsule transactionCapsule = null;
        try {
            transactionCapsule = builder.buildWithoutAsk();
        }
        catch (ZksnarkException e) {
            logger.error("createShieldedTransaction exception, error is " + e.toString());
            throw new ZksnarkException(e.toString());
        }
        return transactionCapsule;
    }

    private void shieldedOutput(List<GrpcAPI.ReceiveNote> shieldedReceives, ZenTransactionBuilder builder, byte[] ovk) throws ZksnarkException {
        for (GrpcAPI.ReceiveNote receiveNote : shieldedReceives) {
            PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(receiveNote.getNote().getPaymentAddress());
            if (paymentAddress == null) {
                throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
            }
            builder.addOutput(ovk, paymentAddress.getD(), paymentAddress.getPkD(), receiveNote.getNote().getValue(), receiveNote.getNote().getRcm().toByteArray(), receiveNote.getNote().getMemo().toByteArray());
        }
    }

    public GrpcAPI.ShieldedAddressInfo getNewShieldedAddress() throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.ShieldedAddressInfo.Builder addressInfo = GrpcAPI.ShieldedAddressInfo.newBuilder();
        GrpcAPI.BytesMessage sk = this.getSpendingKey();
        GrpcAPI.DiversifierMessage d = this.getDiversifier();
        GrpcAPI.ExpandedSpendingKeyMessage expandedSpendingKeyMessage = this.getExpandedSpendingKey(sk.getValue());
        GrpcAPI.BytesMessage ak = this.getAkFromAsk(expandedSpendingKeyMessage.getAsk());
        GrpcAPI.BytesMessage nk = this.getNkFromNsk(expandedSpendingKeyMessage.getNsk());
        GrpcAPI.IncomingViewingKeyMessage ivk = this.getIncomingViewingKey(ak.getValue().toByteArray(), nk.getValue().toByteArray());
        GrpcAPI.PaymentAddressMessage addressMessage = this.getPaymentAddress(new IncomingViewingKey(ivk.getIvk().toByteArray()), new DiversifierT(d.getD().toByteArray()));
        addressInfo.setSk(sk.getValue());
        addressInfo.setAsk(expandedSpendingKeyMessage.getAsk());
        addressInfo.setNsk(expandedSpendingKeyMessage.getNsk());
        addressInfo.setOvk(expandedSpendingKeyMessage.getOvk());
        addressInfo.setAk(ak.getValue());
        addressInfo.setNk(nk.getValue());
        addressInfo.setIvk(ivk.getIvk());
        addressInfo.setD(d.getD());
        addressInfo.setPkD(addressMessage.getPkD());
        addressInfo.setPaymentAddress(addressMessage.getPaymentAddress());
        return addressInfo.build();
    }

    public GrpcAPI.BytesMessage getSpendingKey() throws ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        byte[] sk = SpendingKey.random().getValue();
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])sk)).build();
    }

    public GrpcAPI.ExpandedSpendingKeyMessage getExpandedSpendingKey(ByteString spendingKey) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        if (Objects.isNull(spendingKey)) {
            throw new BadItemException("spendingKey is null");
        }
        if (ByteArray.toHexString((byte[])spendingKey.toByteArray()).length() != 64) {
            throw new BadItemException("the length of spendingKey's hexString should be 64");
        }
        ExpandedSpendingKey expandedSpendingKey = null;
        SpendingKey sk = new SpendingKey(spendingKey.toByteArray());
        expandedSpendingKey = sk.expandedSpendingKey();
        GrpcAPI.ExpandedSpendingKeyMessage.Builder responseBuild = GrpcAPI.ExpandedSpendingKeyMessage.newBuilder();
        responseBuild.setAsk(ByteString.copyFrom((byte[])expandedSpendingKey.getAsk())).setNsk(ByteString.copyFrom((byte[])expandedSpendingKey.getNsk())).setOvk(ByteString.copyFrom((byte[])expandedSpendingKey.getOvk()));
        return responseBuild.build();
    }

    public GrpcAPI.BytesMessage getAkFromAsk(ByteString ask) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        if (Objects.isNull(ask)) {
            throw new BadItemException("ask is null");
        }
        if (ByteArray.toHexString((byte[])ask.toByteArray()).length() != 64) {
            throw new BadItemException("the length of ask's hexString should be 64");
        }
        byte[] ak = ExpandedSpendingKey.getAkFromAsk(ask.toByteArray());
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])ak)).build();
    }

    public GrpcAPI.BytesMessage getNkFromNsk(ByteString nsk) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        if (Objects.isNull(nsk)) {
            throw new BadItemException("nsk is null");
        }
        if (ByteArray.toHexString((byte[])nsk.toByteArray()).length() != 64) {
            throw new BadItemException("the length of nsk's hexString should be 64");
        }
        byte[] nk = ExpandedSpendingKey.getNkFromNsk(nsk.toByteArray());
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])nk)).build();
    }

    public GrpcAPI.IncomingViewingKeyMessage getIncomingViewingKey(byte[] ak, byte[] nk) throws ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        byte[] ivk = new byte[32];
        JLibrustzcash.librustzcashCrhIvk((LibrustzcashParam.CrhIvkParams)new LibrustzcashParam.CrhIvkParams(ak, nk, ivk));
        return GrpcAPI.IncomingViewingKeyMessage.newBuilder().setIvk(ByteString.copyFrom((byte[])ivk)).build();
    }

    public GrpcAPI.DiversifierMessage getDiversifier() throws ZksnarkException {
        byte[] d;
        this.checkFullNodeAllowShieldedTransaction();
        while (!JLibrustzcash.librustzcashCheckDiversifier((byte[])(d = org.tron.keystore.Wallet.generateRandomBytes(11)))) {
        }
        return GrpcAPI.DiversifierMessage.newBuilder().setD(ByteString.copyFrom((byte[])d)).build();
    }

    public GrpcAPI.BytesMessage getRcm() throws ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        byte[] rcm = Note.generateR();
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])rcm)).build();
    }

    public GrpcAPI.PaymentAddressMessage getPaymentAddress(IncomingViewingKey ivk, DiversifierT d) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        if (!JLibrustzcash.librustzcashCheckDiversifier((byte[])d.getData())) {
            throw new BadItemException("d is not valid");
        }
        GrpcAPI.PaymentAddressMessage spa = null;
        Optional<PaymentAddress> op = ivk.address(d);
        if (op.isPresent()) {
            GrpcAPI.DiversifierMessage ds = GrpcAPI.DiversifierMessage.newBuilder().setD(ByteString.copyFrom((byte[])d.getData())).build();
            PaymentAddress paymentAddress = op.get();
            spa = GrpcAPI.PaymentAddressMessage.newBuilder().setD(ds).setPkD(ByteString.copyFrom((byte[])paymentAddress.getPkD())).setPaymentAddress(KeyIo.encodePaymentAddress(paymentAddress)).build();
        }
        return spa;
    }

    public GrpcAPI.SpendResult isSpend(GrpcAPI.NoteParameters noteParameters) throws ZksnarkException, InvalidProtocolBufferException, BadItemException, ItemNotFoundException {
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.Note note = noteParameters.getNote();
        byte[] ak = noteParameters.getAk().toByteArray();
        byte[] nk = noteParameters.getNk().toByteArray();
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
        if (paymentAddress == null) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        ShieldContract.OutputPoint outputPoint = ShieldContract.OutputPoint.newBuilder().setHash(noteParameters.getTxid()).setIndex(noteParameters.getIndex()).build();
        ShieldContract.OutputPointInfo outputPointInfo = ShieldContract.OutputPointInfo.newBuilder().addOutPoints(outputPoint).setBlockNum(1).build();
        ShieldContract.IncrementalMerkleVoucherInfo incrementalMerkleVoucherInfo = this.getMerkleTreeVoucherInfo(outputPointInfo);
        if (incrementalMerkleVoucherInfo.getVouchersCount() == 0) {
            GrpcAPI.SpendResult result = GrpcAPI.SpendResult.newBuilder().setResult(false).setMessage("The input note does not exist").build();
            return result;
        }
        IncrementalMerkleVoucherContainer voucherContainer = new IncrementalMerkleVoucherCapsule(incrementalMerkleVoucherInfo.getVouchers(0)).toMerkleVoucherContainer();
        Note baseNote = new Note(paymentAddress.getD(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray());
        byte[] nf = baseNote.nullifier(ak, nk, voucherContainer.position());
        GrpcAPI.SpendResult result = this.chainBaseManager.getNullifierStore().has(nf) ? GrpcAPI.SpendResult.newBuilder().setResult(true).setMessage("Input note has been spent").build() : GrpcAPI.SpendResult.newBuilder().setResult(false).setMessage("The input note is not spent or does not exist").build();
        return result;
    }

    public GrpcAPI.BytesMessage createSpendAuthSig(GrpcAPI.SpendAuthSigParameters spendAuthSigParameters) throws ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        byte[] result = new byte[64];
        LibrustzcashParam.SpendSigParams spendSigParams = new LibrustzcashParam.SpendSigParams(spendAuthSigParameters.getAsk().toByteArray(), spendAuthSigParameters.getAlpha().toByteArray(), spendAuthSigParameters.getTxHash().toByteArray(), result);
        JLibrustzcash.librustzcashSaplingSpendSig((LibrustzcashParam.SpendSigParams)spendSigParams);
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])result)).build();
    }

    public GrpcAPI.BytesMessage createShieldNullifier(GrpcAPI.NfParameters nfParameters) throws ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        byte[] ak = nfParameters.getAk().toByteArray();
        byte[] nk = nfParameters.getNk().toByteArray();
        byte[] result = new byte[32];
        GrpcAPI.Note note = nfParameters.getNote();
        IncrementalMerkleVoucherCapsule incrementalMerkleVoucherCapsule = new IncrementalMerkleVoucherCapsule(nfParameters.getVoucher());
        IncrementalMerkleVoucherContainer incrementalMerkleVoucherContainer = new IncrementalMerkleVoucherContainer(incrementalMerkleVoucherCapsule);
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
        if (paymentAddress == null) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        LibrustzcashParam.ComputeNfParams computeNfParams = new LibrustzcashParam.ComputeNfParams(paymentAddress.getD().getData(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray(), ak, nk, incrementalMerkleVoucherContainer.position(), result);
        if (!JLibrustzcash.librustzcashComputeNf((LibrustzcashParam.ComputeNfParams)computeNfParams)) {
            return null;
        }
        return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])result)).build();
    }

    public GrpcAPI.BytesMessage getShieldTransactionHash(Protocol.Transaction transaction) throws ContractValidateException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        List contract = transaction.getRawData().getContractList();
        if (contract == null || contract.isEmpty()) {
            throw new ContractValidateException("Contract is null");
        }
        Protocol.Transaction.Contract.ContractType contractType = ((Protocol.Transaction.Contract)contract.get(0)).getType();
        if (contractType != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) {
            throw new ContractValidateException("Not a shielded transaction");
        }
        TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
        byte[] transactionHash = TransactionCapsule.getShieldTransactionHashIgnoreTypeException((Protocol.Transaction)transactionCapsule.getInstance());
        if (transactionHash != null) {
            return GrpcAPI.BytesMessage.newBuilder().setValue(ByteString.copyFrom((byte[])transactionHash)).build();
        }
        return GrpcAPI.BytesMessage.newBuilder().build();
    }

    public GrpcAPI.TransactionInfoList getTransactionInfoByBlockNum(long blockNum) {
        GrpcAPI.TransactionInfoList.Builder transactionInfoList = GrpcAPI.TransactionInfoList.newBuilder();
        try {
            TransactionRetCapsule result = this.dbManager.getTransactionRetStore().getTransactionInfoByBlockNum(ByteArray.fromLong((long)blockNum));
            if (!Objects.isNull(result) && !Objects.isNull(result.getInstance())) {
                result.getInstance().getTransactioninfoList().forEach(transactionInfo -> transactionInfoList.addTransactionInfo(transactionInfo));
            } else {
                Protocol.Block block = this.chainBaseManager.getBlockByNum(blockNum).getInstance();
                if (block != null) {
                    List listTransaction = block.getTransactionsList();
                    for (Protocol.Transaction transaction : listTransaction) {
                        TransactionInfoCapsule transactionInfoCapsule = this.dbManager.getTransactionHistoryStore().get(Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray()));
                        if (transactionInfoCapsule == null) continue;
                        transactionInfoList.addTransactionInfo(transactionInfoCapsule.getInstance());
                    }
                }
            }
        }
        catch (BadItemException | ItemNotFoundException e) {
            logger.warn(e.getMessage());
        }
        return transactionInfoList.build();
    }

    public GrpcAPI.NodeList listNodes() {
        GrpcAPI.NodeList.Builder nodeListBuilder = GrpcAPI.NodeList.newBuilder();
        if (!Args.getInstance().p2pDisable) {
            TronNetService.getP2pService().getConnectableNodes().forEach(node -> nodeListBuilder.addNodes(GrpcAPI.Node.newBuilder().setAddress(GrpcAPI.Address.newBuilder().setHost(ByteString.copyFrom((byte[])ByteArray.fromString((String)node.getPreferInetSocketAddress().getAddress().getHostAddress()))).setPort(node.getPort()))));
        }
        return nodeListBuilder.build();
    }

    public Protocol.MarketOrder getMarketOrderById(ByteString orderId) {
        if (orderId == null || orderId.isEmpty()) {
            return null;
        }
        MarketOrderStore marketOrderStore = this.dbManager.getChainBaseManager().getMarketOrderStore();
        try {
            return marketOrderStore.get(orderId.toByteArray()).getInstance();
        }
        catch (ItemNotFoundException e) {
            logger.warn("orderId = {} not found", (Object)orderId);
            throw new IllegalStateException("order not found in store");
        }
    }

    public Protocol.MarketOrderList getMarketOrderByAccount(ByteString accountAddress) {
        MarketAccountOrderCapsule marketAccountOrderCapsule;
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        try {
            marketAccountOrderCapsule = this.dbManager.getChainBaseManager().getMarketAccountStore().get(accountAddress.toByteArray());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        MarketOrderStore marketOrderStore = this.dbManager.getChainBaseManager().getMarketOrderStore();
        Protocol.MarketOrderList.Builder marketOrderListBuilder = Protocol.MarketOrderList.newBuilder();
        List orderIdList = marketAccountOrderCapsule.getOrdersList();
        orderIdList.forEach(orderId -> {
            try {
                MarketOrderCapsule orderCapsule = marketOrderStore.get(orderId.toByteArray());
                orderCapsule.setPrev(new byte[0]);
                orderCapsule.setNext(new byte[0]);
                marketOrderListBuilder.addOrders(orderCapsule.getInstance());
            }
            catch (ItemNotFoundException e) {
                logger.warn("orderId = {} not found", orderId);
                throw new IllegalStateException("order not found in store");
            }
        });
        return marketOrderListBuilder.build();
    }

    public Protocol.MarketPriceList getMarketPriceByPair(byte[] sellTokenId, byte[] buyTokenId) throws BadItemException {
        MarketUtils.checkPairValid((byte[])sellTokenId, (byte[])buyTokenId);
        MarketPairToPriceStore marketPairToPriceStore = this.dbManager.getChainBaseManager().getMarketPairToPriceStore();
        MarketPairPriceToOrderStore marketPairPriceToOrderStore = this.dbManager.getChainBaseManager().getMarketPairPriceToOrderStore();
        Protocol.MarketPriceList.Builder marketPriceListBuilder = Protocol.MarketPriceList.newBuilder().setSellTokenId(ByteString.copyFrom((byte[])sellTokenId)).setBuyTokenId(ByteString.copyFrom((byte[])buyTokenId));
        long count = marketPairToPriceStore.getPriceNum(sellTokenId, buyTokenId);
        if (count == 0L) {
            return marketPriceListBuilder.build();
        }
        long limit = count < 1000L ? count : 1000L;
        List priceKeysList = marketPairPriceToOrderStore.getPriceKeysList(sellTokenId, buyTokenId, limit);
        priceKeysList.forEach(priceKey -> {
            Protocol.MarketPrice marketPrice = MarketUtils.decodeKeyToMarketPrice((byte[])priceKey);
            marketPriceListBuilder.addPrices(marketPrice);
        });
        return marketPriceListBuilder.build();
    }

    public Protocol.MarketOrderPairList getMarketPairList() {
        Protocol.MarketOrderPairList.Builder builder = Protocol.MarketOrderPairList.newBuilder();
        MarketPairToPriceStore marketPairToPriceStore = this.dbManager.getChainBaseManager().getMarketPairToPriceStore();
        Iterator iterator = marketPairToPriceStore.iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            byte[] pairKey = (byte[])next.getKey();
            builder.addOrderPair(MarketUtils.decodeKeyToMarketPairHuman((byte[])pairKey));
            if (++count <= 1000L) continue;
            break;
        }
        return builder.build();
    }

    public Protocol.MarketOrderList getMarketOrderListByPair(byte[] sellTokenId, byte[] buyTokenId) throws ItemNotFoundException, BadItemException {
        MarketUtils.checkPairValid((byte[])sellTokenId, (byte[])buyTokenId);
        Protocol.MarketOrderList.Builder builder = Protocol.MarketOrderList.newBuilder();
        MarketPairToPriceStore marketPairToPriceStore = this.dbManager.getChainBaseManager().getMarketPairToPriceStore();
        MarketPairPriceToOrderStore marketPairPriceToOrderStore = this.dbManager.getChainBaseManager().getMarketPairPriceToOrderStore();
        MarketPairPriceToOrderStore pairPriceToOrderStore = this.dbManager.getChainBaseManager().getMarketPairPriceToOrderStore();
        MarketOrderStore orderStore = this.dbManager.getChainBaseManager().getMarketOrderStore();
        long countForPrice = marketPairToPriceStore.getPriceNum(sellTokenId, buyTokenId);
        if (countForPrice == 0L) {
            return builder.build();
        }
        long limitForPrice = countForPrice < 1000L ? countForPrice : 1000L;
        List priceKeysList = marketPairPriceToOrderStore.getPriceKeysList(sellTokenId, buyTokenId, limitForPrice);
        long countForOrder = 0L;
        for (byte[] pairPriceKey : priceKeysList) {
            MarketOrderIdListCapsule orderIdListCapsule = (MarketOrderIdListCapsule)pairPriceToOrderStore.getUnchecked(pairPriceKey);
            if (1000L - countForOrder <= 0L) break;
            if (orderIdListCapsule == null) continue;
            List orderList = orderIdListCapsule.getAllOrder(orderStore, 1000L - countForOrder);
            orderList.forEach(orderCapsule -> {
                orderCapsule.setPrev(new byte[0]);
                orderCapsule.setNext(new byte[0]);
                builder.addOrders(orderCapsule.getInstance());
            });
            countForOrder += (long)orderList.size();
        }
        return builder.build();
    }

    public Protocol.Transaction deployContract(TransactionCapsule trxCap) {
        return trxCap.getInstance();
    }

    public Protocol.Transaction triggerContract(SmartContractOuterClass.TriggerSmartContract triggerSmartContract, TransactionCapsule trxCap, GrpcAPI.TransactionExtention.Builder builder, GrpcAPI.Return.Builder retBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        byte[] selector;
        byte[] contractAddress = triggerSmartContract.getContractAddress().toByteArray();
        ContractCapsule contractCapsule = this.chainBaseManager.getContractStore().get(contractAddress);
        if (contractCapsule == null) {
            throw new ContractValidateException("No contract or not a valid smart contract");
        }
        AbiCapsule abiCapsule = this.chainBaseManager.getAbiStore().get(contractAddress);
        SmartContractOuterClass.SmartContract.ABI abi = abiCapsule == null || abiCapsule.getData() == null ? SmartContractOuterClass.SmartContract.ABI.getDefaultInstance() : abiCapsule.getInstance();
        if (WalletUtil.isConstant((SmartContractOuterClass.SmartContract.ABI)abi, (byte[])(selector = WalletUtil.getSelector((byte[])triggerSmartContract.getData().toByteArray())))) {
            return this.callConstantContract(trxCap, builder, retBuilder, false);
        }
        return trxCap.getInstance();
    }

    public Protocol.Transaction estimateEnergy(SmartContractOuterClass.TriggerSmartContract triggerSmartContract, TransactionCapsule txCap, GrpcAPI.TransactionExtention.Builder txExtBuilder, GrpcAPI.Return.Builder txRetBuilder, GrpcAPI.EstimateEnergyMessage.Builder estimateBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        Protocol.Transaction transaction;
        if (!Args.getInstance().estimateEnergy) {
            throw new ContractValidateException("this node does not support estimate energy");
        }
        if (!Args.getInstance().supportConstant) {
            throw new ContractValidateException("this node does not support constant, so estimate energy cannot work");
        }
        int retry = Args.getInstance().estimateEnergyMaxRetry;
        DynamicPropertiesStore dps = this.chainBaseManager.getDynamicPropertiesStore();
        long high = dps.getMaxFeeLimit();
        while (true) {
            try {
                transaction = this.cleanContextAndTriggerConstantContract(triggerSmartContract, txCap, txExtBuilder, txRetBuilder, high);
            }
            catch (Program.OutOfTimeException e) {
                if (--retry >= 0) continue;
                throw e;
            }
            break;
        }
        if (transaction.getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.FAILED)) {
            txRetBuilder.setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR);
            estimateBuilder.setResult(txRetBuilder);
            return transaction;
        }
        long low = dps.getEnergyFee() * txExtBuilder.getEnergyUsed();
        long twoTimes = low * 2L;
        if (twoTimes < high) {
            while (true) {
                try {
                    transaction = this.cleanContextAndTriggerConstantContract(triggerSmartContract, txCap, txExtBuilder, txRetBuilder, twoTimes);
                    if (transaction.getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.FAILED)) {
                        low = twoTimes;
                        break;
                    }
                    high = twoTimes;
                }
                catch (Program.OutOfTimeException e) {
                    if (--retry >= 0) continue;
                    throw e;
                }
                break;
            }
        }
        while (low + 1000000L < high) {
            long mid = (low + high) / 2L;
            while (true) {
                try {
                    transaction = this.cleanContextAndTriggerConstantContract(triggerSmartContract, txCap, txExtBuilder, txRetBuilder, mid);
                }
                catch (Program.OutOfTimeException e) {
                    if (--retry >= 0) continue;
                    throw e;
                }
                break;
            }
            if (transaction.getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.FAILED)) {
                low = mid;
                continue;
            }
            high = mid;
        }
        transaction = this.cleanContextAndTriggerConstantContract(triggerSmartContract, txCap, txExtBuilder, txRetBuilder, high);
        estimateBuilder.setResult(txRetBuilder);
        if (transaction.getRet(0).getRet().equals((Object)Protocol.Transaction.Result.code.SUCESS)) {
            txRetBuilder.setResult(true);
            txRetBuilder.setCode(GrpcAPI.Return.response_code.SUCCESS);
            estimateBuilder.setEnergyRequired((long)Math.ceil((double)high / (double)dps.getEnergyFee()));
        }
        return transaction;
    }

    private Protocol.Transaction cleanContextAndTriggerConstantContract(SmartContractOuterClass.TriggerSmartContract triggerSmartContract, TransactionCapsule txCap, GrpcAPI.TransactionExtention.Builder txExtBuilder, GrpcAPI.Return.Builder txRetBuilder, long feeLimit) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        txCap.setFeeLimit(feeLimit);
        txCap.resetResult();
        txExtBuilder.clear();
        txRetBuilder.clear();
        Protocol.Transaction transaction = this.triggerConstantContract(triggerSmartContract, txCap, txExtBuilder, txRetBuilder, true);
        return transaction;
    }

    public Protocol.Transaction triggerConstantContract(SmartContractOuterClass.TriggerSmartContract triggerSmartContract, TransactionCapsule trxCap, GrpcAPI.TransactionExtention.Builder builder, GrpcAPI.Return.Builder retBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        return this.triggerConstantContract(triggerSmartContract, trxCap, builder, retBuilder, false);
    }

    public Protocol.Transaction triggerConstantContract(SmartContractOuterClass.TriggerSmartContract triggerSmartContract, TransactionCapsule trxCap, GrpcAPI.TransactionExtention.Builder builder, GrpcAPI.Return.Builder retBuilder, boolean isEstimating) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        if (triggerSmartContract.getContractAddress().isEmpty()) {
            SmartContractOuterClass.CreateSmartContract.Builder deployBuilder = SmartContractOuterClass.CreateSmartContract.newBuilder();
            deployBuilder.setOwnerAddress(triggerSmartContract.getOwnerAddress());
            deployBuilder.setNewContract(SmartContractOuterClass.SmartContract.newBuilder().setOriginAddress(triggerSmartContract.getOwnerAddress()).setBytecode(triggerSmartContract.getData()).setCallValue(triggerSmartContract.getCallValue()).setConsumeUserResourcePercent(100L).setOriginEnergyLimit(1L).build());
            deployBuilder.setCallTokenValue(triggerSmartContract.getCallTokenValue());
            deployBuilder.setTokenId(triggerSmartContract.getTokenId());
            long feeLimit = trxCap.getFeeLimit();
            trxCap = this.createTransactionCapsule((Message)deployBuilder.build(), Protocol.Transaction.Contract.ContractType.CreateSmartContract);
            trxCap.setFeeLimit(feeLimit);
        } else {
            byte[] contractAddress;
            ContractStore contractStore = this.chainBaseManager.getContractStore();
            if (contractStore.get(contractAddress = triggerSmartContract.getContractAddress().toByteArray()) == null) {
                throw new ContractValidateException("Smart contract is not exist.");
            }
        }
        return this.callConstantContract(trxCap, builder, retBuilder, isEstimating);
    }

    public Protocol.Transaction callConstantContract(TransactionCapsule trxCap, GrpcAPI.TransactionExtention.Builder builder, GrpcAPI.Return.Builder retBuilder, boolean isEstimating) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        if (!Args.getInstance().isSupportConstant()) {
            throw new ContractValidateException("this node does not support constant");
        }
        List blockCapsuleList = this.chainBaseManager.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isEmpty((Collection)blockCapsuleList)) {
            throw new HeaderNotFound("latest block not found");
        }
        Protocol.Block headBlock = ((BlockCapsule)blockCapsuleList.get(0)).getInstance();
        BlockCapsule headBlockCapsule = new BlockCapsule(headBlock);
        TransactionContext context = new TransactionContext(headBlockCapsule, trxCap, StoreFactory.getInstance(), true, false);
        VMActuator vmActuator = new VMActuator(true);
        vmActuator.validate((Object)context);
        vmActuator.execute((Object)context);
        ProgramResult result = context.getProgramResult();
        if (!isEstimating && result.getException() != null || result.getException() instanceof Program.OutOfTimeException) {
            RuntimeException e = result.getException();
            logger.warn("Constant call failed for reason: {}", (Object)e.getMessage());
            throw e;
        }
        TransactionResultCapsule ret = new TransactionResultCapsule();
        builder.setEnergyUsed(result.getEnergyUsed());
        builder.setEnergyPenalty(result.getEnergyPenaltyTotal());
        builder.addConstantResult(ByteString.copyFrom((byte[])result.getHReturn()));
        result.getLogInfoList().forEach(logInfo -> builder.addLogs(LogInfo.buildLog((LogInfo)logInfo)));
        result.getInternalTransactions().forEach(it -> builder.addInternalTransactions(TransactionUtil.buildInternalTransaction((InternalTransaction)it)));
        ret.setStatus(0L, Protocol.Transaction.Result.code.SUCESS);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{result.getRuntimeError()})) {
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            retBuilder.setMessage(ByteString.copyFromUtf8((String)result.getRuntimeError())).build();
        }
        if (result.isRevert()) {
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            retBuilder.setMessage(ByteString.copyFromUtf8((String)"REVERT opcode executed")).build();
        }
        trxCap.setResult(ret);
        return trxCap.getInstance();
    }

    public SmartContractOuterClass.SmartContract getContract(GrpcAPI.BytesMessage bytesMessage) {
        byte[] address = bytesMessage.getValue().toByteArray();
        AccountCapsule accountCapsule = this.chainBaseManager.getAccountStore().get(address);
        if (accountCapsule == null) {
            logger.warn("Get contract failed, the account {} does not exist or the account does not have a code hash!", (Object)StringUtil.encode58Check((byte[])address));
            return null;
        }
        ContractCapsule contractCapsule = this.chainBaseManager.getContractStore().get(address);
        if (Objects.nonNull(contractCapsule)) {
            AbiCapsule abiCapsule = this.chainBaseManager.getAbiStore().get(address);
            if (abiCapsule != null && abiCapsule.getInstance() != null) {
                contractCapsule = new ContractCapsule(contractCapsule.getInstance().toBuilder().setAbi(abiCapsule.getInstance()).build());
            }
            return contractCapsule.getInstance();
        }
        return null;
    }

    public SmartContractOuterClass.SmartContractDataWrapper getContractInfo(GrpcAPI.BytesMessage bytesMessage) {
        byte[] address = bytesMessage.getValue().toByteArray();
        AccountCapsule accountCapsule = this.chainBaseManager.getAccountStore().get(address);
        if (accountCapsule == null) {
            logger.warn("Get contract failed, the account {} does not exist or the account does not have a code hash!", (Object)StringUtil.encode58Check((byte[])address));
            return null;
        }
        ContractCapsule contractCapsule = this.chainBaseManager.getContractStore().get(address);
        if (Objects.nonNull(contractCapsule)) {
            CodeCapsule codeCapsule;
            AbiCapsule abiCapsule = this.chainBaseManager.getAbiStore().get(address);
            if (abiCapsule != null && abiCapsule.getInstance() != null) {
                contractCapsule = new ContractCapsule(contractCapsule.getInstance().toBuilder().setAbi(abiCapsule.getInstance()).build());
            }
            if (Objects.nonNull(codeCapsule = this.chainBaseManager.getCodeStore().get(address)) && Objects.nonNull(codeCapsule.getData())) {
                contractCapsule.setRuntimecode(codeCapsule.getData());
            } else {
                contractCapsule.setRuntimecode(new byte[0]);
            }
            SmartContractOuterClass.SmartContractDataWrapper wrapper = contractCapsule.generateWrapper();
            ContractStateCapsule contractStateCapsule = this.chainBaseManager.getContractStateStore().get(address);
            if (Objects.nonNull(contractStateCapsule)) {
                contractStateCapsule.catchUpToCycle(this.chainBaseManager.getDynamicPropertiesStore());
            } else {
                contractStateCapsule = new ContractStateCapsule(this.chainBaseManager.getDynamicPropertiesStore().getCurrentCycleNumber());
            }
            return wrapper.toBuilder().setContractState(contractStateCapsule.getInstance()).build();
        }
        return null;
    }

    public GrpcAPI.ProposalList getPaginatedProposalList(long offset, long limit) {
        if (limit < 0L || offset < 0L) {
            return null;
        }
        long latestProposalNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestProposalNum();
        if (latestProposalNum <= offset) {
            return null;
        }
        limit = limit > 1000L ? 1000L : limit;
        long end = offset + limit;
        end = end > latestProposalNum ? latestProposalNum : end;
        GrpcAPI.ProposalList.Builder builder = GrpcAPI.ProposalList.newBuilder();
        ImmutableList rangeList = ContiguousSet.create((Range)Range.openClosed((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(end)), (DiscreteDomain)DiscreteDomain.longs()).asList();
        rangeList.stream().map(ProposalCapsule::calculateDbKey).map(key -> {
            try {
                return this.chainBaseManager.getProposalStore().get(key);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(proposalCapsule -> builder.addProposals(proposalCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.ExchangeList getPaginatedExchangeList(long offset, long limit) {
        if (limit < 0L || offset < 0L) {
            return null;
        }
        long latestExchangeNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestExchangeNum();
        if (latestExchangeNum <= offset) {
            return null;
        }
        limit = limit > 1000L ? 1000L : limit;
        long end = offset + limit;
        end = end > latestExchangeNum ? latestExchangeNum : end;
        GrpcAPI.ExchangeList.Builder builder = GrpcAPI.ExchangeList.newBuilder();
        ImmutableList rangeList = ContiguousSet.create((Range)Range.openClosed((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(end)), (DiscreteDomain)DiscreteDomain.longs()).asList();
        rangeList.stream().map(ExchangeCapsule::calculateDbKey).map(key -> {
            try {
                return Commons.getExchangeStoreFinal((DynamicPropertiesStore)this.chainBaseManager.getDynamicPropertiesStore(), (ExchangeStore)this.chainBaseManager.getExchangeStore(), (ExchangeV2Store)this.chainBaseManager.getExchangeV2Store()).get(key);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(exchangeCapsule -> builder.addExchanges(exchangeCapsule.getInstance()));
        return builder.build();
    }

    public byte[] stripRightZero(byte[] memo) {
        int index;
        for (index = memo.length; index > 0 && memo[index - 1] == 0; --index) {
        }
        byte[] memoStrip = new byte[index];
        System.arraycopy(memo, 0, memoStrip, 0, index);
        return memoStrip;
    }

    private GrpcAPI.DecryptNotes queryNoteByIvk(long startNum, long endNum, byte[] ivk) throws BadItemException, ZksnarkException {
        GrpcAPI.DecryptNotes.Builder builder = GrpcAPI.DecryptNotes.newBuilder();
        if (startNum < 0L || endNum <= startNum || endNum - startNum > 1000L) {
            throw new BadItemException(SHIELDED_TRANSACTION_SCAN_RANGE);
        }
        GrpcAPI.BlockList blockList = this.getBlocksByLimitNext(startNum, endNum - startNum);
        for (Protocol.Block block : blockList.getBlockList()) {
            for (Protocol.Transaction transaction : block.getTransactionsList()) {
                ShieldContract.ShieldedTransferContract stContract;
                Protocol.Transaction.Contract c;
                TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
                byte[] txid = transactionCapsule.getTransactionId().getBytes();
                List contracts = transaction.getRawData().getContractList();
                if (contracts.isEmpty() || (c = (Protocol.Transaction.Contract)contracts.get(0)).getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
                try {
                    stContract = (ShieldContract.ShieldedTransferContract)c.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new ZksnarkException("unpack ShieldedTransferContract failed.");
                }
                for (int index = 0; index < stContract.getReceiveDescriptionList().size(); ++index) {
                    ShieldContract.ReceiveDescription r = stContract.getReceiveDescription(index);
                    Optional<Note> notePlaintext = Note.decrypt(r.getCEnc().toByteArray(), ivk, r.getEpk().toByteArray(), r.getNoteCommitment().toByteArray());
                    if (!notePlaintext.isPresent()) continue;
                    Note noteText = notePlaintext.get();
                    byte[] pkD = new byte[32];
                    if (!JLibrustzcash.librustzcashIvkToPkd((LibrustzcashParam.IvkToPkdParams)new LibrustzcashParam.IvkToPkdParams(ivk, noteText.getD().getData(), pkD))) continue;
                    String paymentAddress = KeyIo.encodePaymentAddress(new PaymentAddress(noteText.getD(), pkD));
                    GrpcAPI.Note note = GrpcAPI.Note.newBuilder().setPaymentAddress(paymentAddress).setValue(noteText.getValue()).setRcm(ByteString.copyFrom((byte[])noteText.getRcm())).setMemo(ByteString.copyFrom((byte[])this.stripRightZero(noteText.getMemo()))).build();
                    GrpcAPI.DecryptNotes.NoteTx noteTx = GrpcAPI.DecryptNotes.NoteTx.newBuilder().setNote(note).setTxid(ByteString.copyFrom((byte[])txid)).setIndex(index).build();
                    builder.addNoteTxs(noteTx);
                }
            }
        }
        return builder.build();
    }

    public GrpcAPI.DecryptNotes scanNoteByIvk(long startNum, long endNum, byte[] ivk) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        return this.queryNoteByIvk(startNum, endNum, ivk);
    }

    public GrpcAPI.DecryptNotesMarked scanAndMarkNoteByIvk(long startNum, long endNum, byte[] ivk, byte[] ak, byte[] nk) throws BadItemException, ZksnarkException, InvalidProtocolBufferException, ItemNotFoundException {
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.DecryptNotes srcNotes = this.queryNoteByIvk(startNum, endNum, ivk);
        GrpcAPI.DecryptNotesMarked.Builder builder = GrpcAPI.DecryptNotesMarked.newBuilder();
        for (GrpcAPI.DecryptNotes.NoteTx noteTx : srcNotes.getNoteTxsList()) {
            GrpcAPI.NoteParameters noteParameters = GrpcAPI.NoteParameters.newBuilder().setNote(noteTx.getNote()).setAk(ByteString.copyFrom((byte[])ak)).setNk(ByteString.copyFrom((byte[])nk)).setTxid(noteTx.getTxid()).setIndex(noteTx.getIndex()).build();
            GrpcAPI.SpendResult spendResult = this.isSpend(noteParameters);
            GrpcAPI.DecryptNotesMarked.NoteTx.Builder markedNoteTx = GrpcAPI.DecryptNotesMarked.NoteTx.newBuilder();
            markedNoteTx.setNote(noteTx.getNote());
            markedNoteTx.setTxid(noteTx.getTxid());
            markedNoteTx.setIndex(noteTx.getIndex());
            markedNoteTx.setIsSpend(spendResult.getResult());
            builder.addNoteTxs(markedNoteTx);
        }
        return builder.build();
    }

    public GrpcAPI.DecryptNotes scanNoteByOvk(long startNum, long endNum, byte[] ovk) throws BadItemException, ZksnarkException {
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.DecryptNotes.Builder builder = GrpcAPI.DecryptNotes.newBuilder();
        if (startNum < 0L || endNum <= startNum || endNum - startNum > 1000L) {
            throw new BadItemException(SHIELDED_TRANSACTION_SCAN_RANGE);
        }
        GrpcAPI.BlockList blockList = this.getBlocksByLimitNext(startNum, endNum - startNum);
        for (Protocol.Block block : blockList.getBlockList()) {
            for (Protocol.Transaction transaction : block.getTransactionsList()) {
                ShieldContract.ShieldedTransferContract stContract;
                Protocol.Transaction.Contract c;
                TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
                byte[] txid = transactionCapsule.getTransactionId().getBytes();
                List contracts = transaction.getRawData().getContractList();
                if (contracts.isEmpty() || (c = (Protocol.Transaction.Contract)contracts.get(0)).getType() != Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
                try {
                    stContract = (ShieldContract.ShieldedTransferContract)c.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("unpack ShieldedTransferContract failed.");
                }
                for (int index = 0; index < stContract.getReceiveDescriptionList().size(); ++index) {
                    ShieldContract.ReceiveDescription r = stContract.getReceiveDescription(index);
                    NoteEncryption.Encryption.OutCiphertext cOut = new NoteEncryption.Encryption.OutCiphertext();
                    cOut.setData(r.getCOut().toByteArray());
                    Optional<OutgoingPlaintext> notePlaintext = OutgoingPlaintext.decrypt(cOut, ovk, r.getValueCommitment().toByteArray(), r.getNoteCommitment().toByteArray(), r.getEpk().toByteArray());
                    if (!notePlaintext.isPresent()) continue;
                    OutgoingPlaintext decryptedOutCtUnwrapped = notePlaintext.get();
                    NoteEncryption.Encryption.EncCiphertext cipherText = new NoteEncryption.Encryption.EncCiphertext();
                    cipherText.setData(r.getCEnc().toByteArray());
                    Optional<Note> foo = Note.decrypt(cipherText, r.getEpk().toByteArray(), decryptedOutCtUnwrapped.getEsk(), decryptedOutCtUnwrapped.getPkD(), r.getNoteCommitment().toByteArray());
                    if (!foo.isPresent()) continue;
                    Note bar = foo.get();
                    String paymentAddress = KeyIo.encodePaymentAddress(new PaymentAddress(bar.getD(), decryptedOutCtUnwrapped.getPkD()));
                    GrpcAPI.Note note = GrpcAPI.Note.newBuilder().setPaymentAddress(paymentAddress).setValue(bar.getValue()).setRcm(ByteString.copyFrom((byte[])bar.getRcm())).setMemo(ByteString.copyFrom((byte[])this.stripRightZero(bar.getMemo()))).build();
                    GrpcAPI.DecryptNotes.NoteTx noteTx = GrpcAPI.DecryptNotes.NoteTx.newBuilder().setNote(note).setTxid(ByteString.copyFrom((byte[])txid)).setIndex(index).build();
                    builder.addNoteTxs(noteTx);
                }
            }
        }
        return builder.build();
    }

    private void checkShieldedTRC20NoteValue(List<GrpcAPI.SpendNoteTRC20> spendNoteTRC20s, List<GrpcAPI.ReceiveNote> receiveNotes) throws ContractValidateException {
        if (!Objects.isNull(spendNoteTRC20s)) {
            for (GrpcAPI.SpendNoteTRC20 spendNote : spendNoteTRC20s) {
                if (spendNote.getNote().getValue() >= 0L) continue;
                throw new ContractValidateException("The value in SpendNoteTRC20 must >= 0");
            }
        }
        if (!Objects.isNull(receiveNotes)) {
            for (GrpcAPI.ReceiveNote receiveNote : receiveNotes) {
                if (receiveNote.getNote().getValue() >= 0L) continue;
                throw new ContractValidateException("The value in ReceiveNote must >= 0");
            }
        }
    }

    private void buildShieldedTRC20Input(ShieldedTRC20ParametersBuilder builder, GrpcAPI.SpendNoteTRC20 spendNote, ExpandedSpendingKey expsk) throws ZksnarkException {
        GrpcAPI.Note note = spendNote.getNote();
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
        if (Objects.isNull(paymentAddress)) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        Note baseNote = new Note(paymentAddress.getD(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray());
        builder.addSpend(expsk, baseNote, spendNote.getAlpha().toByteArray(), spendNote.getRoot().toByteArray(), spendNote.getPath().toByteArray(), spendNote.getPos());
    }

    private void buildShieldedTRC20Output(ShieldedTRC20ParametersBuilder builder, GrpcAPI.ReceiveNote receiveNote, byte[] ovk) throws ZksnarkException {
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(receiveNote.getNote().getPaymentAddress());
        if (Objects.isNull(paymentAddress)) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        builder.addOutput(ovk, paymentAddress.getD(), paymentAddress.getPkD(), receiveNote.getNote().getValue(), receiveNote.getNote().getRcm().toByteArray(), receiveNote.getNote().getMemo().toByteArray());
    }

    public GrpcAPI.ShieldedTRC20Parameters createShieldedContractParameters(GrpcAPI.PrivateShieldedTRC20Parameters request) throws ContractValidateException, ZksnarkException, ContractExeException {
        BigInteger toAmount;
        BigInteger fromAmount;
        this.checkFullNodeAllowShieldedTransaction();
        ShieldedTRC20ParametersBuilder builder = new ShieldedTRC20ParametersBuilder();
        byte[] shieldedTRC20ContractAddress = request.getShieldedTRC20ContractAddress().toByteArray();
        if (ArrayUtils.isEmpty((byte[])shieldedTRC20ContractAddress) || shieldedTRC20ContractAddress.length != 21) {
            throw new ContractValidateException("No valid shielded TRC-20 contract address");
        }
        byte[] shieldedTRC20ContractAddressTvm = new byte[20];
        System.arraycopy(shieldedTRC20ContractAddress, 1, shieldedTRC20ContractAddressTvm, 0, 20);
        builder.setShieldedTRC20Address(shieldedTRC20ContractAddressTvm);
        try {
            fromAmount = this.getBigIntegerFromString(request.getFromAmount());
            toAmount = this.getBigIntegerFromString(request.getToAmount());
        }
        catch (Exception e) {
            throw new ContractValidateException("invalid from_amount or to_amount");
        }
        long[] scaledPublicAmount = this.checkPublicAmount(shieldedTRC20ContractAddress, fromAmount, toAmount);
        long scaledFromAmount = scaledPublicAmount[0];
        long scaledToAmount = scaledPublicAmount[1];
        List shieldedSpends = request.getShieldedSpendsList();
        List shieldedReceives = request.getShieldedReceivesList();
        this.checkShieldedTRC20NoteValue(shieldedSpends, shieldedReceives);
        int spendSize = shieldedSpends.size();
        int receiveSize = shieldedReceives.size();
        long totalToAmount = 0L;
        if (scaledToAmount > 0L) {
            try {
                totalToAmount = receiveSize == 0 ? scaledToAmount : Math.addExact(scaledToAmount, ((GrpcAPI.ReceiveNote)shieldedReceives.get(0)).getNote().getValue());
            }
            catch (ArithmeticException e) {
                throw new ZksnarkException("Unbalanced burn!");
            }
        }
        if (scaledFromAmount > 0L && spendSize == 0 && receiveSize == 1 && scaledFromAmount == ((GrpcAPI.ReceiveNote)shieldedReceives.get(0)).getNote().getValue() && scaledToAmount == 0L) {
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.MINT);
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ovk)) {
                ovk = SpendingKey.random().fullViewingKey().getOvk();
            }
            builder.setTransparentFromAmount(fromAmount);
            this.buildShieldedTRC20Output(builder, (GrpcAPI.ReceiveNote)shieldedReceives.get(0), ovk);
        } else if (scaledFromAmount == 0L && spendSize > 0 && spendSize < 3 && receiveSize > 0 && receiveSize < 3 && scaledToAmount == 0L) {
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.TRANSFER);
            byte[] ask = request.getAsk().toByteArray();
            byte[] nsk = request.getNsk().toByteArray();
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ask) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk)) {
                throw new ContractValidateException("No shielded TRC-20 ask, nsk or ovk");
            }
            ExpandedSpendingKey expsk = new ExpandedSpendingKey(ask, nsk, ovk);
            for (GrpcAPI.SpendNoteTRC20 spendNote : shieldedSpends) {
                this.buildShieldedTRC20Input(builder, spendNote, expsk);
            }
            for (GrpcAPI.ReceiveNote receiveNote : shieldedReceives) {
                this.buildShieldedTRC20Output(builder, receiveNote, ovk);
            }
        } else if (scaledFromAmount == 0L && spendSize == 1 && receiveSize >= 0 && receiveSize <= 1 && scaledToAmount > 0L && totalToAmount == ((GrpcAPI.SpendNoteTRC20)shieldedSpends.get(0)).getNote().getValue()) {
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.BURN);
            byte[] ask = request.getAsk().toByteArray();
            byte[] nsk = request.getNsk().toByteArray();
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ask) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk)) {
                throw new ContractValidateException("No shielded TRC-20 ask, nsk or ovk");
            }
            byte[] transparentToAddress = request.getTransparentToAddress().toByteArray();
            if (ArrayUtils.isEmpty((byte[])transparentToAddress) || transparentToAddress.length != 21) {
                throw new ContractValidateException("No valid transparent TRC-20 output address");
            }
            byte[] transparentToAddressTvm = new byte[20];
            System.arraycopy(transparentToAddress, 1, transparentToAddressTvm, 0, 20);
            builder.setTransparentToAddress(transparentToAddressTvm);
            builder.setTransparentToAmount(toAmount);
            Optional<byte[]> cipher = NoteEncryption.Encryption.encryptBurnMessageByOvk(ovk, toAmount, transparentToAddress);
            cipher.ifPresent(builder::setBurnCiphertext);
            ExpandedSpendingKey expsk = new ExpandedSpendingKey(ask, nsk, ovk);
            GrpcAPI.SpendNoteTRC20 spendNote = (GrpcAPI.SpendNoteTRC20)shieldedSpends.get(0);
            this.buildShieldedTRC20Input(builder, spendNote, expsk);
            if (receiveSize == 1) {
                this.buildShieldedTRC20Output(builder, (GrpcAPI.ReceiveNote)shieldedReceives.get(0), ovk);
            }
        } else {
            throw new ContractValidateException("invalid shielded TRC-20 parameters");
        }
        return builder.build(true);
    }

    private void buildShieldedTRC20InputWithAK(ShieldedTRC20ParametersBuilder builder, GrpcAPI.SpendNoteTRC20 spendNote, byte[] ak, byte[] nsk) throws ZksnarkException {
        GrpcAPI.Note note = spendNote.getNote();
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
        if (Objects.isNull(paymentAddress)) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        Note baseNote = new Note(paymentAddress.getD(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray());
        builder.addSpend(ak, nsk, baseNote, spendNote.getAlpha().toByteArray(), spendNote.getRoot().toByteArray(), spendNote.getPath().toByteArray(), spendNote.getPos());
    }

    public GrpcAPI.ShieldedTRC20Parameters createShieldedContractParametersWithoutAsk(GrpcAPI.PrivateShieldedTRC20ParametersWithoutAsk request) throws ZksnarkException, ContractValidateException, ContractExeException {
        BigInteger toAmount;
        BigInteger fromAmount;
        this.checkFullNodeAllowShieldedTransaction();
        ShieldedTRC20ParametersBuilder builder = new ShieldedTRC20ParametersBuilder();
        byte[] shieldedTRC20ContractAddress = request.getShieldedTRC20ContractAddress().toByteArray();
        if (ArrayUtils.isEmpty((byte[])shieldedTRC20ContractAddress) || shieldedTRC20ContractAddress.length != 21) {
            throw new ContractValidateException("No valid shielded TRC-20 contract address");
        }
        byte[] shieldedTRC20ContractAddressTvm = new byte[20];
        System.arraycopy(shieldedTRC20ContractAddress, 1, shieldedTRC20ContractAddressTvm, 0, 20);
        builder.setShieldedTRC20Address(shieldedTRC20ContractAddressTvm);
        try {
            fromAmount = this.getBigIntegerFromString(request.getFromAmount());
            toAmount = this.getBigIntegerFromString(request.getToAmount());
        }
        catch (Exception e) {
            throw new ContractValidateException("invalid_from amount or to_amount");
        }
        long[] scaledPublicAmount = this.checkPublicAmount(shieldedTRC20ContractAddress, fromAmount, toAmount);
        long scaledFromAmount = scaledPublicAmount[0];
        long scaledToAmount = scaledPublicAmount[1];
        List shieldedSpends = request.getShieldedSpendsList();
        int spendSize = shieldedSpends.size();
        List shieldedReceives = request.getShieldedReceivesList();
        int receiveSize = shieldedReceives.size();
        this.checkShieldedTRC20NoteValue(shieldedSpends, shieldedReceives);
        long totalToAmount = 0L;
        if (scaledToAmount > 0L) {
            try {
                totalToAmount = receiveSize == 0 ? scaledToAmount : Math.addExact(scaledToAmount, ((GrpcAPI.ReceiveNote)shieldedReceives.get(0)).getNote().getValue());
            }
            catch (ArithmeticException e) {
                throw new ZksnarkException("Unbalanced burn!");
            }
        }
        if (scaledFromAmount > 0L && spendSize == 0 && receiveSize == 1 && scaledFromAmount == ((GrpcAPI.ReceiveNote)shieldedReceives.get(0)).getNote().getValue() && scaledToAmount == 0L) {
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ovk)) {
                ovk = SpendingKey.random().fullViewingKey().getOvk();
            }
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.MINT);
            builder.setTransparentFromAmount(fromAmount);
            GrpcAPI.ReceiveNote receiveNote = (GrpcAPI.ReceiveNote)shieldedReceives.get(0);
            this.buildShieldedTRC20Output(builder, receiveNote, ovk);
        } else if (scaledFromAmount == 0L && spendSize > 0 && spendSize < 3 && receiveSize > 0 && receiveSize < 3 && scaledToAmount == 0L) {
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.TRANSFER);
            byte[] ak = request.getAk().toByteArray();
            byte[] nsk = request.getNsk().toByteArray();
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ak) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk)) {
                throw new ContractValidateException("No shielded TRC-20 ak, nsk or ovk");
            }
            for (GrpcAPI.SpendNoteTRC20 spendNote : shieldedSpends) {
                this.buildShieldedTRC20InputWithAK(builder, spendNote, ak, nsk);
            }
            for (GrpcAPI.ReceiveNote receiveNote : shieldedReceives) {
                this.buildShieldedTRC20Output(builder, receiveNote, ovk);
            }
        } else if (scaledFromAmount == 0L && spendSize == 1 && receiveSize >= 0 && receiveSize <= 1 && scaledToAmount > 0L && totalToAmount == ((GrpcAPI.SpendNoteTRC20)shieldedSpends.get(0)).getNote().getValue()) {
            builder.setShieldedTRC20ParametersType(ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.BURN);
            byte[] ak = request.getAk().toByteArray();
            byte[] nsk = request.getNsk().toByteArray();
            byte[] ovk = request.getOvk().toByteArray();
            if (ArrayUtils.isEmpty((byte[])ak) || ArrayUtils.isEmpty((byte[])nsk) || ArrayUtils.isEmpty((byte[])ovk)) {
                throw new ContractValidateException("No shielded TRC-20 ak, nsk or ovk");
            }
            byte[] transparentToAddress = request.getTransparentToAddress().toByteArray();
            if (ArrayUtils.isEmpty((byte[])transparentToAddress) || transparentToAddress.length != 21) {
                throw new ContractValidateException("No transparent TRC-20 output address");
            }
            byte[] transparentToAddressTvm = new byte[20];
            System.arraycopy(transparentToAddress, 1, transparentToAddressTvm, 0, 20);
            builder.setTransparentToAddress(transparentToAddressTvm);
            builder.setTransparentToAmount(toAmount);
            Optional<byte[]> cipher = NoteEncryption.Encryption.encryptBurnMessageByOvk(ovk, toAmount, transparentToAddress);
            cipher.ifPresent(builder::setBurnCiphertext);
            GrpcAPI.SpendNoteTRC20 spendNote = (GrpcAPI.SpendNoteTRC20)shieldedSpends.get(0);
            this.buildShieldedTRC20InputWithAK(builder, spendNote, ak, nsk);
            if (receiveSize == 1) {
                this.buildShieldedTRC20Output(builder, (GrpcAPI.ReceiveNote)shieldedReceives.get(0), ovk);
            }
        } else {
            throw new ContractValidateException("invalid shielded TRC-20 parameters");
        }
        return builder.build(false);
    }

    private int getShieldedTRC20LogType(Protocol.TransactionInfo.Log log, byte[] contractAddress, ProtocolStringList topicsList) throws ZksnarkException {
        byte[] logAddress = log.getAddress().toByteArray();
        byte[] addressWithoutPrefix = new byte[20];
        if (ArrayUtils.isEmpty((byte[])contractAddress) || contractAddress.length != 21) {
            throw new ZksnarkException("invalid contract address");
        }
        System.arraycopy(contractAddress, 1, addressWithoutPrefix, 0, 20);
        if (Arrays.equals(logAddress, addressWithoutPrefix)) {
            List logTopicsList = log.getTopicsList();
            byte[] topicsBytes = new byte[]{};
            for (ByteString bs : logTopicsList) {
                topicsBytes = ByteUtil.merge((byte[][])new byte[][]{topicsBytes, bs.toByteArray()});
            }
            if (Objects.isNull(topicsList) || topicsList.isEmpty()) {
                if (Arrays.equals(topicsBytes, SHIELDED_TRC20_LOG_TOPICS_MINT)) {
                    return 1;
                }
                if (Arrays.equals(topicsBytes, SHIELDED_TRC20_LOG_TOPICS_TRANSFER)) {
                    return 2;
                }
                if (Arrays.equals(topicsBytes, SHIELDED_TRC20_LOG_TOPICS_BURN_LEAF)) {
                    return 3;
                }
                if (Arrays.equals(topicsBytes, SHIELDED_TRC20_LOG_TOPICS_BURN_TOKEN)) {
                    return 4;
                }
            } else {
                for (String topic : topicsList) {
                    byte[] topicHash = Hash.sha3((byte[])ByteArray.fromString((String)topic));
                    if (!Arrays.equals(topicsBytes, topicHash)) continue;
                    if (topic.toLowerCase().contains("mint")) {
                        return 1;
                    }
                    if (topic.toLowerCase().contains("transfer")) {
                        return 2;
                    }
                    if (!topic.toLowerCase().contains("burn")) continue;
                    if (topic.toLowerCase().contains("leaf")) {
                        return 3;
                    }
                    if (!topic.toLowerCase().contains("token")) continue;
                    return 4;
                }
            }
        }
        return 0;
    }

    private Optional<GrpcAPI.DecryptNotesTRC20.NoteTx> getNoteTxFromLogListByIvk(GrpcAPI.DecryptNotesTRC20.NoteTx.Builder builder, Protocol.TransactionInfo.Log log, byte[] ivk, byte[] ak, byte[] nk, byte[] contractAddress, int logType) throws ZksnarkException, ContractExeException {
        byte[] logData = log.getData().toByteArray();
        if (!ArrayUtils.isEmpty((byte[])logData) && logType > 0 && logType < 4) {
            long pos = ByteArray.toLong((byte[])ByteArray.subArray((byte[])logData, (int)0, (int)32));
            byte[] cm = ByteArray.subArray((byte[])logData, (int)32, (int)64);
            byte[] epk = ByteArray.subArray((byte[])logData, (int)96, (int)128);
            byte[] cenc = ByteArray.subArray((byte[])logData, (int)128, (int)708);
            Optional<Note> notePlaintext = Note.decrypt(cenc, ivk, epk, cm);
            if (notePlaintext.isPresent()) {
                Note noteText = notePlaintext.get();
                byte[] pkD = new byte[32];
                if (!JLibrustzcash.librustzcashIvkToPkd((LibrustzcashParam.IvkToPkdParams)new LibrustzcashParam.IvkToPkdParams(ivk, noteText.getD().getData(), pkD))) {
                    throw new ZksnarkException("get payment address error");
                }
                String paymentAddress = KeyIo.encodePaymentAddress(new PaymentAddress(noteText.getD(), pkD));
                GrpcAPI.Note note = GrpcAPI.Note.newBuilder().setPaymentAddress(paymentAddress).setValue(noteText.getValue()).setRcm(ByteString.copyFrom((byte[])noteText.getRcm())).setMemo(ByteString.copyFrom((byte[])this.stripRightZero(noteText.getMemo()))).build();
                if (!ArrayUtils.isEmpty((byte[])ak) && !ArrayUtils.isEmpty((byte[])nk)) {
                    builder.setIsSpent(this.isShieldedTRC20NoteSpent(note, pos, ak, nk, contractAddress));
                }
                return Optional.of(builder.setNote(note).setPosition(pos).build());
            }
        }
        return Optional.empty();
    }

    private GrpcAPI.DecryptNotesTRC20 queryTRC20NoteByIvk(long startNum, long endNum, byte[] shieldedTRC20ContractAddress, byte[] ivk, byte[] ak, byte[] nk, ProtocolStringList topicsList) throws BadItemException, ZksnarkException, ContractExeException {
        if (startNum < 0L || endNum <= startNum || endNum - startNum > 1000L) {
            throw new BadItemException(SHIELDED_TRANSACTION_SCAN_RANGE);
        }
        GrpcAPI.DecryptNotesTRC20.Builder builder = GrpcAPI.DecryptNotesTRC20.newBuilder();
        GrpcAPI.BlockList blockList = this.getBlocksByLimitNext(startNum, endNum - startNum);
        for (Protocol.Block block : blockList.getBlockList()) {
            for (Protocol.Transaction transaction : block.getTransactionsList()) {
                List logList;
                TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
                byte[] txId = transactionCapsule.getTransactionId().getBytes();
                Protocol.TransactionInfo info = this.getTransactionInfoById(ByteString.copyFrom((byte[])txId));
                if (Objects.isNull(info) || Objects.isNull(logList = info.getLogList())) continue;
                int index = 0;
                for (Protocol.TransactionInfo.Log log : logList) {
                    int logType = this.getShieldedTRC20LogType(log, shieldedTRC20ContractAddress, topicsList);
                    if (logType <= 0) continue;
                    GrpcAPI.DecryptNotesTRC20.NoteTx.Builder noteBuilder = GrpcAPI.DecryptNotesTRC20.NoteTx.newBuilder();
                    noteBuilder.setTxid(ByteString.copyFrom((byte[])txId));
                    noteBuilder.setIndex(index);
                    ++index;
                    Optional<GrpcAPI.DecryptNotesTRC20.NoteTx> noteTx = this.getNoteTxFromLogListByIvk(noteBuilder, log, ivk, ak, nk, shieldedTRC20ContractAddress, logType);
                    noteTx.ifPresent(arg_0 -> ((GrpcAPI.DecryptNotesTRC20.Builder)builder).addNoteTxs(arg_0));
                }
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShieldedTRC20NoteSpent(GrpcAPI.Note note, long pos, byte[] ak, byte[] nk, byte[] contractAddress) throws ZksnarkException, ContractExeException {
        GrpcAPI.TransactionExtention trxExt;
        byte[] nf = this.getShieldedTRC20Nullifier(note, pos, ak, nk);
        if (Objects.isNull(nf)) {
            throw new ZksnarkException("compute nullifier error");
        }
        String methodSign = "nullifiers(bytes32)";
        byte[] selector = new byte[4];
        System.arraycopy(Hash.sha3((byte[])methodSign.getBytes()), 0, selector, 0, 4);
        byte[] input = ByteUtil.merge((byte[][])new byte[][]{selector, nf});
        SmartContractOuterClass.TriggerSmartContract.Builder triggerBuilder = SmartContractOuterClass.TriggerSmartContract.newBuilder();
        triggerBuilder.setContractAddress(ByteString.copyFrom((byte[])contractAddress));
        triggerBuilder.setData(ByteString.copyFrom((byte[])input));
        SmartContractOuterClass.TriggerSmartContract trigger = triggerBuilder.build();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            TransactionCapsule trxCap = this.createTransactionCapsule((Message)trigger, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
            Protocol.Transaction trx = this.triggerConstantContract(trigger, trxCap, trxExtBuilder, retBuilder);
            retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            trxExtBuilder.setTransaction(trx);
            trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
            trxExtBuilder.setResult(retBuilder);
        }
        catch (ContractValidateException | VMIllegalException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)(CONTRACT_VALIDATE_ERROR + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn(CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn("When run constant call in VM, failed for reason: " + e.getMessage());
        }
        catch (Exception e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn("unknown exception caught: " + e.getMessage(), (Throwable)e);
        }
        finally {
            trxExt = trxExtBuilder.build();
        }
        String code2 = trxExt.getResult().getCode().toString();
        if ("SUCCESS".equals(code2)) {
            List list = trxExt.getConstantResultList();
            byte[] listBytes = new byte[]{};
            for (ByteString bs : list) {
                listBytes = ByteUtil.merge((byte[][])new byte[][]{listBytes, bs.toByteArray()});
            }
            return Arrays.equals(nf, listBytes);
        }
        throw new ContractExeException("trigger contract to get nullifier error.");
    }

    public GrpcAPI.DecryptNotesTRC20 scanShieldedTRC20NotesByIvk(long startNum, long endNum, byte[] shieldedTRC20ContractAddress, byte[] ivk, byte[] ak, byte[] nk, ProtocolStringList topicsList) throws BadItemException, ZksnarkException, ContractExeException {
        this.checkFullNodeAllowShieldedTransaction();
        return this.queryTRC20NoteByIvk(startNum, endNum, shieldedTRC20ContractAddress, ivk, ak, nk, topicsList);
    }

    private Optional<GrpcAPI.DecryptNotesTRC20.NoteTx> getNoteTxFromLogListByOvk(GrpcAPI.DecryptNotesTRC20.NoteTx.Builder builder, Protocol.TransactionInfo.Log log, byte[] ovk, int logType) throws ZksnarkException {
        byte[] logData = log.getData().toByteArray();
        if (!ArrayUtils.isEmpty((byte[])logData)) {
            if (logType > 0 && logType < 4) {
                byte[] cm = ByteArray.subArray((byte[])logData, (int)32, (int)64);
                byte[] cv = ByteArray.subArray((byte[])logData, (int)64, (int)96);
                byte[] epk = ByteArray.subArray((byte[])logData, (int)96, (int)128);
                byte[] cenc = ByteArray.subArray((byte[])logData, (int)128, (int)708);
                byte[] coutText = ByteArray.subArray((byte[])logData, (int)708, (int)788);
                NoteEncryption.Encryption.OutCiphertext cout = new NoteEncryption.Encryption.OutCiphertext();
                cout.setData(coutText);
                Optional<OutgoingPlaintext> notePlaintext = OutgoingPlaintext.decrypt(cout, ovk, cv, cm, epk);
                if (notePlaintext.isPresent()) {
                    OutgoingPlaintext decryptedOutCtUnwrapped = notePlaintext.get();
                    NoteEncryption.Encryption.EncCiphertext ciphertext = new NoteEncryption.Encryption.EncCiphertext();
                    ciphertext.setData(cenc);
                    Optional<Note> foo = Note.decrypt(ciphertext, epk, decryptedOutCtUnwrapped.getEsk(), decryptedOutCtUnwrapped.getPkD(), cm);
                    if (foo.isPresent()) {
                        Note bar = foo.get();
                        String paymentAddress = KeyIo.encodePaymentAddress(new PaymentAddress(bar.getD(), decryptedOutCtUnwrapped.getPkD()));
                        GrpcAPI.Note note = GrpcAPI.Note.newBuilder().setPaymentAddress(paymentAddress).setValue(bar.getValue()).setRcm(ByteString.copyFrom((byte[])bar.getRcm())).setMemo(ByteString.copyFrom((byte[])this.stripRightZero(bar.getMemo()))).build();
                        builder.setNote(note);
                        return Optional.of(builder.build());
                    }
                }
            } else if (logType == 4) {
                byte[] logToAddress = ByteArray.subArray((byte[])logData, (int)12, (int)32);
                byte[] logAmountArray = ByteArray.subArray((byte[])logData, (int)32, (int)64);
                byte[] cipher = ByteArray.subArray((byte[])logData, (int)64, (int)144);
                BigInteger logAmount = ByteUtil.bytesToBigInteger((byte[])logAmountArray);
                byte[] amountArray = new byte[32];
                byte[] decryptedAddress = new byte[20];
                Optional<byte[]> decryptedText = NoteEncryption.Encryption.decryptBurnMessageByOvk(ovk, cipher);
                if (decryptedText.isPresent()) {
                    byte[] plaintext = decryptedText.get();
                    System.arraycopy(plaintext, 0, amountArray, 0, 32);
                    System.arraycopy(plaintext, 33, decryptedAddress, 0, 20);
                    BigInteger decryptedAmount = ByteUtil.bytesToBigInteger((byte[])amountArray);
                    if (logAmount.equals(decryptedAmount) && Hex.toHexString((byte[])logToAddress).equals(Hex.toHexString((byte[])decryptedAddress))) {
                        byte[] addressWithPrefix = new byte[21];
                        System.arraycopy(plaintext, 32, addressWithPrefix, 0, 21);
                        builder.setToAmount(logAmount.toString(10)).setTransparentToAddress(ByteString.copyFrom((byte[])addressWithPrefix));
                        return Optional.of(builder.build());
                    }
                }
            }
        }
        return Optional.empty();
    }

    public GrpcAPI.DecryptNotesTRC20 scanShieldedTRC20NotesByOvk(long startNum, long endNum, byte[] ovk, byte[] shieldedTRC20ContractAddress, ProtocolStringList topicsList) throws ZksnarkException, BadItemException {
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.DecryptNotesTRC20.Builder builder = GrpcAPI.DecryptNotesTRC20.newBuilder();
        if (startNum < 0L || endNum <= startNum || endNum - startNum > 1000L) {
            throw new BadItemException(SHIELDED_TRANSACTION_SCAN_RANGE);
        }
        GrpcAPI.BlockList blockList = this.getBlocksByLimitNext(startNum, endNum - startNum);
        for (Protocol.Block block : blockList.getBlockList()) {
            for (Protocol.Transaction transaction : block.getTransactionsList()) {
                List logList;
                TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
                byte[] txid = transactionCapsule.getTransactionId().getBytes();
                Protocol.TransactionInfo info = this.getTransactionInfoById(ByteString.copyFrom((byte[])txid));
                if (Objects.isNull(info) || Objects.isNull(logList = info.getLogList())) continue;
                int index = 0;
                for (Protocol.TransactionInfo.Log log : logList) {
                    int logType = this.getShieldedTRC20LogType(log, shieldedTRC20ContractAddress, topicsList);
                    if (logType <= 0) continue;
                    GrpcAPI.DecryptNotesTRC20.NoteTx.Builder noteBuilder = GrpcAPI.DecryptNotesTRC20.NoteTx.newBuilder();
                    noteBuilder.setTxid(ByteString.copyFrom((byte[])txid));
                    noteBuilder.setIndex(index);
                    ++index;
                    Optional<GrpcAPI.DecryptNotesTRC20.NoteTx> noteTx = this.getNoteTxFromLogListByOvk(noteBuilder, log, ovk, logType);
                    noteTx.ifPresent(arg_0 -> ((GrpcAPI.DecryptNotesTRC20.Builder)builder).addNoteTxs(arg_0));
                }
            }
        }
        return builder.build();
    }

    private byte[] getShieldedTRC20Nullifier(GrpcAPI.Note note, long pos, byte[] ak, byte[] nk) throws ZksnarkException {
        byte[] result = new byte[32];
        PaymentAddress paymentAddress = KeyIo.decodePaymentAddress(note.getPaymentAddress());
        if (Objects.isNull(paymentAddress)) {
            throw new ZksnarkException(PAYMENT_ADDRESS_FORMAT_WRONG);
        }
        LibrustzcashParam.ComputeNfParams computeNfParams = new LibrustzcashParam.ComputeNfParams(paymentAddress.getD().getData(), paymentAddress.getPkD(), note.getValue(), note.getRcm().toByteArray(), ak, nk, pos, result);
        if (!JLibrustzcash.librustzcashComputeNf((LibrustzcashParam.ComputeNfParams)computeNfParams)) {
            return null;
        }
        return result;
    }

    public GrpcAPI.NullifierResult isShieldedTRC20ContractNoteSpent(GrpcAPI.NfTRC20Parameters request) throws ZksnarkException, ContractExeException {
        this.checkFullNodeAllowShieldedTransaction();
        return GrpcAPI.NullifierResult.newBuilder().setIsSpent(this.isShieldedTRC20NoteSpent(request.getNote(), request.getPosition(), request.getAk().toByteArray(), request.getNk().toByteArray(), request.getShieldedTRC20ContractAddress().toByteArray())).build();
    }

    private BigInteger getBigIntegerFromString(String in) {
        String trimmedIn = in.trim();
        if (trimmedIn.length() == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(trimmedIn, 10);
    }

    private long[] checkPublicAmount(byte[] address, BigInteger fromAmount, BigInteger toAmount) throws ContractExeException, ContractValidateException {
        BigInteger scalingFactor;
        this.checkBigIntegerRange(fromAmount);
        this.checkBigIntegerRange(toAmount);
        try {
            byte[] scalingFactorBytes = this.getShieldedContractScalingFactor(address);
            scalingFactor = ByteUtil.bytesToBigInteger((byte[])scalingFactorBytes);
        }
        catch (ContractExeException e) {
            throw new ContractExeException("Get shielded contract scalingFactor failed");
        }
        if (!fromAmount.mod(scalingFactor).equals(BigInteger.ZERO) || !toAmount.mod(scalingFactor).equals(BigInteger.ZERO)) {
            throw new ContractValidateException("fromAmount or toAmount invalid");
        }
        long[] ret = new long[2];
        try {
            ret[0] = fromAmount.divide(scalingFactor).longValueExact();
            ret[1] = toAmount.divide(scalingFactor).longValueExact();
        }
        catch (ArithmeticException e) {
            throw new ContractValidateException("fromAmount or toAmount invalid");
        }
        return ret;
    }

    private void checkBigIntegerRange(BigInteger in) throws ContractValidateException {
        if (in.compareTo(BigInteger.ZERO) < 0) {
            throw new ContractValidateException("public amount must be non-negative");
        }
        if (in.bitLength() > 256) {
            throw new ContractValidateException("public amount must be no more than 256 bits");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getShieldedContractScalingFactor(byte[] contractAddress) throws ContractExeException {
        GrpcAPI.TransactionExtention trxExt;
        String methodSign = "scalingFactor()";
        byte[] selector = new byte[4];
        System.arraycopy(Hash.sha3((byte[])methodSign.getBytes()), 0, selector, 0, 4);
        SmartContractOuterClass.TriggerSmartContract.Builder triggerBuilder = SmartContractOuterClass.TriggerSmartContract.newBuilder();
        triggerBuilder.setContractAddress(ByteString.copyFrom((byte[])contractAddress));
        triggerBuilder.setData(ByteString.copyFrom((byte[])selector));
        SmartContractOuterClass.TriggerSmartContract trigger = triggerBuilder.build();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            TransactionCapsule trxCap = this.createTransactionCapsule((Message)trigger, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
            Protocol.Transaction trx = this.triggerConstantContract(trigger, trxCap, trxExtBuilder, retBuilder);
            retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            trxExtBuilder.setTransaction(trx);
            trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
            trxExtBuilder.setResult(retBuilder);
        }
        catch (ContractValidateException | VMIllegalException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)(CONTRACT_VALIDATE_ERROR + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn(CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn("When run constant call in VM, failed for reason: " + e.getMessage());
        }
        catch (Exception e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn("Unknown exception caught: " + e.getMessage(), (Throwable)e);
        }
        finally {
            trxExt = trxExtBuilder.build();
        }
        String code2 = trxExt.getResult().getCode().toString();
        if ("SUCCESS".equals(code2)) {
            List list = trxExt.getConstantResultList();
            byte[] listBytes = new byte[]{};
            for (ByteString bs : list) {
                listBytes = ByteUtil.merge((byte[][])new byte[][]{listBytes, bs.toByteArray()});
            }
            return listBytes;
        }
        throw new ContractExeException("trigger contract to get scaling factor error.");
    }

    public GrpcAPI.BytesMessage getTriggerInputForShieldedTRC20Contract(GrpcAPI.ShieldedTRC20TriggerContractParameters request) throws ZksnarkException, ContractValidateException {
        String input;
        this.checkFullNodeAllowShieldedTransaction();
        GrpcAPI.ShieldedTRC20Parameters shieldedTRC20Parameters = request.getShieldedTRC20Parameters();
        List spendAuthoritySignature = request.getSpendAuthoritySignatureList();
        BigInteger value = this.getBigIntegerFromString(request.getAmount());
        this.checkBigIntegerRange(value);
        byte[] transparentToAddress = request.getTransparentToAddress().toByteArray();
        byte[] transparentToAddressTvm = new byte[20];
        if (!ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            if (transparentToAddress.length == 21) {
                System.arraycopy(transparentToAddress, 1, transparentToAddressTvm, 0, 20);
            } else {
                throw new ZksnarkException("invalid transparent to address");
            }
        }
        String parameterType = shieldedTRC20Parameters.getParameterType();
        if (shieldedTRC20Parameters.getSpendDescriptionList().size() != spendAuthoritySignature.size()) {
            throw new ZksnarkException("the number of spendDescription and spendAuthoritySignature is not equal");
        }
        ShieldedTRC20ParametersBuilder parametersBuilder = new ShieldedTRC20ParametersBuilder(parameterType);
        if (parametersBuilder.getShieldedTRC20ParametersType() == ShieldedTRC20ParametersBuilder.ShieldedTRC20ParametersType.BURN) {
            byte[] burnCiper = ByteArray.fromHexString((String)shieldedTRC20Parameters.getTriggerContractInput());
            if (!ArrayUtils.isEmpty((byte[])burnCiper) && burnCiper.length == 80) {
                parametersBuilder.setBurnCiphertext(burnCiper);
            } else {
                throw new ZksnarkException("invalid shielded TRC-20 contract parameters for burn trigger input");
            }
        }
        if (Objects.isNull(input = parametersBuilder.getTriggerContractInput(shieldedTRC20Parameters, spendAuthoritySignature, value, false, transparentToAddressTvm))) {
            throw new ZksnarkException("generate the trigger contract parameters error");
        }
        GrpcAPI.BytesMessage.Builder bytesBuilder = GrpcAPI.BytesMessage.newBuilder();
        return bytesBuilder.setValue(ByteString.copyFrom((byte[])Hex.decode((String)input))).build();
    }

    public BalanceContract.AccountBalanceResponse getAccountBalance(BalanceContract.AccountBalanceRequest request) throws ItemNotFoundException {
        BalanceContract.AccountIdentifier accountIdentifier = request.getAccountIdentifier();
        this.checkAccountIdentifier(accountIdentifier);
        BalanceContract.BlockBalanceTrace.BlockIdentifier blockIdentifier = request.getBlockIdentifier();
        this.checkBlockIdentifier(blockIdentifier);
        AccountTraceStore accountTraceStore = this.chainBaseManager.getAccountTraceStore();
        BlockIndexStore blockIndexStore = this.chainBaseManager.getBlockIndexStore();
        BlockCapsule.BlockId blockId = blockIndexStore.get(Long.valueOf(blockIdentifier.getNumber()));
        if (!blockId.getByteString().equals((Object)blockIdentifier.getHash())) {
            throw new IllegalArgumentException("number and hash do not match");
        }
        Pair pair = accountTraceStore.getPrevBalance(accountIdentifier.getAddress().toByteArray(), blockIdentifier.getNumber());
        BalanceContract.AccountBalanceResponse.Builder builder = BalanceContract.AccountBalanceResponse.newBuilder();
        if (((Long)pair.getLeft()).longValue() == blockIdentifier.getNumber()) {
            builder.setBlockIdentifier(blockIdentifier);
        } else {
            blockId = blockIndexStore.get((Long)pair.getLeft());
            builder.setBlockIdentifier(BalanceContract.BlockBalanceTrace.BlockIdentifier.newBuilder().setNumber(((Long)pair.getLeft()).longValue()).setHash(blockId.getByteString()));
        }
        builder.setBalance(((Long)pair.getRight()).longValue());
        return builder.build();
    }

    public BalanceContract.BlockBalanceTrace getBlockBalance(BalanceContract.BlockBalanceTrace.BlockIdentifier request) throws ItemNotFoundException, BadItemException {
        this.checkBlockIdentifier(request);
        BalanceTraceStore balanceTraceStore = this.chainBaseManager.getBalanceTraceStore();
        BlockIndexStore blockIndexStore = this.chainBaseManager.getBlockIndexStore();
        BlockCapsule.BlockId blockId = blockIndexStore.get(Long.valueOf(request.getNumber()));
        if (!blockId.getByteString().equals((Object)request.getHash())) {
            throw new IllegalArgumentException("number and hash do not match");
        }
        BlockBalanceTraceCapsule blockBalanceTraceCapsule = balanceTraceStore.getBlockBalanceTrace(blockId);
        if (blockBalanceTraceCapsule == null) {
            throw new ItemNotFoundException("This block does not exist");
        }
        return blockBalanceTraceCapsule.getInstance();
    }

    public void checkBlockIdentifier(BalanceContract.BlockBalanceTrace.BlockIdentifier blockIdentifier) {
        if (blockIdentifier == blockIdentifier.getDefaultInstanceForType()) {
            throw new IllegalArgumentException("block_identifier null");
        }
        if (blockIdentifier.getNumber() < 0L) {
            throw new IllegalArgumentException("block_identifier number less than 0");
        }
        if (blockIdentifier.getHash().size() != 32) {
            throw new IllegalArgumentException("block_identifier hash length not equals 32");
        }
    }

    public void checkAccountIdentifier(BalanceContract.AccountIdentifier accountIdentifier) {
        if (accountIdentifier == accountIdentifier.getDefaultInstanceForType()) {
            throw new IllegalArgumentException("account_identifier is null");
        }
        if (accountIdentifier.getAddress().isEmpty()) {
            throw new IllegalArgumentException("account_identifier address is null");
        }
    }

    public long getEnergyFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getEnergyFee();
    }

    public long getEnergyFee(long timestamp) {
        try {
            String energyPriceHistory = this.chainBaseManager.getDynamicPropertiesStore().getEnergyPriceHistory();
            long energyFee = JsonRpcApiUtil.parseEnergyFee(timestamp, energyPriceHistory);
            if (energyFee == -1L) {
                energyFee = this.getEnergyFee();
            }
            return energyFee;
        }
        catch (Exception e) {
            logger.error("getEnergyFee timestamp={} failed, error is {}", (Object)timestamp, (Object)e.getMessage());
            return this.getEnergyFee();
        }
    }

    public String getEnergyPrices() {
        try {
            return this.chainBaseManager.getDynamicPropertiesStore().getEnergyPriceHistory();
        }
        catch (Exception e) {
            logger.error("getEnergyPrices failed, error is {}", (Object)e.getMessage());
            return null;
        }
    }

    public String getBandwidthPrices() {
        try {
            return this.chainBaseManager.getDynamicPropertiesStore().getBandwidthPriceHistory();
        }
        catch (Exception e) {
            logger.error("getBandwidthPrices failed, error is {}", (Object)e.getMessage());
            return null;
        }
    }

    public String getCoinbase() {
        if (!CommonParameter.getInstance().isWitness()) {
            return null;
        }
        List localPrivateKeys = Args.getLocalWitnesses().getPrivateKeys();
        ArrayList<String> localWitnessAddresses = new ArrayList<String>();
        for (String privateKey : localPrivateKeys) {
            localWitnessAddresses.add(Hex.toHexString((byte[])SignUtils.fromPrivate((byte[])ByteArray.fromHexString((String)privateKey), (boolean)CommonParameter.getInstance().isECKeyCryptoEngine()).getAddress()));
        }
        List witnesses = this.consensusDelegate.getAllWitnesses();
        ArrayList<String> witnessAddresses = new ArrayList<String>();
        for (WitnessCapsule witnessCapsule : witnesses) {
            witnessAddresses.add(Hex.toHexString((byte[])witnessCapsule.getAddress().toByteArray()));
        }
        for (String localWitnessAddress : localWitnessAddresses) {
            if (!witnessAddresses.contains(localWitnessAddress)) continue;
            return "0x" + localWitnessAddress;
        }
        return null;
    }

    public boolean isMining() {
        if (!CommonParameter.getInstance().isWitness()) {
            return false;
        }
        List localPrivateKeys = Args.getLocalWitnesses().getPrivateKeys();
        ArrayList<String> localWitnessAddresses = new ArrayList<String>();
        for (String privateKey : localPrivateKeys) {
            localWitnessAddresses.add(Hex.toHexString((byte[])SignUtils.fromPrivate((byte[])ByteArray.fromHexString((String)privateKey), (boolean)CommonParameter.getInstance().isECKeyCryptoEngine()).getAddress()));
        }
        List activeWitnesses = this.consensusDelegate.getActiveWitnesses();
        ArrayList<String> activeWitnessAddresses = new ArrayList<String>();
        for (ByteString activeWitness : activeWitnesses) {
            activeWitnessAddresses.add(Hex.toHexString((byte[])activeWitness.toByteArray()));
        }
        for (String localWitnessAddress : localWitnessAddresses) {
            if (!activeWitnessAddresses.contains(localWitnessAddress)) continue;
            return true;
        }
        return false;
    }

    public Chainbase.Cursor getCursor() {
        return this.chainBaseManager.getBlockStore().getRevokingDB().getCursor();
    }

    public Protocol.Block getBlock(GrpcAPI.BlockReq request) {
        Protocol.Block block;
        long head = this.chainBaseManager.getHeadBlockNum();
        if (!request.getIdOrNum().isEmpty()) {
            Long num = WalletUtil.isLong((String)request.getIdOrNum());
            if (num != null) {
                if (num > head) {
                    return null;
                }
                if (num < 0L) {
                    throw new IllegalArgumentException("num must be non-positive number.");
                }
                block = this.getBlockByNum(num);
            } else {
                IllegalArgumentException e = new IllegalArgumentException("id must be legal block hash.");
                if (request.getIdOrNum().length() != 64) {
                    throw e;
                }
                try {
                    ByteString id = ByteString.copyFrom((byte[])ByteArray.fromHexString((String)request.getIdOrNum()));
                    if (id.size() == 32) {
                        num = new BlockCapsule.BlockId(Sha256Hash.wrap((ByteString)id)).getNum();
                        if (num > head || num < 0L) {
                            throw e;
                        }
                    } else {
                        throw e;
                    }
                    block = this.getBlockById(id);
                }
                catch (DecoderException ignored) {
                    throw e;
                }
            }
        } else {
            block = this.getNowBlock();
        }
        if (Objects.isNull(block) || block.getTransactionsList().isEmpty() || request.getDetail()) {
            return block;
        }
        return block.toBuilder().clearTransactions().build();
    }

    public String getMemoFeePrices() {
        try {
            return this.chainBaseManager.getDynamicPropertiesStore().getMemoFeeHistory();
        }
        catch (Exception e) {
            logger.error("getMemoFeePrices failed, error is {}", (Object)e.getMessage());
            return null;
        }
    }

    public SignInterface getCryptoEngine() {
        return this.cryptoEngine;
    }
}

