/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import org.tron.api.TronZksnarkGrpc;
import org.tron.api.ZksnarkGrpcAPI;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.protos.Protocol;

public class ZksnarkClient {
    public static final ZksnarkClient instance = new ZksnarkClient();
    private TronZksnarkGrpc.TronZksnarkBlockingStub blockingStub = TronZksnarkGrpc.newBlockingStub((Channel)ManagedChannelBuilder.forTarget((String)"127.0.0.1:60051").usePlaintext().build());

    public static ZksnarkClient getInstance() {
        return instance;
    }

    public boolean checkZksnarkProof(Protocol.Transaction transaction, byte[] sighash, long valueBalance) {
        String txId = new TransactionCapsule(transaction).getTransactionId().toString();
        ZksnarkGrpcAPI.ZksnarkRequest request = ZksnarkGrpcAPI.ZksnarkRequest.newBuilder().setTransaction(transaction).setTxId(txId).setSighash(ByteString.copyFrom((byte[])sighash)).setValueBalance(valueBalance).build();
        return this.blockingStub.checkZksnarkProof(request).getCode() == ZksnarkGrpcAPI.ZksnarkResponse.Code.SUCCESS;
    }
}

