/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.Runtime;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.Actuator2;
import org.tron.core.actuator.ActuatorCreator;
import org.tron.core.actuator.VMActuator;
import org.tron.core.db.TransactionContext;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.vm.program.Program;
import org.tron.protos.Protocol;

public class RuntimeImpl
implements Runtime {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    TransactionContext context;
    private List<Actuator> actuatorList = null;
    private Actuator2 actuator2 = null;

    public void execute(TransactionContext context) throws ContractValidateException, ContractExeException {
        this.context = context;
        Protocol.Transaction.Contract.ContractType contractType = context.getTrxCap().getInstance().getRawData().getContract(0).getType();
        switch (contractType.getNumber()) {
            case 30: 
            case 31: {
                Set actuatorSet = CommonParameter.getInstance().getActuatorSet();
                if (!actuatorSet.isEmpty() && !actuatorSet.contains(VMActuator.class.getSimpleName())) {
                    throw new ContractValidateException("not exist contract SmartContract");
                }
                this.actuator2 = new VMActuator(context.isStatic());
                break;
            }
            default: {
                this.actuatorList = ActuatorCreator.getINSTANCE().createActuator(context.getTrxCap());
            }
        }
        if (this.actuator2 != null) {
            this.actuator2.validate((Object)context);
            this.actuator2.execute((Object)context);
        } else {
            for (Actuator act : this.actuatorList) {
                act.validate();
                act.execute((Object)context.getProgramResult().getRet());
            }
        }
        this.setResultCode(context.getProgramResult());
    }

    public ProgramResult getResult() {
        return this.context.getProgramResult();
    }

    public String getRuntimeError() {
        return this.context.getProgramResult().getRuntimeError();
    }

    private void setResultCode(ProgramResult result) {
        RuntimeException exception = result.getException();
        if (Objects.isNull(exception) && StringUtils.isEmpty((CharSequence)result.getRuntimeError()) && !result.isRevert()) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.SUCCESS);
            return;
        }
        if (result.isRevert()) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.REVERT);
            return;
        }
        if (exception instanceof Program.IllegalOperationException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.ILLEGAL_OPERATION);
            return;
        }
        if (exception instanceof Program.OutOfEnergyException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_ENERGY);
            return;
        }
        if (exception instanceof Program.BadJumpDestinationException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.BAD_JUMP_DESTINATION);
            return;
        }
        if (exception instanceof Program.OutOfTimeException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_TIME);
            return;
        }
        if (exception instanceof Program.OutOfMemoryException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_MEMORY);
            return;
        }
        if (exception instanceof Program.PrecompiledContractException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.PRECOMPILED_CONTRACT);
            return;
        }
        if (exception instanceof Program.StackTooSmallException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.STACK_TOO_SMALL);
            return;
        }
        if (exception instanceof Program.StackTooLargeException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.STACK_TOO_LARGE);
            return;
        }
        if (exception instanceof Program.JVMStackOverFlowException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.JVM_STACK_OVER_FLOW);
            return;
        }
        if (exception instanceof Program.TransferException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.TRANSFER_FAILED);
            return;
        }
        if (exception instanceof Program.InvalidCodeException) {
            result.setResultCode(Protocol.Transaction.Result.contractResult.INVALID_CODE);
            return;
        }
        result.setResultCode(Protocol.Transaction.Result.contractResult.UNKNOWN);
    }

    public Actuator2 getActuator2() {
        return this.actuator2;
    }
}

