/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter.nativequeue;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public class NativeMessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(NativeMessageQueue.class);
    private static final int DEFAULT_BIND_PORT = 5555;
    private static final int DEFAULT_QUEUE_LENGTH = 1000;
    private static NativeMessageQueue instance;
    private ZContext context = null;
    private ZMQ.Socket publisher = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeMessageQueue getInstance() {
        if (!Objects.isNull(instance)) return instance;
        Class<NativeMessageQueue> clazz = NativeMessageQueue.class;
        synchronized (NativeMessageQueue.class) {
            if (!Objects.isNull(instance)) return instance;
            instance = new NativeMessageQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean start(int bindPort, int sendQueueLength) {
        this.context = new ZContext();
        this.publisher = this.context.createSocket(SocketType.PUB);
        if (Objects.isNull(this.publisher)) {
            return false;
        }
        if (bindPort == 0 || bindPort < 0) {
            bindPort = 5555;
        }
        if (sendQueueLength < 0) {
            sendQueueLength = 1000;
        }
        this.context.setSndHWM(sendQueueLength);
        String bindAddress = String.format("tcp://*:%d", bindPort);
        return this.publisher.bind(bindAddress);
    }

    public void stop() {
        if (Objects.nonNull(this.publisher)) {
            this.publisher.close();
        }
        if (Objects.nonNull(this.context)) {
            this.context.close();
        }
    }

    public void publishTrigger(String data, String topic) {
        if (Objects.isNull(this.publisher) || Objects.isNull(this.context) || this.context.isClosed()) {
            return;
        }
        try {
            this.publisher.sendMore(topic);
            this.publisher.send(data);
        }
        catch (RuntimeException e) {
            logger.error("write data to zeromq failed, data:{}, topic:{}, error:{}", new Object[]{data, topic, e.getMessage()});
        }
    }
}

