/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter.capsule;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.bloom.Bloom;
import org.tron.common.logsfilter.capsule.FilterTriggerCapsule;
import org.tron.core.services.jsonrpc.TronJsonRpcImpl;
import org.tron.protos.Protocol;

public class LogsFilterCapsule
extends FilterTriggerCapsule {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private long blockNumber;
    private String blockHash;
    private Bloom bloom;
    private List<Protocol.TransactionInfo> txInfoList;
    private boolean solidified;
    private boolean removed;

    public LogsFilterCapsule(long blockNumber, String blockHash, Bloom bloom, List<Protocol.TransactionInfo> txInfoList, boolean solidified, boolean removed) {
        this.blockNumber = blockNumber;
        this.blockHash = blockHash;
        this.bloom = bloom;
        this.txInfoList = txInfoList;
        this.solidified = solidified;
        this.removed = removed;
    }

    @Override
    public void processFilterTrigger() {
        TronJsonRpcImpl.handleLogsFilter(this);
    }

    public String toString() {
        return "LogsFilterCapsule(blockNumber=" + this.getBlockNumber() + ", blockHash=" + this.getBlockHash() + ", bloom=" + this.getBloom() + ", txInfoList=" + this.getTxInfoList() + ", solidified=" + this.isSolidified() + ", removed=" + this.isRemoved() + ")";
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public Bloom getBloom() {
        return this.bloom;
    }

    public void setBloom(Bloom bloom) {
        this.bloom = bloom;
    }

    public List<Protocol.TransactionInfo> getTxInfoList() {
        return this.txInfoList;
    }

    public void setTxInfoList(List<Protocol.TransactionInfo> txInfoList) {
        this.txInfoList = txInfoList;
    }

    public boolean isSolidified() {
        return this.solidified;
    }

    public void setSolidified(boolean solidified) {
        this.solidified = solidified;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

