/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter.capsule;

import java.util.List;
import org.tron.common.logsfilter.ContractEventParserAbi;
import org.tron.common.logsfilter.EventPluginLoader;
import org.tron.common.logsfilter.capsule.TriggerCapsule;
import org.tron.common.logsfilter.trigger.ContractEventTrigger;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.runtime.LogEventWrapper;
import org.tron.protos.contract.SmartContractOuterClass;

public class ContractEventTriggerCapsule
extends TriggerCapsule {
    private ContractEventTrigger contractEventTrigger = new ContractEventTrigger();
    private List<byte[]> topicList;
    private byte[] data;
    private SmartContractOuterClass.SmartContract.ABI.Entry abiEntry;

    public ContractEventTriggerCapsule(LogEventWrapper log) {
        this.contractEventTrigger.setUniqueId(log.getUniqueId());
        this.contractEventTrigger.setTransactionId(log.getTransactionId());
        this.contractEventTrigger.setContractAddress(log.getContractAddress());
        this.contractEventTrigger.setCallerAddress(log.getCallerAddress());
        this.contractEventTrigger.setOriginAddress(log.getOriginAddress());
        this.contractEventTrigger.setCreatorAddress(log.getCreatorAddress());
        this.contractEventTrigger.setBlockNumber(log.getBlockNumber());
        this.contractEventTrigger.setTimeStamp(log.getTimeStamp());
        this.topicList = log.getTopicList();
        this.data = log.getData();
        this.contractEventTrigger.setEventSignature(log.getEventSignature());
        this.contractEventTrigger.setEventSignatureFull(log.getEventSignatureFull());
        this.contractEventTrigger.setEventName(log.getAbiEntry().getName());
        this.abiEntry = log.getAbiEntry();
    }

    public void setLatestSolidifiedBlockNumber(long latestSolidifiedBlockNumber) {
        this.contractEventTrigger.setLatestSolidifiedBlockNumber(latestSolidifiedBlockNumber);
    }

    @Override
    public void processTrigger() {
        this.contractEventTrigger.setTopicMap(ContractEventParserAbi.parseTopics(this.topicList, this.abiEntry));
        this.contractEventTrigger.setDataMap(ContractEventParserAbi.parseEventData(this.data, this.topicList, this.abiEntry));
        if (EventPluginLoader.matchFilter((ContractTrigger)this.contractEventTrigger)) {
            EventPluginLoader.getInstance().postContractEventTrigger(this.contractEventTrigger);
        }
    }

    public ContractEventTrigger getContractEventTrigger() {
        return this.contractEventTrigger;
    }

    public void setContractEventTrigger(ContractEventTrigger contractEventTrigger) {
        this.contractEventTrigger = contractEventTrigger;
    }

    public List<byte[]> getTopicList() {
        return this.topicList;
    }

    public void setTopicList(List<byte[]> topicList) {
        this.topicList = topicList;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public SmartContractOuterClass.SmartContract.ABI.Entry getAbiEntry() {
        return this.abiEntry;
    }

    public void setAbiEntry(SmartContractOuterClass.SmartContract.ABI.Entry abiEntry) {
        this.abiEntry = abiEntry;
    }
}

