/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.logsfilter.ContractEventParser;

public class ContractEventParserJson
extends ContractEventParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"Parser");
    private static final String INPUTS = "inputs";
    private static final String INDEXED = "indexed";

    public static Map<String, String> parseTopics(List<byte[]> topicList, JSONObject entry) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (topicList == null || topicList.isEmpty()) {
            return map;
        }
        int index = 1;
        JSONArray inputs = entry.getJSONArray(INPUTS);
        if (ContractEventParserJson.topicsMatched(topicList, entry)) {
            if (inputs != null) {
                for (int i = 0; i < inputs.size(); ++i) {
                    Boolean indexed;
                    JSONObject param = inputs.getJSONObject(i);
                    if (param == null || (indexed = param.getBoolean(INDEXED)) == null || !indexed.booleanValue()) continue;
                    if (index < topicList.size()) {
                        String str = ContractEventParserJson.parseTopic(topicList.get(index++), param.getString("type"));
                        if (StringUtils.isNotNullOrEmpty((String)param.getString("name"))) {
                            map.put(param.getString("name"), str);
                        }
                        map.put("" + i, str);
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (int i = 1; i < topicList.size(); ++i) {
                map.put("" + (i - 1), Hex.toHexString((byte[])topicList.get(i)));
            }
        }
        return map;
    }

    public static Map<String, String> parseEventData(byte[] data, List<byte[]> topicList, JSONObject entry) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ArrayUtils.isEmpty((byte[])data)) {
            return map;
        }
        if (!ContractEventParserJson.topicsMatched(topicList, entry)) {
            map.put("" + (topicList.size() - 1), Hex.toHexString((byte[])data));
            return map;
        }
        JSONArray inputs = entry.getJSONArray(INPUTS);
        Integer startIndex = 0;
        try {
            int index = 0;
            if (inputs != null) {
                Integer i = 0;
                while (i < inputs.size()) {
                    Boolean indexed;
                    JSONObject param = inputs.getJSONObject(i.intValue());
                    if (!(param == null || (indexed = param.getBoolean(INDEXED)) != null && indexed.booleanValue())) {
                        if (startIndex == 0) {
                            startIndex = i;
                        }
                        String str = ContractEventParserJson.parseDataBytes(data, param.getString("type"), index++);
                        if (StringUtils.isNotNullOrEmpty((String)param.getString("name"))) {
                            map.put(param.getString("name"), str);
                        }
                        map.put("" + i, str);
                    }
                    i = i + 1;
                }
            } else {
                map.put("0", Hex.toHexString((byte[])data));
            }
        }
        catch (UnsupportedOperationException e) {
            logger.debug("UnsupportedOperationException", (Throwable)e);
            map.clear();
            map.put(startIndex.toString(), Hex.toHexString((byte[])data));
        }
        return map;
    }

    private static boolean topicsMatched(List<byte[]> topicList, JSONObject entry) {
        if (topicList == null || topicList.isEmpty()) {
            return true;
        }
        int inputSize = 1;
        JSONArray inputs = entry.getJSONArray(INPUTS);
        if (inputs != null) {
            for (int i = 0; i < inputs.size(); ++i) {
                Boolean indexed;
                JSONObject param = inputs.getJSONObject(i);
                if (param == null || (indexed = param.getBoolean(INDEXED)) == null || !indexed.booleanValue()) continue;
                ++inputSize;
            }
        }
        return inputSize == topicList.size();
    }
}

