/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.logsfilter.ContractEventParser;
import org.tron.protos.contract.SmartContractOuterClass;

public class ContractEventParserAbi
extends ContractEventParser {
    private static final Logger logger = LoggerFactory.getLogger((String)"Parser");

    public static Map<String, String> parseTopics(List<byte[]> topicList, SmartContractOuterClass.SmartContract.ABI.Entry entry) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (topicList == null || topicList.isEmpty()) {
            return map;
        }
        int index = 1;
        List list = entry.getInputsList();
        if (ContractEventParserAbi.topicsMatched(topicList, entry)) {
            for (int i = 0; i < list.size(); ++i) {
                SmartContractOuterClass.SmartContract.ABI.Entry.Param param = (SmartContractOuterClass.SmartContract.ABI.Entry.Param)list.get(i);
                if (!param.getIndexed()) continue;
                if (index < topicList.size()) {
                    String str = ContractEventParserAbi.parseTopic(topicList.get(index++), param.getType());
                    if (StringUtils.isNotNullOrEmpty((String)param.getName())) {
                        map.put(param.getName(), str);
                    }
                    map.put("" + i, str);
                    continue;
                }
                break;
            }
        } else {
            for (int i = 1; i < topicList.size(); ++i) {
                map.put("" + (i - 1), Hex.toHexString((byte[])topicList.get(i)));
            }
        }
        return map;
    }

    public static Map<String, String> parseEventData(byte[] data, List<byte[]> topicList, SmartContractOuterClass.SmartContract.ABI.Entry entry) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ArrayUtils.isEmpty((byte[])data)) {
            return map;
        }
        if (!ContractEventParserAbi.topicsMatched(topicList, entry)) {
            map.put("" + (topicList.size() - 1), Hex.toHexString((byte[])data));
            return map;
        }
        List list = entry.getInputsList();
        Integer startIndex = 0;
        try {
            int index = 0;
            Integer i = 0;
            while (i < list.size()) {
                SmartContractOuterClass.SmartContract.ABI.Entry.Param param = (SmartContractOuterClass.SmartContract.ABI.Entry.Param)list.get(i);
                if (!param.getIndexed()) {
                    if (startIndex == 0) {
                        startIndex = i;
                    }
                    String str = ContractEventParserAbi.parseDataBytes(data, param.getType(), index++);
                    if (StringUtils.isNotNullOrEmpty((String)param.getName())) {
                        map.put(param.getName(), str);
                    }
                    map.put("" + i, str);
                }
                i = i + 1;
            }
            if (list.isEmpty()) {
                map.put("0", Hex.toHexString((byte[])data));
            }
        }
        catch (UnsupportedOperationException e) {
            logger.debug("UnsupportedOperationException", (Throwable)e);
            map.clear();
            map.put(startIndex.toString(), Hex.toHexString((byte[])data));
        }
        return map;
    }

    private static boolean topicsMatched(List<byte[]> topicList, SmartContractOuterClass.SmartContract.ABI.Entry entry) {
        if (topicList == null || topicList.isEmpty()) {
            return true;
        }
        int inputSize = 1;
        for (SmartContractOuterClass.SmartContract.ABI.Entry.Param param : entry.getInputsList()) {
            if (!param.getIndexed()) continue;
            ++inputSize;
        }
        return inputSize == topicList.size();
    }
}

