/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.client;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.tron.api.GrpcAPI;
import org.tron.api.WalletGrpc;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.WitnessContract;

public class WalletGrpcClient {
    private final ManagedChannel channel;
    private final WalletGrpc.WalletBlockingStub walletBlockingStub;

    public WalletGrpcClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.walletBlockingStub = WalletGrpc.newBlockingStub((Channel)this.channel);
    }

    public WalletGrpcClient(String host) {
        this.channel = ManagedChannelBuilder.forTarget((String)host).usePlaintext().build();
        this.walletBlockingStub = WalletGrpc.newBlockingStub((Channel)this.channel);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public Protocol.Account queryAccount(byte[] address) {
        ByteString addressByteString = ByteString.copyFrom((byte[])address);
        Protocol.Account request = Protocol.Account.newBuilder().setAddress(addressByteString).build();
        return this.walletBlockingStub.getAccount(request);
    }

    public Protocol.Transaction createTransaction(BalanceContract.TransferContract contract) {
        return this.walletBlockingStub.createTransaction(contract);
    }

    public Protocol.Transaction createTransferAssetTransaction(AssetIssueContractOuterClass.TransferAssetContract contract) {
        return this.walletBlockingStub.transferAsset(contract);
    }

    public Protocol.Transaction createParticipateAssetIssueTransaction(AssetIssueContractOuterClass.ParticipateAssetIssueContract contract) {
        return this.walletBlockingStub.participateAssetIssue(contract);
    }

    public Protocol.Transaction createAssetIssue(AssetIssueContractOuterClass.AssetIssueContract contract) {
        return this.walletBlockingStub.createAssetIssue(contract);
    }

    public Protocol.Transaction voteWitnessAccount(WitnessContract.VoteWitnessContract contract) {
        return this.walletBlockingStub.voteWitnessAccount(contract);
    }

    public Protocol.Transaction createWitness(WitnessContract.WitnessCreateContract contract) {
        return this.walletBlockingStub.createWitness(contract);
    }

    public boolean broadcastTransaction(Protocol.Transaction signedTransaction) {
        GrpcAPI.Return response = this.walletBlockingStub.broadcastTransaction(signedTransaction);
        return response.getResult();
    }

    public Protocol.Block getBlock(long blockNum) {
        if (blockNum < 0L) {
            return this.walletBlockingStub.getNowBlock(GrpcAPI.EmptyMessage.newBuilder().build());
        }
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
        builder.setNum(blockNum);
        return this.walletBlockingStub.getBlockByNum(builder.build());
    }

    public Optional<GrpcAPI.NodeList> listNodes() {
        GrpcAPI.NodeList nodeList = this.walletBlockingStub.listNodes(GrpcAPI.EmptyMessage.newBuilder().build());
        if (nodeList != null) {
            return Optional.of(nodeList);
        }
        return Optional.empty();
    }

    public Optional<GrpcAPI.AssetIssueList> getAssetIssueByAccount(byte[] address) {
        ByteString addressByteString = ByteString.copyFrom((byte[])address);
        Protocol.Account request = Protocol.Account.newBuilder().setAddress(addressByteString).build();
        GrpcAPI.AssetIssueList assetIssueList = this.walletBlockingStub.getAssetIssueByAccount(request);
        if (assetIssueList != null) {
            return Optional.of(assetIssueList);
        }
        return Optional.empty();
    }

    public AssetIssueContractOuterClass.AssetIssueContract getAssetIssueByName(String assetName) {
        ByteString assetNameBs = ByteString.copyFrom((byte[])assetName.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetNameBs).build();
        return this.walletBlockingStub.getAssetIssueByName(request);
    }

    public Optional<GrpcAPI.AssetIssueList> getAssetIssueListByName(String assetName) {
        ByteString assetNameBs = ByteString.copyFrom((byte[])assetName.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetNameBs).build();
        GrpcAPI.AssetIssueList assetIssueList = this.walletBlockingStub.getAssetIssueListByName(request);
        if (assetIssueList != null) {
            return Optional.of(assetIssueList);
        }
        return Optional.empty();
    }

    public AssetIssueContractOuterClass.AssetIssueContract getAssetIssueById(String assetId) {
        ByteString assetIdBs = ByteString.copyFrom((byte[])assetId.getBytes());
        GrpcAPI.BytesMessage request = GrpcAPI.BytesMessage.newBuilder().setValue(assetIdBs).build();
        return this.walletBlockingStub.getAssetIssueById(request);
    }
}

