/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.protos.Protocol;

public class DatabaseGrpcClient {
    private final ManagedChannel channel;
    private final DatabaseGrpc.DatabaseBlockingStub databaseBlockingStub;

    public DatabaseGrpcClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.databaseBlockingStub = DatabaseGrpc.newBlockingStub((Channel)this.channel);
    }

    public DatabaseGrpcClient(String host) {
        this.channel = ManagedChannelBuilder.forTarget((String)host).usePlaintext().build();
        this.databaseBlockingStub = DatabaseGrpc.newBlockingStub((Channel)this.channel);
    }

    public Protocol.Block getBlock(long blockNum) {
        if (blockNum < 0L) {
            return this.databaseBlockingStub.getNowBlock(GrpcAPI.EmptyMessage.newBuilder().build());
        }
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
        builder.setNum(blockNum);
        return this.databaseBlockingStub.getBlockByNum(builder.build());
    }

    public void shutdown() {
        this.channel.shutdown();
    }

    public Protocol.DynamicProperties getDynamicProperties() {
        return this.databaseBlockingStub.getDynamicProperties(GrpcAPI.EmptyMessage.newBuilder().build());
    }
}

