/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.backup.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.backup.BackupManager;
import org.tron.common.backup.socket.MessageHandler;
import org.tron.common.backup.socket.PacketDecoder;
import org.tron.common.parameter.CommonParameter;
import org.tron.p2p.stats.TrafficStats;

@Component
public class BackupServer {
    private static final Logger logger = LoggerFactory.getLogger((String)"backup");
    private CommonParameter commonParameter = CommonParameter.getInstance();
    private int port = this.commonParameter.getBackupPort();
    private BackupManager backupManager;
    private Channel channel;
    private volatile boolean shutdown = false;

    @Autowired
    public BackupServer(BackupManager backupManager) {
        this.backupManager = backupManager;
    }

    public void initServer() {
        if (this.port > 0 && this.commonParameter.getBackupMembers().size() > 0) {
            new Thread(() -> {
                try {
                    this.start();
                }
                catch (Exception e) {
                    logger.error("Start backup server failed, {}", (Throwable)e);
                }
            }, "BackupServer").start();
        }
    }

    private void start() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            while (!this.shutdown) {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

                    public void initChannel(NioDatagramChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{TrafficStats.udp});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
                        ch.pipeline().addLast(new ChannelHandler[]{new PacketDecoder()});
                        MessageHandler messageHandler = new MessageHandler(ch, BackupServer.this.backupManager);
                        BackupServer.this.backupManager.setMessageHandler(messageHandler);
                        ch.pipeline().addLast(new ChannelHandler[]{messageHandler});
                    }
                });
                this.channel = b.bind(this.port).sync().channel();
                logger.info("Backup server started, bind port {}", (Object)this.port);
                this.channel.closeFuture().sync();
                if (this.shutdown) {
                    logger.info("Shutdown backup BackupServer");
                    break;
                }
                logger.warn("Restart backup server ...");
            }
        }
        catch (Exception e) {
            logger.error("Start backup server with port {} failed.", (Object)this.port, (Object)e);
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    public void close() {
        logger.info("Closing backup server...");
        this.shutdown = true;
        if (this.channel != null) {
            try {
                this.channel.close().await(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.warn("Closing backup server failed.", (Throwable)e);
            }
        }
    }
}

