/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.backup;

import io.netty.util.internal.ConcurrentSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.backup.message.KeepAliveMessage;
import org.tron.common.backup.message.Message;
import org.tron.common.backup.message.UdpMessageTypeEnum;
import org.tron.common.backup.socket.EventHandler;
import org.tron.common.backup.socket.MessageHandler;
import org.tron.common.backup.socket.UdpEvent;
import org.tron.common.parameter.CommonParameter;

@Component
public class BackupManager
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"backup");
    private CommonParameter parameter = CommonParameter.getInstance();
    private int priority = this.parameter.getBackupPriority();
    private int port = this.parameter.getBackupPort();
    private int keepAliveInterval = this.parameter.getKeepAliveInterval();
    private int keepAliveTimeout = this.keepAliveInterval * 6;
    private String localIp = "";
    private Set<String> members = new ConcurrentSet();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private MessageHandler messageHandler;
    private BackupStatusEnum status = BackupStatusEnum.MASTER;
    private volatile long lastKeepAliveTime;
    private volatile boolean isInit = false;

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public BackupStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(BackupStatusEnum status) {
        logger.info("Change backup status to {}", (Object)status);
        this.status = status;
    }

    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        try {
            this.localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.warn("Failed to get local ip");
        }
        for (String member : this.parameter.getBackupMembers()) {
            if (this.localIp.equals(member)) continue;
            this.members.add(member);
        }
        logger.info("Backup localIp:{}, members: size= {}, {}", new Object[]{this.localIp, this.members.size(), this.members});
        this.setStatus(BackupStatusEnum.INIT);
        this.lastKeepAliveTime = System.currentTimeMillis();
        this.executorService.scheduleWithFixedDelay(() -> {
            try {
                if (!this.status.equals((Object)BackupStatusEnum.MASTER) && System.currentTimeMillis() - this.lastKeepAliveTime > (long)this.keepAliveTimeout) {
                    if (this.status.equals((Object)BackupStatusEnum.SLAVER)) {
                        this.setStatus(BackupStatusEnum.INIT);
                        this.lastKeepAliveTime = System.currentTimeMillis();
                    } else {
                        this.setStatus(BackupStatusEnum.MASTER);
                    }
                }
                if (this.status.equals((Object)BackupStatusEnum.SLAVER)) {
                    return;
                }
                this.members.forEach(member -> this.messageHandler.accept(new UdpEvent(new KeepAliveMessage(this.status.equals((Object)BackupStatusEnum.MASTER), this.priority), new InetSocketAddress((String)member, this.port))));
            }
            catch (Throwable t) {
                logger.error("Exception in send keep alive", t);
            }
        }, 1000L, this.keepAliveInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void handleEvent(UdpEvent udpEvent) {
        InetSocketAddress sender = udpEvent.getAddress();
        Message msg = udpEvent.getMessage();
        if (!msg.getType().equals((Object)UdpMessageTypeEnum.BACKUP_KEEP_ALIVE)) {
            logger.warn("Receive not keep alive message from {}, type {}", (Object)sender.getHostString(), (Object)msg.getType());
            return;
        }
        if (!this.members.contains(sender.getHostString())) {
            logger.warn("Receive keep alive message from {} is not my member", (Object)sender.getHostString());
            return;
        }
        this.lastKeepAliveTime = System.currentTimeMillis();
        KeepAliveMessage keepAliveMessage = (KeepAliveMessage)msg;
        int peerPriority = keepAliveMessage.getPriority();
        String peerIp = sender.getAddress().getHostAddress();
        if (this.status.equals((Object)BackupStatusEnum.INIT) && (keepAliveMessage.getFlag() || peerPriority > this.priority)) {
            this.setStatus(BackupStatusEnum.SLAVER);
            return;
        }
        if (this.status.equals((Object)BackupStatusEnum.MASTER) && keepAliveMessage.getFlag()) {
            if (peerPriority > this.priority) {
                this.setStatus(BackupStatusEnum.SLAVER);
            } else if (peerPriority == this.priority && this.localIp.compareTo(peerIp) < 0) {
                this.setStatus(BackupStatusEnum.SLAVER);
            }
        }
    }

    @Override
    public void channelActivated() {
        this.init();
    }

    public static enum BackupStatusEnum {
        INIT,
        SLAVER,
        MASTER;

    }
}

