/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import org.tron.common.crypto.zksnark.Field;
import org.tron.common.crypto.zksnark.Fp2;
import org.tron.common.crypto.zksnark.Params;

public class Fp
implements Field<Fp> {
    static final Fp ZERO = new Fp(BigInteger.ZERO);
    static final Fp _1 = new Fp(BigInteger.ONE);
    static final Fp NON_RESIDUE = new Fp(new BigInteger("21888242871839275222246405745257275088696311157297823662689037894645226208582"));
    static final Fp _2_INV = new Fp(BigInteger.valueOf(2L).modInverse(Params.P));
    BigInteger v;

    Fp(BigInteger v) {
        this.v = v;
    }

    static Fp create(byte[] v) {
        return new Fp(new BigInteger(1, v));
    }

    static Fp create(BigInteger v) {
        return new Fp(v);
    }

    @Override
    public Fp add(Fp o) {
        return new Fp(this.v.add(o.v).mod(Params.P));
    }

    @Override
    public Fp mul(Fp o) {
        return new Fp(this.v.multiply(o.v).mod(Params.P));
    }

    @Override
    public Fp sub(Fp o) {
        return new Fp(this.v.subtract(o.v).mod(Params.P));
    }

    @Override
    public Fp squared() {
        return new Fp(this.v.multiply(this.v).mod(Params.P));
    }

    @Override
    public Fp dbl() {
        return new Fp(this.v.add(this.v).mod(Params.P));
    }

    @Override
    public Fp inverse() {
        return new Fp(this.v.modInverse(Params.P));
    }

    @Override
    public Fp negate() {
        return new Fp(this.v.negate().mod(Params.P));
    }

    @Override
    public boolean isZero() {
        return this.v.compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public boolean isValid() {
        return this.v.compareTo(Params.P) < 0;
    }

    @Override
    Fp2 mul(Fp2 o) {
        return new Fp2(o.a.mul(this), o.b.mul(this));
    }

    public byte[] bytes() {
        return this.v.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fp fp = (Fp)o;
        return !(this.v == null ? fp.v != null : this.v.compareTo(fp.v) != 0);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    public String toString() {
        return this.v.toString();
    }
}

