/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import org.tron.common.crypto.zksnark.BN128;
import org.tron.common.crypto.zksnark.Fp;
import org.tron.common.crypto.zksnark.Params;

public class BN128Fp
extends BN128<Fp> {
    static final BN128<Fp> ZERO = new BN128Fp(Fp.ZERO, Fp.ZERO, Fp.ZERO);

    protected BN128Fp(Fp x, Fp y, Fp z) {
        super(x, y, z);
    }

    public static BN128<Fp> create(byte[] xx, byte[] yy) {
        Fp x = Fp.create(xx);
        Fp y = Fp.create(yy);
        if (x.isZero() && y.isZero()) {
            return ZERO;
        }
        BN128Fp p = new BN128Fp(x, y, Fp._1);
        if (p.isValid()) {
            return p;
        }
        return null;
    }

    @Override
    protected BN128<Fp> zero() {
        return ZERO;
    }

    @Override
    protected BN128<Fp> instance(Fp x, Fp y, Fp z) {
        return new BN128Fp(x, y, z);
    }

    @Override
    protected Fp b() {
        return Params.B_Fp;
    }

    @Override
    protected Fp one() {
        return Fp._1;
    }
}

