/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.pbft.message;

import com.google.protobuf.ByteString;
import java.util.List;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.Sha256Hash;
import org.tron.consensus.base.Param;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.protos.Protocol;

public class PbftMessage
extends PbftBaseMessage {
    public PbftMessage() {
    }

    public PbftMessage(byte[] data) throws Exception {
        super(MessageTypes.PBFT_MSG.asByte(), data);
    }

    @Override
    public String getNo() {
        return this.pbftMessage.getRawData().getViewN() + "_" + this.pbftMessage.getRawData().getDataType();
    }

    public static PbftMessage prePrepareBlockMsg(BlockCapsule block, long epoch, Param.Miner miner) {
        return PbftMessage.buildCommon(Protocol.PBFTMessage.DataType.BLOCK, block.getBlockId().getByteString(), block, epoch, block.getNum(), miner);
    }

    public static PbftMessage fullNodePrePrepareBlockMsg(BlockCapsule block, long epoch) {
        return PbftMessage.buildFullNodeCommon(Protocol.PBFTMessage.DataType.BLOCK, block.getBlockId().getByteString(), block, epoch, block.getNum());
    }

    public static PbftMessage prePrepareSRLMsg(BlockCapsule block, List<ByteString> currentWitness, long epoch, Param.Miner miner) {
        Protocol.SRL.Builder srListBuilder = Protocol.SRL.newBuilder();
        ByteString data = srListBuilder.addAllSrAddress(currentWitness).build().toByteString();
        return PbftMessage.buildCommon(Protocol.PBFTMessage.DataType.SRL, data, block, epoch, epoch, miner);
    }

    public static PbftMessage fullNodePrePrepareSRLMsg(BlockCapsule block, List<ByteString> currentWitness, long epoch) {
        Protocol.SRL.Builder srListBuilder = Protocol.SRL.newBuilder();
        ByteString data = srListBuilder.addAllSrAddress(currentWitness).build().toByteString();
        return PbftMessage.buildFullNodeCommon(Protocol.PBFTMessage.DataType.SRL, data, block, epoch, epoch);
    }

    private static PbftMessage buildCommon(Protocol.PBFTMessage.DataType dataType, ByteString data, BlockCapsule block, long epoch, long viewN, Param.Miner miner) {
        PbftMessage pbftMessage = new PbftMessage();
        ECKey ecKey = ECKey.fromPrivate((byte[])miner.getPrivateKey());
        Protocol.PBFTMessage.Raw.Builder rawBuilder = Protocol.PBFTMessage.Raw.newBuilder();
        Protocol.PBFTMessage.Builder builder = Protocol.PBFTMessage.newBuilder();
        rawBuilder.setViewN(viewN).setEpoch(epoch).setDataType(dataType).setMsgType(Protocol.PBFTMessage.MsgType.PREPREPARE).setData(data);
        Protocol.PBFTMessage.Raw raw2 = rawBuilder.build();
        byte[] hash = Sha256Hash.hash((boolean)true, (byte[])raw2.toByteArray());
        ECKey.ECDSASignature signature = ecKey.sign(hash);
        builder.setRawData(raw2).setSignature(ByteString.copyFrom((byte[])signature.toByteArray()));
        Protocol.PBFTMessage message = builder.build();
        pbftMessage.setType(MessageTypes.PBFT_MSG.asByte()).setPbftMessage(message).setData(message.toByteArray()).setSwitch(block.isSwitch());
        return pbftMessage;
    }

    private static PbftMessage buildFullNodeCommon(Protocol.PBFTMessage.DataType dataType, ByteString data, BlockCapsule block, long epoch, long viewN) {
        PbftMessage pbftMessage = new PbftMessage();
        Protocol.PBFTMessage.Raw.Builder rawBuilder = Protocol.PBFTMessage.Raw.newBuilder();
        Protocol.PBFTMessage.Builder builder = Protocol.PBFTMessage.newBuilder();
        rawBuilder.setViewN(viewN).setEpoch(epoch).setDataType(dataType).setMsgType(Protocol.PBFTMessage.MsgType.PREPREPARE).setData(data);
        Protocol.PBFTMessage.Raw raw2 = rawBuilder.build();
        builder.setRawData(raw2);
        Protocol.PBFTMessage message = builder.build();
        pbftMessage.setType(MessageTypes.PBFT_MSG.asByte()).setPbftMessage(message).setData(message.toByteArray()).setSwitch(block.isSwitch());
        return pbftMessage;
    }

    public PbftMessage buildPrePareMessage(Param.Miner miner) {
        return this.buildMessageCapsule(Protocol.PBFTMessage.MsgType.PREPARE, miner);
    }

    public PbftMessage buildCommitMessage(Param.Miner miner) {
        return this.buildMessageCapsule(Protocol.PBFTMessage.MsgType.COMMIT, miner);
    }

    private PbftMessage buildMessageCapsule(Protocol.PBFTMessage.MsgType type, Param.Miner miner) {
        PbftMessage pbftMessage = new PbftMessage();
        ECKey ecKey = ECKey.fromPrivate((byte[])miner.getPrivateKey());
        Protocol.PBFTMessage.Builder builder = Protocol.PBFTMessage.newBuilder();
        Protocol.PBFTMessage.Raw.Builder rawBuilder = Protocol.PBFTMessage.Raw.newBuilder();
        rawBuilder.setViewN(this.getPbftMessage().getRawData().getViewN()).setDataType(this.getPbftMessage().getRawData().getDataType()).setMsgType(type).setEpoch(this.getPbftMessage().getRawData().getEpoch()).setData(this.getPbftMessage().getRawData().getData());
        Protocol.PBFTMessage.Raw raw2 = rawBuilder.build();
        byte[] hash = Sha256Hash.hash((boolean)true, (byte[])raw2.toByteArray());
        ECKey.ECDSASignature signature = ecKey.sign(hash);
        builder.setRawData(raw2).setSignature(ByteString.copyFrom((byte[])signature.toByteArray()));
        Protocol.PBFTMessage message = builder.build();
        pbftMessage.setType(this.getType().asByte()).setPbftMessage(message).setData(message.toByteArray());
        return pbftMessage;
    }
}

