/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.pbft;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicLongMap;
import com.google.protobuf.ByteString;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.base.Param;
import org.tron.consensus.dpos.MaintenanceManager;
import org.tron.consensus.pbft.PbftMessageAction;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.ChainBaseManager;
import org.tron.protos.Protocol;

@Component
public class PbftMessageHandle {
    private static final Logger logger = LoggerFactory.getLogger((String)"pbft");
    public static final int TIME_OUT = 60000;
    private Set<String> preVotes = Sets.newConcurrentHashSet();
    private Map<String, PbftMessage> pareVoteMap = Maps.newConcurrentMap();
    private AtomicLongMap<String> agreePare = AtomicLongMap.create();
    private Cache<String, PbftMessage> pareMsgCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private Map<String, PbftMessage> commitVoteMap = Maps.newConcurrentMap();
    private AtomicLongMap<String> agreeCommit = AtomicLongMap.create();
    private Cache<String, PbftMessage> commitMsgCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
    private Map<String, Long> timeOuts = Maps.newConcurrentMap();
    private Map<String, PbftMessage> doneMsg = Maps.newConcurrentMap();
    private LoadingCache<String, List<ByteString>> dataSignCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<ByteString>>(){

        public List<ByteString> load(String s) throws Exception {
            return new ArrayList<ByteString>();
        }
    });
    private PbftMessage srPbftMessage;
    private Timer timer = new Timer("pbft-timer");
    @Autowired
    private PbftMessageAction pbftMessageAction;
    private MaintenanceManager maintenanceManager;
    @Autowired
    private ChainBaseManager chainBaseManager;

    @PostConstruct
    public void init() {
        this.start();
    }

    @PreDestroy
    public void close() {
        try {
            this.timer.cancel();
            this.timer = null;
        }
        catch (Exception e) {
            logger.warn("pbft-timer cancel error", (Throwable)e);
        }
    }

    public List<Param.Miner> getSrMinerList(long epoch) {
        List<ByteString> compareList = epoch > this.maintenanceManager.getBeforeMaintenanceTime() ? this.maintenanceManager.getCurrentWitness() : this.maintenanceManager.getBeforeWitness();
        return Param.getInstance().getMiners().stream().filter(miner -> compareList.contains(miner.getWitnessAddress())).collect(Collectors.toList());
    }

    public void onPrePrepare(PbftMessage message) {
        String key = message.getNo();
        if (message.isSwitch()) {
            logger.warn("block chain switch, again proposal block num: {}, data: {}", (Object)message.getNumber(), (Object)message.getDataString());
            this.remove(key);
            return;
        }
        if (this.preVotes.contains(key)) {
            return;
        }
        this.preVotes.add(key);
        this.timeOuts.put(key, System.currentTimeMillis());
        this.checkPrepareMsgCache(key);
        long epoch = message.getPbftMessage().getRawData().getEpoch();
        if (!this.checkIsCanSendMsg(epoch)) {
            return;
        }
        for (Param.Miner miner : this.getSrMinerList(epoch)) {
            PbftMessage paMessage = message.buildPrePareMessage(miner);
            this.forwardMessage(paMessage);
            try {
                paMessage.analyzeSignature();
            }
            catch (SignatureException e) {
                logger.error("", (Throwable)e);
            }
            this.onPrepare(paMessage);
        }
        if (message.getDataType() == Protocol.PBFTMessage.DataType.SRL) {
            this.srPbftMessage = message;
        }
    }

    public synchronized void onPrepare(PbftMessage message) {
        long agCou;
        String key = message.getKey();
        if (!this.preVotes.contains(message.getNo())) {
            this.pareMsgCache.put((Object)key, (Object)message);
            return;
        }
        if (this.pareVoteMap.containsKey(key)) {
            if (!this.pareVoteMap.get(key).getPbftMessage().getRawData().getData().equals((Object)message.getPbftMessage().getRawData().getData())) {
                // empty if block
            }
            return;
        }
        this.pareVoteMap.put(key, message);
        this.checkCommitMsgCache(message.getNo());
        long epoch = message.getPbftMessage().getRawData().getEpoch();
        if (!this.checkIsCanSendMsg(epoch)) {
            return;
        }
        if (!this.doneMsg.containsKey(message.getNo()) && (agCou = this.agreePare.incrementAndGet((Object)message.getDataKey())) >= (long)Param.getInstance().getAgreeNodeCount()) {
            this.agreePare.remove((Object)message.getDataKey());
            for (Param.Miner miner : this.getSrMinerList(epoch)) {
                PbftMessage cmMessage = message.buildCommitMessage(miner);
                this.doneMsg.put(message.getNo(), cmMessage);
                this.forwardMessage(cmMessage);
                try {
                    cmMessage.analyzeSignature();
                }
                catch (SignatureException e) {
                    logger.error("", (Throwable)e);
                }
                this.onCommit(cmMessage);
            }
        }
    }

    public synchronized void onCommit(PbftMessage message) {
        String key = message.getKey();
        if (!this.pareVoteMap.containsKey(key)) {
            this.commitMsgCache.put((Object)key, (Object)message);
            return;
        }
        if (this.commitVoteMap.containsKey(key)) {
            if (!this.commitVoteMap.get(key).getPbftMessage().getRawData().getData().equals((Object)message.getPbftMessage().getRawData().getData())) {
                // empty if block
            }
            return;
        }
        this.commitVoteMap.put(key, message);
        long agCou = this.agreeCommit.incrementAndGet((Object)message.getDataKey());
        ((List)this.dataSignCache.getUnchecked((Object)message.getDataKey())).add(message.getPbftMessage().getSignature());
        if (agCou >= (long)Param.getInstance().getAgreeNodeCount()) {
            this.srPbftMessage = null;
            this.remove(message.getNo());
            if (!this.isSyncing()) {
                this.pbftMessageAction.action(message, (List)this.dataSignCache.getUnchecked((Object)message.getDataKey()));
            }
        }
    }

    public void onRequestData(PbftBaseMessage message) {
    }

    public void onChangeView(PbftBaseMessage message) {
    }

    public void forwardMessage(PbftBaseMessage message) {
        Param.getInstance().getPbftInterface().forwardMessage(message);
    }

    private void checkPrepareMsgCache(String key) {
        for (Map.Entry entry : this.pareMsgCache.asMap().entrySet()) {
            if (!StringUtils.startsWith((CharSequence)((CharSequence)entry.getKey()), (CharSequence)key)) continue;
            this.pareMsgCache.invalidate(entry.getKey());
            this.onPrepare((PbftMessage)((Object)entry.getValue()));
        }
    }

    private void checkCommitMsgCache(String key) {
        for (Map.Entry entry : this.commitMsgCache.asMap().entrySet()) {
            if (!StringUtils.startsWith((CharSequence)((CharSequence)entry.getKey()), (CharSequence)key)) continue;
            this.commitMsgCache.invalidate(entry.getKey());
            this.onCommit((PbftMessage)((Object)entry.getValue()));
        }
    }

    public boolean checkIsCanSendMsg(long epoch) {
        if (!Param.getInstance().isEnable()) {
            return false;
        }
        if (this.getSrMinerList(epoch).isEmpty()) {
            return false;
        }
        return !this.isSyncing();
    }

    public boolean isSyncing() {
        return Param.getInstance().getPbftInterface().isSyncing();
    }

    private void remove(String no) {
        String pre = String.valueOf(no) + "_";
        this.preVotes.remove(no);
        this.pareVoteMap.keySet().removeIf(vp -> StringUtils.startsWith((CharSequence)vp, (CharSequence)pre));
        this.commitVoteMap.keySet().removeIf(vp -> StringUtils.startsWith((CharSequence)vp, (CharSequence)pre));
        this.agreePare.asMap().keySet().forEach(s -> {
            if (StringUtils.startsWith((CharSequence)s, (CharSequence)pre)) {
                long value = this.agreePare.remove(s);
                logger.debug("{} agreePare count:{}", (Object)no, (Object)value);
            }
        });
        this.agreeCommit.asMap().keySet().forEach(s -> {
            if (StringUtils.startsWith((CharSequence)s, (CharSequence)pre)) {
                long value = this.agreeCommit.remove(s);
                logger.debug("{} agreeCommit count:{}", (Object)no, (Object)value);
            }
        });
        this.doneMsg.remove(no);
        this.timeOuts.remove(no);
        if (this.srPbftMessage != null && StringUtils.equals((CharSequence)no, (CharSequence)this.srPbftMessage.getNo())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onPrePrepare(this.srPbftMessage);
            this.srPbftMessage = null;
        }
    }

    private void checkTimer() {
        for (Map.Entry<String, Long> item : this.timeOuts.entrySet()) {
            if (System.currentTimeMillis() - item.getValue() <= 60000L) continue;
            logger.info("vote will be invalid:{}", (Object)item.getKey());
            this.remove(item.getKey());
        }
    }

    public void start() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PbftMessageHandle.this.checkTimer();
            }
        }, 10L, 1000L);
    }

    public void setMaintenanceManager(MaintenanceManager maintenanceManager) {
        this.maintenanceManager = maintenanceManager;
    }
}

