/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.protobuf.ByteString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.ConsensusDelegate;
import org.tron.core.capsule.AccountCapsule;

@Component
public class IncentiveManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;

    public void reward(List<ByteString> witnesses) {
        if (this.consensusDelegate.allowChangeDelegation()) {
            return;
        }
        if (witnesses.size() > 127) {
            witnesses = witnesses.subList(0, 127);
        }
        long voteSum = 0L;
        for (ByteString witness : witnesses) {
            voteSum += this.consensusDelegate.getWitness(witness.toByteArray()).getVoteCount();
        }
        if (voteSum <= 0L) {
            return;
        }
        long totalPay = this.consensusDelegate.getWitnessStandbyAllowance();
        for (ByteString witness : witnesses) {
            byte[] address = witness.toByteArray();
            long pay = (long)((double)this.consensusDelegate.getWitness(address).getVoteCount() * ((double)totalPay / (double)voteSum));
            AccountCapsule accountCapsule = this.consensusDelegate.getAccount(address);
            accountCapsule.setAllowance(accountCapsule.getAllowance() + pay);
            this.consensusDelegate.saveAccount(accountCapsule);
        }
    }
}

