/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.dpos.DposService;

@Component
public class DposSlot {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    private DposService dposService;

    public long getAbSlot(long time) {
        return (time - this.dposService.getGenesisBlockTime()) / 3000L;
    }

    public long getSlot(long time) {
        long firstSlotTime = this.getTime(1L);
        if (time < firstSlotTime) {
            return 0L;
        }
        return (time - firstSlotTime) / 3000L + 1L;
    }

    public long getTime(long slot) {
        if (slot == 0L) {
            return System.currentTimeMillis();
        }
        long interval = 3000L;
        if (this.consensusDelegate.getLatestBlockHeaderNumber() == 0L) {
            return this.dposService.getGenesisBlockTime() + slot * interval;
        }
        if (this.consensusDelegate.lastHeadBlockIsMaintenance()) {
            slot += this.consensusDelegate.getMaintenanceSkipSlots();
        }
        long time = this.consensusDelegate.getLatestBlockHeaderTimestamp();
        time -= (time - this.dposService.getGenesisBlockTime()) % interval;
        return time + interval * slot;
    }

    public ByteString getScheduledWitness(long slot) {
        long currentSlot = this.getAbSlot(this.consensusDelegate.getLatestBlockHeaderTimestamp()) + slot;
        if (currentSlot < 0L) {
            throw new RuntimeException("current slot should be positive.");
        }
        int size = this.consensusDelegate.getActiveWitnesses().size();
        if (size <= 0) {
            throw new RuntimeException("active witnesses is null.");
        }
        int witnessIndex = (int)currentSlot % (size * 1);
        return this.consensusDelegate.getActiveWitnesses().get(witnessIndex /= 1);
    }

    public void setDposService(DposService dposService) {
        this.dposService = dposService;
    }
}

