/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.args.GenesisBlock;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.base.BlockHandle;
import org.tron.consensus.base.ConsensusInterface;
import org.tron.consensus.base.Param;
import org.tron.consensus.dpos.DposSlot;
import org.tron.consensus.dpos.DposTask;
import org.tron.consensus.dpos.MaintenanceManager;
import org.tron.consensus.dpos.StateManager;
import org.tron.consensus.dpos.StatisticManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.WitnessCapsule;

@Component
public class DposService
implements ConsensusInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    @Autowired
    private DposTask dposTask;
    @Autowired
    private DposSlot dposSlot;
    @Autowired
    private StateManager stateManager;
    @Autowired
    private StatisticManager statisticManager;
    @Autowired
    private MaintenanceManager maintenanceManager;
    private volatile boolean needSyncCheck;
    private volatile boolean enable;
    private int minParticipationRate;
    private int blockProduceTimeoutPercent;
    private long genesisBlockTime;
    private BlockHandle blockHandle;
    private GenesisBlock genesisBlock;
    private Map<ByteString, Param.Miner> miners = new HashMap<ByteString, Param.Miner>();

    @Override
    public void start(Param param) {
        this.enable = param.isEnable();
        this.needSyncCheck = param.isNeedSyncCheck();
        this.minParticipationRate = param.getMinParticipationRate();
        this.blockProduceTimeoutPercent = param.getBlockProduceTimeoutPercent();
        this.blockHandle = param.getBlockHandle();
        this.genesisBlock = param.getGenesisBlock();
        this.genesisBlockTime = Long.parseLong(param.getGenesisBlock().getTimestamp());
        param.getMiners().forEach(miner -> this.miners.put(miner.getWitnessAddress(), (Param.Miner)miner));
        this.dposTask.setDposService(this);
        this.dposSlot.setDposService(this);
        this.stateManager.setDposService(this);
        this.maintenanceManager.setDposService(this);
        if (this.consensusDelegate.getLatestBlockHeaderNumber() == 0L) {
            ArrayList<ByteString> witnesses = new ArrayList<ByteString>();
            this.consensusDelegate.getAllWitnesses().forEach(witnessCapsule -> witnesses.add(witnessCapsule.getAddress()));
            this.updateWitness(witnesses);
            List<ByteString> addresses = this.consensusDelegate.getActiveWitnesses();
            addresses.forEach(address -> {
                WitnessCapsule witnessCapsule = this.consensusDelegate.getWitness(address.toByteArray());
                witnessCapsule.setIsJobs(true);
                this.consensusDelegate.saveWitness(witnessCapsule);
            });
        }
        this.maintenanceManager.init();
        this.dposTask.init();
    }

    @Override
    public void stop() {
        this.dposTask.stop();
    }

    @Override
    public void receiveBlock(BlockCapsule blockCapsule) {
        this.stateManager.receiveBlock(blockCapsule);
    }

    @Override
    public boolean validBlock(BlockCapsule blockCapsule) {
        long hSlot;
        if (this.consensusDelegate.getLatestBlockHeaderNumber() == 0L) {
            return true;
        }
        ByteString witnessAddress = blockCapsule.getWitnessAddress();
        long timeStamp = blockCapsule.getTimeStamp();
        long bSlot = this.dposSlot.getAbSlot(timeStamp);
        if (bSlot <= (hSlot = this.dposSlot.getAbSlot(this.consensusDelegate.getLatestBlockHeaderTimestamp()))) {
            logger.warn("ValidBlock failed: bSlot: {} <= hSlot: {}", (Object)bSlot, (Object)hSlot);
            return false;
        }
        long slot = this.dposSlot.getSlot(timeStamp);
        ByteString scheduledWitness = this.dposSlot.getScheduledWitness(slot);
        if (!scheduledWitness.equals((Object)witnessAddress)) {
            logger.warn("ValidBlock failed: sWitness: {}, bWitness: {}, bTimeStamp: {}, slot: {}", new Object[]{ByteArray.toHexString((byte[])scheduledWitness.toByteArray()), ByteArray.toHexString((byte[])witnessAddress.toByteArray()), new DateTime(timeStamp), slot});
            return false;
        }
        return true;
    }

    @Override
    public boolean applyBlock(BlockCapsule blockCapsule) {
        this.statisticManager.applyBlock(blockCapsule);
        this.maintenanceManager.applyBlock(blockCapsule);
        this.updateSolidBlock();
        return true;
    }

    private void updateSolidBlock() {
        long oldSolidNum;
        long size;
        int position;
        List numbers = this.consensusDelegate.getActiveWitnesses().stream().map(address -> this.consensusDelegate.getWitness(address.toByteArray()).getLatestBlockNum()).sorted().collect(Collectors.toList());
        long newSolidNum = (Long)numbers.get(position = (int)((double)(size = (long)this.consensusDelegate.getActiveWitnesses().size()) * 0.30000000000000004));
        if (newSolidNum < (oldSolidNum = this.consensusDelegate.getLatestSolidifiedBlockNum())) {
            logger.warn("Update solid block number failed, new: {} < old: {}", (Object)newSolidNum, (Object)oldSolidNum);
            return;
        }
        CommonParameter.getInstance().setOldSolidityBlockNum(this.consensusDelegate.getLatestSolidifiedBlockNum());
        this.consensusDelegate.saveLatestSolidifiedBlockNum(newSolidNum);
        logger.info("Update solid block number to {}", (Object)newSolidNum);
    }

    public void updateWitness(List<ByteString> list) {
        list.sort(Comparator.comparingLong(b -> this.consensusDelegate.getWitness(b.toByteArray()).getVoteCount()).reversed().thenComparing(Comparator.comparingInt(ByteString::hashCode).reversed()));
        if (list.size() > 27) {
            this.consensusDelegate.saveActiveWitnesses(list.subList(0, 27));
        } else {
            this.consensusDelegate.saveActiveWitnesses(list);
        }
    }

    public boolean isNeedSyncCheck() {
        return this.needSyncCheck;
    }

    public void setNeedSyncCheck(boolean needSyncCheck) {
        this.needSyncCheck = needSyncCheck;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public int getMinParticipationRate() {
        return this.minParticipationRate;
    }

    public int getBlockProduceTimeoutPercent() {
        return this.blockProduceTimeoutPercent;
    }

    public long getGenesisBlockTime() {
        return this.genesisBlockTime;
    }

    public BlockHandle getBlockHandle() {
        return this.blockHandle;
    }

    public GenesisBlock getGenesisBlock() {
        return this.genesisBlock;
    }

    public Map<ByteString, Param.Miner> getMiners() {
        return this.miners;
    }
}

