/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.io.Serializable;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.tron.common.utils.FastByteComparisons;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper>,
Serializable {
    private static final long serialVersionUID = -8645797230368480951L;
    private final byte[] data;
    private int hashCode = 0;

    public ByteArrayWrapper(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.data = data;
        this.hashCode = Arrays.hashCode(data);
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        byte[] otherData = ((ByteArrayWrapper)other).getData();
        return FastByteComparisons.compareTo(this.data, 0, this.data.length, otherData, 0, otherData.length) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        return FastByteComparisons.compareTo(this.data, 0, this.data.length, o.getData(), 0, o.getData().length);
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return Hex.toHexString((byte[])this.data);
    }
}

