/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;
import org.tron.common.cache.CacheStrategies;
import org.tron.common.cache.CacheType;
import org.tron.common.utils.DbOptionalsUtils;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.Property;

public class Storage {
    private static final String DB_DIRECTORY_CONFIG_KEY = "storage.db.directory";
    private static final String DB_ENGINE_CONFIG_KEY = "storage.db.engine";
    private static final String DB_SYNC_CONFIG_KEY = "storage.db.sync";
    private static final String INDEX_DIRECTORY_CONFIG_KEY = "storage.index.directory";
    private static final String INDEX_SWITCH_CONFIG_KEY = "storage.index.switch";
    private static final String TRANSACTIONHISTORY_SWITCH_CONFIG_KEY = "storage.transHistory.switch";
    private static final String ESTIMATED_TRANSACTIONS_CONFIG_KEY = "storage.txCache.estimatedTransactions";
    private static final String SNAPSHOT_MAX_FLUSH_COUNT_CONFIG_KEY = "storage.snapshot.maxFlushCount";
    private static final String PROPERTIES_CONFIG_KEY = "storage.properties";
    private static final String PROPERTIES_CONFIG_DB_KEY = "storage";
    private static final String PROPERTIES_CONFIG_DEFAULT_KEY = "default";
    private static final String PROPERTIES_CONFIG_DEFAULT_M_KEY = "defaultM";
    private static final String PROPERTIES_CONFIG_DEFAULT_L_KEY = "defaultL";
    private static final String DEFAULT_TRANSACTIONHISTORY_SWITCH = "on";
    private static final String NAME_CONFIG_KEY = "name";
    private static final String PATH_CONFIG_KEY = "path";
    private static final String CREATE_IF_MISSING_CONFIG_KEY = "createIfMissing";
    private static final String PARANOID_CHECKS_CONFIG_KEY = "paranoidChecks";
    private static final String VERITY_CHECK_SUMS_CONFIG_KEY = "verifyChecksums";
    private static final String COMPRESSION_TYPE_CONFIG_KEY = "compressionType";
    private static final String BLOCK_SIZE_CONFIG_KEY = "blockSize";
    private static final String WRITE_BUFFER_SIZE_CONFIG_KEY = "writeBufferSize";
    private static final String CACHE_SIZE_CONFIG_KEY = "cacheSize";
    private static final String MAX_OPEN_FILES_CONFIG_KEY = "maxOpenFiles";
    private static final String EVENT_SUBSCRIBE_CONTRACT_PARSE = "event.subscribe.contractParse";
    private static final String CHECKPOINT_VERSION_KEY = "storage.checkpoint.version";
    private static final String CHECKPOINT_SYNC_KEY = "storage.checkpoint.sync";
    private static final String CACHE_STRATEGIES = "storage.cache.strategies";
    private static final String DEFAULT_DB_ENGINE = "LEVELDB";
    private static final boolean DEFAULT_DB_SYNC = false;
    private static final boolean DEFAULT_EVENT_SUBSCRIBE_CONTRACT_PARSE = true;
    private static final String DEFAULT_DB_DIRECTORY = "database";
    private static final String DEFAULT_INDEX_DIRECTORY = "index";
    private static final String DEFAULT_INDEX_SWITCH = "on";
    private static final int DEFAULT_CHECKPOINT_VERSION = 1;
    private static final boolean DEFAULT_CHECKPOINT_SYNC = true;
    private static final int DEFAULT_ESTIMATED_TRANSACTIONS = 1000;
    private static final int DEFAULT_SNAPSHOT_MAX_FLUSH_COUNT = 1;
    private Config storage;
    private String dbDirectory;
    private String dbEngine;
    private boolean dbSync;
    private int maxFlushCount;
    private String indexDirectory;
    private String indexSwitch;
    private boolean contractParseSwitch;
    private String transactionHistorySwitch;
    private int checkpointVersion;
    private boolean checkpointSync;
    private Options defaultDbOptions;
    private int estimatedBlockTransactions;
    private final Map<CacheType, String> cacheStrategies = Maps.newConcurrentMap();
    private final List<String> cacheDbs = CacheStrategies.CACHE_DBS;
    private Map<String, Property> propertyMap;

    public static String getDbEngineFromConfig(Config config) {
        return config.hasPath(DB_ENGINE_CONFIG_KEY) ? config.getString(DB_ENGINE_CONFIG_KEY) : DEFAULT_DB_ENGINE;
    }

    public static Boolean getDbVersionSyncFromConfig(Config config) {
        return config.hasPath(DB_SYNC_CONFIG_KEY) ? config.getBoolean(DB_SYNC_CONFIG_KEY) : false;
    }

    public static int getSnapshotMaxFlushCountFromConfig(Config config) {
        if (!config.hasPath(SNAPSHOT_MAX_FLUSH_COUNT_CONFIG_KEY)) {
            return 1;
        }
        int maxFlushCountConfig = config.getInt(SNAPSHOT_MAX_FLUSH_COUNT_CONFIG_KEY);
        if (maxFlushCountConfig <= 0) {
            throw new IllegalArgumentException("MaxFlushCount value can not be negative or zero!");
        }
        if (maxFlushCountConfig > 500) {
            throw new IllegalArgumentException("MaxFlushCount value must not exceed 500!");
        }
        return maxFlushCountConfig;
    }

    public static Boolean getContractParseSwitchFromConfig(Config config) {
        return config.hasPath(EVENT_SUBSCRIBE_CONTRACT_PARSE) ? config.getBoolean(EVENT_SUBSCRIBE_CONTRACT_PARSE) : true;
    }

    public static String getDbDirectoryFromConfig(Config config) {
        return config.hasPath(DB_DIRECTORY_CONFIG_KEY) ? config.getString(DB_DIRECTORY_CONFIG_KEY) : DEFAULT_DB_DIRECTORY;
    }

    public static String getIndexDirectoryFromConfig(Config config) {
        return config.hasPath(INDEX_DIRECTORY_CONFIG_KEY) ? config.getString(INDEX_DIRECTORY_CONFIG_KEY) : DEFAULT_INDEX_DIRECTORY;
    }

    public static String getIndexSwitchFromConfig(Config config) {
        return config.hasPath(INDEX_SWITCH_CONFIG_KEY) && StringUtils.isNotEmpty((CharSequence)config.getString(INDEX_SWITCH_CONFIG_KEY)) ? config.getString(INDEX_SWITCH_CONFIG_KEY) : "on";
    }

    public static String getTransactionHistorySwitchFromConfig(Config config) {
        return config.hasPath(TRANSACTIONHISTORY_SWITCH_CONFIG_KEY) ? config.getString(TRANSACTIONHISTORY_SWITCH_CONFIG_KEY) : "on";
    }

    public static int getCheckpointVersionFromConfig(Config config) {
        return config.hasPath(CHECKPOINT_VERSION_KEY) ? config.getInt(CHECKPOINT_VERSION_KEY) : 1;
    }

    public static boolean getCheckpointSyncFromConfig(Config config) {
        return config.hasPath(CHECKPOINT_SYNC_KEY) ? config.getBoolean(CHECKPOINT_SYNC_KEY) : true;
    }

    public static int getEstimatedTransactionsFromConfig(Config config) {
        if (!config.hasPath(ESTIMATED_TRANSACTIONS_CONFIG_KEY)) {
            return 1000;
        }
        int estimatedTransactions = config.getInt(ESTIMATED_TRANSACTIONS_CONFIG_KEY);
        if (estimatedTransactions > 10000) {
            estimatedTransactions = 10000;
        } else if (estimatedTransactions < 100) {
            estimatedTransactions = 100;
        }
        return estimatedTransactions;
    }

    public void setCacheStrategies(Config config) {
        if (config.hasPath(CACHE_STRATEGIES)) {
            config.getConfig(CACHE_STRATEGIES).resolve().entrySet().forEach(c -> this.cacheStrategies.put(CacheType.valueOf((String)c.getKey()), ((ConfigValue)c.getValue()).unwrapped().toString()));
        }
    }

    public String getCacheStrategy(CacheType dbName) {
        return this.cacheStrategies.getOrDefault((Object)dbName, CacheStrategies.getCacheStrategy(dbName));
    }

    private Property createProperty(ConfigObject conf) {
        Property property = new Property();
        if (!conf.containsKey((Object)NAME_CONFIG_KEY)) {
            throw new IllegalArgumentException("[storage.properties] database name must be set.");
        }
        property.setName(conf.get((Object)NAME_CONFIG_KEY).unwrapped().toString());
        if (conf.containsKey((Object)PATH_CONFIG_KEY)) {
            String path = conf.get((Object)PATH_CONFIG_KEY).unwrapped().toString();
            File file = new File(path);
            if (!file.exists() && !file.mkdirs()) {
                throw new IllegalArgumentException(String.format("[storage.properties] can not create storage path: %s", path));
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException(String.format("[storage.properties] permission denied to write to: %s ", path));
            }
            property.setPath(path);
        }
        Options dbOptions = this.newDefaultDbOptions(property.getName());
        Storage.setIfNeeded(conf, dbOptions);
        property.setDbOptions(dbOptions);
        return property;
    }

    private static void setIfNeeded(ConfigObject conf, Options dbOptions) {
        String param;
        if (conf.containsKey((Object)CREATE_IF_MISSING_CONFIG_KEY)) {
            dbOptions.createIfMissing(Boolean.parseBoolean(conf.get((Object)CREATE_IF_MISSING_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)PARANOID_CHECKS_CONFIG_KEY)) {
            dbOptions.paranoidChecks(Boolean.parseBoolean(conf.get((Object)PARANOID_CHECKS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)VERITY_CHECK_SUMS_CONFIG_KEY)) {
            dbOptions.verifyChecksums(Boolean.parseBoolean(conf.get((Object)VERITY_CHECK_SUMS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)COMPRESSION_TYPE_CONFIG_KEY)) {
            param = conf.get((Object)COMPRESSION_TYPE_CONFIG_KEY).unwrapped().toString();
            try {
                dbOptions.compressionType(CompressionType.getCompressionTypeByPersistentId((int)Integer.parseInt(param)));
            }
            catch (NumberFormatException e) {
                Storage.throwIllegalArgumentException(COMPRESSION_TYPE_CONFIG_KEY, Integer.class, param);
            }
        }
        if (conf.containsKey((Object)BLOCK_SIZE_CONFIG_KEY)) {
            param = conf.get((Object)BLOCK_SIZE_CONFIG_KEY).unwrapped().toString();
            try {
                dbOptions.blockSize(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                Storage.throwIllegalArgumentException(BLOCK_SIZE_CONFIG_KEY, Integer.class, param);
            }
        }
        if (conf.containsKey((Object)WRITE_BUFFER_SIZE_CONFIG_KEY)) {
            param = conf.get((Object)WRITE_BUFFER_SIZE_CONFIG_KEY).unwrapped().toString();
            try {
                dbOptions.writeBufferSize(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                Storage.throwIllegalArgumentException(WRITE_BUFFER_SIZE_CONFIG_KEY, Integer.class, param);
            }
        }
        if (conf.containsKey((Object)CACHE_SIZE_CONFIG_KEY)) {
            param = conf.get((Object)CACHE_SIZE_CONFIG_KEY).unwrapped().toString();
            try {
                dbOptions.cacheSize(Long.parseLong(param));
            }
            catch (NumberFormatException e) {
                Storage.throwIllegalArgumentException(CACHE_SIZE_CONFIG_KEY, Long.class, param);
            }
        }
        if (conf.containsKey((Object)MAX_OPEN_FILES_CONFIG_KEY)) {
            param = conf.get((Object)MAX_OPEN_FILES_CONFIG_KEY).unwrapped().toString();
            try {
                dbOptions.maxOpenFiles(Integer.parseInt(param));
            }
            catch (NumberFormatException e) {
                Storage.throwIllegalArgumentException(MAX_OPEN_FILES_CONFIG_KEY, Integer.class, param);
            }
        }
    }

    private static void throwIllegalArgumentException(String param, Class type, String actual) {
        throw new IllegalArgumentException(String.format("[storage.properties] %s must be %s type, actual: %s.", param, type.getSimpleName(), actual));
    }

    public void setPropertyMapFromConfig(Config config) {
        if (config.hasPath(PROPERTIES_CONFIG_KEY)) {
            this.propertyMap = config.getObjectList(PROPERTIES_CONFIG_KEY).stream().map(this::createProperty).collect(Collectors.toMap(Property::getName, p -> p));
        }
    }

    public void deleteAllStoragePaths() {
        if (this.propertyMap == null) {
            return;
        }
        for (Property property : this.propertyMap.values()) {
            String path = property.getPath();
            if (path == null) continue;
            FileUtil.recursiveDelete(path);
        }
    }

    public void setDefaultDbOptions(Config config) {
        this.defaultDbOptions = DbOptionalsUtils.createDefaultDbOptions();
        this.storage = config.getConfig(PROPERTIES_CONFIG_DB_KEY);
    }

    public Options newDefaultDbOptions(String name) {
        Options options = DbOptionalsUtils.newDefaultDbOptions(name, this.defaultDbOptions);
        if (this.storage.hasPath(PROPERTIES_CONFIG_DEFAULT_KEY)) {
            Storage.setIfNeeded(this.storage.getObject(PROPERTIES_CONFIG_DEFAULT_KEY), options);
        }
        if (this.storage.hasPath(PROPERTIES_CONFIG_DEFAULT_M_KEY) && DbOptionalsUtils.DB_M.contains(name)) {
            Storage.setIfNeeded(this.storage.getObject(PROPERTIES_CONFIG_DEFAULT_M_KEY), options);
        }
        if (this.storage.hasPath(PROPERTIES_CONFIG_DEFAULT_L_KEY) && DbOptionalsUtils.DB_L.contains(name)) {
            Storage.setIfNeeded(this.storage.getObject(PROPERTIES_CONFIG_DEFAULT_L_KEY), options);
        }
        return options;
    }

    public String getDbDirectory() {
        return this.dbDirectory;
    }

    public void setDbDirectory(String dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    public String getDbEngine() {
        return this.dbEngine;
    }

    public void setDbEngine(String dbEngine) {
        this.dbEngine = dbEngine;
    }

    public boolean isDbSync() {
        return this.dbSync;
    }

    public void setDbSync(boolean dbSync) {
        this.dbSync = dbSync;
    }

    public int getMaxFlushCount() {
        return this.maxFlushCount;
    }

    public void setMaxFlushCount(int maxFlushCount) {
        this.maxFlushCount = maxFlushCount;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getIndexSwitch() {
        return this.indexSwitch;
    }

    public void setIndexSwitch(String indexSwitch) {
        this.indexSwitch = indexSwitch;
    }

    public boolean isContractParseSwitch() {
        return this.contractParseSwitch;
    }

    public void setContractParseSwitch(boolean contractParseSwitch) {
        this.contractParseSwitch = contractParseSwitch;
    }

    public String getTransactionHistorySwitch() {
        return this.transactionHistorySwitch;
    }

    public void setTransactionHistorySwitch(String transactionHistorySwitch) {
        this.transactionHistorySwitch = transactionHistorySwitch;
    }

    public int getCheckpointVersion() {
        return this.checkpointVersion;
    }

    public void setCheckpointVersion(int checkpointVersion) {
        this.checkpointVersion = checkpointVersion;
    }

    public boolean isCheckpointSync() {
        return this.checkpointSync;
    }

    public void setCheckpointSync(boolean checkpointSync) {
        this.checkpointSync = checkpointSync;
    }

    public int getEstimatedBlockTransactions() {
        return this.estimatedBlockTransactions;
    }

    public void setEstimatedBlockTransactions(int estimatedBlockTransactions) {
        this.estimatedBlockTransactions = estimatedBlockTransactions;
    }

    public List<String> getCacheDbs() {
        return this.cacheDbs;
    }

    public Map<String, Property> getPropertyMap() {
        return this.propertyMap;
    }
}

