/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.Arrays;
import java.util.List;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;

public class DbOptionalsUtils {
    public static final CompressionType DEFAULT_COMPRESSION_TYPE = CompressionType.SNAPPY;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 0x1000000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE_M = 0x4000000;
    public static final long DEFAULT_CACHE_SIZE = 0x2000000L;
    public static final int DEFAULT_MAX_OPEN_FILES = 100;
    public static final int DEFAULT_MAX_OPEN_FILES_M = 100;
    public static final int DEFAULT_MAX_OPEN_FILES_L = 100;
    public static final List<String> DB_M = Arrays.asList("code", "contract");
    public static final List<String> DB_L = Arrays.asList("account", "delegation", "storage-row");

    private DbOptionalsUtils() {
        throw new IllegalStateException("DbOptionalsUtils class");
    }

    public static Options createDefaultDbOptions() {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(DEFAULT_COMPRESSION_TYPE);
        dbOptions.blockSize(4096);
        dbOptions.writeBufferSize(0x1000000);
        dbOptions.cacheSize(0x2000000L);
        dbOptions.maxOpenFiles(100);
        return dbOptions;
    }

    public static Options newDefaultDbOptions(String name, Options defaultOptions) {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(defaultOptions.createIfMissing());
        dbOptions.paranoidChecks(defaultOptions.paranoidChecks());
        dbOptions.verifyChecksums(defaultOptions.verifyChecksums());
        dbOptions.compressionType(defaultOptions.compressionType());
        dbOptions.blockSize(defaultOptions.blockSize());
        dbOptions.writeBufferSize(defaultOptions.writeBufferSize());
        dbOptions.cacheSize(defaultOptions.cacheSize());
        dbOptions.maxOpenFiles(defaultOptions.maxOpenFiles());
        if (DB_M.contains(name)) {
            DbOptionalsUtils.adjustDefaultDbOptionsForM(dbOptions);
        }
        if (DB_L.contains(name)) {
            DbOptionalsUtils.adjustDefaultDbOptionsForL(dbOptions);
        }
        return dbOptions;
    }

    private static void adjustDefaultDbOptionsForM(Options defaultOptions) {
        defaultOptions.maxOpenFiles(100);
        defaultOptions.writeBufferSize(0x4000000);
    }

    private static void adjustDefaultDbOptionsForL(Options defaultOptions) {
        defaultOptions.maxOpenFiles(100);
        defaultOptions.writeBufferSize(0x4000000);
    }
}

