/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.exception.JsonRpcInvalidParamsException;

public class ByteArray {
    private static final Logger logger = LoggerFactory.getLogger((String)"utils");

    public static String toHexString(byte[] data) {
        return data == null ? "" : Hex.toHexString((byte[])data);
    }

    public static byte[] fromHexString(String data) {
        if (data == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        if (data.startsWith("0x")) {
            data = data.substring(2);
        }
        if (data.length() % 2 != 0) {
            data = "0" + data;
        }
        return Hex.decode((String)data);
    }

    public static long toLong(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? 0L : new BigInteger(1, b).longValue();
    }

    public static int toInt(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? 0 : new BigInteger(1, b).intValue();
    }

    public static byte[] fromString(String s) {
        return StringUtils.isBlank((CharSequence)s) ? null : s.getBytes();
    }

    public static String toStr(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : new String(b);
    }

    public static byte[] fromLong(long val) {
        return Longs.toByteArray((long)val);
    }

    public static byte[] fromInt(int val) {
        return Ints.toByteArray((int)val);
    }

    public static byte[] fromObject(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("objectToByteArray failed: " + e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public static String toJsonHex(byte[] x) {
        return x == null || x.length == 0 ? "0x" : "0x" + Hex.toHexString((byte[])x);
    }

    public static String toJsonHexAddress(byte[] x) {
        if (x == null || x.length == 0) {
            return null;
        }
        String res = Hex.toHexString((byte[])x);
        if (res.startsWith(DecodeUtil.addressPreFixString)) {
            return "0x" + res.substring(DecodeUtil.addressPreFixString.length());
        }
        return "0x" + res;
    }

    public static String toJsonHex(Long x) {
        return x == null ? null : "0x" + Long.toHexString(x);
    }

    public static String toJsonHex(int x) {
        return ByteArray.toJsonHex(Long.valueOf(x));
    }

    public static String toJsonHex(String x) {
        return "0x" + x;
    }

    public static BigInteger hexToBigInteger(String input) {
        if (input.startsWith("0x")) {
            return new BigInteger(input.substring(2), 16);
        }
        return new BigInteger(input, 10);
    }

    public static long jsonHexToLong(String x) throws JsonRpcInvalidParamsException {
        if (!x.startsWith("0x")) {
            throw new JsonRpcInvalidParamsException("Incorrect hex syntax");
        }
        x = x.substring(2);
        return Long.parseLong(x, 16);
    }

    public static int jsonHexToInt(String x) throws Exception {
        if (!x.startsWith("0x")) {
            throw new Exception("Incorrect hex syntax");
        }
        x = x.substring(2);
        return Integer.parseInt(x, 16);
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static boolean isEmpty(byte[] input) {
        return input == null || input.length == 0;
    }

    public static boolean matrixContains(List<byte[]> source, byte[] obj) {
        for (byte[] sobj : source) {
            if (!Arrays.equals(sobj, obj)) continue;
            return true;
        }
        return false;
    }

    public static String fromHex(String x) {
        if (x.startsWith("0x")) {
            x = x.substring(2);
        }
        if (x.length() % 2 != 0) {
            x = "0" + x;
        }
        return x;
    }
}

