/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.prometheus;

import io.prometheus.client.Histogram;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.prometheus.Metrics;

public class MetricsHistogram {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private static final Map<String, Histogram> container = new ConcurrentHashMap<String, Histogram>();

    private MetricsHistogram() {
        throw new IllegalStateException("MetricsHistogram");
    }

    private static void init(String name, String help, String ... labels) {
        container.put(name, (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).help(help)).labelNames(labels)).register());
    }

    static Histogram.Timer startTimer(String key, String ... labels) {
        if (Metrics.enabled()) {
            Histogram histogram = container.get(key);
            if (histogram == null) {
                logger.info("{} not exist", (Object)key);
                return null;
            }
            return ((Histogram.Child)histogram.labels(labels)).startTimer();
        }
        return null;
    }

    static void observeDuration(Histogram.Timer startTimer) {
        if (startTimer != null) {
            startTimer.observeDuration();
        }
    }

    static void observe(String key, double amt, String ... labels) {
        if (Metrics.enabled()) {
            Histogram histogram = container.get(key);
            if (histogram == null) {
                logger.info("{} not exist", (Object)key);
                return;
            }
            ((Histogram.Child)histogram.labels(labels)).observe(amt);
        }
    }

    static {
        MetricsHistogram.init("tron:internal_service_latency_seconds", "Internal Service latency.", "class", "method");
        MetricsHistogram.init("tron:http_service_latency_seconds", "Http Service latency.", "url");
        MetricsHistogram.init("tron:grpc_service_latency_seconds", "Grpc Service latency.", "endpoint");
        MetricsHistogram.init("tron:jsonrpc_service_latency_seconds", "JsonRpc Service latency.", "method");
        MetricsHistogram.init("tron:miner_latency_seconds", "miner latency.", "miner");
        MetricsHistogram.init("tron:ping_pong_latency_seconds", "node  ping pong  latency.", new String[0]);
        MetricsHistogram.init("tron:verify_sign_latency_seconds", "verify sign latency for trx , block.", "type");
        MetricsHistogram.init("tron:lock_acquire_latency_seconds", "lock acquire latency.", "type");
        MetricsHistogram.init("tron:block_process_latency_seconds", "process block latency for TronNetDelegate.", "sync");
        MetricsHistogram.init("tron:block_push_latency_seconds", "push block latency for Manager.", new String[0]);
        MetricsHistogram.init("tron:block_generate_latency_seconds", "generate block latency.", "address");
        MetricsHistogram.init("tron:process_transaction_latency_seconds", "process transaction latency.", "type", "contract");
        MetricsHistogram.init("tron:miner_delay_seconds", "miner delay time, actualTime - planTime.", "miner");
        MetricsHistogram.init("tron:udp_bytes", "udp_bytes traffic.", "type");
        MetricsHistogram.init("tron:tcp_bytes", "tcp_bytes traffic.", "type");
        MetricsHistogram.init("tron:http_bytes", "http_bytes traffic.", "url", "status");
        MetricsHistogram.init("tron:message_process_latency_seconds", "process message latency.", "type");
        MetricsHistogram.init("tron:block_fetch_latency_seconds", "fetch block latency.", new String[0]);
        MetricsHistogram.init("tron:block_receive_delay_seconds", "receive block delay time, receiveTime - blockTime.", new String[0]);
    }
}

