/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterQuery {
    private static final Logger logger = LoggerFactory.getLogger(FilterQuery.class);
    public static final int EARLIEST_BLOCK_NUM = 0;
    public static final int LATEST_BLOCK_NUM = -1;
    public static final String EARLIEST = "earliest";
    public static final String LATEST = "latest";
    private long fromBlock;
    private long toBlock;
    private List<String> contractAddressList;
    private List<String> contractTopicList;

    public static long parseFromBlockNumber(String blockNum) {
        long number = 0L;
        if (StringUtils.isEmpty((CharSequence)blockNum) || EARLIEST.equalsIgnoreCase(blockNum)) {
            number = 0L;
        } else {
            try {
                number = Long.parseLong(blockNum);
            }
            catch (Exception e) {
                logger.error("invalid filter: fromBlockNumber: {}", (Object)blockNum);
                throw e;
            }
        }
        return number;
    }

    public static long parseToBlockNumber(String blockNum) {
        long number = 0L;
        if (StringUtils.isEmpty((CharSequence)blockNum) || LATEST.equalsIgnoreCase(blockNum)) {
            number = -1L;
        } else {
            try {
                number = Long.parseLong(blockNum);
            }
            catch (Exception e) {
                logger.error("invalid filter: toBlockNumber: {}", (Object)blockNum);
                throw e;
            }
        }
        return number;
    }

    public String toString() {
        return "fromBlock: " + this.fromBlock + ", toBlock: " + this.toBlock + ", contractAddress: " + this.contractAddressList + ", contractTopics: " + this.contractTopicList;
    }

    public long getFromBlock() {
        return this.fromBlock;
    }

    public void setFromBlock(long fromBlock) {
        this.fromBlock = fromBlock;
    }

    public long getToBlock() {
        return this.toBlock;
    }

    public void setToBlock(long toBlock) {
        this.toBlock = toBlock;
    }

    public List<String> getContractAddressList() {
        return this.contractAddressList;
    }

    public void setContractAddressList(List<String> contractAddressList) {
        this.contractAddressList = contractAddressList;
    }

    public List<String> getContractTopicList() {
        return this.contractTopicList;
    }

    public void setContractTopicList(List<String> contractTopicList) {
        this.contractTopicList = contractTopicList;
    }
}

