/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.cache;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.tron.common.cache.CacheType;

public class TronCache<K, V> {
    private final CacheType name;
    private final Cache<K, V> cache;

    TronCache(CacheType name, String strategy) {
        this.name = name;
        this.cache = CacheBuilder.from((String)strategy).build();
    }

    TronCache(CacheType name, String strategy, CacheLoader<K, V> loader) {
        this.name = name;
        this.cache = CacheBuilder.from((String)strategy).build(loader);
    }

    public void put(K k, V v) {
        this.cache.put(k, v);
    }

    public V getIfPresent(K k) {
        return (V)this.cache.getIfPresent(k);
    }

    public V get(K k, Callable<? extends V> loader) throws ExecutionException {
        return (V)this.cache.get(k, loader);
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TronCache tronCache = (TronCache)o;
        return Objects.equal((Object)((Object)this.name), (Object)((Object)tronCache.name));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public CacheType getName() {
        return this.name;
    }
}

