/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tron.common.cache.CacheType;

public class CacheStrategies {
    public static final String PATTERNS = "initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats";
    public static final List<CacheType> CACHE_BIG_DBS = Collections.singletonList(CacheType.delegation);
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final String CACHE_STRATEGY_DEFAULT = String.format("initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats", 1000, 1000, "30s", CPUS);
    private static final String CACHE_STRATEGY_SMALL_DEFAULT = String.format("initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats", 100, 100, "30s", CPUS);
    private static final List<CacheType> CACHE_SMALL_DBS = Arrays.asList(CacheType.recentBlock, CacheType.witness, CacheType.witnessSchedule, CacheType.delegatedResource, CacheType.delegatedResourceAccountIndex, CacheType.votes, CacheType.abi);
    private static final String CACHE_STRATEGY_NORMAL_DEFAULT = String.format("initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats", 500, 500, "30s", CPUS);
    private static final List<CacheType> CACHE_NORMAL_DBS = Arrays.asList(CacheType.code, CacheType.contract, CacheType.assetIssueV2, CacheType.properties);
    private static final String CACHE_STRATEGY_BIG_DEFAULT = String.format("initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats", 10000, 10000, "30s", CPUS);
    private static final String CACHE_STRATEGY_HUGE_DEFAULT = String.format("initialCapacity=%d,maximumSize=%d,expireAfterAccess=%s,concurrencyLevel=%d,recordStats", 20000, 20000, "30s", CPUS);
    private static final List<CacheType> CACHE_HUGE_DBS = Arrays.asList(CacheType.storageRow, CacheType.account);
    public static final List<String> CACHE_DBS = Stream.of(CACHE_SMALL_DBS, CACHE_NORMAL_DBS, CACHE_BIG_DBS, CACHE_HUGE_DBS).flatMap(Collection::stream).map(CacheType::toString).collect(Collectors.toList());

    public static String getCacheStrategy(CacheType dbName) {
        String defaultStrategy = CACHE_STRATEGY_DEFAULT;
        if (CACHE_SMALL_DBS.contains((Object)dbName)) {
            defaultStrategy = CACHE_STRATEGY_SMALL_DEFAULT;
        }
        if (CACHE_NORMAL_DBS.contains((Object)dbName)) {
            defaultStrategy = CACHE_STRATEGY_NORMAL_DEFAULT;
        }
        if (CACHE_BIG_DBS.contains((Object)dbName)) {
            defaultStrategy = CACHE_STRATEGY_BIG_DEFAULT;
        }
        if (CACHE_HUGE_DBS.contains((Object)dbName)) {
            defaultStrategy = CACHE_STRATEGY_HUGE_DEFAULT;
        }
        return defaultStrategy;
    }
}

