/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.tron.common.utils.ByteArraySet;
import org.tron.common.utils.SetAdapter;
import org.tron.core.db.ByteArrayWrapper;

public class ByteArrayMap<V>
implements Map<byte[], V> {
    private static final String RUNTIME_EXCEPTION_MSG = "Not implemented";
    private final Map<ByteArrayWrapper, V> delegate;

    public ByteArrayMap() {
        this(new HashMap());
    }

    public ByteArrayMap(Map<ByteArrayWrapper, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(new ByteArrayWrapper((byte[])key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(new ByteArrayWrapper((byte[])key));
    }

    @Override
    public V put(byte[] key, V value) {
        return this.delegate.put(new ByteArrayWrapper(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(new ByteArrayWrapper((byte[])key));
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends V> m) {
        for (Map.Entry<byte[], V> entry : m.entrySet()) {
            this.delegate.put(new ByteArrayWrapper(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<byte[]> keySet() {
        return new ByteArraySet(new SetAdapter<ByteArrayWrapper>(this.delegate));
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<byte[], V>> entrySet() {
        return new MapEntrySet(this.delegate.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private class MapEntrySet
    implements Set<Map.Entry<byte[], V>> {
        private final Set<Map.Entry<ByteArrayWrapper, V>> delegate;

        private MapEntrySet(Set<Map.Entry<ByteArrayWrapper, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public Iterator<Map.Entry<byte[], V>> iterator() {
            final Iterator it = this.delegate.iterator();
            return new Iterator<Map.Entry<byte[], V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<byte[], V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry next = (Map.Entry)it.next();
                    return Maps.immutableEntry((Object)((ByteArrayWrapper)next.getKey()).getData(), next.getValue());
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean add(Map.Entry<byte[], V> vEntry) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<byte[], V>> c) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }

        @Override
        public void clear() {
            throw new RuntimeException(ByteArrayMap.RUNTIME_EXCEPTION_MSG);
        }
    }
}

