/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.parameter;

import com.typesafe.config.ConfigObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RateLimiterInitialization {
    private boolean httpFlag;
    private boolean rpcFlag;
    private Map<String, HttpRateLimiterItem> httpMap = new HashMap<String, HttpRateLimiterItem>();
    private Map<String, RpcRateLimiterItem> rpcMap = new HashMap<String, RpcRateLimiterItem>();

    @Nullable
    public static HttpRateLimiterItem createHttpItem(ConfigObject asset) {
        try {
            return new HttpRateLimiterItem(asset);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static RpcRateLimiterItem createRpcItem(ConfigObject asset) {
        try {
            return new RpcRateLimiterItem(asset);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setHttpMap(List<HttpRateLimiterItem> list) {
        for (HttpRateLimiterItem item : list) {
            if (item == null) continue;
            this.httpMap.put(item.component, item);
        }
        this.httpFlag = this.httpMap.size() > 0;
    }

    public void setRpcMap(List<RpcRateLimiterItem> list) {
        for (RpcRateLimiterItem item : list) {
            if (item == null) continue;
            this.rpcMap.put(item.component, item);
        }
        this.rpcFlag = this.rpcMap.size() > 0;
    }

    public boolean isHttpFlag() {
        return this.httpFlag;
    }

    public boolean isRpcFlag() {
        return this.rpcFlag;
    }

    public Map<String, HttpRateLimiterItem> getHttpMap() {
        return this.httpMap;
    }

    public Map<String, RpcRateLimiterItem> getRpcMap() {
        return this.rpcMap;
    }

    public static class RpcRateLimiterItem {
        private String component;
        private String strategy;
        private String params;

        public RpcRateLimiterItem(ConfigObject asset) {
            this.component = asset.get((Object)"component").unwrapped().toString();
            this.strategy = asset.get((Object)"strategy").unwrapped().toString();
            this.params = asset.get((Object)"paramString").unwrapped().toString();
        }

        public String getComponent() {
            return this.component;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public String getParams() {
            return this.params;
        }
    }

    public static class HttpRateLimiterItem {
        private String component;
        private String strategy;
        private String params;

        public HttpRateLimiterItem(ConfigObject asset) {
            this.component = asset.get((Object)"component").unwrapped().toString();
            this.strategy = asset.get((Object)"strategy").unwrapped().toString();
            this.params = asset.get((Object)"paramString").unwrapped().toString();
        }

        public String getComponent() {
            return this.component;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public String getParams() {
            return this.params;
        }
    }
}

