/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.es;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"common-executor");

    public static ExecutorService newSingleThreadExecutor(String name) {
        return ExecutorServiceManager.newSingleThreadExecutor(name, false);
    }

    public static ExecutorService newSingleThreadExecutor(String name, boolean isDaemon) {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(name).setDaemon(isDaemon).build());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name) {
        return ExecutorServiceManager.newSingleThreadScheduledExecutor(name, false);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String name, boolean isDaemon) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(name).setDaemon(isDaemon).build());
    }

    public static ExecutorService newFixedThreadPool(String name, int fixThreads) {
        return ExecutorServiceManager.newFixedThreadPool(name, fixThreads, false);
    }

    public static ExecutorService newFixedThreadPool(String name, int fixThreads, boolean isDaemon) {
        return Executors.newFixedThreadPool(fixThreads, new ThreadFactoryBuilder().setNameFormat(name + "-%d").setDaemon(isDaemon).build());
    }

    public static ExecutorService newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String name) {
        return ExecutorServiceManager.newThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, name, false);
    }

    public static ExecutorService newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String name, boolean isDaemon) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new ThreadFactoryBuilder().setNameFormat(name + "-%d").setDaemon(isDaemon).build());
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, String name) {
        if (pool == null) {
            return;
        }
        logger.info("Pool {} shutdown...", (Object)name);
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.warn("Pool {} did not terminate", (Object)name);
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        logger.info("Pool {} shutdown done", (Object)name);
    }
}

