/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;
import org.tron.common.utils.DbOptionalsUtils;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.Property;

public class Storage {
    private static final String DB_DIRECTORY_CONFIG_KEY = "storage.db.directory";
    private static final String DB_VERSION_CONFIG_KEY = "storage.db.version";
    private static final String DB_ENGINE_CONFIG_KEY = "storage.db.engine";
    private static final String DB_SYNC_CONFIG_KEY = "storage.db.sync";
    private static final String INDEX_DIRECTORY_CONFIG_KEY = "storage.index.directory";
    private static final String INDEX_SWITCH_CONFIG_KEY = "storage.index.switch";
    private static final String TRANSACTIONHISTORY_SWITCH_CONFIG_KEY = "storage.transHistory.switch";
    private static final String PROPERTIES_CONFIG_KEY = "storage.properties";
    private static final String DEFAULT_TRANSACTIONHISTORY_SWITCH = "on";
    private static final String NAME_CONFIG_KEY = "name";
    private static final String PATH_CONFIG_KEY = "path";
    private static final String CREATE_IF_MISSING_CONFIG_KEY = "createIfMissing";
    private static final String PARANOID_CHECKS_CONFIG_KEY = "paranoidChecks";
    private static final String VERITY_CHECK_SUMS_CONFIG_KEY = "verifyChecksums";
    private static final String COMPRESSION_TYPE_CONFIG_KEY = "compressionType";
    private static final String BLOCK_SIZE_CONFIG_KEY = "blockSize";
    private static final String WRITE_BUFFER_SIZE_CONFIG_KEY = "writeBufferSize";
    private static final String CACHE_SIZE_CONFIG_KEY = "cacheSize";
    private static final String MAX_OPEN_FILES_CONFIG_KEY = "maxOpenFiles";
    private static final String EVENT_SUBSCRIBE_CONTRACT_PARSE = "event.subscribe.contractParse";
    private static final int DEFAULT_DB_VERSION = 2;
    private static final String DEFAULT_DB_ENGINE = "LEVELDB";
    private static final boolean DEFAULT_DB_SYNC = false;
    private static final boolean DEFAULT_EVENT_SUBSCRIBE_CONTRACT_PARSE = true;
    private static final String DEFAULT_DB_DIRECTORY = "database";
    private static final String DEFAULT_INDEX_DIRECTORY = "index";
    private static final String DEFAULT_INDEX_SWITCH = "on";
    private String dbDirectory;
    private int dbVersion;
    private String dbEngine;
    private boolean dbSync;
    private String indexDirectory;
    private String indexSwitch;
    private boolean contractParseSwitch;
    private String transactionHistorySwitch;
    private Map<String, Property> propertyMap;

    public static int getDbVersionFromConfig(Config config) {
        return config.hasPath(DB_VERSION_CONFIG_KEY) ? config.getInt(DB_VERSION_CONFIG_KEY) : 2;
    }

    public static String getDbEngineFromConfig(Config config) {
        return config.hasPath(DB_ENGINE_CONFIG_KEY) ? config.getString(DB_ENGINE_CONFIG_KEY) : DEFAULT_DB_ENGINE;
    }

    public static Boolean getDbVersionSyncFromConfig(Config config) {
        return config.hasPath(DB_SYNC_CONFIG_KEY) ? config.getBoolean(DB_SYNC_CONFIG_KEY) : false;
    }

    public static Boolean getContractParseSwitchFromConfig(Config config) {
        return config.hasPath(EVENT_SUBSCRIBE_CONTRACT_PARSE) ? config.getBoolean(EVENT_SUBSCRIBE_CONTRACT_PARSE) : true;
    }

    public static String getDbDirectoryFromConfig(Config config) {
        return config.hasPath(DB_DIRECTORY_CONFIG_KEY) ? config.getString(DB_DIRECTORY_CONFIG_KEY) : DEFAULT_DB_DIRECTORY;
    }

    public static String getIndexDirectoryFromConfig(Config config) {
        return config.hasPath(INDEX_DIRECTORY_CONFIG_KEY) ? config.getString(INDEX_DIRECTORY_CONFIG_KEY) : DEFAULT_INDEX_DIRECTORY;
    }

    public static String getIndexSwitchFromConfig(Config config) {
        return config.hasPath(INDEX_SWITCH_CONFIG_KEY) && StringUtils.isNotEmpty((CharSequence)config.getString(INDEX_SWITCH_CONFIG_KEY)) ? config.getString(INDEX_SWITCH_CONFIG_KEY) : "on";
    }

    public static String getTransactionHistorySwitchFromConfig(Config config) {
        return config.hasPath(TRANSACTIONHISTORY_SWITCH_CONFIG_KEY) ? config.getString(TRANSACTIONHISTORY_SWITCH_CONFIG_KEY) : "on";
    }

    private static Property createProperty(ConfigObject conf) {
        Property property = new Property();
        if (!conf.containsKey((Object)NAME_CONFIG_KEY)) {
            throw new IllegalArgumentException("[storage.properties] database name must be set.");
        }
        property.setName(conf.get((Object)NAME_CONFIG_KEY).unwrapped().toString());
        if (conf.containsKey((Object)PATH_CONFIG_KEY)) {
            String path = conf.get((Object)PATH_CONFIG_KEY).unwrapped().toString();
            File file = new File(path);
            if (!file.exists() && !file.mkdirs()) {
                throw new IllegalArgumentException("[storage.properties] can not create storage path: " + path);
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("[storage.properties] permission denied to write to: " + path);
            }
            property.setPath(path);
        }
        Options dbOptions = DbOptionalsUtils.createDefaultDbOptions();
        if (conf.containsKey((Object)CREATE_IF_MISSING_CONFIG_KEY)) {
            dbOptions.createIfMissing(Boolean.parseBoolean(conf.get((Object)CREATE_IF_MISSING_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)PARANOID_CHECKS_CONFIG_KEY)) {
            dbOptions.paranoidChecks(Boolean.parseBoolean(conf.get((Object)PARANOID_CHECKS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)VERITY_CHECK_SUMS_CONFIG_KEY)) {
            dbOptions.verifyChecksums(Boolean.parseBoolean(conf.get((Object)VERITY_CHECK_SUMS_CONFIG_KEY).unwrapped().toString()));
        }
        if (conf.containsKey((Object)COMPRESSION_TYPE_CONFIG_KEY)) {
            try {
                dbOptions.compressionType(CompressionType.getCompressionTypeByPersistentId((int)Integer.parseInt(conf.get((Object)COMPRESSION_TYPE_CONFIG_KEY).unwrapped().toString())));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] compressionType must be Integer type.");
            }
        }
        if (conf.containsKey((Object)BLOCK_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.blockSize(Integer.parseInt(conf.get((Object)BLOCK_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] blockSize must be Integer type.");
            }
        }
        if (conf.containsKey((Object)WRITE_BUFFER_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.writeBufferSize(Integer.parseInt(conf.get((Object)WRITE_BUFFER_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] writeBufferSize must be Integer type.");
            }
        }
        if (conf.containsKey((Object)CACHE_SIZE_CONFIG_KEY)) {
            try {
                dbOptions.cacheSize(Long.parseLong(conf.get((Object)CACHE_SIZE_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] cacheSize must be Long type.");
            }
        }
        if (conf.containsKey((Object)MAX_OPEN_FILES_CONFIG_KEY)) {
            try {
                dbOptions.maxOpenFiles(Integer.parseInt(conf.get((Object)MAX_OPEN_FILES_CONFIG_KEY).unwrapped().toString()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("[storage.properties] maxOpenFiles must be Integer type.");
            }
        }
        property.setDbOptions(dbOptions);
        return property;
    }

    public void setPropertyMapFromConfig(Config config) {
        if (config.hasPath(PROPERTIES_CONFIG_KEY)) {
            this.propertyMap = config.getObjectList(PROPERTIES_CONFIG_KEY).stream().map(Storage::createProperty).collect(Collectors.toMap(Property::getName, p -> p));
        }
    }

    public void deleteAllStoragePaths() {
        if (this.propertyMap == null) {
            return;
        }
        for (Property property : this.propertyMap.values()) {
            String path = property.getPath();
            if (path == null) continue;
            FileUtil.recursiveDelete(path);
        }
    }

    public String getDbDirectory() {
        return this.dbDirectory;
    }

    public void setDbDirectory(String dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    public int getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(int dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getDbEngine() {
        return this.dbEngine;
    }

    public void setDbEngine(String dbEngine) {
        this.dbEngine = dbEngine;
    }

    public boolean isDbSync() {
        return this.dbSync;
    }

    public void setDbSync(boolean dbSync) {
        this.dbSync = dbSync;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getIndexSwitch() {
        return this.indexSwitch;
    }

    public void setIndexSwitch(String indexSwitch) {
        this.indexSwitch = indexSwitch;
    }

    public boolean isContractParseSwitch() {
        return this.contractParseSwitch;
    }

    public void setContractParseSwitch(boolean contractParseSwitch) {
        this.contractParseSwitch = contractParseSwitch;
    }

    public String getTransactionHistorySwitch() {
        return this.transactionHistorySwitch;
    }

    public void setTransactionHistorySwitch(String transactionHistorySwitch) {
        this.transactionHistorySwitch = transactionHistorySwitch;
    }

    public Map<String, Property> getPropertyMap() {
        return this.propertyMap;
    }
}

