/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollectionUtils {
    public static <K, V> List<V> collectList(Collection<K> items, Function<K, V> collector) {
        ArrayList<V> collected = new ArrayList<V>(items.size());
        for (K item : items) {
            collected.add(collector.apply(item));
        }
        return collected;
    }

    public static <K, V> Set<V> collectSet(Collection<K> items, Function<K, V> collector) {
        HashSet<V> collected = new HashSet<V>();
        for (K item : items) {
            collected.add(collector.apply(item));
        }
        return collected;
    }

    public static <T> List<T> truncate(List<T> items, int limit) {
        if (limit > items.size()) {
            return new ArrayList<T>(items);
        }
        ArrayList<T> truncated = new ArrayList<T>(limit);
        for (T item : items) {
            truncated.add(item);
            if (truncated.size() != limit) continue;
            break;
        }
        return truncated;
    }

    public static <T> List<T> truncateRandom(List<T> items, int limit, int confirm) {
        if (limit > items.size()) {
            return new ArrayList<T>(items);
        }
        ArrayList<T> truncated = new ArrayList<T>(limit);
        if (confirm >= limit) {
            for (T item : items) {
                truncated.add(item);
                if (truncated.size() != limit) continue;
                break;
            }
        } else {
            if (confirm > 0) {
                truncated.addAll(items.subList(0, confirm));
            }
            List<T> endList = items.subList(confirm, items.size());
            Collections.shuffle(endList);
            for (int i = 0; i < limit - confirm; ++i) {
                truncated.add(endList.get(i));
            }
        }
        return truncated;
    }

    public static <T> List<T> selectList(Collection<T> items, Predicate<T> predicate) {
        ArrayList<T> selected = new ArrayList<T>();
        for (T item : items) {
            if (!predicate.test(item)) continue;
            selected.add(item);
        }
        return selected;
    }

    public static <T> Set<T> selectSet(Collection<T> items, Predicate<T> predicate) {
        HashSet<T> selected = new HashSet<T>();
        for (T item : items) {
            if (!predicate.test(item)) continue;
            selected.add(item);
        }
        return selected;
    }
}

