/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Utils;

public class Node
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)"discover");
    private static final long serialVersionUID = -4267600517925770636L;
    private byte[] id;
    private String host;
    private int port;
    private int bindPort;
    private int p2pVersion;
    private boolean isFakeNodeId = false;

    public Node(byte[] id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.isFakeNodeId = true;
    }

    public Node(byte[] id, String host, int port, int bindPort) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.bindPort = bindPort;
    }

    public static Node instanceOf(String hostPort) {
        try {
            String[] sz = hostPort.split(":");
            int port = Integer.parseInt(sz[1]);
            return new Node(Node.getNodeId(), sz[0], port);
        }
        catch (Exception e) {
            logger.error("Parse node failed, {}", (Object)hostPort);
            throw e;
        }
    }

    public static byte[] getNodeId() {
        int NODE_ID_LENGTH = 64;
        Random gen = new Random();
        byte[] id = new byte[NODE_ID_LENGTH];
        gen.nextBytes(id);
        return id;
    }

    public boolean isConnectible(int argsP2PVersion) {
        return this.port == this.bindPort && this.p2pVersion == argsP2PVersion;
    }

    public String getHexId() {
        return Hex.toHexString((byte[])this.id);
    }

    public String getHexIdShort() {
        return Utils.getIdShort(this.getHexId());
    }

    public boolean isDiscoveryNode() {
        return this.isFakeNodeId;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIdString() {
        if (this.id == null) {
            return null;
        }
        return new String(this.id);
    }

    public String toString() {
        return "Node{ host='" + this.host + '\'' + ", port=" + this.port + ", id=" + ByteArray.toHexString(this.id) + '}';
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            return StringUtils.equals((CharSequence)this.getIdString(), (CharSequence)((Node)o).getIdString());
        }
        return false;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setP2pVersion(int p2pVersion) {
        this.p2pVersion = p2pVersion;
    }
}

