/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.config;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.FileUtil;

public class DbBackupConfig {
    private static final Logger logger = LoggerFactory.getLogger(DbBackupConfig.class);
    private static volatile DbBackupConfig instance;
    private String propPath;
    private String bak1path;
    private String bak2path;
    private int frequency;
    private boolean enable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DbBackupConfig getInstance() {
        if (instance != null) return instance;
        Class<DbBackupConfig> clazz = DbBackupConfig.class;
        synchronized (DbBackupConfig.class) {
            if (instance != null) return instance;
            instance = new DbBackupConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DbBackupConfig initArgs(boolean enable, String propPath, String bak1path, String bak2path, int frequency) {
        this.setEnable(enable);
        if (this.isEnable()) {
            if (!bak1path.endsWith(File.separator)) {
                bak1path = bak1path + File.separator;
            }
            if (!bak2path.endsWith(File.separator)) {
                bak2path = bak2path + File.separator;
            }
            if (!FileUtil.createFileIfNotExists(propPath)) {
                throw new RuntimeException("failure to create file:" + propPath);
            }
            if (!FileUtil.createDirIfNotExists(bak1path)) {
                throw new RuntimeException("failure to mkdir: " + bak1path);
            }
            if (!FileUtil.createDirIfNotExists(bak2path)) {
                throw new RuntimeException("failure to mkdir: " + bak2path);
            }
            if (bak1path.equals(bak2path)) {
                throw new RuntimeException("bak1path and bak2path must be different.");
            }
            if (frequency <= 0) {
                throw new IllegalArgumentException("frequency must be positive number.");
            }
            this.setPropPath(propPath);
            this.setBak1path(bak1path);
            this.setBak2path(bak2path);
            this.setFrequency(frequency);
            logger.info("success to enable the db backup plugin. bak1path:{}, bak2path:{}, backup once every {} blocks handled", new Object[]{bak1path, bak2path, frequency});
        }
        return this;
    }

    public String getPropPath() {
        return this.propPath;
    }

    public void setPropPath(String propPath) {
        this.propPath = propPath;
    }

    public String getBak1path() {
        return this.bak1path;
    }

    public void setBak1path(String bak1path) {
        this.bak1path = bak1path;
    }

    public String getBak2path() {
        return this.bak2path;
    }

    public void setBak2path(String bak2path) {
        this.bak2path = bak2path;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

