/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class ContractStateStore
extends TronStoreWithRevoking<ContractStateCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    private ContractStateStore(@Value(value="contract-state") String dbName) {
        super(dbName);
    }

    @Override
    public ContractStateCapsule get(byte[] key) {
        return (ContractStateCapsule)this.getUnchecked(key);
    }

    @Override
    public void put(byte[] key, ContractStateCapsule item) {
        if (Objects.isNull(key) || Objects.isNull(item)) {
            return;
        }
        this.revokingDB.put(key, item.getData());
    }
}

