/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.AccountTraceCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;

@Component
public class AccountTraceStore
extends TronStoreWithRevoking<AccountTraceCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    protected AccountTraceStore(@Value(value="account-trace") String dbName) {
        super(dbName);
    }

    private long xor(long l) {
        return l ^ Long.MAX_VALUE;
    }

    public void recordBalanceWithBlock(byte[] address, long number, long balance) {
        byte[] key = Bytes.concat((byte[][])new byte[][]{address, Longs.toByteArray((long)this.xor(number))});
        this.put(key, new AccountTraceCapsule(balance));
    }

    public Pair<Long, Long> getPrevBalance(byte[] address, long number) {
        byte[] key = Bytes.concat((byte[][])new byte[][]{address, Longs.toByteArray((long)this.xor(number))});
        Map<byte[], byte[]> result = this.revokingDB.getNext(key, 1L);
        if (MapUtils.isEmpty(result)) {
            return Pair.of((Object)number, (Object)0L);
        }
        Map.Entry<byte[], byte[]> entry = new ArrayList<Map.Entry<byte[], byte[]>>(result.entrySet()).get(0);
        byte[] resultAddress = Arrays.copyOf(entry.getKey(), 21);
        if (!Arrays.equals(address, resultAddress)) {
            return Pair.of((Object)number, (Object)0L);
        }
        try {
            byte[] numberbytes = Arrays.copyOfRange(entry.getKey(), 21, 29);
            return Pair.of((Object)this.xor(Longs.fromByteArray((byte[])numberbytes)), (Object)new AccountTraceCapsule(entry.getValue()).getBalance());
        }
        catch (BadItemException e) {
            return Pair.of((Object)number, (Object)0L);
        }
    }
}

