/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.common.iterator;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.db.common.iterator.DBIterator;

public final class RockStoreIterator
implements DBIterator {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private final RocksIterator dbIterator;
    private boolean first = true;
    private boolean valid = true;

    public RockStoreIterator(RocksIterator dbIterator) {
        this.dbIterator = dbIterator;
    }

    @Override
    public void close() throws IOException {
        this.dbIterator.close();
    }

    @Override
    public boolean hasNext() {
        if (!this.valid) {
            return false;
        }
        boolean hasNext = false;
        try {
            if (this.first) {
                this.dbIterator.seekToFirst();
                this.first = false;
            }
            if (!(hasNext = this.dbIterator.isValid())) {
                this.dbIterator.close();
                this.valid = false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            try {
                this.dbIterator.close();
            }
            catch (Exception e1) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return hasNext;
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (!this.valid) {
            throw new NoSuchElementException();
        }
        final byte[] key = this.dbIterator.key();
        final byte[] value = this.dbIterator.value();
        this.dbIterator.next();
        return new Map.Entry<byte[], byte[]>(){

            @Override
            public byte[] getKey() {
                return key;
            }

            @Override
            public byte[] getValue() {
                return value;
            }

            @Override
            public byte[] setValue(byte[] value2) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

