/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteUtil;
import org.tron.common.zksnark.Librustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.common.zksnark.LibrustzcashWrapper;
import org.tron.core.exception.ZksnarkException;

public class JLibrustzcash {
    private static final Logger logger = LoggerFactory.getLogger(JLibrustzcash.class);
    private static Librustzcash INSTANCE;

    public static void librustzcashZip32XskMaster(LibrustzcashParam.Zip32XskMasterParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashZip32XskMaster(params.getData(), params.getSize(), params.getM_bytes());
    }

    public static void librustzcashInitZksnarkParams(LibrustzcashParam.InitZksnarkParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashInitZksnarkParams(params.getSpend_path(), params.getSpend_hash(), params.getOutput_path(), params.getOutput_hash());
    }

    public static void librustzcashZip32XskDerive(LibrustzcashParam.Zip32XskDeriveParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashZip32XskDerive(params.getData(), params.getSize(), params.getM_bytes());
    }

    public static boolean librustzcashZip32XfvkAddress(LibrustzcashParam.Zip32XfvkAddressParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashZip32XfvkAddress(params.getXfvk(), params.getJ(), params.getJ_ret(), params.getAddr_ret());
    }

    public static void librustzcashCrhIvk(LibrustzcashParam.CrhIvkParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashCrhIvk(params.getAk(), params.getNk(), params.getIvk());
    }

    public static boolean librustzcashKaAgree(LibrustzcashParam.KaAgreeParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingKaAgree(params.getP(), params.getSk(), params.getResult());
    }

    public static boolean librustzcashComputeCm(LibrustzcashParam.ComputeCmParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingComputeCm(params.getD(), params.getPkD(), params.getValue(), params.getR(), params.getCm());
    }

    public static boolean librustzcashComputeNf(LibrustzcashParam.ComputeNfParams params) {
        if (JLibrustzcash.isOpenZen()) {
            INSTANCE.librustzcashSaplingComputeNf(params.getD(), params.getPkD(), params.getValue(), params.getR(), params.getAk(), params.getNk(), params.getPosition(), params.getResult());
        }
        return true;
    }

    public static byte[] librustzcashAskToAk(byte[] ask) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        LibrustzcashParam.valid32Params(ask);
        byte[] ak = new byte[32];
        INSTANCE.librustzcashAskToAk(ask, ak);
        return ak;
    }

    public static byte[] librustzcashNskToNk(byte[] nsk) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        LibrustzcashParam.valid32Params(nsk);
        byte[] nk = new byte[32];
        INSTANCE.librustzcashNskToNk(nsk, nk);
        return nk;
    }

    public static byte[] librustzcashSaplingGenerateR(byte[] r) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        LibrustzcashParam.valid32Params(r);
        INSTANCE.librustzcashSaplingGenerateR(r);
        return r;
    }

    public static boolean librustzcashSaplingKaDerivepublic(LibrustzcashParam.KaDerivepublicParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingKaDerivepublic(params.getDiversifier(), params.getEsk(), params.getResult());
    }

    public static long librustzcashSaplingProvingCtxInit() {
        if (!JLibrustzcash.isOpenZen()) {
            return 0L;
        }
        return INSTANCE.librustzcashSaplingProvingCtxInit();
    }

    public static boolean librustzcashCheckDiversifier(byte[] d) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        LibrustzcashParam.valid11Params(d);
        return INSTANCE.librustzcashCheckDiversifier(d);
    }

    public static boolean librustzcashSaplingSpendProof(LibrustzcashParam.SpendProofParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingSpendProof(params.getCtx(), params.getAk(), params.getNsk(), params.getD(), params.getR(), params.getAlpha(), params.getValue(), params.getAnchor(), params.getVoucherPath(), params.getCv(), params.getRk(), params.getZkproof());
    }

    public static boolean librustzcashSaplingOutputProof(LibrustzcashParam.OutputProofParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingOutputProof(params.getCtx(), params.getEsk(), params.getD(), params.getPkD(), params.getR(), params.getValue(), params.getCv(), params.getZkproof());
    }

    public static boolean librustzcashSaplingSpendSig(LibrustzcashParam.SpendSigParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingSpendSig(params.getAsk(), params.getAlpha(), params.getSigHash(), params.getResult());
    }

    public static boolean librustzcashSaplingBindingSig(LibrustzcashParam.BindingSigParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingBindingSig(params.getCtx(), params.getValueBalance(), params.getSighash(), params.getResult());
    }

    public static void librustzcashToScalar(byte[] value, byte[] data) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        LibrustzcashParam.validParamLength(value, 64);
        LibrustzcashParam.valid32Params(data);
        INSTANCE.librustzcashToScalar(value, data);
    }

    public static void librustzcashSaplingProvingCtxFree(long ctx) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashSaplingProvingCtxFree(ctx);
    }

    public static long librustzcashSaplingVerificationCtxInit() {
        if (!JLibrustzcash.isOpenZen()) {
            return 0L;
        }
        return INSTANCE.librustzcashSaplingVerificationCtxInit();
    }

    public static boolean librustzcashSaplingCheckSpend(LibrustzcashParam.CheckSpendParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingCheckSpend(params.getCtx(), params.getCv(), params.getAnchor(), params.getNullifier(), params.getRk(), params.getZkproof(), params.getSpendAuthSig(), params.getSighashValue());
    }

    public static boolean librustzcashSaplingCheckOutput(LibrustzcashParam.CheckOutputParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingCheckOutput(params.getCtx(), params.getCv(), params.getCm(), params.getEphemeralKey(), params.getZkproof());
    }

    public static boolean librustzcashSaplingFinalCheck(LibrustzcashParam.FinalCheckParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingFinalCheck(params.getCtx(), params.getValueBalance(), params.getBindingSig(), params.getSighashValue());
    }

    public static boolean librustzcashSaplingCheckSpendNew(LibrustzcashParam.CheckSpendNewParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingCheckSpendNew(params.getCv(), params.getAnchor(), params.getNullifier(), params.getRk(), params.getZkproof(), params.getSpendAuthSig(), params.getSighashValue());
    }

    public static boolean librustzcashSaplingCheckOutputNew(LibrustzcashParam.CheckOutputNewParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingCheckOutputNew(params.getCv(), params.getCm(), params.getEphemeralKey(), params.getZkproof());
    }

    public static boolean librustzcashSaplingFinalCheckNew(LibrustzcashParam.FinalCheckNewParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashSaplingFinalCheckNew(params.getValueBalance(), params.getBindingSig(), params.getSighashValue(), params.getSpendCv(), params.getSpendCvLen(), params.getOutputCv(), params.getOutputCvLen());
    }

    public static void librustzcashSaplingVerificationCtxFree(long ctx) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashSaplingVerificationCtxFree(ctx);
    }

    public static boolean librustzcashIvkToPkd(LibrustzcashParam.IvkToPkdParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return true;
        }
        return INSTANCE.librustzcashIvkToPkd(params.getIvk(), params.getD(), params.getPkD());
    }

    public static void librustzcashMerkleHash(LibrustzcashParam.MerkleHashParams params) {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        INSTANCE.librustzcashMerkleHash(params.getDepth(), params.getA(), params.getB(), params.getResult());
    }

    public static void librustzcashTreeUncommitted(byte[] result) throws ZksnarkException {
        if (!JLibrustzcash.isOpenZen()) {
            return;
        }
        LibrustzcashParam.valid32Params(result);
        INSTANCE.librustzcashTreeUncommitted(result);
    }

    public static boolean isOpenZen() {
        boolean res = CommonParameter.getInstance().isFullNodeAllowShieldedTransactionArgs();
        if (res) {
            INSTANCE = LibrustzcashWrapper.getInstance();
        }
        return res;
    }
}

