/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Base58;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;

public class Commons {
    private static final Logger logger = LoggerFactory.getLogger((String)"Commons");
    public static final int ASSET_ISSUE_COUNT_LIMIT_MAX = 1000;

    public static byte[] decode58Check(String input) {
        byte[] decodeCheck = Base58.decode((String)input);
        if (decodeCheck.length <= 4) {
            return null;
        }
        byte[] decodeData = new byte[decodeCheck.length - 4];
        System.arraycopy(decodeCheck, 0, decodeData, 0, decodeData.length);
        byte[] hash0 = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])decodeData);
        byte[] hash1 = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])hash0);
        if (hash1[0] == decodeCheck[decodeData.length] && hash1[1] == decodeCheck[decodeData.length + 1] && hash1[2] == decodeCheck[decodeData.length + 2] && hash1[3] == decodeCheck[decodeData.length + 3]) {
            return decodeData;
        }
        return null;
    }

    public static byte[] decodeFromBase58Check(String addressBase58) {
        if (StringUtils.isEmpty((CharSequence)addressBase58)) {
            logger.warn("Warning: Address is empty !!");
            return null;
        }
        byte[] address = Commons.decode58Check(addressBase58);
        if (address == null) {
            return null;
        }
        if (!DecodeUtil.addressValid((byte[])address)) {
            return null;
        }
        return address;
    }

    public static void adjustBalance(AccountStore accountStore, byte[] accountAddress, long amount) throws BalanceInsufficientException {
        AccountCapsule account = (AccountCapsule)accountStore.getUnchecked(accountAddress);
        Commons.adjustBalance(accountStore, account, amount);
    }

    public static void adjustBalance(AccountStore accountStore, AccountCapsule account, long amount) throws BalanceInsufficientException {
        long balance = account.getBalance();
        if (amount == 0L) {
            return;
        }
        if (amount < 0L && balance < -amount) {
            throw new BalanceInsufficientException(String.format("%s insufficient balance, balance: %d, amount: %d", StringUtil.createReadableString((byte[])account.createDbKey()), balance, -amount));
        }
        account.setBalance(Math.addExact(balance, amount));
        accountStore.put(account.getAddress().toByteArray(), account);
    }

    public static ExchangeStore getExchangeStoreFinal(DynamicPropertiesStore dynamicPropertiesStore, ExchangeStore exchangeStore, ExchangeV2Store exchangeV2Store) {
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            return exchangeStore;
        }
        return exchangeV2Store;
    }

    public static void putExchangeCapsule(ExchangeCapsule exchangeCapsule, DynamicPropertiesStore dynamicPropertiesStore, ExchangeStore exchangeStore, ExchangeV2Store exchangeV2Store, AssetIssueStore assetIssueStore) {
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            exchangeStore.put(exchangeCapsule.createDbKey(), exchangeCapsule);
            ExchangeCapsule exchangeCapsuleV2 = new ExchangeCapsule(exchangeCapsule.getData());
            exchangeCapsuleV2.resetTokenWithID(assetIssueStore, dynamicPropertiesStore);
            exchangeV2Store.put(exchangeCapsuleV2.createDbKey(), exchangeCapsuleV2);
        } else {
            exchangeV2Store.put(exchangeCapsule.createDbKey(), exchangeCapsule);
        }
    }

    public static AssetIssueStore getAssetIssueStoreFinal(DynamicPropertiesStore dynamicPropertiesStore, AssetIssueStore assetIssueStore, AssetIssueV2Store assetIssueV2Store) {
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            return assetIssueStore;
        }
        return assetIssueV2Store;
    }

    public static void adjustAssetBalanceV2(AccountCapsule account, String AssetID, long amount, AccountStore accountStore, AssetIssueStore assetIssueStore, DynamicPropertiesStore dynamicPropertiesStore) throws BalanceInsufficientException {
        if (amount < 0L) {
            if (!account.reduceAssetAmountV2(AssetID.getBytes(), -amount, dynamicPropertiesStore, assetIssueStore)) {
                throw new BalanceInsufficientException(String.format("reduceAssetAmount failed! account: %s", StringUtil.encode58Check((byte[])account.createDbKey())));
            }
        } else if (amount > 0L && !account.addAssetAmountV2(AssetID.getBytes(), amount, dynamicPropertiesStore, assetIssueStore)) {
            throw new BalanceInsufficientException(String.format("addAssetAmount failed! account: %s", StringUtil.encode58Check((byte[])account.createDbKey())));
        }
        accountStore.put(account.getAddress().toByteArray(), account);
    }

    public static void adjustTotalShieldedPoolValue(long valueBalance, DynamicPropertiesStore dynamicPropertiesStore) throws BalanceInsufficientException {
        long totalShieldedPoolValue = Math.subtractExact(dynamicPropertiesStore.getTotalShieldedPoolValue(), valueBalance);
        if (totalShieldedPoolValue < 0L) {
            throw new BalanceInsufficientException(String.format("total shielded pool value can not below 0, actual: %d", totalShieldedPoolValue));
        }
        dynamicPropertiesStore.saveTotalShieldedPoolValue(totalShieldedPoolValue);
    }

    public static void adjustAssetBalanceV2(byte[] accountAddress, String AssetID, long amount, AccountStore accountStore, AssetIssueStore assetIssueStore, DynamicPropertiesStore dynamicPropertiesStore) throws BalanceInsufficientException {
        AccountCapsule account = (AccountCapsule)accountStore.getUnchecked(accountAddress);
        Commons.adjustAssetBalanceV2(account, AssetID, amount, accountStore, assetIssueStore, dynamicPropertiesStore);
    }
}

