package org.tron.core.db;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db2.common.TxCacheDB;

@Slf4j
public class TransactionCache extends TronStoreWithRevoking<BytesCapsule> {

  @Autowired
  public TransactionCache(@Value("trans-cache") String dbName,
                          RecentTransactionStore recentTransactionStore) {
    super(new TxCacheDB(dbName, recentTransactionStore));
  }

  public void initCache() {
    ((TxCacheDB) getDb()).init();
  }
}
