/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.MarketOrderIdListCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.store.MarketPairPriceToOrderStore;

@Component
public class MarketPairToPriceStore
extends TronStoreWithRevoking<BytesCapsule> {
    @Autowired
    protected MarketPairToPriceStore(@Value(value="market_pair_to_price") String dbName) {
        super(dbName);
    }

    @Override
    public BytesCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new BytesCapsule(value);
    }

    public long getPriceNum(byte[] key) {
        BytesCapsule bytesCapsule = this.get(key);
        if (bytesCapsule != null) {
            return ByteArray.toLong((byte[])bytesCapsule.getData());
        }
        return 0L;
    }

    public long getPriceNum(byte[] sellTokenId, byte[] buyTokenId) {
        return this.getPriceNum(MarketUtils.createPairKey(sellTokenId, buyTokenId));
    }

    public void setPriceNum(byte[] key, long number) {
        this.put(key, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public void setPriceNum(byte[] sellTokenId, byte[] buyTokenId, long number) {
        this.setPriceNum(MarketUtils.createPairKey(sellTokenId, buyTokenId), number);
    }

    public void addNewPriceKey(byte[] sellTokenId, byte[] buyTokenId, MarketPairPriceToOrderStore pairPriceToOrderStore) {
        long number;
        byte[] pairKey = MarketUtils.createPairKey(sellTokenId, buyTokenId);
        if (this.has(pairKey)) {
            number = this.getPriceNum(pairKey) + 1L;
        } else {
            number = 1L;
            byte[] headKey = MarketUtils.getPairPriceHeadKey(sellTokenId, buyTokenId);
            pairPriceToOrderStore.put(headKey, new MarketOrderIdListCapsule());
        }
        this.setPriceNum(pairKey, number);
    }
}

